/*************************************************************************
 *
 *  $RCSfile: rapofflinepersistentstoragefactory.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:58:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINEPERSISTENTSTORAGEFACTORY_HXX
#include "rapofflinepersistentstoragefactory.hxx"
#endif

#ifndef INCLUDED_UCB_RAPOFFLINEFILESTREAM_HXX
#include "rapofflinefilestream.hxx"
#endif

#ifndef _COM_SUN_STAR_IO_XACTIVEDATASINK_HPP_
#include "com/sun/star/io/XActiveDataSink.hpp"
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include "com/sun/star/io/XActiveDataSource.hpp"
#endif
#ifndef _COM_SUN_STAR_IO_XDATAINPUTSTREAM_HPP_
#include "com/sun/star/io/XDataInputStream.hpp"
#endif
#ifndef _COM_SUN_STAR_IO_XDATAOUTPUTSTREAM_HPP_
#include "com/sun/star/io/XDataOutputStream.hpp"
#endif
#ifndef _COM_SUN_STAR_LANG_ILLEGALARGUMENTEXCEPTION_HPP_
#include "com/sun/star/lang/IllegalArgumentException.hpp"
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include "com/sun/star/lang/XMultiServiceFactory.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_EXCEPTION_HPP_
#include "com/sun/star/uno/Exception.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include "com/sun/star/uno/Reference.hxx"
#endif
#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include "com/sun/star/uno/RuntimeException.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include "com/sun/star/uno/Sequence.hxx"
#endif
#ifndef _OSL_DIAGNOSE_H_
#include "osl/diagnose.h"
#endif
#ifndef _OSL_FILE_HXX_
#include "osl/file.hxx"
#endif
#ifndef _RTL_USTBUF_HXX_
#include "rtl/ustrbuf.hxx"
#endif
#ifndef _RTL_USTRING_H_
#include "rtl/ustring.h"
#endif
#ifndef _RTL_USTRING_HXX_
#include "rtl/ustring.hxx"
#endif
#ifndef _SAL_TYPES_H_
#include "sal/types.h"
#endif

using namespace com::sun;
using ucprmt::offline::FileStream;
using ucprmt::offline::PersistentStorageFactory;

bool PersistentStorageFactory::createPath(rtl::OUString const & rIdentifier,
                                          rtl::OUString * pPath)
{
    OSL_ASSERT(pPath);

    // To prevent (most) forseeable problems (e.g., "..\\xxx" as an identifier
    // on a DOS file system), restrict identifiers to non-empty strings of
    // alphanumeric characters:
    sal_Int32 nLength = rIdentifier.getLength();
    if (nLength == 0)
        return false;
    for (sal_Int32 i = 0; i < nLength; ++i)
    {
        sal_Unicode c = rIdentifier[i];
        if ((c < '0' || c > '9')
            && (c < 'A' || c > 'Z')
            && (c < 'a' || c > 'z'))
            return false;
    }

    rtl::OUStringBuffer aBuffer(m_aSystemPath);
    aBuffer.append(rIdentifier);
    *pPath = aBuffer.makeStringAndClear();
    return true;
}

PersistentStorageFactory::PersistentStorageFactory(
    star::uno::Reference< star::lang::XMultiServiceFactory > const &
        rServiceFactory,
    rtl::OUString const & rSystemPath):
    m_xServiceFactory(rServiceFactory),
    m_aSystemPath(rSystemPath)
{
    // Make sure the path ends in '/':
    if (m_aSystemPath.getLength() == 0
        || m_aSystemPath[m_aSystemPath.getLength() - 1] != '/')
    {
        rtl::OUStringBuffer aBuffer(m_aSystemPath);
        aBuffer.append(sal_Unicode('/'));
        m_aSystemPath = aBuffer.makeStringAndClear();
    }
}

PersistentStorageFactory::~PersistentStorageFactory()
{}

star::uno::Sequence< rtl::OUString > SAL_CALL
PersistentStorageFactory::getIdentifiers()
    throw (star::uno::RuntimeException)
{
    star::uno::Sequence< rtl::OUString > aIdentifiers;
    sal_Int32 nCount = 0;
    osl::Directory aDirectory(m_aSystemPath);
    aDirectory.open();
    osl::DirectoryItem aItem;
    while (aDirectory.getNextItem(aItem) == osl::FileBase::E_None)
    {
        osl::FileStatus
            aStatus(FileStatusMask_Type | FileStatusMask_FileName);
        if (aItem.getFileStatus(aStatus) == osl::FileBase::E_None
            && aStatus.getFileType() == osl::FileStatus::Regular)
        {
            rtl::OUString aName(aStatus.getFileName());
            if (aName.getLength() > 0)
            {
                aIdentifiers.realloc(++nCount);
                aIdentifiers[nCount - 1] = aName;
            }
        }
    }
    return aIdentifiers;
}

sal_Bool SAL_CALL
PersistentStorageFactory::deleteStorage(rtl::OUString const & rIdentifier)
    throw (star::uno::RuntimeException)
{
    rtl::OUString aPath;
    return createPath(rIdentifier, &aPath)
           && osl::File::remove(aPath) == osl::FileBase::E_None;
}

star::uno::Reference< star::io::XDataInputStream > SAL_CALL
PersistentStorageFactory::getDataInputStream(
    rtl::OUString const & rIdentifier)
    throw (star::lang::IllegalArgumentException, star::uno::RuntimeException)
{
    rtl::OUString aPath;
    if (!createPath(rIdentifier, &aPath))
        throw star::lang::IllegalArgumentException(
                  rtl::OUString(
                      RTL_CONSTASCII_USTRINGPARAM(
                          "Bad com.sun.star.XPersistentStorageFactory."
                              "getDataInputStream() identifier")),
                  *this,
                  0);

    star::uno::Reference< star::io::XDataInputStream > xDataStream;
    if (m_xServiceFactory.is())
        try
        {
            xDataStream
                = star::uno::Reference< star::io::XDataInputStream >(
                      m_xServiceFactory->
                          createInstance(
                              rtl::OUString(
                                  RTL_CONSTASCII_USTRINGPARAM(
                                      "com.sun.star.io.DataInputStream"))),
                      star::uno::UNO_QUERY);
        }
        catch (star::uno::RuntimeException const &)
        {
            throw;
        }
        catch (star::uno::Exception const &)
        {}
    star::uno::Reference< star::io::XActiveDataSink >
        xSink(xDataStream, star::uno::UNO_QUERY);
    if (!xDataStream.is() || !xSink.is())
    {
        OSL_ASSERT(false);
        return 0;
    }

    xSink->setInputStream(new FileStream(aPath,
                                         OpenFlag_Read | OpenFlag_Create));
        //TODO! Do anything with the service's XConnectable?
    return xDataStream;
}

star::uno::Reference< star::io::XDataOutputStream > SAL_CALL
PersistentStorageFactory::getDataOutputStream(
    rtl::OUString const & rIdentifier)
    throw (star::lang::IllegalArgumentException, star::uno::RuntimeException)
{
    rtl::OUString aPath;
    if (!createPath(rIdentifier, &aPath))
        throw star::lang::IllegalArgumentException(
                  rtl::OUString(
                      RTL_CONSTASCII_USTRINGPARAM(
                          "Bad com.sun.star.XPersistentStorageFactory."
                              "getDataOutputStream() identifier")),
                  *this,
                  0);

    star::uno::Reference< star::io::XDataOutputStream > xDataStream;
    if (m_xServiceFactory.is())
        try
        {
            xDataStream
                = star::uno::Reference< star::io::XDataOutputStream >(
                      m_xServiceFactory->
                          createInstance(
                              rtl::OUString(
                                  RTL_CONSTASCII_USTRINGPARAM(
                                      "com.sun.star.io.DataOutputStream"))),
                      star::uno::UNO_QUERY);
        }
        catch (star::uno::RuntimeException const &)
        {
            throw;
        }
        catch (star::uno::Exception const &)
        {}
    star::uno::Reference< star::io::XActiveDataSource >
        xSource(xDataStream, star::uno::UNO_QUERY);
    if (!xDataStream.is() || !xSource.is())
    {
        OSL_ASSERT(false);
        return 0;
    }

    xSource->setOutputStream(new FileStream(aPath,
                                            OpenFlag_Write
                                                | OpenFlag_Create));
    return xDataStream;
}
