#include <sys/time.h>
#include <time.h>
#include <errno.h>
#ifndef _FILSTAT_HXX_
#include "filstat.hxx"
#endif



using namespace fileaccess;



#ifdef __cplusplus
extern "C" {
#endif
    
    
    static void deleteStatusFiller(void* p)
    {
        StatusFiller* pp = reinterpret_cast<StatusFiller*>(p);
        delete pp;
    }
    
    
    static void* runThread(void*p)
    {
        pthread_cleanup_push(deleteStatusFiller,p);
        StatusFiller* pp = reinterpret_cast<StatusFiller*>(p);
        
        pp->run(0);
        pthread_cleanup_pop(1);
        return 0;
    }


    static void osa_pthread_mutex_unlock(void *mutex)
    {
        pthread_mutex_unlock((pthread_mutex_t*)mutex);
    }
    

	static void exit_Thread(void *pData)
	{
        reinterpret_cast<StatusFiller*>(pData)->exit();
	}

#ifdef __cplusplus	
}
#endif


/****************************************************************************/
/*                                                                          */
/*                cleanup function for thread specific data                 */
/*                                                                          */
/****************************************************************************/



StatusFillerThread::StatusFillerThread()
{
    pthread_key_create(&m_threadKey,exit_Thread);
}



StatusFillerThread::~StatusFillerThread() 
{
    handle()->exit();
	pthread_key_delete(m_threadKey);
}



StatusFiller* StatusFillerThread::handle()
{
 	StatusFiller* ret;
	if(!(ret = reinterpret_cast<StatusFiller*>(
        pthread_getspecific(m_threadKey)))) {
		ret = new StatusFiller(0);
		pthread_setspecific(m_threadKey,reinterpret_cast<void*>(ret));
	}
	
	return ret;
}


void StatusFillerThread::clear()
{
 	StatusFiller* old = 
        reinterpret_cast<StatusFiller*>(
            pthread_getspecific(m_threadKey));
    if(old)
        old->exit();
    pthread_setspecific(m_threadKey,0);
}



/****************************************************************************/
/*                                                                          */
/*                definition of StatusFiller object                         */
/*                                                                          */
/****************************************************************************/



StatusFiller::StatusFiller(sal_Int32 n_Mask)
    : osl::FileStatus(n_Mask),
      m_bProvided(false),
      m_pFilStat(0),
      m_nError1(osl::FileBase::E_None),
      m_nError2(osl::FileBase::E_None),
      
      m_bRequested(false),
      m_aUnqPath(),
      m_nMask(0),
      
      m_bExited(false)
{
    pthread_mutex_init(&_mut,0);
    pthread_cond_init(&_cP,0);
    pthread_cond_init(&_cR,0);
    
    pthread_attr_init(&_attr);
    pthread_attr_setdetachstate(&_attr,PTHREAD_CREATE_DETACHED);
    
    pthread_create(
        &_thread,&_attr,
        runThread,
        (void*)this);
}



StatusFiller::~StatusFiller()
{    
    pthread_attr_destroy(&_attr);
    pthread_cond_destroy(&_cR);
    pthread_cond_destroy(&_cP);
    pthread_mutex_destroy(&_mut);
    
    delete m_pFilStat;
}



osl::FileBase::RC StatusFiller::getStatusFromNextEntry(
    osl::Directory* pFolder)
{
    osl::FileBase::RC err;
    
    pthread_cleanup_push(osa_pthread_mutex_unlock,(void *)&_mut);
    pthread_mutex_lock(&_mut);
    
    err = pFolder->getNextItem(m_aDirIte);
    // set request parameter
    m_bRequested = err == osl::FileBase::E_None;
    m_aUnqPath = rtl::OUString();
    m_nMask = 0;

    // clear return values
    m_bProvided = false;    
    m_pFilStat = 0;
    m_nError1 = m_nError2 = osl::FileBase::E_None;
    
    if(m_bRequested)
        pthread_cond_signal(&_cR);
    
    pthread_cleanup_pop(1);
    return err;
}



void StatusFiller::getStatusFromFilename(
    const rtl::OUString & aUnqPath,sal_Int32 nMask)
{
    pthread_cleanup_push(osa_pthread_mutex_unlock, (void *)&_mut);
    pthread_mutex_lock(&_mut);
    
    // set request paramter
    m_bRequested = true;
    m_aUnqPath = aUnqPath;
    m_nMask = nMask;
    
    // clear return values
    m_bProvided = false;
    m_pFilStat = 0;
    m_nError1 = m_nError2 = osl::FileBase::E_None;
    
    pthread_cond_signal(&_cR);
    pthread_cleanup_pop(1);
}


void* StatusFiller::run(void*)
{
    while(true) {
        bool bExited,bRequested;
        rtl::OUString aUnqPath;
        sal_Int32 nMask;
        
        pthread_cleanup_push(osa_pthread_mutex_unlock, (void *)&_mut);
        pthread_mutex_lock(&_mut);
        while(!(m_bRequested || m_bExited))
            pthread_cond_wait(&_cR,&_mut);
        
        // copy parameters and set back to default.
        bRequested = m_bRequested, m_bRequested = false;
        aUnqPath = m_aUnqPath, m_aUnqPath = rtl::OUString();
        nMask = m_nMask, m_nMask = 0;
        
        // exit?
        bExited = m_bExited;
        pthread_cleanup_pop(1);
        
        if(bExited)
            break;
        
        if(bRequested && aUnqPath.getLength()) {
            osl::FileStatus* pFilStat = new osl::FileStatus(nMask);
            // might block!
            osl::FileBase::RC err1 = 
                osl::DirectoryItem::get(aUnqPath,m_aDirIte);
            osl::FileBase::RC err2 = osl::FileBase::E_None;
            // might block!
            if(err1 == osl::FileBase::E_None)
                err2 = m_aDirIte.getFileStatus(*pFilStat);
            
            // signal the provision
            pthread_cleanup_push(osa_pthread_mutex_unlock, (void *)&_mut);
            pthread_mutex_lock(&_mut);
            
            m_bProvided = true;            
            m_pFilStat = pFilStat;
            m_nError1 = err1;
            m_nError2 = err2;
            
            pthread_cond_signal(&_cP);
            pthread_cleanup_pop(1);
        }
        else if(bRequested && aUnqPath.getLength() == 0) {
            // never hold a mutex while doing this call
            osl::FileBase::RC err = 
                m_aDirIte.getFileStatus(*((StatusFiller*)this));
            
            // signal the provision
            pthread_cleanup_push(osa_pthread_mutex_unlock, (void *)&_mut);
            pthread_mutex_lock(&_mut);
            
            m_bProvided = true;
            m_pFilStat = 0;
            m_nError2 = err;
            
            pthread_cond_signal(&_cP);
            pthread_cleanup_pop(1);
        }
    }
    
    return 0;
}


void StatusFiller::exit(void)
{
    pthread_cleanup_push(osa_pthread_mutex_unlock, (void *)&_mut);
    pthread_mutex_lock(&_mut);
    m_bExited = true;
    pthread_cond_signal(&_cR);
    pthread_cleanup_pop(1);
}


StatusFiller::Status
StatusFiller::getFileStatus() throw(StatusFiller::timedout)
{
    int retcode(0);
    StatusFiller::Status ret;
    ret.pFilStat = 0;
    ret.nError1 = osl::FileBase::E_None;
    ret.nError2 = osl::FileBase::E_None;
    
    pthread_cleanup_push(osa_pthread_mutex_unlock, (void *)&_mut);
    pthread_mutex_lock(&_mut);
    
    struct timeval now;
    gettimeofday(&now,0);
    
    unsigned long milli = now.tv_usec / 1000 + 5000;
    
    struct timespec timeout;
    timeout.tv_sec = now.tv_sec + milli / 1000;
    timeout.tv_nsec = 1000000 * (milli % 1000);
    
    while(!m_bProvided && retcode != ETIMEDOUT)
        retcode = pthread_cond_timedwait(
            &_cP,&_mut,&timeout);
    
    if(retcode != ETIMEDOUT) {
        m_bProvided = false;
        ret.pFilStat = m_pFilStat, m_pFilStat = 0;
        ret.nError1 = m_nError1, m_nError1 = osl::FileBase::E_None;
        ret.nError2 = m_nError2, m_nError2 = osl::FileBase::E_None;
    }
    
    pthread_cleanup_pop(1);
    
    if(retcode == ETIMEDOUT)
        throw timedout();
    
    return ret;
}


com::sun::star::uno::Reference< com::sun::star::sdbc::XRow > SAL_CALL
StatusFiller::getv( 
    sal_Int32 CommandId,
    Notifier* pNotifier,
    const com::sun::star::uno::Sequence<
    com::sun::star::beans::Property >& properties,
    shell* pShell,
    rtl::OUString& aUnqPath,
    sal_Bool       bIsRegularUsed,
    sal_Bool&      bIsRegular )
    throw(StatusFiller::timedout)
{
    int retcode(0);
    com::sun::star::uno::Reference< com::sun::star::sdbc::XRow > aRow;
    
    pthread_cleanup_push(osa_pthread_mutex_unlock, (void *)&_mut);
    pthread_mutex_lock(&_mut);
    
    struct timeval now;
    gettimeofday(&now,0);
    
    unsigned long milli = now.tv_usec / 1000 + 5000;
    
    struct timespec timeout;
    timeout.tv_sec = now.tv_sec + milli / 1000;
    timeout.tv_nsec = 1000000 * (milli % 1000);
    
    while(!m_bProvided && retcode != ETIMEDOUT)
        retcode = pthread_cond_timedwait(
            &_cP,&_mut,&timeout);
    
    if(retcode != ETIMEDOUT) {
        m_bProvided = false;
        m_pFilStat = 0;
        m_nError1 = osl::FileBase::E_None;
        m_nError2 = osl::FileBase::E_None;
        aRow =
            pShell->getv(
                CommandId,pNotifier,
                properties,*this,aUnqPath,
                bIsRegularUsed,bIsRegular);
    }
    
    pthread_cleanup_pop(1);
    
    if(retcode == ETIMEDOUT)
        throw timedout();
    
    return aRow;
}
