/*************************************************************************
 *
 *  $RCSfile: ucbmain.cxx,v $
 *
 *  $Revision: 1.27 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 17:22:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <vector>

#if defined UNX
#include <unistd.h>
#endif // UNX

#ifndef _COM_SUN_STAR_BRIDGE_XBRIDGEFACTORY_HPP_
#include <com/sun/star/bridge/XBridgeFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_BRIDGE_XINSTANCEPROVIDER_HPP_
#include <com/sun/star/bridge/XInstanceProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERDISTRIBUTOR_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderDistributor.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COMPHELPER_REGPATHHELPER_HXX_
#include <comphelper/regpathhelper.hxx>
#endif
#ifndef _CPPUHELPER_BOOTSTRAP_HXX_
#include <cppuhelper/bootstrap.hxx>
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _OSL_NLSUPPORT_H_
#include <osl/nlsupport.h>
#endif
#ifndef _OSL_SIGNAL_H_
#include <osl/signal.h>
#endif
#ifndef _RTL_STRING_HXX_
#include <rtl/string.hxx>
#endif
#ifndef _RTL_TEXTENC_H_
#include <rtl/textenc.h>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _ISOLANG_HXX
#include <tools/isolang.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _UTL_CONFIGMGR_HXX_
#include <unotools/configmgr.hxx>
#endif
#ifndef _VOS_PROCESS_HXX_
#include <vos/process.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif
#ifndef _VOS_SECURITY_HXX_
#include <vos/security.hxx>
#endif
#ifndef _VOS_THREAD_HXX_
#include <vos/thread.hxx>
#endif

#ifndef _UCB_MAIN_ACCEPTTHREAD_HXX_
#include "acceptthread.hxx"
#endif
#ifndef _UCB_MAIN_CUNOBROK_HXX_
#include "cunobrok.hxx"
#endif
#ifndef _UCB_MAIN_INSTANCEPROVIDER_HXX_
#include "instanceprovider.hxx"
#endif
#ifndef _UCB_MAIN_MACHINE_HXX_
#include "machine.hxx"
#endif
#ifndef INCLUDED_UCB_MAINWRAPPEDSERVICEFACTORY_HXX
#include "mainwrappedservicefactory.hxx"
#endif
#ifndef _UCB_MAIN_PLUGINACCEPTTHREAD_HXX_
#include "pluginacceptthread.hxx"
#endif
#ifndef _UCB_MAIN_UCBDISTRIBUTOR_HXX_
#include "ucbdistributor.hxx"
#endif

namespace unnamed_ucb_main_ucbmain {}
using namespace unnamed_ucb_main_ucbmain;
    // unnamed namespaces don't work well yet...

using namespace com::sun::star;

#if SUPD < 620 && defined SOLARIS
extern "C" {
    void ChangeGlobalInit(); // voodoo stuff...
}
#endif // SUPD, 620, SOLARIS

//============================================================================
//
//  Connection
//
//============================================================================

namespace unnamed_ucb_main_ucbmain {

struct Connection
{
    rtl::OUString m_aConnection;
    rtl::OUString m_aProtocol;
    vos::ORef< ucb_main::AcceptThread > m_xThread;

    inline Connection(rtl::OUString const & rTheConnection,
                      rtl::OUString const & rTheProtocol):
        m_aConnection(rTheConnection), m_aProtocol(rTheProtocol) {}

    rtl::OString getDescription() const;
};

}

//============================================================================
rtl::OString Connection::getDescription() const
{
    rtl::OUStringBuffer aDescription(m_aConnection);
    aDescription.append(sal_Unicode(';'));
    aDescription.append(m_aProtocol);
    return rtl::OString(aDescription.getStr(),
                        aDescription.getLength(),
                        RTL_TEXTENCODING_UTF8);
}

//============================================================================
//
//  signalHandler
//
//============================================================================

namespace unnamed_ucb_main_ucbmain {

extern "C" oslSignalAction SAL_CALL
signalHandler(void *, oslSignalInfo * pInfo)
{
#if OSL_DEBUG_LEVEL > 1
    switch (pInfo ? pInfo->Signal : osl_Signal_FORCE_EQUAL_SIZE)
    {
        case osl_Signal_System:
            fprintf(stderr, "ucb: Caught osl_Signal_System.\n");
            break;

        case osl_Signal_Terminate:
            fprintf(stderr, "ucb: Caught osl_Signal_Terminate.\n");
            break;

        case osl_Signal_AccessViolation:
            fprintf(stderr, "ucb: Caught osl_Signal_AccessViolation.\n");
            break;

        case osl_Signal_IntegerDivideByZero:
            fprintf(stderr, "ucb: Caught osl_Signal_IntegerDivideByZero.\n");
            break;

        case osl_Signal_FloatDivideByZero:
            fprintf(stderr, "ucb: Caught osl_Signal_FloatDivideByZero.\n");
            break;

        case osl_Signal_DebugBreak:
            fprintf(stderr, "ucb: Caught osl_Signal_DebugBreak.\n");
            break;

        case osl_Signal_User:
            fprintf(stderr, "ucb: Caught osl_Signal_User.\n");
            break;

        case osl_Signal_Alarm:
            fprintf(stderr, "ucb: Caught osl_Signal_Alarm.\n");
            break;

        default:
            fprintf(stderr, "ucb: Caught unknown signal.\n");
            break;
    }
#endif // OSL_DEBUG_LEVEL > 1
    return pInfo && pInfo->Signal == osl_Signal_Terminate ?
               osl_Signal_ActIgnore : osl_Signal_ActCallNextHdl;
}

}

//============================================================================
//
//  execute
//
//============================================================================

namespace unnamed_ucb_main_ucbmain {

bool execute()
{
    // Process command line arguments:
    bool bServer = false;
    std::vector< Connection > aConnections;
    {
        rtl::OUString aUserId;
        vos::OSecurity().getUserIdent(aUserId);
        vos::OExtCommandLine aCommandLine;
        sal_uInt32 nCount = aCommandLine.getCommandArgCount();
        for (sal_uInt32 i = 0; i < nCount; ++i)
        {
            rtl::OUString aArgument;
            if (!aCommandLine.getCommandArg(i, aArgument))
            {
                fprintf(stderr,
                        "ucb: Cannot retrieve command line arguments");
                return false;
            }
            if (aArgument.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("-server")))
                bServer = true;
            else if (aArgument.compareToAscii(RTL_CONSTASCII_STRINGPARAM(
                                                  "-connection="))
                         == 0)
            {
                rtl::OUString
                    aConnection(aArgument.copy(RTL_CONSTASCII_LENGTH(
                                                   "-connection=")));
                for (sal_Int32 nPos = 0;; nPos += aUserId.getLength())
                {
                    nPos = aConnection.
                               indexOf(rtl::OUString(
                                           RTL_CONSTASCII_USTRINGPARAM(
                                               "$(USERID)")),
                                       nPos);
                    if (nPos == -1)
                        break;
                    aConnection
                        = aConnection.
                              replaceAt(nPos,
                                        RTL_CONSTASCII_LENGTH("$(USERID)"),
                                        aUserId);
                }
                rtl::OUString aProtocol;
                sal_Int32 nDelim = aConnection.indexOf(';');
                if (nDelim == -1)
                    aProtocol = rtl::OUString::createFromAscii("urp");
                else
                {
                    aProtocol = aConnection.copy(nDelim + 1);
                    aConnection = aConnection.copy(0, nDelim);
                }
                aConnections.push_back(Connection(aConnection, aProtocol));
            }
            else if (aArgument.getLength() > 0
                     && aArgument.compareToAscii(RTL_CONSTASCII_STRINGPARAM(
                                                     "-portal,"))
                            != 0
                     && aArgument.compareToAscii(RTL_CONSTASCII_STRINGPARAM(
                                                     "-userid"))
                            != 0
                     && aArgument.compareToAscii(RTL_CONSTASCII_STRINGPARAM(
                                                     "-env:"))
                            != 0)
                // empty args are generated by ucb.sh,
                // -portal is interpreted by configuration management,
                // -userid is interpreted by InstallUser service,
                // -env is interpreted by some code in RTL...
                fprintf(stderr,
                        "ucb: Ignoring unknown argument %s\n",
                        rtl::OString(aArgument.getStr(),
                                     aArgument.getLength(),
                                     RTL_TEXTENCODING_ASCII_US).
                            getStr());
        }
        if (aConnections.empty())
        {
            fprintf(stderr,
                    "ucb: No connections specified on command line\n");
            return false;
        }
    }

    // Initialize local Service Manager and basic services:
    if (bServer)
        printf("ucb: Initializing...\n");
    uno::Reference< lang::XMultiServiceFactory > xServiceFactory;
    try
    {
        // Put a wrapper around xServiceFactory that initializes the UCB
        // service the first time it is requested (initializing the UCB is
        // expansive, so do that as late as possible):
        uno::Reference< uno::XComponentContext > xCtx =
            cppu::defaultBootstrap_InitialComponentContext();

        xServiceFactory
            = new ucb_main::WrappedServiceFactory(
                uno::Reference< lang::XMultiServiceFactory >(
                    xCtx->getServiceManager(), uno::UNO_QUERY ),
                bServer);
    }
    catch (uno::Exception const &) {}
    if (!xServiceFactory.is())
    {
        fprintf(stderr, "ucb: Error creating RegistryServiceFactory\n");
        return false;
    }
    comphelper::setProcessServiceFactory(xServiceFactory);

    // The following block is here to make sure that the relevant local
    // variables are destructed before xServiceFactory is disposed...
    {
        // Set process wide text encoding (needed by file system functions in
        // osl); this is a HACK---the correct solution would be to set the
        // encoding at every relevant thread via osl_setThreadTextEncoding():
        uno::Any aLocaleAny(
                     utl::ConfigManager::GetConfigManager()->
                         GetDirectConfigProperty(utl::ConfigManager::LOCALE));
        rtl::OUString aLocaleStr;
        if (aLocaleAny >>= aLocaleStr)
        {
            UniString aLanguage;
            UniString aCountry;
            ConvertLanguageToIsoNames(ConvertIsoStringToLanguage(aLocaleStr),
                                      aLanguage,
                                      aCountry);
            rtl_TextEncoding eEncoding
                = osl_getTextEncodingFromLocale(rtl_locale_register(
                                                    aLanguage.GetBuffer(),
                                                    aCountry.GetBuffer(),
                                                    0));
            if (eEncoding == RTL_TEXTENCODING_DONTKNOW)
                OSL_ENSURE(false,
                           "bad osl_getTextEncodingFromLocale() result");
            else
            {
                OSL_ENSURE(eEncoding >= 0
                           && eEncoding <= 65535
                           && 65535 <= UINT_MAX,
                           "rtl_TextEncoding value outside"
                               " sal_uInt16/unsigned range");
                    // this can't happen...
                static char aEnv[] = "SOLAR_USER_RTL_TEXTENCODING=\0\0\0\0\0";
                    // must be static for putenv(); 5 digits suffice for
                    // [0..65535]
                if (sprintf(aEnv + RTL_CONSTASCII_LENGTH( // #100211# - checked
                                       "SOLAR_USER_RTL_TEXTENCODING="),
                            "%u",
                            static_cast< unsigned >(eEncoding))
                        > 5)
                    OSL_ENSURE(false,
                               "numeric representation of rtl_TextEncoding"
                                   " needs more than 5 digits");
                        // this can't happen...
                if (putenv(aEnv) != 0)
                    OSL_ENSURE(false,
                               "putenv(SOLAR_USER_RTL_TEXTENCODING) failed");
            }
        }
        else
            OSL_ENSURE(false,
                       "bad ConfigManager::GetDirectConfigProperty() result");

        // Start services:
        uno::Reference< bridge::XBridgeFactory > xBridgeFactory;
        try
        {
            xBridgeFactory
                = uno::Reference< bridge::XBridgeFactory >(
                      xServiceFactory->
                          createInstance(
                              rtl::OUString::createFromAscii(
                                  "com.sun.star.bridge.BridgeFactory")),
                      uno::UNO_QUERY);
        }
        catch (uno::Exception const &) {}
        if (!xBridgeFactory.is())
        {
            fprintf(stderr, "ucb: Error creating BridgeFactory\n");
            return false;
        }
        uno::Reference< bridge::XInstanceProvider >
            xInstanceProvider(new ucb_main::InstanceProvider(xServiceFactory,
                                                             bServer));

        ucb_main::MachineControl aControl;
        uno::Reference< ucb::XRemoteContentProviderDistributor > xDistributor;
        if (bServer)
        {
            // Create connection broker and let it accept incoming calls (the
            // undoing of a client distribution will only work correctly if
            // there's only one connection):
            VOS_ENSURE(aConnections.size() == 1,
                       "main(): Server with more than one connection\n");
            for (std::vector< Connection >::size_type i = 0;
                 i < aConnections.size(); ++i)
            {
                aConnections[i].m_xThread
                    = new ucb_main::AcceptorThread(xServiceFactory,
                                                   xBridgeFactory,
                                                   xInstanceProvider,
                                                   aConnections[i].
                                                       m_aConnection,
                                                   aConnections[i].
                                                       m_aProtocol);
                aConnections[i].m_xThread->create();
                printf("ucb: ...started %s...\n",
                       static_cast< char const * >(aConnections[i].
                                                       getDescription().
                                                           getStr()));
            }
        }
        else
        {
            // Register distributor service:
            if (!ucb_main::UcbDistributor::registerAtServiceFactory(
                     xServiceFactory, &aControl))
                fprintf(stderr,
                        "ucb: Error registering distributor service\n");

            // Configure and hold distributor service:
            try
            {
                xDistributor
                    = uno::Reference<
                              ucb::XRemoteContentProviderDistributor >(
                          xServiceFactory->
                              createInstance(
                                  rtl::OUString(
                                      RTL_CONSTASCII_USTRINGPARAM(
                       "com.sun.star.ucb.RemoteContentProviderDistributor"))),
                          uno::UNO_QUERY);
            }
            catch (uno::Exception const &) {}
            if (!xDistributor.is())
                fprintf(stderr,
                        "ucb: Error configuring distributor service\n");

            // Create connection brokers and let them accept incoming calls:
            for (std::vector< Connection >::size_type i = 0;
                 i < aConnections.size(); ++i)
            {
                aConnections[i].m_xThread
                    = new ucb_main::PluginAcceptThread(xServiceFactory,
                                                       xBridgeFactory,
                                                       xInstanceProvider,
                                                       aConnections[i].
                                                           m_aConnection,
                                                       aConnections[i].
                                                           m_aProtocol,
                                                       &aControl);
                aConnections[i].m_xThread->create();
            }

            aControl.activate();
        }

        {for (std::vector< Connection >::size_type i = 0;
              i < aConnections.size(); ++i)
        {
            aConnections[i].m_xThread->join();
            aConnections[i].m_xThread = 0;
            if (bServer)
                printf("ucb: ...terminated %s...\n",
                       static_cast< char const * >(aConnections[i].
                                                       getDescription().
                                                           getStr()));
        }}

        // Shutdown:
        if (xDistributor.is())
            xDistributor->disconnectFromAll();
    }

    if (bServer)
        printf("ucb: ...exiting.\n");
    uno::Reference< lang::XComponent >
        xComponent(xServiceFactory, uno::UNO_QUERY);
    if (xComponent.is())
        xComponent->dispose();
    return true;
}

}

//============================================================================
//
//  main
//
//============================================================================

int
#if defined WNT
_cdecl
#endif // WNT
main()
{
#if SUPD < 620 && defined SOLARIS
    ChangeGlobalInit(); // voodoo stuff...
#endif // SUPD, 620, SOLARIS

    osl_addSignalHandler(signalHandler, 0);

    int nReturn = execute() ? EXIT_SUCCESS : EXIT_FAILURE;

#if defined UNX
    _exit(nReturn);
        //@@@ on Solaris, use _exit() to avoid unexplained crashes in exit()
#else // UNX
    return nReturn;
#endif // UNX
}
