/*************************************************************************
 *
 *  $RCSfile: sdesktop.cpp,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: armin $ $Date: 2001/03/08 09:53:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define INCL_PM
#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>

#include <som.xh>
#include <wpobject.xh>
#include <wpfsys.xh>
#include <wpfolder.xh>
#include <wpshadow.xh>
#include <wppgm.xh>
#include <wpnetlnk.xh>
#include <wpshdir.xh>
#include <wpserver.xh>
#include <wpprint.xh>

#include <ctype.h>
#include <stdio.h>

#include "soagent.xih"
#include <wpdesktp.h>
#include <wpsdll.h>

#include <set>

/* this set is used to store globalized icon handles */
typedef set<LHANDLE, equal_to<LHANDLE> > icon_set;


/* specific types */
typedef USHORT MSGSIZ;

typedef struct
{
    MSGSIZ Size;
    BYTE   Type;

    union
    {
        CHAR           str[2*CCHMAXPATHCOMP];
        APIRET         rc;
        wps_objectInfo info;
        wps_linkInfo   linkinfo;
    } Data;

} MessageData;

static const CHAR szTitle[]     = "StarAgent";
static const CHAR szFolder[]    = "<WP_NOWHERE>";
static const CHAR szLibName[]   = "SOAGENT";
static const CHAR szPipeName[]  = "\\PIPE\\STAR_DESKTOP_AGENT";
static const CHAR szObjectID[]  = "<STAR_AGENT>";
static const CHAR szClassName[] = "StarOfficeAgent";
static const ULONG ulBufSize    = 4096;

static CHAR  szSetupString[256];

static void queryTarget(MessageData& Message, WPObject *pObject);

/************************************************************************************
 *
 * Binary strings
 *
 ************************************************************************************
 */

#define HINIBBLE( byte )   (((UCHAR)(byte) & 0xF0) >> 4)
#define LONIBBLE( byte )   ((UCHAR)(byte) & 0x0F)
#define MAKEBYTE( lo, hi ) ( ((UCHAR)(lo) & 0x0F) | (((UCHAR)(hi) & 0x0F) << 4) )

//************************************************************************************

static inline CHAR NibbleToChar( BYTE nibble )
{
    if( nibble < 0x0A )
        return '0' + nibble;
    else if( nibble < 0x10 )
        return 'A' + ( nibble - 0x0A );
    else
        return '?';
}

//***********************************************************************************

static inline BYTE CharToNibble( CHAR c )
{
    if ( c >= '0' && c <= '9' )
        return c - '0';
    else if ( c >= 'A' && c <= 'F' )
        return c - 'A' + 0x0A;
    else if ( c >= 'a' && c <= 'f' )
        return c - 'a' + 0x0a;
    else
        return (BYTE)-1;
}

/************************************************************************************
 *
 * ObjectHandleToString
 *
 ************************************************************************************
 */

static ULONG ObjectHandleToString(const HOBJECT hObject, PSZ pszString, ULONG cbStringSize)
{
    static const ULONG cbRequired = 2 * sizeof(HOBJECT) + 5;

    if(hObject && cbRequired <= cbStringSize )
    {
        if(pszString)
        {
            PBYTE pBytes = (PBYTE) &hObject;
            BYTE  nCRC   = 0;
            BYTE  cbSize = sizeof(HOBJECT);

            /*
             * encapsulate object handle in <>,
             * so that the office can handle it as object id
             */
            *(pszString++) = '<';

            while( cbSize-- )
            {
                BYTE b = *(pBytes++);

                *(pszString++) = NibbleToChar( LONIBBLE( b ) );
                *(pszString++) = NibbleToChar( HINIBBLE( b ) );

                nCRC ^= b;
            }

            // write a checksum to validate on reading
            *(pszString++) = NibbleToChar( LONIBBLE( nCRC ) );
            *(pszString++) = NibbleToChar( HINIBBLE( nCRC ) );

            *(pszString++) = '>';
            *pszString     = '\0';
        }

        return cbRequired;
    }
    return 0;
}

/************************************************************************************
 *
 * StringToObjectHandle
 *
 ************************************************************************************
 */


extern "C" HOBJECT StringToObjectHandle( PSZ pszStr )
{
    BYTE bBuffer[sizeof(HOBJECT) + 1];

    if((*(pszStr++) == '<') && (strlen(pszStr) == 2 * sizeof(HOBJECT) + 3))
    {
        PBYTE pBytes = (PBYTE) &bBuffer;
        BYTE  nCRC   = 0;
        BYTE  cbSize = sizeof(HOBJECT) + 1;

        while( cbSize -- )
        {
            BYTE bLo, bHi;
            CHAR c = *(pszStr++);

            bLo = CharToNibble( c );
            c = *(pszStr++);
            bHi = CharToNibble( c );

            *(pBytes++) = MAKEBYTE( bLo, bHi );
        }

        // calculate checksum
        cbSize = sizeof(HOBJECT);
        while( cbSize-- )
        {
            nCRC ^= bBuffer[cbSize];
        }

        // validate checksum
        if(nCRC == bBuffer[sizeof(HOBJECT)])
            return *((HOBJECT *) &bBuffer);
    }

    return NULL;
}

/************************************************************************************
 *
 * ResourceIDToString
 *
 ************************************************************************************
 */

static ULONG ResourceIDToString(const ULONG resID, PSZ pszString, ULONG cbStringSize)
{
    static const ULONG cbRequired = 2 * sizeof(ULONG) + 2;

    if(resID && cbRequired <= cbStringSize )
    {
        if(pszString)
        {
            PBYTE pBytes = (PBYTE) &resID;
            UCHAR cbSize = 4;

            *pszString++ = ',';

            while( cbSize-- )
            {
                BYTE b = *(pBytes++);

                *(pszString++) = NibbleToChar( LONIBBLE( b ) );
                *(pszString++) = NibbleToChar( HINIBBLE( b ) );
            }

            *pszString = '\0';
        }

        return cbRequired;
    }
    return 0;
}

/**************************************************************************************
 *
 * returnError - prepare buffer for returning an error value
 *
 **************************************************************************************
 */

static inline void returnError(MessageData& Message, APIRET rc)
{
    Message.Type    = API_ERROR;
    Message.Size    = sizeof(APIRET);
    Message.Data.rc = rc;
}

/**************************************************************************************
 *
 * DosOpenNPipe - open named pipe
 *
 **************************************************************************************
 */

static const ULONG ulOpenFlags  = OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS;
static const ULONG ulOpenMode   = OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYREADWRITE | OPEN_ACCESS_READWRITE;
static const ULONG ulAttributes = FILE_NORMAL;

static inline APIRET DosOpenNPipe(PCSZ pszPipeName, PHPIPE phPipe, UCHAR nmax)
{
    APIRET rc;
    UCHAR  n = 0;
    ULONG  ulAction;
    
    while(n++ < nmax)
    {
        rc = DosOpen(pszPipeName, phPipe, &ulAction, 0, ulAttributes, ulOpenFlags, ulOpenMode, NULL);

        switch(rc)
        {
        case NO_ERROR:
            break;
        case ERROR_PIPE_BUSY:
            // wait for the connection to be available
            DosWaitNPipe(pszPipeName, 0);
            continue;
        default:
            // give the wps a chance to create the pipe
            DosSleep(500);
            continue;
        }
        
        break;
    }

    return rc;
}

/**************************************************************************************
 *
 * DosReadNPipe - read from pipe in two steps
 *
 **************************************************************************************
 */

static inline APIRET DosReadNPipe(HPIPE hPipe, PVOID buffer, ULONG ulBufSize)
{
    ULONG  ulActual;
    MSGSIZ msgSize;
    APIRET rc;

    /* read data size first */
    rc = DosRead(hPipe, &msgSize, sizeof(MSGSIZ), &ulActual);

    /* ignore any errors like >>more data<< */
    if(ulActual != sizeof(MSGSIZ))
        return ERROR_BROKEN_PIPE;
            
    /* check buffer size */
    if(ulBufSize < sizeof(MSGSIZ) + msgSize)
        return ERROR_BUFFER_OVERFLOW;

    /* add the size of the type information */
    msgSize += sizeof(MessageData::Type);

    /* read the rest of this data block */
    rc = DosRead(hPipe, (PVOID) ((PBYTE) buffer + sizeof(MSGSIZ)), msgSize, &ulActual);

    /* ignore any errors like >>more data<< */
    if(rc || (ulActual != msgSize))
        return rc;

    /* success - complete size information */
    *(MSGSIZ *) buffer = msgSize - sizeof(MessageData::Type);
    
    return NO_ERROR;
}


/**************************************************************************************
 *
 * DosWriteNPipe - write the correct number of bytes to pipe
 *
 **************************************************************************************
 */

static inline APIRET DosWriteNPipe(HPIPE hPipe, PVOID buffer)
{
    APIRET rc;
    ULONG  ulSize;
    ULONG  ulActual;

    /* determine correct size */
    ulSize = sizeof(MSGSIZ) + sizeof(MessageData::Type) + *(MSGSIZ*)buffer;
    
    rc = DosWrite(hPipe, buffer, ulSize, &ulActual);

    /* this is a protocol error */
    if(ulActual != ulSize)
        return rc;

    return NO_ERROR;
}

/**************************************************************************************
 *
 * identifyObject - find suitable string to identify an object
 *
 **************************************************************************************
 */

static void identifyObject(WPObject *pObject, PSZ pszBuffer, UCHAR& nSize,
                           USHORT& nAttribs, BOOL bFullPath)
{
    BOOL bDone = FALSE;
    SOMClass *pClass = pObject->somGetClass();

    PSZ pszObjectID = pObject->wpQueryObjectID();

    // query if object is a file
    if(pClass->somDescendedFrom(_WPFileSystem))
    {
        nAttribs |= OBJECT_ATTRIB_IS_FILESYSTEM;

        // query if object is a folder - ignore object ID if not
        if(pClass->somDescendedFrom(_WPFolder))
        {
            nAttribs |= OBJECT_ATTRIB_IS_FOLDER;

            if(pszObjectID && (strncmp(pszObjectID, "<WP_", 4) != 0))
                pszObjectID = NULL;
        }
        else
            pszObjectID = NULL;

        if(!pszObjectID)
        {
            ULONG ulSize = CCHMAXPATHCOMP;

            if(((WPFileSystem *) pObject)->wpQueryRealName(pszBuffer, &ulSize, bFullPath))
            {
                pszBuffer[ulSize] = '\0';
                nSize = ulSize;
                bDone = TRUE;
            }
        }
    }

    // already done ?
    if(!bDone)
    {
        // ignore object id when it contains small characters
        if(pszObjectID)
        {
            for(USHORT n = 0; pszObjectID[n]; n++)
                if(islower(pszObjectID[n]))
                {
                    pszObjectID = NULL;
                    break;
                }
        }

        // copy object ID if available and does not contain forbidden characters
        if(pszObjectID && (strpbrk(pszObjectID, "\\/|:,") == NULL))
        {
            nSize = strlen(pszObjectID);

            // copy identifyer to message
            strncpy(pszBuffer, pszObjectID, nSize);
            pszBuffer[nSize] = '\0';
        }
        else
        {
            nSize = ObjectHandleToString(pObject->wpQueryHandle(), pszBuffer, 13);
        }
    }
}


/**************************************************************************************
 *
 * copyObjectData - collect data to transfer via pipe
 *
 **************************************************************************************
 */

static void copyObjectData(MessageData& Message, WPObject *pObject, icon_set *pIconList)
{
    wps_objectInfo * pInfo = &Message.Data.info;

    // clear structure
    memset(pInfo, 0, sizeof(wps_objectInfo));

    // set icon handle
    pInfo->hIcon = pObject->wpQueryIcon();

    // make icon handle accessable to other processes
    if(WinSetPointerOwner(pInfo->hIcon, 0, FALSE))
        pIconList->insert(pInfo->hIcon);

    // query object identification string
    identifyObject(pObject, pInfo->szName, pInfo->cbName, pInfo->attrObject, FALSE);

    // query title to display
    PSZ pszTitle = pObject->wpQueryTitle();

    if(pszTitle)
    {
        pInfo->cbTitle = strlen(pszTitle);
        strncpy(pInfo->szTitle + pInfo->cbName, pszTitle, pInfo->cbTitle);
        pInfo->szTitle[pInfo->cbName + pInfo->cbTitle] = '\0';
    }

    // query and translate object style
    ULONG ulStyle = pObject->wpQueryStyle();

    if(ulStyle & OBJSTYLE_NOCOPY)
        pInfo->attrObject |= OBJECT_ATTRIB_DO_NOT_COPY;

    if(ulStyle & OBJSTYLE_NOMOVE)
        pInfo->attrObject |= OBJECT_ATTRIB_DO_NOT_MOVE;
    
    if(ulStyle & OBJSTYLE_NOLINK)
        pInfo->attrObject |= OBJECT_ATTRIB_DO_NOT_LINK;

    if(ulStyle & OBJSTYLE_NODELETE)
        pInfo->attrObject |= OBJECT_ATTRIB_DO_NOT_DELETE;
    
    if(ulStyle & OBJSTYLE_NORENAME)
        pInfo->attrObject |= OBJECT_ATTRIB_DO_NOT_RENAME;

    if(ulStyle & OBJSTYLE_NODRAG)
        pInfo->attrObject |= OBJECT_ATTRIB_DO_NOT_DRAG;

    if(ulStyle & OBJSTYLE_NODROPON)
        pInfo->attrObject |= OBJECT_ATTRIB_DO_NOT_DROP_ON;

    if(ulStyle & OBJSTYLE_NOPRINT)
        pInfo->attrObject |= OBJECT_ATTRIB_DO_NOT_PRINT;

    if(ulStyle & OBJSTYLE_NOTVISIBLE)
        pInfo->attrObject |= OBJECT_ATTRIB_HIDDEN;

    if(ulStyle & OBJSTYLE_NOPRINT)
        pInfo->attrObject |= OBJECT_ATTRIB_DO_NOT_PRINT;

    SOMClass *pClass = pObject->somGetClass();

    if(pClass->somDescendedFrom(_WPShadow) || pClass->somDescendedFrom(_WPProgram))
    {
        pInfo->attrObject |= OBJECT_ATTRIB_IS_LINK;
    }

    Message.Size = sizeof(wps_objectInfo) + pInfo->cbName + pInfo->cbTitle;

    return;
}

/**************************************************************************************
 *
 * queryIconLocation - find a usable icon location to transfer
 *
 **************************************************************************************
 */

static void queryIconLocation(MessageData& Message, WPObject *pObject)
{
    returnError(Message, ERROR_NOT_SUPPORTED);
}

/**************************************************************************************
 *
 * queryHandle - report object Handle
 *
 **************************************************************************************
 */

static inline void queryHandle(MessageData& Message, WPObject *pObject)
{
    Message.Size = ObjectHandleToString(pObject->wpQueryHandle(), Message.Data.str, 13);
}


/**************************************************************************************
 *
 * queryFileLocation - find a usable icon location to transfer
 *
 **************************************************************************************
 */

static inline void queryFileLocation(MessageData& Message, WPObject *pObject)
{
    // if filesystem object, return path
    if(pObject->somGetClass()->somDescendedFrom(_WPFileSystem))
    {
        ULONG ulSize = CCHMAXPATHCOMP;

        if(((WPFileSystem *) pObject)->wpQueryRealName(Message.Data.str, &ulSize, TRUE))
        {
            Message.Data.str[ulSize] = '\0';
            Message.Size = ulSize + 1;
        }
        else
            returnError(Message, ERROR_PATH_NOT_FOUND);
    }

    else
    {
        returnError(Message, ERROR_NOT_SUPPORTED);
    }
}

/**************************************************************************************
 *
 * renameObject - set new title for wps object
 *
 **************************************************************************************
 */

static inline void renameObject(MessageData& Message, WPObject *pObject, icon_set *pIconList)
{
    BOOL bRet;
    CHAR *pTitle = Message.Data.str + strlen(Message.Data.str) + 1;

    if(pObject->somGetClass()->somDescendedFrom(_WPFileSystem))
    {
        bRet = ((WPFileSystem *) pObject)->wpSetTitleAndRenameFile(pTitle, 0);
    }
    else
    {
        bRet = pObject->wpSetTitle(pTitle);
    }

    if(bRet)
    {
        copyObjectData(Message, pObject, pIconList);
    }
    else
    {
        returnError(Message,ERROR_NOT_SUPPORTED);
    }
}

/**************************************************************************************
 *
 * queryTarget - query target of a link
 *
 **************************************************************************************
 */

static inline void queryLinkInfo(MessageData& Message, WPObject *pObject, icon_set *pIconList)
{
    wps_linkInfo *pInfo = &Message.Data.linkinfo;
    SOMClass *pClass = pObject->somGetClass();

    // clear structure
    memset(pInfo, 0, sizeof(wps_linkInfo));

    // set icon handle
    pInfo->hIcon = pObject->wpQueryIcon();

    // make icon handle accessable to other processes
    if(WinSetPointerOwner(pInfo->hIcon, 0, FALSE))
        pIconList->insert(pInfo->hIcon);

    /*********************************************
     *  WPShadow
     *********************************************
     */

    if(pClass->somDescendedFrom(_WPShadow))
    {
        WPObject *pTarget = ((WPShadow *) pObject)->wpQueryShadowedObject(FALSE);

        if(pTarget)
        {
            USHORT attrObject = 0;

            // determine link type
            pInfo->linkType = LINK_TYPE_SHADOW;
            if(pTarget->somGetClass()->somDescendedFrom(_WPFolder))
            {
                pInfo->linkType |= LINK_TYPE_DIR;
            }

            // query object identification string
            identifyObject(pTarget, pInfo->szTarget, pInfo->cbTarget, attrObject, TRUE);
        }
        else
            returnError(Message, ERROR_FILE_NOT_FOUND);
    }

    /*********************************************
     *  WPProgram
     *********************************************
     */

    else if(pClass->somDescendedFrom(_WPProgram))
    {
        ULONG ulSize;

        // query buffer size needed
        if(((WPProgram *) pObject)->wpQueryProgDetails(NULL, &ulSize))
        {
            PPROGDETAILS pDetails = (PPROGDETAILS) pObject->wpAllocMem(ulSize, NULL);

            if(pDetails)
            {
                // query program details
                if(((WPProgram *) pObject)->wpQueryProgDetails(pDetails, &ulSize))
                {
                    if(pDetails->pszExecutable)
                    {
                        pInfo->linkType = LINK_TYPE_PROGRAM;

                        // copy executable name as target
                        strcpy(pInfo->szTarget, pDetails->pszExecutable);
                        pInfo->cbTarget = strlen(pDetails->pszExecutable);

                        // copy parameters if any
                        if(pDetails->pszParameters)
                        {
                            char * cp = pInfo->szArguments + pInfo->cbTarget;

                            strcpy(cp, pDetails->pszParameters);
                            pInfo->cbArguments = strlen(pDetails->pszParameters);
                        }

                        // copy startup dir if set
                        if(pDetails->pszStartupDir)
                        {
                            char * cp = pInfo->szWorkingDir + pInfo->cbTarget + pInfo->cbArguments;

                            strcpy(cp, pDetails->pszStartupDir);
                            pInfo->cbWorkingDir = strlen(pDetails->pszStartupDir);
                        }
                    }
                    else
                        returnError(Message, ERROR_NOT_SUPPORTED);
                }
                else
                    returnError(Message, ERROR_NOT_SUPPORTED);

                pObject->wpFreeMem((PBYTE) pDetails);
            }
            else
                returnError(Message, ERROR_NOT_ENOUGH_MEMORY);
        }
        else
            returnError(Message, ERROR_FILE_NOT_FOUND);
    }

    else
    {
        returnError(Message, ERROR_NOT_SUPPORTED);
    }

    Message.Size = sizeof(wps_linkInfo) + pInfo->cbTarget + pInfo->cbArguments + pInfo->cbWorkingDir;
}

/**************************************************************************************
 *
 * AtExit - ExitHandler for desktop integration thread
 *
 **************************************************************************************
 */

typedef struct
{
    HPIPE    hPipe;
    icon_set aIconList;

} ExitData;

static LONG SysPointerList[] =
{
    SPTR_APPICON,
    SPTR_FOLDER,
    SPTR_PROGRAM,
    0
};

extern "C" void _System AtExit(ULONG ulParam)
{
    if(ulParam)
    {
        ExitData *pData = (ExitData *) ulParam;

        /* ensure pipe is closed */
        DosClose(pData->hPipe);

        PTIB ptib = NULL;
        PPIB ppib = NULL;

        /* query wps process id */
        if(NO_ERROR == DosGetInfoBlocks(&ptib, &ppib))
        {
            icon_set::iterator iPos;
            USHORT n;

            /* remove system pointer from list */
            for(n = 0; SysPointerList[n]; n++)
            {
                HPOINTER hIcon = WinQuerySysPointer(HWND_DESKTOP, SysPointerList[n], FALSE);

                pData->aIconList.erase(hIcon);
            }

            /* reset pointer owner */
            for(iPos = pData->aIconList.begin(); iPos != pData->aIconList.end(); iPos++)
            {
                WinSetPointerOwner(*iPos, ppib->pib_ulpid, TRUE);

                /*
                 * do not use, wps does not reload icons for folder
                 *
                 * WinDestroyPointer(*iPos);
                 */
            }
        }

        delete pData;
    }
}

/**************************************************************************************
 *
 * StarDesktopAgent - WPS thread for desktop integration
 *
 **************************************************************************************
 */

#define PDATA ((StarOfficeAgentData *)Param)

extern "C" void _System StarDesktopAgent(ULONG Param)
{
    APIRET    rc;
    HPIPE     hPipe;
    ExitData *pExitData = new ExitData;

    /* ensure exit data is created */
    if(!pExitData)
        return;

    /* make sure thread is not killed in between */
    if(DosEnterCritSec())
    {
        delete pExitData;
        return;
    }

    /* create named pipe */
    rc = DosCreateNPipe( (PSZ) szPipeName,
                         &hPipe,
                         NP_ACCESS_DUPLEX,    /* open pipe for read and write access */
                         0x01,                /* allow only one instance */
                         ulBufSize,           /* output buffer size */
                         ulBufSize,           /* input buffer size */
                         0L                   /* use default time-out time */
                       );
    if(!rc) {
        /* set exit handler */
        pExitData->hPipe = hPipe;

        ((PFN2U) PDATA->fnExit)((ULONG) &AtExit, (ULONG) pExitData);
    }

    /* critical section ended */
    DosExitCritSec();

    /* exit thread on errors */
    if(rc) return;

    while(PDATA->bRun)
    {
        /* wait until a client connects */
        if(DosConnectNPipe(hPipe))
            continue;

        while(PDATA->bRun)
        {
            MessageData Message;
            WPObject *  pObject;
            WPFolder *  pFolder;

            try
            {
                if(DosReadNPipe(hPipe, (PVOID) &Message, sizeof(Message)))
                    break;

                // replace line-ends with eofs
                for(char *cp = Message.Data.str; *cp != '\0';)
                {
                    if(*cp == '\n')
                        *cp = '\0';

                    cp++;
                }

                if(Message.Type == FIND_FIRST_OBJECT || Message.Type == POPULATE_FOLDER || Message.Type == BUILD_CRC )
                {
                    // parameter string is path of folder
                    pFolder = (WPFolder *) _WPObject->wpclsQueryFolder(Message.Data.str, FALSE);

                    if(pFolder)
                    {
                        if(Message.Type == FIND_FIRST_OBJECT)
                        {
                            pObject = pFolder->wpQueryContent(NULL, QC_FIRST);

                            if(pObject)
                                copyObjectData(Message, pObject, &pExitData->aIconList);
                            else
                                returnError(Message, ERROR_NO_MORE_FILES);
                        }
                        else if(Message.Type == POPULATE_FOLDER)
                        {
                            // the folder must be populated to display all its content
                            if(pFolder->wpPopulate(NULLHANDLE, NULL, FALSE))
                            {
                                pFolder->wpLockObject();
                                returnError(Message, NO_ERROR);
                            }
                            else
                                returnError(Message, ERROR_NO_MORE_FILES);
                        }
                        else
                        {
                            ULONG nCRC = 0;

                            pObject = pFolder->wpQueryContent(NULL, QC_FIRST);

                            while(pObject)
                            {
                                HOBJECT hObject = pObject->wpQueryHandle();
                                nCRC ^= hObject;

                                pObject = pFolder->wpQueryContent(pObject, QC_NEXT);
                            }

                            Message.Data.rc = nCRC;
                            Message.Size = sizeof(ULONG);
                        }
                    }
                    else
                    {
                        returnError(Message, ERROR_PATH_NOT_FOUND);
                    }
                }
                else
                {
                    HOBJECT hObject = StringToObjectHandle(Message.Data.str);

                    if(hObject)
                    {
                        pObject = _WPObject->wpclsQueryObject(hObject);
                    }
                    else
                    {
                        pObject = _WPFileSystem->wpclsQueryObjectFromPath(Message.Data.str);

                        /*
                         * for WPFileSystem::wpclsQueryObjectFromPath() does not recognize objects from
                         * their IDs, which are not descended from WPFileSystem, we need this fallback here.
                         */
                        
                        if(!pObject)
                            pObject = _WPObject->wpclsQueryObject(WinQueryObject(Message.Data.str));
                    }

                    if(pObject)
                    {
                        switch(Message.Type)
                        {
                        case FIND_NEXT_OBJECT:

                            // the folder must be awake to display all its content
                            if(pFolder = (WPFolder *) pObject->wpQueryFolder())
                            {
                                pObject = pFolder->wpQueryContent(pObject, QC_NEXT);

                                if(pObject)
                                    copyObjectData(Message, pObject, &pExitData->aIconList);
                                else
                                    returnError(Message, ERROR_NO_MORE_FILES);
                            }
                            else
                                returnError(Message, ERROR_PATH_NOT_FOUND);

                            break;

                        case GET_OBJECT_INFO:

                            copyObjectData(Message, pObject, &pExitData->aIconList);
                            break;

                        case GET_OBJECT_HANDLE:

                            queryHandle(Message, pObject);
                            break;

                        case GET_OBJECT_LOCATION:

                            queryFileLocation(Message, pObject);
                            break;

                        case GET_OBJECT_ICON:

                            queryIconLocation(Message, pObject);
                            break;

                        case GET_LINK_INFO:

                            queryLinkInfo(Message, pObject, &pExitData->aIconList);
                            break;

                        case RENAME_OBJECT:

                            renameObject(Message, pObject, &pExitData->aIconList);
                            break;

                        case DELETE_OBJECT:
                            pObject->wpDelete(0);

                            Message.Data.str[0] = '\0';
                            Message.Size = 1;

                            break;

                        case RELEASE_LOCK:
                            pObject->wpUnlockObject();

                            Message.Data.str[0] = '\0';
                            Message.Size = 1;

                            break;

                        default:
                            returnError(Message, ERROR_NOT_SUPPORTED);
                            break;
                        } /* switch */
                    } /* if */
                    else
                        returnError(Message, ERROR_FILE_NOT_FOUND);
                } /* else */

                if(DosWriteNPipe(hPipe, (PVOID) &Message))
                    break;
            }
            catch(...)
            {
                /* reconnect on any error */
                break;
            }
        }
        
        DosDisConnectNPipe(hPipe);
    }
}

/**************************************************************************************
 *
 * wps_connect - connect to agent at startup
 *
 **************************************************************************************
 */

extern "C" HPIPE wps_connect()
{
    HPIPE hPipe;

    // construct setup string
    sprintf((char *) szSetupString, "OBJECTID=%s;%s=%s;%s=StarDesktopAgent;%s=32768",
            szObjectID, WPSETUPKEY_LIBRARY, _WPS_DLL_NAME, WPSETUPKEY_FUNCTION, WPSETUPKEY_STACK);

    // is agent object still alive ?
    HOBJECT hObject = WinQueryObject(szObjectID);

    if(hObject)
    {
        // the agent should be in connnect()
        if(NO_ERROR == DosOpenNPipe(szPipeName, &hPipe, 2))
            return hPipe;

        // if not, destroy agent
        WinDestroyObject(hObject);
    }

    // create agent object
    if(!WinCreateObject(szClassName, szTitle, szSetupString, szFolder, CO_REPLACEIFEXISTS))
    {
        // if creation failed, register class and try again
        if(!WinRegisterObjectClass(szClassName, szLibName) ||
           !WinCreateObject(szClassName, szTitle, szSetupString, szFolder, CO_REPLACEIFEXISTS))
        {
            return NULL;
        }
    }

    // try to open the pipe
    if(NO_ERROR != DosOpenNPipe(szPipeName, &hPipe, 5))
        return NULL;

    return hPipe;
}

/**************************************************************************************
 *
 * wps_reconnect - reconnect to agent after pipe error
 *
 **************************************************************************************
 */

extern "C" HPIPE wps_reconnect(HPIPE hPipe)
{
    // close old pipe handle
    DosClose(hPipe);

    // is agent object still alive ?
    HOBJECT hObject = WinQueryObject(szObjectID);

    if(hObject)
    {
        // the agent should be in connnect()
        if(NO_ERROR == DosOpenNPipe(szPipeName, &hPipe, 2))
            return hPipe;

        // if not, destroy agent
        WinDestroyObject(hObject);
    }

    // recreate agent
    if(!WinCreateObject(szClassName, szTitle, szSetupString, szFolder, CO_REPLACEIFEXISTS))
    {
        return NULL;
    }

    // try to open the pipe
    if(NO_ERROR != DosOpenNPipe(szPipeName, &hPipe, 5))
        return NULL;

    return hPipe;
}

/**************************************************************************************
 *
 * wps_disconnect - disconnect from and delete agent
 *
 **************************************************************************************
 */

extern "C" VOID wps_disconnect(HPIPE hPipe)
{
    DosClose(hPipe);
    
    // is agent object still alive ?
    HOBJECT hObject = WinQueryObject(szObjectID);
    if(hObject) WinDestroyObject(hObject);
}

/**************************************************************************************
 *
 * wps_request - send a request to agent
 *
 **************************************************************************************
 */

extern "C" APIRET wps_request(HPIPE hPipe, const PSZ pszObject, BYTE aType,
                              PVOID pBuffer, PULONG pulSize)
{
    MessageData Message;

    // copy path of the folder
    strcpy(Message.Data.str, pszObject);

    // set data size and type
    Message.Size = strlen(Message.Data.str) + 1;
    Message.Type = aType;

    // send query via pipe
    APIRET rc = DosWriteNPipe(hPipe, (PVOID) &Message);
    
    if(rc == NO_ERROR )
    {
        // receive data
        rc = DosReadNPipe (hPipe, (PVOID) &Message, sizeof(Message));

        if(rc == NO_ERROR)
        {
            // query failed - return error code
            if(Message.Type == API_ERROR)
                return Message.Data.rc;

            // data available, check for sufficient buffer size
            if(*pulSize < Message.Size)
                return ERROR_BUFFER_OVERFLOW;

            // copy data to buffer and set its size
            memcpy(pBuffer, &Message.Data, Message.Size);
            *pulSize = Message.Size;
        }
    }
    
    return rc;
}

/**************************************************************************************
 *
 * wps_init - initialize api at startup
 *
 **************************************************************************************
 */

extern "C" void* wps_init()
{
    static wps_api api =
    {
        &wps_connect,
        &wps_reconnect,
        &wps_disconnect,
        &wps_request,
        &StringToObjectHandle,
    };

    return &api;
}

