/*************************************************************************
 *
 *  $RCSfile: envset.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: svesik $ $Date: 2001/05/04 16:40:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <stdlib.h>

#include "stream.hxx"
#include "fsys.hxx"
#include "iparser.hxx"
#include "geninfo.hxx"
#include "shellprp.hxx"
#include "envset.hxx"

#include <stdio.h>

//
// class SwitchList
//
#ifdef GCC
#define private public
#endif

#ifdef MAC
#define putenv(x)
#endif

static ByteString aPathSep =
	ByteString( DirEntry::GetAccessDelimiter(), gsl_getSystemTextEncoding());
static ByteString aSearchSep =
	ByteString( DirEntry::GetSearchDelimiter(), gsl_getSystemTextEncoding());

/*****************************************************************************/
void SwitchList::InsertUnique( Switch *pObject )
/*****************************************************************************/
{
	BOOL bFound = FALSE;

	for ( ULONG i = 0; !bFound && i < Count(); i++ ) {
		if ( *GetObject( i ) == *pObject )
			bFound = TRUE;
	}

	if ( !bFound )
		Insert( pObject, LIST_APPEND );
}



//
// class EnvironmentVariable
//

/*****************************************************************************/
EnvironmentVariable::EnvironmentVariable( const ByteString &rVar,
										 const ByteString &rVal )
/*****************************************************************************/
				: ByteString( rVar ),
				sValue( rVal )
{
}

/*****************************************************************************/
EnvironmentVariable::EnvironmentVariable( const ByteString &rVar )
/*****************************************************************************/
				: ByteString( rVar ),
				sValue( "" )
{
}

/*****************************************************************************/
ByteString &EnvironmentVariable::GetValue( BOOL bOutOfEnv )
/*****************************************************************************/
{
	if ( bOutOfEnv )
		GetEnv();

	while ( sValue.SearchAndReplace( "$/", aPathSep ) != STRING_NOTFOUND );
	while ( sValue.SearchAndReplace( "$:", aSearchSep ) != STRING_NOTFOUND );
	return sValue;
}

/*****************************************************************************/
void EnvironmentVariable::SetValue( const ByteString &rVal, BOOL bIntoEnv )
/*****************************************************************************/
{
	sValue = rVal;

	if ( bIntoEnv )
		PutEnv();
}

/*****************************************************************************/
void EnvironmentVariable::PutEnv()
/*****************************************************************************/
{
	putenv(( char * )( GetSetter().GetBuffer()));
//	putenv( const_cast<char*>(GetSetter().GetStr()));
}

/*****************************************************************************/
void EnvironmentVariable::PutEnv( const ByteString &rVal )
/*****************************************************************************/
{
	SetValue( rVal, TRUE );
}

/*****************************************************************************/
ByteString &EnvironmentVariable::GetEnv()
/*****************************************************************************/
{
	sValue = ByteString( getenv( GetBuffer()));

	return sValue;
}

/*****************************************************************************/
ByteString EnvironmentVariable::GetSetter( BOOL bUnset )
/*****************************************************************************/
{
	ByteString sNewValue( GetValue());
	ByteString sUnsetter;
	ShellProperties& theShProps = ShellProperties::getShellProperties();

	if ( sNewValue.GetTokenCount( ' ' ) > 1 ) {
		ByteString sTmp(theShProps.getQuote());
		sTmp +=	sNewValue;
		sTmp += theShProps.getQuote();
		sNewValue = sTmp;
	}

	ByteString sCommand;
	if ( (*this).GetChar( 0 ) == '*' ) {
		(*this).SetChar( 0, ' ' );
		if ( !sNewValue.Len())
			sCommand = theShProps.getAliasUnsetter(*this );
		else {
			if ( bUnset ) {
				sCommand = theShProps.getAliasUnsetter(*this );
				sCommand +=	theShProps.getCommandSeparator();
				sCommand = theShProps.getAliasSetter(*this, sNewValue );
			}
			else {
				sCommand = theShProps.getAliasSetter(*this, sNewValue );
			}
		}
	}
	else if ( !sNewValue.Len() ) {
		sCommand = theShProps.getEnvUnsetter(*this);
	}
	else {
		if ( bUnset ) {
			sCommand = 	theShProps.getEnvUnsetter(*this);
			sCommand +=	theShProps.getCommandSeparator();
			sCommand += theShProps.getEnvSetter(*this, sNewValue);
		}
		else {
			sCommand = theShProps.getEnvSetter(*this, sNewValue);
		}
	}

	return sCommand;
}

//
// class EnvironmentSetter
//

/*****************************************************************************/
EnvironmentSetter::EnvironmentSetter( const ByteString &rConfigFile,
					GenericInformationList *pVerList,
					EnvironmentSetter *pSourceSetter )
/*****************************************************************************/
				: pPossibleSwitches( NULL ),
				pInfoList( NULL ),
				nError( ENVSET_NO_ERROR ),
				pVersionList( pVerList )
{
	// copy source
	if ( pSourceSetter ) {
		for ( ULONG i = 0; i < pSourceSetter->Count(); i++ ) {
			EnvironmentVariable *pNewVar =
				new EnvironmentVariable( *(pSourceSetter->GetObject( i )),
					pSourceSetter->GetObject( i )->GetValue());
			EnvironmentList::Insert( pNewVar, LIST_APPEND );
		}
	}

	// check if file is valid
	DirEntry aDirEntry( rConfigFile );
	if ( !aDirEntry.Exists())
		nError = ENVSET_NO_FILE;

	if ( nError == ENVSET_NO_ERROR ) {
		String s = String( rConfigFile, gsl_getSystemTextEncoding());

		// read all informations out of file
		InformationParser aParser;
		pInfoList = aParser.Execute( s );

		if ( !pInfoList )
			nError = ENVSET_FILE_ERROR;
	}
}

/*****************************************************************************/
EnvironmentSetter::~EnvironmentSetter()
/*****************************************************************************/
{
	if ( pInfoList )
		delete pInfoList;

#if defined GCC
	for ( ULONG i = 0; i < Container::Count(); i++ ) {
#else
	for ( ULONG i = 0; i < Count(); i++ ) {
#endif
		EnvironmentVariable *pVar = GetObject( i );
		if ( pVar )
			delete pVar;
	}

	for ( ULONG nPre = 0; nPre < aPreScript.Count(); nPre++ )
		delete aPreScript.GetObject( nPre );

	for ( ULONG nPost = 0; nPost < aPostScript.Count(); nPost++ )
		delete aPostScript.GetObject( nPost );

}

/*****************************************************************************/
void EnvironmentSetter::Insert( const ByteString &rVar, const ByteString &rVal )
/*****************************************************************************/
{
	ByteString sNewValue( rVal );
	ULONG i;

	for ( i = 0; i < Count(); i++ ) {
		// search for known variables and replace them
		EnvironmentVariable *pVariable = GetObject( i );

		ByteString sVariable( "%" );
		sVariable += *pVariable;
		sVariable += ByteString( "%" );

		ByteString sValue( pVariable->GetValue());

		while ( sNewValue.SearchAndReplace( sVariable, sValue ) !=
			STRING_NOTFOUND );
	}
	int nErrorFlag_0 = 0;

	while ( sNewValue.Search( '%' ) != STRING_NOTFOUND ) {
		ByteString sEmpty( "%" );
		sEmpty += sNewValue.GetToken( 1, '%' );
		sEmpty += ByteString( "%" );

		int nErrorFlag = 0;
		while ( sNewValue.SearchAndReplace( sEmpty, "" ) !=
			STRING_NOTFOUND )
		{
			if ( ++nErrorFlag > 1024 )
			{
				ByteString aErrTxt( "Possible % - mismatch in Line : ");
				aErrTxt += rVal;
				PrintStatus(aErrTxt.GetBuffer());
				exit(1);
			}
		}
		if ( ++nErrorFlag_0 > 1024 )
		{
			ByteString aErrTxt( "Possible % - mismatch in Line : ");
			aErrTxt += rVal;
			PrintStatus(aErrTxt.GetBuffer());
			exit(1);
		}
	}

	if ( rVar.GetChar( 0 ) == '*' ) {
		while ( sNewValue.Search( '' ) != STRING_NOTFOUND ) {
			ByteString sNativEnvVar = sNewValue.GetToken( 1, '' );
			ByteString sToSearch( "" );
			sToSearch += sNativEnvVar;
			sToSearch += ByteString( "" );
#ifndef UNX
			ByteString sReplace( "%" );
#else
			ByteString sReplace( "$" );
#endif
			sReplace += sNativEnvVar;

			int nErrorFlag = 0;
			while( sNewValue.SearchAndReplace( sToSearch, sReplace ) !=
				STRING_NOTFOUND )
			{
				if ( ++nErrorFlag > 1024 )
				{
					ByteString aErrTxt( "Possible % - mismatch in Line : ");
					aErrTxt += rVal;
					PrintStatus (aErrTxt.GetBuffer());
					exit(1);
				}
			}
		}
#ifndef UNX
		sNewValue.SearchAndReplaceAll("#","%");
#else
		sNewValue.SearchAndReplaceAll("#","$");
#endif
	}

	EnvironmentVariable *pNewVariable =
		new EnvironmentVariable( rVar, sNewValue );

	// add variable to current environment
	BOOL bFound = FALSE;

	for ( i = 0; !bFound && i < Count(); i++ ) {
		if ( *GetObject( i ) == *pNewVariable ) {
			delete GetObject( i );
			Remove( i );
			EnvironmentList::Insert( pNewVariable, LIST_APPEND );
			bFound = TRUE;
		}
	}

	if ( !bFound )
		EnvironmentList::Insert( pNewVariable, LIST_APPEND );
}

/*****************************************************************************/
void EnvironmentSetter::Set()
/*****************************************************************************/
{
	for ( ULONG i = 0; i < Count(); i++ ) {
		GetObject( i )->PutEnv();
	}
}

/*****************************************************************************/
BOOL EnvironmentSetter::WriteToFile( const ByteString &rFileName )
/*****************************************************************************/
{
	SvFileStream aStream( String( rFileName, gsl_getSystemTextEncoding()),
		STREAM_STD_WRITE | STREAM_TRUNC );
	if ( !aStream.IsOpen())
		return FALSE;

	for ( ULONG nPre = 0; nPre < aPreScript.Count(); nPre++ )
		aStream.WriteLine( *aPreScript.GetObject( nPre ));

	for ( ULONG i = 0; i < Count(); i++ ) {
		ByteString sLine = GetObject( i )->GetSetter( TRUE );
		aStream.WriteLines( sLine );
	}

	for ( ULONG nPost = 0; nPost < aPostScript.Count(); nPost++ )
		aStream.WriteLine( *aPostScript.GetObject( nPost ));

	aStream.Close();

	return TRUE;
}

/*****************************************************************************/
SwitchList *EnvironmentSetter::GetPossibleSwitches()
/*****************************************************************************/
{
	if ( !pInfoList )
		return NULL;

	if ( pPossibleSwitches )
		return pPossibleSwitches;

	ByteString sPath( "switches" );

	pPossibleSwitches = new SwitchList();
	for ( ULONG i = 0; i < pInfoList->Count(); i++ ) {
		GenericInformation *pInfo = pInfoList->GetObject( i );
		if ( pInfo ) {
			GenericInformation *pCurSwitches = pInfo->GetSubInfo( sPath );
			if ( pCurSwitches ) {
				GenericInformationList *pCurSwitchList =
					pCurSwitches->GetSubList();
				if ( pCurSwitchList ) {
					for ( ULONG j = 0; j < pCurSwitchList->Count(); j++ ) {
						GenericInformation *pThisSwitch =
							pCurSwitchList->GetObject( i );
						Switch *pTheSwitch = new Switch( *pThisSwitch,
							pThisSwitch->GetValue());
						pPossibleSwitches->InsertUnique( pTheSwitch );
					}
				}
			}
		}
	}

	return pPossibleSwitches;
}

/*****************************************************************************/
void EnvironmentSetter::Expand( ByteString &rVariableToExpand )
/*****************************************************************************/
{
	for ( ULONG i = 0; i < Count(); i++ ) {
		// search for known variables and replace them
		EnvironmentVariable *pVariable = GetObject( i );

		ByteString sVariable( "%" );
		sVariable += *pVariable;
		sVariable += ByteString( "%" );

		ByteString sValue( pVariable->GetValue());

		while ( rVariableToExpand.SearchAndReplace( sVariable, sValue ) !=
			STRING_NOTFOUND );
	}

	while ( rVariableToExpand.Search( '%' ) != STRING_NOTFOUND ) {
		ByteString sEmpty( "%" );
		sEmpty += rVariableToExpand.GetToken( 1, '%' );
		sEmpty += ByteString( "%" );

		while ( rVariableToExpand.SearchAndReplace( sEmpty, "" ) !=
			STRING_NOTFOUND );
	}
}

/*****************************************************************************/
BOOL EnvironmentSetter::CheckIfStatement( const ByteString &rStatement )
/*****************************************************************************/
{
	// search for "IF"
	ByteString sTmpStatement( rStatement );
	if ( sTmpStatement.ToUpperAscii().Search( "IF" ) != 0 ) {
		PrintStatus( sTmpStatement.GetBuffer());
		PrintStatus( "------------>" );
		return FALSE;
	}

	ByteString sLeftSide;
	ByteString sRightSide;
	ByteString sOperator;

	ByteString sStatement( rStatement );

	if ( sStatement.Search( '\"' ) != STRING_NOTFOUND ) {
		// separator: "

		sLeftSide = sStatement.GetToken( 1, '\"' );
		sRightSide = sStatement.GetToken( 3, '\"' );
		sOperator = sStatement.GetToken( 2, '\"' ).EraseAllChars( ' ' );
	}
	else {
		// separator: space
		while ( sStatement.SearchAndReplace( "  ", " " ) !=
			STRING_NOTFOUND );

		sLeftSide = sStatement.GetToken( 1, ' ' );
		sRightSide = sStatement.GetToken( 3, ' ' );
		sOperator = sStatement.GetToken( 2, ' ' );
	}

	Expand( sLeftSide.ToUpperAscii());
	Expand( sRightSide.ToUpperAscii());
	sLeftSide.ToUpperAscii();
	sRightSide.ToUpperAscii();

	BOOL bReturn = FALSE;

	if ( sOperator == "==" )
		bReturn = ( sLeftSide == sRightSide );
	else if ( sOperator == "!=" )
		bReturn = ( sLeftSide != sRightSide );
	else if ( sOperator == ">" )
		bReturn = ( sLeftSide > sRightSide );
	else if ( sOperator == ">=" )
		bReturn = ( sLeftSide >= sRightSide );
	else if ( sOperator == "<" )
		bReturn = ( sLeftSide < sRightSide );
	else if ( sOperator == "<=" )
		bReturn = ( sLeftSide <= sRightSide );

	return bReturn;
}

/*****************************************************************************/
USHORT EnvironmentSetter::Execute( SwitchList &rSwitches,
	ByteString sEnvironment )
/*****************************************************************************/
{
	ByteString sTmpEnvironment;
	if ( sEnvironment.ToUpperAscii() != "COMMON" &&
			sEnvironment.ToUpperAscii() != "FINISH" ) {
		sTmpEnvironment = "common";
		Execute( rSwitches, sTmpEnvironment );
	}

	GenericInformation *pEnvInfo =
		pInfoList->GetInfo( sEnvironment, FALSE );

	if ( !pEnvInfo )
		return ENVSET_NO_ENVIRONMENT;

	ByteString sPath( "switches" );
	GenericInformation *pSwitches = pEnvInfo->GetSubInfo( sPath );

	// check all switches
	if ( pSwitches ) {
		GenericInformationList *pSwitchList = pSwitches->GetSubList();
		if ( pSwitchList ) {
			for ( ULONG i = 0; i < rSwitches.Count(); i++ ) {
				BOOL bFound = FALSE;
				Switch *pCurSwitch = rSwitches.GetObject( i );
				for ( ULONG j = 0; !bFound && j < pSwitchList->Count(); j++ ) {
					if ( pCurSwitch->ToUpperAscii() ==
						( pSwitchList->GetObject( j ))->ToUpperAscii())
					{
						bFound = TRUE;
						GenericInformation *pSwitchDef =
							pSwitchList->GetObject( j );
						if ( pSwitchDef->GetValue().Len()) {
							if ( !pCurSwitch->GetValue().Len() && (
								sEnvironment.ToUpperAscii() != "COMMON" &&
								sEnvironment.ToUpperAscii() != "FINISH"))
							{
								ByteString sStatus( "ERROR: switch -" );
								sStatus += *pCurSwitch;
								sStatus += ByteString( " must have a value!" );
								PrintStatus( sStatus.GetBuffer());
								return ENVSET_MISSING_VALUE;
							}
							// put value of switch in environment
							Insert( pSwitchDef->GetValue(),
								pCurSwitch->GetValue());
						}
					}
				}
				if ( pCurSwitch->IsValid())
					bFound = TRUE;
				if ( !bFound && (sEnvironment.ToUpperAscii() != "COMMON"
						&& sEnvironment.ToUpperAscii() != "FINISH")) {
					ByteString sStatus( "ERROR: the switch -" );
					sStatus += *pCurSwitch;
					sStatus += ByteString( " is not valid!" );
					PrintStatus( sStatus.GetBuffer());
					return ENVSET_NO_SWITCH;
				}
			}
		}
	}

	sPath = ByteString( "extern" );
	GenericInformation *pExternals = pEnvInfo->GetSubInfo( sPath, FALSE );
	if ( pExternals ) {
		// read external environment
		GenericInformationList *pExternalList = pExternals->GetSubList();
		if ( pExternalList ) {
			for ( ULONG i = 0; i < pExternalList->Count(); i++ ) {
				GenericInformation *pExternalVariable =
					pExternalList->GetObject( i );
				ByteString sValue( getenv( pExternalVariable->GetBuffer()));
				Insert( *pExternalVariable, sValue );
			}
		}
	}

	// now reset old variables
	sPath = ByteString( "reset" );
	GenericInformation *pReset = pEnvInfo->GetSubInfo( sPath, FALSE );
	if ( pReset ) {
		GenericInformationList *pResetList = pReset->GetSubList();
		if ( pResetList ) {
			for ( ULONG i = 0; i < pResetList->Count(); i++ ) {
				GenericInformation *pToReset = pResetList->
					GetObject( i );
				Insert( *pToReset, pToReset->GetValue());
			}
		}
	}

	// restore content of old variables
	sPath = ByteString( "restore" );
	GenericInformation *pRestore = pEnvInfo->GetSubInfo( sPath, FALSE );
	if ( pRestore ) {
		GenericInformationList *pRestoreList = pRestore->GetSubList();
		if ( pRestoreList ) {
			for ( ULONG i = 0; i < pRestoreList->Count(); i++ ) {
				GenericInformation *pToRestore = pRestoreList->
					GetObject( i );
				ByteString sSave( "SSX_" ); sSave += *pToRestore;
				ByteString sOldValue = getenv( sSave.GetBuffer());
				if ( sOldValue.Len())
					Insert( *pToRestore, sOldValue );
				else {
					ByteString sRestoreVal( "%" );
					sRestoreVal += *pToRestore;
					sRestoreVal += ByteString( "%" );
					Insert( sSave, sRestoreVal );
				}
			}
		}
	}

	// get info out of version list
	sPath = ByteString( "standlst" );
	GenericInformation *pStandlst = pEnvInfo->GetSubInfo( sPath, FALSE );
	if ( pStandlst ) {
		GenericInformationList *pStandlstList = pStandlst->GetSubList();
		if ( pStandlstList ) {
			for ( ULONG i = 0; i < pStandlstList->Count(); i++ ) {
				GenericInformation *pStandinfo = pStandlstList->
					GetObject( i );
				ByteString sVerPath( pStandinfo->GetValue().GetBuffer());
				Expand( sVerPath );
				GenericInformation *pFinalInfo =
					pVersionList->GetInfo( sVerPath, TRUE );
				if ( pFinalInfo ) {
					Insert( *pStandinfo, pFinalInfo->GetValue());
					fprintf( stderr, "%s %s\n", pStandinfo->GetBuffer(), pFinalInfo->GetValue().GetBuffer());
				}
				else
					return ENVSET_VERLISTENTRY_NOT_FOUND;
			}
		}
	}

	sPath = ByteString( "environment" );
	GenericInformation *pEnvironment = pEnvInfo->GetSubInfo( sPath, FALSE );
	if ( pEnvironment ) {
		sPath = ByteString( "order" );
		GenericInformation *pOrder = pEnvInfo->GetSubInfo( sPath, FALSE );
		if ( !pOrder )
			return ENVSET_NO_ORDER;

		ByteString sOrder = pOrder->GetValue().ToUpperAscii();
		USHORT nOrderCount = sOrder.GetTokenCount( ' ' );

		GenericInformationList *pEnvSettings = pEnvironment->GetSubList();
		for ( USHORT i = 0; i < nOrderCount; i++ ) {
			sPath = sOrder.GetToken( i, ' ' );
			GenericInformation *pCurEnvSetting = pEnvSettings->GetInfo( sPath, FALSE );
			if ( !pCurEnvSetting ) {
				ByteString sStatus( "Accesspath: " );
				sStatus += sPath;
				PrintStatus( sStatus.GetBuffer());
				return ENVSET_UNKNOWN_BLOCK;
			}

			BOOL bFound = FALSE;
			if ( pCurEnvSetting->ToUpperAscii().Search( "COMMON" ) == 0 ||
					 pCurEnvSetting->ToUpperAscii().Search( "FINISH" ) == 0 )
			{
				if ( pCurEnvSetting->Search(":") != STRING_NOTFOUND )
					bFound = CheckIfStatement( pCurEnvSetting->GetValue());
				else
					bFound = TRUE;
			}

			// check if this switch is set
			for ( ULONG j = 0; !bFound && j < rSwitches.Count(); j++ ) {
				if ( pCurEnvSetting->ToUpperAscii() ==
					(rSwitches.GetObject( j ))->ToUpperAscii())
				{
					bFound = TRUE;
				}
				else if ( pCurEnvSetting->ToUpperAscii().GetToken( 0, ':' ) ==
					(rSwitches.GetObject( j ))->ToUpperAscii())
				{
					bFound = CheckIfStatement( pCurEnvSetting->GetValue());
				}
			}
			if ( bFound ) {
				// set environment for this switch
				GenericInformationList *pEnvToSet =
					pCurEnvSetting->GetSubList();
				if ( pEnvToSet ) {
					for ( ULONG j = 0; j < pEnvToSet->Count(); j++ ) {
						// add the setting to environment
						GenericInformation *pSetting =
							pEnvToSet->GetObject( j );
						Insert( *pSetting, pSetting->GetValue());
					}
				}
			}
		}
	}

	sPath = ByteString( "script" );
	GenericInformation *pScript = pEnvInfo->GetSubInfo( sPath, FALSE );
	if ( pScript ) {
		sPath = ByteString( "pre" );
		GenericInformation *pPreScript = pScript->GetSubInfo( sPath, FALSE );
		if ( pPreScript ) {
			GenericInformationList *pPreList = pPreScript->GetSubList();
			if ( pPreList ) {
				for ( ULONG i = 0; i < pPreList->Count(); i++ )
					aPreScript.Insert( new ByteString( pPreList->GetObject( i )->GetValue()), LIST_APPEND );
			}
		}
		sPath = ByteString( "post" );
		GenericInformation *pPostScript = pScript->GetSubInfo( sPath, FALSE );
		if ( pPostScript ) {
			GenericInformationList *pPostList = pPostScript->GetSubList();
			if ( pPostList ) {
				for ( ULONG i = 0; i < pPostList->Count(); i++ )
					aPostScript.Insert( new ByteString( pPostList->GetObject( i )->GetValue()), LIST_APPEND );
			}
		}
	}

	if (( sEnvironment.ToUpperAscii() != "FINISH" ) &&
		( sEnvironment.ToUpperAscii() != "COMMON" )) {
		sTmpEnvironment = "finish";
		Execute( rSwitches, sTmpEnvironment );
	}

 	return ENVSET_NO_ERROR;
}
