/*************************************************************************
 *
 *  $RCSfile: wizlt.cxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 16:02:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _SV_PRNSETUP_HXX_ //autogen
#include <svtools/prnsetup.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _SVX_ADRITEM_HXX //autogen
#include <svx/adritem.hxx>
#endif

#ifndef _SWTYPES_HXX
#include <swtypes.hxx>
#endif
#ifndef _NUMRULE_HXX
#include <numrule.hxx>
#endif
#ifndef _FLDBAS_HXX
#include <fldbas.hxx>  // TYP_FIXDATEFLD zum Fuellen der DateListbox
#endif
#ifndef _WIZLT_HXX
#include <wizlt.hxx>
#endif
#ifndef _WIZPAGE_HXX
#include <wizpage.hxx>
#endif
#ifndef _WIZARD_HRC
#include <wizard.hrc>
#endif
#ifndef _HELPID_H
#include <helpid.h>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif


////////////////////////////////////////////////////////////////////////////////
//
// @@@@@ @@ @@ @@@@@ @@  @@ @@@@ @@  @@  @@@@  @@  @@ @@@@@  @@   @@@@@ @@@@@
// @@    @@ @@ @@    @@@ @@  @@  @@  @@ @@  @@ @@@ @@ @@  @@ @@   @@    @@  @@
// @@    @@ @@ @@    @@@@@@  @@  @@  @@ @@  @@ @@@@@@ @@  @@ @@   @@    @@  @@
// @@@@  @@@@@ @@@@  @@@@@@  @@  @@@@@@ @@@@@@ @@@@@@ @@  @@ @@   @@@@  @@@@@
// @@     @@@  @@    @@ @@@  @@  @@  @@ @@  @@ @@ @@@ @@  @@ @@   @@    @@  @@
// @@     @@@  @@    @@  @@  @@  @@  @@ @@  @@ @@  @@ @@  @@ @@   @@    @@  @@
// @@@@@   @   @@@@@ @@  @@  @@  @@  @@ @@  @@ @@  @@ @@@@@  @@@@ @@@@@ @@  @@
//
////////////////////////////////////////////////////////////////////////////////

IMPL_LINK_INLINE_START( LetterDialog, PrivRadioClickHdl, RadioButton *, pBtn )
{
	SetPrivat();
	SetLogoAbsnFDisable();   // Logo und Absn sind nun evtl weg
	SetLogoAbsnPrnDisable(); // Logo und Absn sind nun evtl weg
	FillDocInfoList();       // Damit DocInfo bei Privatbrief disabled
	return 0;
}
IMPL_LINK_INLINE_END( LetterDialog, PrivRadioClickHdl, RadioButton *, pBtn )

////////////////////////////////////////////////////////////////////////////////
// Absn
////////////////////////////////////////////////////////////////////////////////

IMPL_LINK( LetterDialog, AbsnBBtnHdl, Button *, pBtn )
{
	PageAlign ePage = ALIGN_Null;

	if( pBtn == &a3_BBtn_AbsnOL ) 	   ePage = ALIGN_LiOb;
	else if( pBtn == &a3_BBtn_AbsnOR ) ePage = ALIGN_ReOb;
	else if( pBtn == &a3_BBtn_AbsnMi ) ePage = ALIGN_Mitt;
	else if( pBtn == &a3_BBtn_AbsnUL ) ePage = ALIGN_LiUn;
	else if( pBtn == &a3_BBtn_AbsnUR ) ePage = ALIGN_ReUn;

	if( ALIGN_Null != ePage )
		aPage1.aAbsn.SetAlign( ePage, &aPrevWin );

	SetLogoBMapBtnDisable();
	SetAbsnBMapBtnDisable();
	SetMetDisable();
	SetElemBetr(); // Oberer Textrand wird evtl beeinflusst (beim Privatbrief)
	return 0;
}

IMPL_LINK( LetterDialog, AbsnMFldHdl, MetricField *, pEdt )
{
	USHORT nVal = USHORT( pEdt->GetValue(FUNIT_CM) );
	if( pEdt == &a3_MFld_AbsnWd ) 		aPage1.aAbsn.SetWdt(nVal,&aPrevWin);
	else if( pEdt == &a3_MFld_AbsnHg )	aPage1.aAbsn.SetHgt(nVal,&aPrevWin);
	else if( pEdt == &a3_MFld_AbsnHo )	aPage1.aAbsn.SetHor(nVal,&aPrevWin);
	else if( pEdt == &a3_MFld_AbsnVe )	aPage1.aAbsn.SetVer(nVal,&aPrevWin);
	SetElemBetr(); // Oberer Textrand wird evtl beeinflusst (beim Privatbrief)
	return 0;
}

IMPL_LINK_INLINE_START( LetterDialog, AbsnGschRadioClickHdl, RadioButton *, pBtn )
{
	aPage1.aEmpf.ShowAbsn(&aPrevWin,a3_RBtn_WdhJaa.IsChecked());
	return 0;
}
IMPL_LINK_INLINE_END( LetterDialog, AbsnGschRadioClickHdl, RadioButton *, pBtn )

IMPL_LINK( LetterDialog, AbsnPrivRadioClickHdl, RadioButton *, pBtn )
{
	if (pBtn==&a3_RBtn_AnzJaa)
	{
		aPage1.aAbsn.Show(&aPrevWin);
		PageAlign eAlign = aPageF.aKopz.GetAbsnAlign();
		aPageF.aKopz.ShowAbsn( &aPrevWin, eAlign != ALIGN_Null );
		AbsnFToUI();
	}
	else if (pBtn==&a3_RBtn_AnzNee)
	{
		aPage1.aAbsn.Hide(&aPrevWin);
		p7_List_AbsnWo->SelectEntryPos(0);
		KopzFListSelectHdl(p7_List_AbsnWo);
	}
	SetLogoBMapBtnDisable(); // Evtl mehr Platz fuers Logo?
	SetAbsnBMapBtnDisable(); // Enable...
	SetElemBetr(); // Oberer Textrand wird evtl beeinflusst (beim Privatbrief)
	SetLogoAbsnFDisable(); // Absender ist nun evtl weg
	SetLogoAbsnPrnDisable(); // Absn ist nun evtl weg
	return 0;
}

////////////////////////////////////////////////////////////////////////////////
// Logo - Abgefangene Handler von WizLogoDlg
////////////////////////////////////////////////////////////////////////////////

IMPL_LINK_INLINE_START( LetterDialog, LogoBBtnHdl, Button *, pBtn )
{
	aLogo.BBtnHdl(pBtn); // erstmal das Original rufen
	SetLogoBMapBtnDisable();
	SetAbsnBMapBtnDisable();
	SetElemBetr(); // Oberer Textrand wird evtl beeinflusst (beim Privatbrief)
	return 0;
}
IMPL_LINK_INLINE_END( LetterDialog, LogoBBtnHdl, Button *, pBtn )

IMPL_LINK_INLINE_START( LetterDialog, LogoMFldHdl, MetricField *, pEdt )
{
	aLogo.MFldHdl(pEdt);
	SetElemBetr(); // Oberer Textrand wird evtl beeinflusst (beim Privatbrief)
	return 0;
}
IMPL_LINK_INLINE_END( LetterDialog, LogoMFldHdl, MetricField *, pEdt )

IMPL_LINK( LetterDialog, LogoRBtnHdl, RadioButton *, pBtn )
{
	aLogo.RBtnHdl(pBtn);
	SetLogoBMapBtnDisable();
	SetAbsnBMapBtnDisable();
	SetElemBetr(); // Oberer Textrand wird evtl beeinflusst (beim Privatbrief)
	SetLogoAbsnFDisable(); // Logo ist nun evtl weg
	SetLogoAbsnPrnDisable(); // Logo ist nun evtl weg
	return 0;
}

////////////////////////////////////////////////////////////////////////////////
// Elem
////////////////////////////////////////////////////////////////////////////////

IMPL_LINK( LetterDialog, ElemCheckClickHdl, CheckBox *, pBtn )
{
	USHORT nPos = 0;
	if( pBtn == &a5_CBox_Elem1 ) nPos = 1;
	else if( pBtn == &a5_CBox_Elem2 ) nPos = 2;
	else if( pBtn == &a5_CBox_Elem3 ) nPos = 3;
	else if( pBtn == &a5_CBox_Elem4 ) nPos = 4;
	else if( pBtn == &a5_CBox_Datum ) nPos = 5;
	else if( pBtn == &a5_CBox_Betref ) nPos = 6;

	if( nPos )
	{
		if( 6 == nPos )
			aPage1.aBetr.Show(  &aPrevWin, pBtn->IsChecked() );
		else
			aPage1.aElem.Show( nPos - 1, &aPrevWin, pBtn->IsChecked() );
	}

	SetElemBetr();
	SetElemDisable();
	FillDocInfoList();
	return 0;
}

IMPL_LINK( LetterDialog, ElemModifyHdl, Edit *, pEdt )
{
	USHORT nPos = 0;
	if( pEdt == &a5_Edit_Elem1 )  nPos = 1;
	else if( pEdt == &a5_Edit_Elem2 )  nPos = 2;
	else if( pEdt == &a5_Edit_Elem3 )  nPos = 3;
	else if( pEdt == &a5_Edit_Elem4 )  nPos = 4;
	else if( pEdt == &a5_Edit_Betref ) nPos = 5;

	if( nPos )
	{
		String aStr( pEdt->GetText() );
		if( 5 == nPos )
			aPage1.aBetr.SetStr( aStr, &aPrevWin );
		else
			aPage1.aElem.aBezeich[ nPos-1 ].SetStr( aStr, &aPrevWin );
	}

	FillDocInfoList();
	return 0;
}

IMPL_LINK( LetterDialog, PNumCheckClickHdl, CheckBox *, pBtn )
{
	if (pBtn==&a5_CBox_PagNum)
	{
		aPage1.aFusz.SetPgNum(a5_CBox_PagNum.IsChecked(),&aPrevWin);
		aPageF.aFusz.SetPgNum(a5_CBox_PagNum.IsChecked(),&aPrevWin);
	}
	else if (pBtn==&a5_CBox_PagGes)
	{
		aPage1.aFusz.SetPgNumGes( a5_CBox_PagGes.IsChecked() );
		aPageF.aFusz.SetPgNumGes( a5_CBox_PagGes.IsChecked() );
	}
	SetPagNumDisable();
	return 0;
}

IMPL_LINK( LetterDialog, PNumModifyHdl, Edit *, pEdt )
{
	if (pEdt==&a5_Edit_PagNum)
	{
		aPage1.aFusz.SetPgNumStr( pEdt->GetText() );
		aPageF.aFusz.SetPgNumStr( pEdt->GetText() );
	}
	else if (pEdt==&a5_Edit_PagGes)
	{
		aPage1.aFusz.SetPgNumGesStr( pEdt->GetText() );
		aPageF.aFusz.SetPgNumGesStr( pEdt->GetText() );
	}
	return 0;
}

IMPL_LINK( LetterDialog, SelPrtHdl, Button *, pButton )
{
	// Druck-Setup aufrufen
	if (!pPrinter)
		pPrinter = new Printer;
    String sTmpPrinterName = pPrinter->GetName();
    PrinterSetupDialog* pDlg = new PrinterSetupDialog(this);
	pDlg->SetPrinter(pPrinter);
    USHORT nRet = pDlg->Execute();
	delete pDlg;

	GrabFocus();
    if(RET_OK == nRet &&
         pPrinter->GetName() != sTmpPrinterName)
    {
        p9_Text_PrName->SetText(pPrinter->GetName());
        InitFinaUI();   // Druckerschaechte neu initialisieren

#ifndef NO_PAPERBIN
        p9_List_TrayS1->SelectEntryPos(0); // Erster Schacht
        p9_List_TrayFF->SelectEntryPos(0); // Erster Schacht
#endif
    }

	return 0;
}

IMPL_LINK_INLINE_START( LetterDialog, PNumSelectHdl, ListBox *, pLst )
{
	USHORT nTmp = (USHORT)(ULONG)a5_List_PagNum.GetEntryData(
											a5_List_PagNum.GetSelectEntryPos() );
	aPage1.aFusz.SetPgNumFmt( nTmp );
	aPageF.aFusz.SetPgNumFmt( nTmp );
	return 0;
}
IMPL_LINK_INLINE_END( LetterDialog, PNumSelectHdl, ListBox *, pLst )

////////////////////////////////////////////////////////////////////////////////
// Fusz1 - Abgefangene Handler von WizFuszDlg
////////////////////////////////////////////////////////////////////////////////

IMPL_LINK( LetterDialog, Fuss1CheckClickHdl, CheckBox *, pBtn )
{
	pFusz->ClckHdl(pBtn); // erstmal das Orginal von WizFuszDlg aufrufen
	if (pBtn==pFusz->pF_CBox_FussAn)
	{
		if (!pFusz->pF_CBox_FussAn->IsChecked()) { // Keine Fusszeile auf den Folgeseiten ohne Fusszeile auf der ersten Seite
		   aPageF.aFusz.Hide(&aPrevWin);
		} else { // Ansonsten Fusszeile auf den Folgeseiten anzeigen, falls das Kreuz da war
		   aPageF.aFusz.Show(&aPrevWin,p7_CBox_FusAnz->IsChecked());
		}
		SetFussFDisable();
	}
	if (pBtn==pFusz->pF_CBox_TrennL) {
		aPageF.aFusz.SetTrennlinie(pFusz->pF_CBox_TrennL->IsChecked(),&aPrevWin); // Fusszeile auf den Folgeseiten hat dann auch eine Trennlinie oder nicht
	}
	SetPagNumDisable(); // Keine Seitennumerierung ohne Fusszeilen
	return 0;
}

IMPL_LINK_INLINE_START( LetterDialog, Fuss1ModifyHdl, MultiLineEdit *, pEdt )
{
	pFusz->EditHdl(pEdt); // erstmal das Orginal von WizFuszDlg aufrufen
	aPageF.aFusz.SetStr(aPage1.aFusz.GetStr()); // Gleicher Fusszeilentext auf den Folgeseiten
	return 0;
}
IMPL_LINK_INLINE_END( LetterDialog, Fuss1ModifyHdl, MultiLineEdit *, pEdt )

/*void LetterDialog::Fuss1MetrModifyHdl(MetricField* pEdt)
{
	USHORT nVal=USHORT(pEdt->GetValue(FUNIT_CM));
	if (pEdt==&a6_MFld_VonUnt) aPage1.aFusz.SetVer(nVal,&aPrevWin);
	if (pEdt==&a6_MFld_ZumTxt) aPage1.aFusz.SetTextDst(nVal,&aPrevWin);
}*/

////////////////////////////////////////////////////////////////////////////////
// FuszF
////////////////////////////////////////////////////////////////////////////////

IMPL_LINK_INLINE_START( LetterDialog, FussFCheckClickHdl, CheckBox *, pBtn )
{
	if (pBtn==p7_CBox_FusAnz) {
		aPageF.aFusz.Show(&aPrevWin,p7_CBox_FusAnz->IsChecked());
		SetFussFDisable();
	}
	SetPagNumDisable(); // Keine Seitennumerierung ohne Fusszeilen
	return 0;
}
IMPL_LINK_INLINE_END( LetterDialog, FussFCheckClickHdl, CheckBox *, pBtn )

IMPL_LINK_INLINE_START( LetterDialog, FussFMetrModifyHdl, MetricField *, pEdt )
{
	USHORT nVal=USHORT(pEdt->GetValue(FUNIT_CM));
	if (pEdt==p7_MFld_FLinOb) aPageF.aFusz.SetVer(nVal,&aPrevWin);
	if (pEdt==p7_MFld_FLinTx) aPageF.aFusz.SetTextDst(nVal,&aPrevWin);
	return 0;
}
IMPL_LINK_INLINE_END( LetterDialog, FussFMetrModifyHdl, MetricField *, pEdt )

////////////////////////////////////////////////////////////////////////////////
// KopzF
////////////////////////////////////////////////////////////////////////////////

IMPL_LINK( LetterDialog, KopzFMetrModifyHdl, MetricField *, pEdt )
{
	USHORT nVal=USHORT(pEdt->GetValue(FUNIT_CM));
	if (pEdt==p7_MFld_KLinOb) aPageF.aKopz.SetVer(nVal,&aPrevWin);
	if (pEdt==p7_MFld_KLinTx) aPageF.aKopz.SetTextDst(nVal,&aPrevWin);
	if (pEdt==p7_MFld_LogoWd) aPageF.aKopz.SetLogoWdt(nVal,&aPrevWin);
	if (pEdt==p7_MFld_LogoHg) aPageF.aKopz.SetLogoHgt(nVal,&aPrevWin);
	if (pEdt==p7_MFld_AbsnWd) aPageF.aKopz.SetAbsnWdt(nVal,&aPrevWin);
	if (pEdt==p7_MFld_AbsnHg) aPageF.aKopz.SetAbsnHgt(nVal,&aPrevWin);
	return 0;
}

IMPL_LINK( LetterDialog, KopzFListSelectHdl, ListBox *, pLst )
{
	PageAlign eAlign = ALIGN_Null;
	switch( pLst->GetSelectEntryPos() )
	{
		case 1: eAlign=ALIGN_LiOb; break;
		case 2: eAlign=ALIGN_MiOb; break;
		case 3: eAlign=ALIGN_ReOb; break;
	}
	if( pLst == p7_List_LogoWo )
	{
		if (eAlign != ALIGN_Null)
			aPageF.aKopz.SetLogoAlign( eAlign, &aPrevWin );
		aPageF.aKopz.ShowLogo( &aPrevWin, eAlign != ALIGN_Null );
	}
	else if( pLst == p7_List_AbsnWo)
	{
		if( eAlign != ALIGN_Null )
			aPageF.aKopz.SetAbsnAlign( eAlign, &aPrevWin );
		aPageF.aKopz.ShowAbsn( &aPrevWin, eAlign != ALIGN_Null );
	}
	SetLogoAbsnFDisable();
	return 0;
}

////////////////////////////////////////////////////////////////////////////////
// Marg - Abgefangene Handler von WizFuszDlg
////////////////////////////////////////////////////////////////////////////////

void LetterDialog::SetFuszKopzMarg()
{ // Raender der Kopf und Fusszeilen sowie Betreff eingrenzen !
//  aPage1.aBetr.KorregWdt(&aPrevWin); // Betreff ist nun im eigenen Rahmen.
	aPage1.aFusz.KorregWdt(&aPrevWin);
	aPageF.aFusz.KorregWdt(&aPrevWin);
	aPageF.aKopz.KorregWdt(&aPrevWin);
}

IMPL_LINK_INLINE_START( LetterDialog, RandMetrcModifyHdl, MetricField *, pEdt )
{
	pMarg->MFldHdl(pEdt); // erstmal das Orginal rufen
	SetFuszKopzMarg();
	return 0;
}
IMPL_LINK_INLINE_END( LetterDialog, RandMetrcModifyHdl, MetricField *, pEdt )

IMPL_LINK( LetterDialog, EditModifyHdl, Edit *, pEdt )
{
	String aStr(pEdt->GetText());
	if (pEdt==&a3_MEdt_AbsInp)
	{
		aPageF.aKopz.aAbsn.SetStr(aStr,&aPrevWin);
		aPage1.aAbsn.SetStr(aStr,&aPrevWin);
		aPage1.aEmpf.SetAbsnStr(aStr,&aPrevWin);
		SetElemBetr(); // Absenderhoehe evtl. geaendert (AutoGrowOnStr)
	}
	return 0;
}
IMPL_LINK( LetterDialog, UpdateAdressHdl, PushButton*, pButton)
{
	GetFromUsr();
	a3_MEdt_AbsInp.SetText(aPage1.aAbsn.GetStr());
	return 0;
}
////////////////////////////////////////////////////////////////////////////////
// Empf - Abgefangene Handler von WizEmpfDlg
////////////////////////////////////////////////////////////////////////////////

IMPL_LINK_INLINE_START( LetterDialog, EmpfDBasListHdl, ListBox *, pLst )
{
	aEmpf.DBasListHdl(pLst);
	FillDocInfoList();
	return 0;
}
IMPL_LINK_INLINE_END( LetterDialog, EmpfDBasListHdl, ListBox *, pLst )

IMPL_LINK_INLINE_START( LetterDialog, StyleClickHdl, RadioButton *, pBtn )
{
	BYTE nStyle=0;
//    if (a1_RBtn_Stil1.IsChecked()) nStyle=0;
	if (a1_RBtn_Stil2.IsChecked()) nStyle=1;
	if (a1_RBtn_Stil3.IsChecked()) nStyle=2;
	return 0;
}
IMPL_LINK_INLINE_END( LetterDialog, StyleClickHdl, RadioButton *, pBtn )

////////////////////////////////////////////////////////////////////////////////
// LetterDialog
////////////////////////////////////////////////////////////////////////////////

LetterDialog::LetterDialog(Window* pParent)
	: WizardLettDialog(pParent)
{
	Init();
	aPrevWin.SetPage(&aPage1);
	aLogo.SetPtr(&aPage1.aLogo,&aPageF.aKopz.aLogo);
	aEmpf.SetPtr(&aPage1.aEmpf);
	pMarg->SetPtr(&aPage1/*,&aPageF*/); // Raender auf den Folgeseiten nicht aendern.
	pFusz->SetPtr(&aPage1.aFusz);
	pDoku->SetPtr(pOkayBtn);

	InitElemUI();
	InitFinaUI();

	GetFromDef();  // Harte Defaults setzen
	GetFromUsr();  // Defaults von Benutzereinstellungen holen
	GetFromIni();  // Defaults vom Inifile holen

	SetEventHandler();

	aLogo.ToUI();
	aEmpf.ToUI();
	pMarg->ToUI();
	pFusz->ToUI();
	pDoku->ToUI();
	FillDocInfoList();
	AbsnToUI();
	Absn1ToUI();
	EmpfToUI();
	ElemToUI();
	LogoFToUI();
	AbsnFToUI();
	KopzFToUI();
	FuszFToUI();
	PgNumToUI();

	pFusz->SetDisable();
	pDoku->SetDisable();
	SetFuszKopzMarg();
	SetPrivat();
	//SetFuss1Disable();
	SetFussFDisable();
	SetKopfFDisable();
	SetAbsnBMapBtnDisable();
	SetMetDisable();
	//SetLogoRadioDisable();
	SetLogoAbsnFDisable();
	SetLogoAbsnPrnDisable();
	SetPagNumDisable();
	SetElemDisable();
	SetElemBetr();
	Inc();
}

////////////////////////////////////////////////////////////////////////////////
//
//  @@@@  @@@@@ @@@@   @@@@@ @@@@   @@@@  @@   @@
// @@  @@ @@     @@    @@    @@ @@ @@  @@ @@@ @@@
// @@     @@     @@    @@    @@ @@ @@  @@ @@@@@@@
// @@ @@@ @@@@   @@    @@@@  @@@@  @@  @@ @@ @ @@
// @@  @@ @@     @@    @@    @@ @@ @@  @@ @@   @@
// @@  @@ @@     @@    @@    @@ @@ @@  @@ @@   @@  @@ @@ @@
//  @@@@@ @@@@@  @@    @@    @@ @@  @@@@  @@   @@  @@ @@ @@
//
////////////////////////////////////////////////////////////////////////////////

void LetterDialog::GetFromDef()
{
	a1_RBtn_GesBrf.Check(TRUE);  // Geschaeftsbrief
	a1_RBtn_Stil1.Check(TRUE);   // Stilrichtung 1
	a3_RBtn_AnzNee.Check(TRUE);  // Absender bei Privatbrief

//    aEmpf.ForceDefault();

	for (USHORT i = 0; i < a5_List_PagNum.GetEntryCount(); i++)
	{
		if (SVX_NUM_ARABIC == (USHORT)(ULONG)a5_List_PagNum.GetEntryData(i))
		{
			a5_List_PagNum.SelectEntryPos(i);
			break;
		}
	}

	aPage1.aFusz.Show();
	aPageF.aFusz.Show();

	aPage1.aFusz.SetPgNum(FALSE);
	aPage1.aFusz.SetPgNumStr(a5_Edit_PagNum.GetText());
	aPage1.aFusz.SetPgNumFmt(SVX_NUM_ARABIC); // Arabisch numerieren

	aPage1.aFusz.SetPgNumGes(FALSE);
	aPage1.aFusz.SetPgNumGesStr(a5_Edit_PagGes.GetText());

	aPageF.aFusz.SetPgNum(FALSE);
	aPageF.aFusz.SetPgNumStr(a5_Edit_PagNum.GetText());
	aPageF.aFusz.SetPgNumFmt(SVX_NUM_ARABIC); // Arabisch numerieren
	aPageF.aFusz.SetPgNumGes(FALSE);
	aPageF.aFusz.SetPgNumGesStr(a5_Edit_PagGes.GetText());

	p9_List_AbsPrn->SelectEntryPos(0); // Absender immer drucken
	p9_List_LgoPrn->SelectEntryPos(0); // Logo immer drucken
#ifndef NO_PAPERBIN
	p9_List_TrayS1->SelectEntryPos(0); // Erster Schacht
	p9_List_TrayFF->SelectEntryPos(0); // Erster Schacht
#endif
}

void LetterDialog::GetFromUsr()
{
	String aLF( String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM(NEWLINE)));
	String sStr, sRow, sTmp, sToken, sPrevToken;
	String sAddrDef(SW_RES(STR_Brf_Usr_Address));

	SvxAddressItem aAddress;
	String sPhoneHome(aAddress.GetToken(POS_TEL_PRIVATE));
	String sPhoneWork(aAddress.GetToken(POS_TEL_COMPANY));
	String sFax(aAddress.GetToken(POS_FAX));
	String sEmail(aAddress.GetToken(POS_EMAIL));

	USHORT nCnt = sAddrDef.GetTokenCount();

	for (USHORT i = 0; i < nCnt; i++)
	{
		sPrevToken = sToken;
		sToken = sAddrDef.GetToken(i);
		int nPos = -1;

		if (sToken.EqualsAscii("COMPANY"))
		{
			if ((sTmp = aAddress.GetToken(POS_COMPANY)).Len())
			{
				sRow.Insert('>', 0);
				sRow += sTmp;
			}
			continue;
		}
		else if (sToken.EqualsAscii("PREFIX"))
			nPos = POS_TITLE;
		else if (sToken.EqualsAscii("FIRSTNAME"))
		{
			sRow += aAddress.GetFirstName();
			continue;
		}
		else if (sToken.EqualsAscii("LASTNAME"))
		{
			if (!aAddress.GetToken(POS_COMPANY).Len())
				sRow.Insert('>', 0);
			sRow += aAddress.GetName();
			continue;
		}
		else if (sToken.EqualsAscii("TITLE"))
			nPos = POS_POSITION;
		else if (sToken.EqualsAscii("ADDRESS"))
		{
			if ((sTmp = aAddress.GetToken(POS_STREET)).Len())
			{
				sRow.Insert('>', 0);
				sRow += sTmp;
			}
			continue;
		}
		else if (sToken.EqualsAscii("COUNTRY"))
			nPos = POS_COUNTRY;
		else if (sToken.EqualsAscii("POSTALCODE"))
			nPos = POS_PLZ;
		else if (sToken.EqualsAscii("CITY"))
		{
			if ((sTmp = aAddress.GetToken(POS_CITY)).Len())
			{
				sRow.Insert('>', 0);
				sRow += sTmp;
			}
			continue;
		}
		else if (sToken.EqualsAscii("EMAILPREFIX"))
		{
			if(sEmail.Len())
				sRow += SW_RESSTR(STR_Usr_ElektrMail);
			continue;
		}
		else if (sToken.EqualsAscii("EMAIL"))
		{
			sRow += sEmail;
			continue;
		}
		else if (sToken.EqualsAscii("STATEPROV"))
			nPos = POS_STATE;
		else if (sToken.EqualsAscii("FAXPREFIX"))
		{
			if (sFax.Len())
				sRow += SW_RESSTR(STR_Usr_Faxnummer);
			continue;
		}
		else if (sToken.EqualsAscii("FAX"))
		{
			if (sFax.Len())
				sRow += sFax;
			continue;
		}
		else if (sToken.EqualsAscii("PHONEPREFIX"))
		{
			if (sPhoneWork.Len())
				sRow += SW_RESSTR(STR_Usr_TeleDienst);
			else if(sPhoneHome.Len())
				sRow += SW_RESSTR(STR_Usr_TelePrivat);
			continue;
		}
		else if (sToken.EqualsAscii("PHONEHOME"))
		{
			sRow += sPhoneHome;
			continue;
		}
		else if (sToken.EqualsAscii("PHONEWORK"))
		{
			if (sPhoneWork.Len())
				sRow += sPhoneWork;
			else
				sRow += sPhoneHome;
			continue;
		}
		else if (sToken.EqualsAscii("CR"))
		{
			if (sRow.Len())
			{
				(sStr += sRow) += aLF;
				sRow.Erase();
			}
			sToken = aEmptyStr;
			continue;
		}

		if (nPos >= 0)
		{
			sToken = aAddress.GetToken(nPos);
			sRow += sToken;
			continue;
		}

		if (sPrevToken.Len())	// Trennzeichen nur einfuegen, wenn
			sRow += sToken;		// vorheriges Token existierte.
	}
	if (sRow.Len())
		sStr += sRow;

	aPage1.aAbsn.SetStr( sStr );
}

void LetterDialog::GetFromIni()
{
	if(!aConfig.HasValuesRead())
		return;
	switch(aConfig.nTemplateStyleTypePreferredStyle)
	{
		case 0: a1_RBtn_Stil1.Check(TRUE);break;
		case 1: a1_RBtn_Stil2.Check(TRUE);break;
		default: a1_RBtn_Stil3.Check(TRUE);
	}
	StyleClickHdl(NULL);

	a1_RBtn_PrvBrf.Check(aConfig.bTemplateType);
	a3_RBtn_AnzNee.Check(aConfig.bSenderRepeat);

	aPage1.aLogo.SetModeGraf(0, aConfig.bLogoVisible);
	if(aConfig.bLogoIsGraphic)
        aPage1.aLogo.SetGraphic(aConfig.sLogoFileTypeName,
                                aConfig.sLogoFileTypeFilter,
                                aConfig.bLogoFileTypeAsLink);
	aPage1.aLogo.SetPosX(MM100_TO_TWIP(aConfig.nLogoPositionXYTypeX));
	aPage1.aLogo.SetPosY(MM100_TO_TWIP(aConfig.nLogoPositionXYTypeY));
    aPage1.aLogo.SetWdt((USHORT)MM100_TO_TWIP(aConfig.nLogoSizeTypeWidth));
    aPage1.aLogo.SetHgt((USHORT)MM100_TO_TWIP(aConfig.nLogoSizeTypeHeight));
    aPage1.aLogo.SetRandL((USHORT)MM100_TO_TWIP(aConfig.nLogoAlignmentPositionTypeLeft));
    aPage1.aLogo.SetRandR((USHORT)MM100_TO_TWIP(aConfig.nLogoAlignmentPositionTypeRight));
    aPage1.aLogo.SetRandO((USHORT)MM100_TO_TWIP(aConfig.nLogoAlignmentPositionTypeTop));
    aPage1.aLogo.SetRandU((USHORT)MM100_TO_TWIP(aConfig.nLogoAlignmentPositionTypeBottom));
	aPage1.aLogo.SetAlign((PageAlign)aConfig.nLogoAlignmentAlignmentTypePosition);
	aPage1.aLogo.SetStr(aConfig.sLogoText);

	//copy data to header logo of following pages
	aPageF.aKopz.aLogo.SetStr(aPage1.aLogo.GetStr());
	aPageF.aKopz.aLogo.SetModeGraf(NULL,aPage1.aLogo.IsGrafLogo());
	aPageF.aKopz.aLogo.Show(NULL,aPage1.aLogo.IsVisible());
    aPageF.aKopz.aLogo.SetGraphic(
        aConfig.sLogoFileTypeName,
        aConfig.sLogoFileTypeFilter,
        aConfig.bLogoFileTypeAsLink);

	aPage1.aAbsn.SetPosX(MM100_TO_TWIP(aConfig.nSenderPositionXYTypeX));
	aPage1.aAbsn.SetPosY(MM100_TO_TWIP(aConfig.nSenderPositionXYTypeY));
    aPage1.aAbsn.SetWdt((USHORT)MM100_TO_TWIP(aConfig.nSenderSizeTypeWidth));
    aPage1.aAbsn.SetHgt((USHORT)MM100_TO_TWIP(aConfig.nSenderSizeTypeHeight));
    aPage1.aAbsn.SetRandL((USHORT)MM100_TO_TWIP(aConfig.nSenderPositionTypeLeft));
    aPage1.aAbsn.SetRandR((USHORT)MM100_TO_TWIP(aConfig.nSenderPositionTypeRight));
    aPage1.aAbsn.SetRandO((USHORT)MM100_TO_TWIP(aConfig.nSenderPositionTypeTop));
    aPage1.aAbsn.SetRandU((USHORT)MM100_TO_TWIP(aConfig.nSenderPositionTypeBottom));
	aPage1.aAbsn.SetAlign((PageAlign)aConfig.nSenderAlignmentTypePosition);
	aPage1.aAbsn.SetStr(aConfig.sSenderContent);
	aPage1.aEmpf.ShowAbsn(NULL,aConfig.bSenderShow);

    USHORT nDBIndex = aEmpf.pE_List_DBase->GetEntryPos(String(aConfig.sRecipientDatabase));
    //select first time to fill the table ListBox
    aEmpf.SelectDBasList(nDBIndex);
    aEmpf.pE_List_DBTable->SelectEntry(aConfig.sRecipientDataTable);
    //select a second time
    aEmpf.SelectDBasList(nDBIndex);

	aEmpf.pE_Edit_AnrFix->SetText(aConfig.sRecipientSalutation);
	aEmpf.pE_List_AnrFld->SelectEntry(aConfig.sRecipientSalutationField);

	aPage1.aEmpf.SetPosX( MM100_TO_TWIP(aConfig.nRecipientPositionXYTypeX));
	aPage1.aEmpf.SetPosY( MM100_TO_TWIP(aConfig.nRecipientPositionXYTypeY));
    aPage1.aEmpf.SetWdt((USHORT)MM100_TO_TWIP(aConfig.nRecipientSizeTypeWidth));
    aPage1.aEmpf.SetHgt((USHORT)MM100_TO_TWIP(aConfig.nRecipientSizeTypeHeight));
    aPage1.aEmpf.SetRandL((USHORT)MM100_TO_TWIP(aConfig.nRecipientAlignmentPositionTypeLeft));
    aPage1.aEmpf.SetRandR((USHORT)MM100_TO_TWIP(aConfig.nRecipientAlignmentPositionTypeRight));
    aPage1.aEmpf.SetRandO((USHORT)MM100_TO_TWIP(aConfig.nRecipientAlignmentPositionTypeTop));
    aPage1.aEmpf.SetRandU((USHORT)MM100_TO_TWIP(aConfig.nRecipientAlignmentPositionTypeBottom));
	aPage1.aEmpf.SetAlign((PageAlign)aConfig.nRecipientAlignmentAlignmentTypePosition);
	aPage1.aEmpf.SetStr(aConfig.sRecipientContent);

	a5_Edit_Elem1.SetText(aConfig.sElementsElement1TextElementTypeContent );
	a5_Edit_Elem2.SetText(aConfig.sElementsElement2TextElementTypeContent );
	a5_Edit_Elem3.SetText(aConfig.sElementsElement3TextElementTypeContent );
	a5_Edit_Elem4.SetText(aConfig.sElementsElement4TextElementTypeContent );
	aPage1.aElem.Show(0,NULL,aConfig.bElementsElement1TextElementTypeVisible);
	aPage1.aElem.Show(1,NULL,aConfig.bElementsElement2TextElementTypeVisible);
	aPage1.aElem.Show(2,NULL,aConfig.bElementsElement3TextElementTypeVisible);
	aPage1.aElem.Show(3,NULL,aConfig.bElementsElement4TextElementTypeVisible);

    a5_List_Datum.SelectEntryPos((USHORT)aConfig.nElementsDateIntElementTypeContent);
	aPage1.aElem.Show(4,NULL,aConfig.bElementsDateIntElementTypeVisible);

	a5_Edit_Betref.SetText(aConfig.sElementsSubjectTextElementTypeContent);
	aPage1.aBetr.Show(NULL,aConfig.bElementsSubjectTextElementTypeVisible);

	a5_CBox_KopiAn.Check(aConfig.bElementsCopy);
	a5_CBox_Anlagn.Check(aConfig.bElementsEnclosure);


	aPage1.aFusz.SetPgNum(aConfig.bElementsPageNumberVisible);
	aPage1.aFusz.SetPgNumStr(aConfig.sElementsPageNumberTextBefore);

    aPage1.aFusz.SetPgNumFmt((USHORT)aConfig.nElementsPageNumberFormat);

	aPage1.aFusz.SetPgNumGes(aConfig.bElementsPageNumberTotalPageCountVisible);
	aPage1.aFusz.SetPgNumGesStr(aConfig.sElementsPageNumberTotalPageCountTextBefore);

	//copy settings to following pages
	aPageF.aFusz.SetPgNum      (aPage1.aFusz.IsPgNum());
	aPageF.aFusz.SetPgNumStr   (aPage1.aFusz.GetPgNumStr());
	aPageF.aFusz.SetPgNumFmt   (aPage1.aFusz.GetPgNumFmt());
	aPageF.aFusz.SetPgNumGes   (aPage1.aFusz.IsPgNumGes());
	aPageF.aFusz.SetPgNumGesStr(aPage1.aFusz.GetPgNumGesStr());

	aPage1.aFusz.Show(NULL,aConfig.bFooterOnPage1Enable);
	aPage1.aFusz.SetTrennlinie(aConfig.bFooterOnPage1Separator);
    aPage1.aFusz.SetVer((USHORT)MM100_TO_TWIP(aConfig.nFooterOnPage1FromBottom));
    aPage1.aFusz.SetTextDst((USHORT)MM100_TO_TWIP(aConfig.nFooterOnPage1FromText));
	aPage1.aFusz.SetStr(aConfig.sFooterOnPage1Text);

	aPageF.aFusz.Show(NULL,aConfig.bFooterOnContinuationPagesEnable);
    aPageF.aFusz.SetVer((USHORT)MM100_TO_TWIP(aConfig.nFooterOnContinuationPagesFromBottom));
    aPageF.aFusz.SetTextDst((USHORT)MM100_TO_TWIP(aConfig.nFooterOnContinuationPagesFromText));
	//copy text to following pages
	aPageF.aFusz.SetStr(aPage1.aFusz.GetStr());

    aPageF.aKopz.SetVer((USHORT)MM100_TO_TWIP(aConfig.nHeaderFromTop));
    aPageF.aKopz.SetTextDst((USHORT)MM100_TO_TWIP(aConfig.nHeaderFromText));
	aPageF.aKopz.aLogo.Show(NULL,aConfig.bHeaderLogoVisible);
	aPageF.aKopz.SetLogoAlign((PageAlign)aConfig.nHeaderLogoAlignmentTypePosition);
    aPageF.aKopz.SetLogoWdt((USHORT)MM100_TO_TWIP(aConfig.nHeaderLogoSizeTypeWidth));
    aPageF.aKopz.SetLogoHgt((USHORT)MM100_TO_TWIP(aConfig.nHeaderLogoSizeTypeHeight));
	aPageF.aKopz.aAbsn.Show(NULL,aConfig.bHeaderSenderVisible);
	aPageF.aKopz.SetAbsnAlign((PageAlign)aConfig.nHeaderSenderAlignmentTypePosition);
    aPageF.aKopz.SetAbsnWdt((USHORT)MM100_TO_TWIP(aConfig.nHeaderSenderSizeTypeWidth));
    aPageF.aKopz.SetAbsnHgt((USHORT)MM100_TO_TWIP(aConfig.nHeaderSenderSizeTypeHeight));

    aPage1.SetRandL((USHORT)MM100_TO_TWIP(aConfig.nPageMarginLeft ));
    aPage1.SetRandR((USHORT)MM100_TO_TWIP(aConfig.nPageMarginRight));

    p9_List_LgoPrn->SelectEntryPos((USHORT)aConfig.nPrintLogo);
    p9_List_AbsPrn->SelectEntryPos((USHORT)aConfig.nPrintSender);
#ifndef NO_PAPERBIN
	p9_List_TrayS1->SelectEntry(aConfig.sPrintTrayPage1);
	p9_List_TrayFF->SelectEntry(aConfig.sPrintTrayContinuationPage);
#endif
	BOOL bPrt = FALSE;
	if(aConfig.sPrintPrinter.getLength())
	{
		Printer *pPrt = new Printer(aConfig.sPrintPrinter);
		if (pPrt)
		{
			if (pPrinter)
				delete pPrinter;
			pPrinter = pPrt;
			p9_Text_PrName->SetText(aConfig.sPrintPrinter);
			bPrt = TRUE;
		}
	}
	if (!bPrt)
		p9_Text_PrName->SetText(Printer::GetDefaultPrinterName());

	FillDocInfoList();
	aConfig.ReadDocInfo(*pDoku);
}

void LetterDialog::WriteToIni()
{
	aConfig.nTemplateStyleTypePreferredStyle = a1_RBtn_Stil1.IsChecked() ? 0 :
		a1_RBtn_Stil2.IsChecked() ? 1 : 2;

	aConfig.bTemplateType = a1_RBtn_PrvBrf.IsChecked(); //private letter
	aConfig.bSenderRepeat = a3_RBtn_AnzNee.IsChecked();

	aConfig.bLogoIsGraphic = aPage1.aLogo.IsGrafLogo();
	String sName, sFilter;
    sal_Bool bAsLink;
    aPage1.aLogo.GetGraphic( sName, sFilter, bAsLink );
	aConfig.sLogoFileTypeName = sName;
	aConfig.sLogoFileTypeFilter = sFilter;
    aConfig.bLogoFileTypeAsLink = bAsLink;
	aConfig.bLogoVisible = aPage1.aLogo.IsVisible();
	aConfig.nLogoPositionXYTypeX = TWIP_TO_MM100(aPage1.aLogo.GetPosX());
	aConfig.nLogoPositionXYTypeY = TWIP_TO_MM100(aPage1.aLogo.GetPosY());
	aConfig.nLogoSizeTypeWidth   = TWIP_TO_MM100(aPage1.aLogo.GetWdt());
	aConfig.nLogoSizeTypeHeight  = TWIP_TO_MM100(aPage1.aLogo.GetHgt());
	aConfig.nLogoAlignmentAlignmentTypePosition = aPage1.aLogo.GetAlign();
	aConfig.nLogoAlignmentPositionTypeLeft  = TWIP_TO_MM100(aPage1.aLogo.GetRandL());
	aConfig.nLogoAlignmentPositionTypeRight = TWIP_TO_MM100(aPage1.aLogo.GetRandR());
	aConfig.nLogoAlignmentPositionTypeTop   = TWIP_TO_MM100(aPage1.aLogo.GetRandO());
	aConfig.nLogoAlignmentPositionTypeBottom= TWIP_TO_MM100(aPage1.aLogo.GetRandU());
	aConfig.sLogoText = aPage1.aLogo.GetStr();

	aConfig.sSenderContent = aPage1.aAbsn.GetStr();
	aConfig.nSenderPositionXYTypeX =        TWIP_TO_MM100(aPage1.aAbsn.GetPosX());
	aConfig.nSenderPositionXYTypeY =        TWIP_TO_MM100(aPage1.aAbsn.GetPosY());
	aConfig.nSenderSizeTypeWidth =          TWIP_TO_MM100(aPage1.aAbsn.GetWdt());
	aConfig.nSenderSizeTypeHeight =         TWIP_TO_MM100(aPage1.aAbsn.GetHgt());
	aConfig.nSenderPositionTypeLeft =       TWIP_TO_MM100(aPage1.aAbsn.GetRandL());
	aConfig.nSenderPositionTypeRight =      TWIP_TO_MM100(aPage1.aAbsn.GetRandR());
	aConfig.nSenderPositionTypeTop =        TWIP_TO_MM100(aPage1.aAbsn.GetRandO());
	aConfig.nSenderPositionTypeBottom =     TWIP_TO_MM100(aPage1.aAbsn.GetRandU());
	aConfig.nSenderAlignmentTypePosition =  aPage1.aAbsn.GetAlign();

	aConfig.bSenderShow = aPage1.aEmpf.IsAbsnShown();

	aConfig.sRecipientDatabase = aEmpf.pE_List_DBase->GetSelectEntry();
    aConfig.sRecipientDataTable = aEmpf.pE_List_DBTable->GetSelectEntry();

	aConfig.sRecipientSalutation = aEmpf.pE_Edit_AnrFix->GetText();
	aConfig.sRecipientSalutationField = aEmpf.pE_List_AnrFld->GetSelectEntry();

	aConfig.sRecipientContent =                     aPage1.aEmpf.GetStr();
	aConfig.nRecipientPositionXYTypeX =                TWIP_TO_MM100(aPage1.aEmpf.GetPosX());
	aConfig.nRecipientPositionXYTypeY =                TWIP_TO_MM100(aPage1.aEmpf.GetPosY());
	aConfig.nRecipientSizeTypeWidth =                  TWIP_TO_MM100(aPage1.aEmpf.GetWdt());
	aConfig.nRecipientSizeTypeHeight =                 TWIP_TO_MM100(aPage1.aEmpf.GetHgt());
	aConfig.nRecipientAlignmentPositionTypeLeft =      TWIP_TO_MM100(aPage1.aEmpf.GetRandL());
	aConfig.nRecipientAlignmentPositionTypeRight =     TWIP_TO_MM100(aPage1.aEmpf.GetRandR());
	aConfig.nRecipientAlignmentPositionTypeTop =       TWIP_TO_MM100(aPage1.aEmpf.GetRandO());
	aConfig.nRecipientAlignmentPositionTypeBottom =    TWIP_TO_MM100(aPage1.aEmpf.GetRandU());
	aConfig.nRecipientAlignmentAlignmentTypePosition = aPage1.aEmpf.GetAlign();

	aConfig.bElementsElement1TextElementTypeVisible = aPage1.aElem.IsVisible(0);
	aConfig.sElementsElement1TextElementTypeContent = a5_Edit_Elem1.GetText();
	aConfig.bElementsElement2TextElementTypeVisible = aPage1.aElem.IsVisible(1);
	aConfig.sElementsElement2TextElementTypeContent = a5_Edit_Elem2.GetText();
	aConfig.bElementsElement3TextElementTypeVisible = aPage1.aElem.IsVisible(2);
	aConfig.sElementsElement3TextElementTypeContent = a5_Edit_Elem3.GetText();
	aConfig.bElementsElement4TextElementTypeVisible = aPage1.aElem.IsVisible(3);
	aConfig.sElementsElement4TextElementTypeContent = a5_Edit_Elem4.GetText();
	aConfig.bElementsDateIntElementTypeVisible = 		aPage1.aElem.IsVisible(4);
	aConfig.nElementsDateIntElementTypeContent = 		a5_List_Datum.GetSelectEntryPos();
	aConfig.bElementsSubjectTextElementTypeVisible = 	aPage1.aBetr.IsVisible();
	aConfig.sElementsSubjectTextElementTypeContent = 	a5_Edit_Betref.GetText();
	aConfig.bElementsCopy = 							a5_CBox_KopiAn.IsChecked();
	aConfig.bElementsEnclosure =                        a5_CBox_Anlagn.IsChecked();
	aConfig.bElementsPageNumberVisible =                aPage1.aFusz.IsPgNum();
	aConfig.sElementsPageNumberTextBefore =             aPage1.aFusz.GetPgNumStr();
	aConfig.nElementsPageNumberFormat =					aPage1.aFusz.GetPgNumFmt();
	aConfig.bElementsPageNumberTotalPageCountVisible =  	aPage1.aFusz.IsPgNumGes();
	aConfig.sElementsPageNumberTotalPageCountTextBefore =   aPage1.aFusz.GetPgNumGesStr();

	aConfig.bFooterOnPage1Enable =				aPage1.aFusz.IsVisible();
	aConfig.bFooterOnPage1Separator =			aPage1.aFusz.IsTrennlinie();
	aConfig.sFooterOnPage1Text =                aPage1.aFusz.GetStr();
	aConfig.nFooterOnPage1FromBottom =			TWIP_TO_MM100(aPage1.aFusz.GetVer());
	aConfig.nFooterOnPage1FromText =            TWIP_TO_MM100(aPage1.aFusz.GetTextDst());
	aConfig.bFooterOnContinuationPagesEnable =  aPageF.aFusz.IsVisible();
	aConfig.nFooterOnContinuationPagesFromBottom = TWIP_TO_MM100(aPageF.aFusz.GetVer());
	aConfig.nFooterOnContinuationPagesFromText = 	TWIP_TO_MM100(aPageF.aFusz.GetTextDst());

	aConfig.nHeaderFromTop = 						TWIP_TO_MM100(aPageF.aKopz.GetVer());
	aConfig.nHeaderFromText = 						TWIP_TO_MM100(aPageF.aKopz.GetTextDst());
	aConfig.bHeaderSenderVisible =					aPageF.aKopz.aAbsn.IsVisible();
	aConfig.nHeaderSenderSizeTypeWidth =			TWIP_TO_MM100(aPageF.aKopz.aAbsn.GetWdt());
	aConfig.nHeaderSenderSizeTypeHeight =           TWIP_TO_MM100(aPageF.aKopz.aAbsn.GetHgt());
	aConfig.nHeaderSenderAlignmentTypePosition =    aPageF.aKopz.aAbsn.GetAlign();
	aConfig.bHeaderLogoVisible = 					aPageF.aKopz.aLogo.IsVisible();
	aConfig.nHeaderLogoSizeTypeWidth =				TWIP_TO_MM100(aPageF.aKopz.aLogo.GetWdt());
	aConfig.nHeaderLogoSizeTypeHeight =             TWIP_TO_MM100(aPageF.aKopz.aLogo.GetHgt());
	aConfig.nHeaderLogoAlignmentTypePosition = 		aPageF.aKopz.aLogo.GetAlign();

	aConfig.nPageMarginLeft = TWIP_TO_MM100(aPage1.GetRandL());
	aConfig.nPageMarginRight = TWIP_TO_MM100(aPage1.GetRandR());

	aConfig.nPrintSender = p9_List_AbsPrn->GetSelectEntryPos();
	aConfig.nPrintLogo = p9_List_LgoPrn->GetSelectEntryPos();
	aConfig.sPrintPrinter = p9_Text_PrName->GetText();
	if(p9_List_TrayS1->GetSelectEntryPos() > 0)
        aConfig.sPrintTrayPage1 = p9_List_TrayS1->GetSelectEntry();
    else
        aConfig.sPrintTrayPage1 = aEmptyStr;
	if(p9_List_TrayFF->GetSelectEntryPos() > 0)
        aConfig.sPrintTrayContinuationPage = p9_List_TrayFF->GetSelectEntry();
    else
        aConfig.sPrintTrayContinuationPage = aEmptyStr;

	aConfig.WriteDocInfo(*pDoku);
	aConfig.Commit();
}

////////////////////////////////////////////////////////////////////////////////
// SetDisable
////////////////////////////////////////////////////////////////////////////////

void LetterDialog::SetElemDisable()
{
	a5_Edit_Elem1 .Enable(a5_CBox_Elem1 .IsChecked());
	a5_Edit_Elem2 .Enable(a5_CBox_Elem2 .IsChecked());
	a5_Edit_Elem3 .Enable(a5_CBox_Elem3 .IsChecked());
	a5_Edit_Elem4 .Enable(a5_CBox_Elem4 .IsChecked());
	a5_List_Datum .Enable(a5_CBox_Datum .IsChecked());
	a5_Edit_Betref.Enable(a5_CBox_Betref.IsChecked());
}

void LetterDialog::SetPagNumDisable()
{
	BOOL bFusz=(pFusz->pF_CBox_FussAn->IsChecked() && // Keine Seitennumerierung Fusszeile
				p7_CBox_FusAnz->IsChecked());         // auf allen Seiten
	BOOL bPNum=bFusz && a5_CBox_PagNum.IsChecked();
	BOOL bPGes=bPNum && a5_CBox_PagGes.IsChecked();

	a5_CBox_PagNum.Enable(bFusz);
	a5_Edit_PagNum.Enable(bPNum);
	a5_List_PagNum.Enable(bPNum);
	a5_CBox_PagGes.Enable(bPNum);
	a5_Edit_PagGes.Enable(bPGes);
}

void LetterDialog::SetLogoBMapBtnDisable()
{
	if (aPage1.aAbsn.IsVisible()) {
		aLogo.SetBeware(aPage1.aAbsn.GetAlign());
	} else {
		aLogo.SetBeware(ALIGN_Null);
	}
}

void LetterDialog::SetAbsnBMapBtnDisable()
{
	BOOL bEnable = aPage1.aAbsn.IsVisible();
	BOOL bAbsnLi=bEnable;
	BOOL bAbsnRe=bEnable;
	if ( bEnable && aPage1.aLogo.IsVisible() )
	{
		switch (aPage1.aLogo.GetAlign()) {
			case ALIGN_LiOb: bAbsnLi=FALSE; break;
			case ALIGN_ReOb: bAbsnRe=FALSE; break;
			case ALIGN_MiOb: bAbsnLi=FALSE; bAbsnRe=FALSE; break;
		}
	}
	a3_BBtn_AbsnOL.Enable(bAbsnLi);
	a3_BBtn_AbsnOR.Enable(bAbsnRe);
	a3_BBtn_AbsnUL.Enable(bEnable);
	a3_BBtn_AbsnUR.Enable(bEnable);
	a3_BBtn_AbsnMi.Enable(bEnable);
}

void LetterDialog::SetMetDisable()
{
	a3_MFld_AbsnHo.SetValue(aPage1.aAbsn.GetHor(), FUNIT_CM);
	a3_MFld_AbsnVe.SetValue(aPage1.aAbsn.GetVer(), FUNIT_CM);
	BOOL bAbs=aPage1.aAbsn.IsVisible();
	String aStr;

	BOOL bEnable = aPage1.aAbsn.GetHorStr(aStr) && bAbs;
	if (bEnable)
		a3_Text_AbsnHo.SetText(aStr);
	a3_Text_AbsnHo.Enable(bEnable);
	a3_MFld_AbsnHo.Enable(bEnable);

	bEnable = aPage1.aAbsn.GetVerStr(aStr) && bAbs;
	if (bEnable)
		a3_Text_AbsnVe.SetText(aStr);
	a3_Text_AbsnVe.Enable(bEnable);
	a3_MFld_AbsnVe.Enable(bEnable);
}

void LetterDialog::SetElemBetr() // Hier wird vor allem auch der obere Papierrand gesetzt.
{
	USHORT Ofs=10*EINHEIT;
	USHORT Ofs1=0;
	USHORT Ofs2=0;
	USHORT Ofs3=0;
	if (aPage1.aLogo.IsVisible()) Ofs1=USHORT(aPage1.aLogo.GetPosY()+aPage1.aLogo.GetHgt()+5*EINHEIT);
	if (aPage1.aAbsn.IsVisible() && !aPage1.aAbsn.IsUnt()) Ofs2=USHORT(aPage1.aAbsn.GetPosY()+aPage1.aAbsn.GetHgt()+5*EINHEIT);
	if (aPage1.aEmpf.IsVisible()) Ofs3=USHORT(aPage1.aEmpf.GetPosY()+aPage1.aEmpf.GetHgt()+12*EINHEIT);
	Ofs=Max(Ofs,Ofs1);
	Ofs=Max(Ofs,Ofs2);
	Ofs=Max(Ofs,Ofs3);
	aPage1.aElem.SetPosY(Ofs,&aPrevWin);
	USHORT Hgt=aPage1.aElem.GetHgt();
	if (Hgt!=0) Hgt+=7*EINHEIT; // 7mm zwischen Elementen und Betreff
	Ofs+=Hgt;
	aPage1.aBetr.SetPosY(Ofs,&aPrevWin);
	if (aPage1.aBetr.IsVisible()) Ofs+=aPage1.aBetr.GetHgt()+8*EINHEIT;
	aPage1.SetRandO(Ofs,&aPrevWin);
}

void LetterDialog::SetPrivat()
{
	if( a1_RBtn_PrvBrf.IsChecked() )
	{
		// Privatbrief
		aPage1.aEmpf.Set2ndHide(TRUE,&aPrevWin);
		aPage1.aBetr.Set2ndHide(TRUE,&aPrevWin);
		aPage1.aElem.Set2ndHide(TRUE,&aPrevWin);
		if (a3_RBtn_AnzNee.IsChecked())
		{
			aPage1.aAbsn.Hide(&aPrevWin);
			p7_List_AbsnWo->SelectEntryPos(0);
			KopzFListSelectHdl(p7_List_AbsnWo);
		}
		else
			a3_RBtn_AnzJaa.Check( TRUE );
		ShowHideWin( a3_Text_AbsWdh, FALSE);
		ShowHideWin( a3_RBtn_WdhJaa, FALSE);
		ShowHideWin( a3_RBtn_WdhNee, FALSE);
		ShowHideWin( a3_Text_AbsAnz, TRUE );
		ShowHideWin( a3_RBtn_AnzJaa, TRUE );
		ShowHideWin( a3_RBtn_AnzNee, TRUE );
	}
	else
	{
		// Geschaeftsbrief
		aPage1.aEmpf.Set2ndHide(FALSE,&aPrevWin);
		aPage1.aBetr.Set2ndHide(FALSE,&aPrevWin);
		aPage1.aElem.Set2ndHide(FALSE,&aPrevWin);
		aPage1.aAbsn.Show(&aPrevWin);
		ShowHideWin( a3_Text_AbsWdh, TRUE );
		ShowHideWin( a3_RBtn_WdhJaa, TRUE );
		ShowHideWin( a3_RBtn_WdhNee, TRUE );
		ShowHideWin( a3_Text_AbsAnz, FALSE);
		ShowHideWin( a3_RBtn_AnzJaa, FALSE);
		ShowHideWin( a3_RBtn_AnzNee, FALSE);
	}
	SetLogoBMapBtnDisable(); // Evtl mehr Platz fuers Logo?
	SetAbsnBMapBtnDisable(); // Evtl ist der Absender weg
	SetElemBetr();
}

/*void LetterDialog::SetFuss1Disable()
{
	if (aPage1.aFusz.IsVisible()) {
		a6_CBox_TrennL.Enable();
		a6_Text_VonUnt.Enable();
		a6_MFld_VonUnt.Enable();
		a6_Text_ZumTxt.Enable();
		a6_MFld_ZumTxt.Enable();
		a6_MEdt_FusZei.Enable();
	} else {
		a6_CBox_TrennL.Disable();
		a6_Text_VonUnt.Disable();
		a6_MFld_VonUnt.Disable();
		a6_Text_ZumTxt.Disable();
		a6_MFld_ZumTxt.Disable();
		a6_MEdt_FusZei.Disable();
	}
}*/

void LetterDialog::SetFussFDisable()
{
	const BOOL bEnable = aPage1.aFusz.IsVisible();
	const BOOL bFus=aPageF.aFusz.IsVisible() && bEnable;
	p7_CBox_FusAnz->Enable(bEnable);
    p7_FL_FusLin->Enable(bEnable);
	p7_Text_FLinOb->Enable(bFus);
	p7_MFld_FLinOb->Enable(bFus);
	p7_Text_FLinTx->Enable(bFus);
	p7_MFld_FLinTx->Enable(bFus);
}

void LetterDialog::SetKopfFDisable()
{
	const BOOL bEnable = aPage1.aFusz.IsVisible();
	const BOOL bFus=aPageF.aFusz.IsVisible() && bEnable;
	p7_CBox_FusAnz->Enable(bEnable);
    p7_FL_FusLin->Enable(bEnable);
	p7_Text_FLinOb->Enable(bFus);
	p7_MFld_FLinOb->Enable(bFus);
	p7_Text_FLinTx->Enable(bFus);
	p7_MFld_FLinTx->Enable(bFus);
}

void LetterDialog::SetLogoAbsnFDisable()
{
	const BOOL bLgo1=aPage1.aLogo.IsVisible();
	const BOOL bAbs1=aPage1.aAbsn.IsVisible();
	const BOOL bLgo2=bLgo1 && aPageF.aKopz.LogoIsVisible();
	const BOOL bAbs2=bAbs1 && aPageF.aKopz.AbsnIsVisible();

	p7_Text_LogoWo->Enable(bLgo1);
	p7_List_LogoWo->Enable(bLgo1);

	p7_Text_LogoWd->Enable(bLgo2);
	p7_MFld_LogoWd->Enable(bLgo2);
	p7_Text_LogoHg->Enable(bLgo2);
	p7_MFld_LogoHg->Enable(bLgo2);

	p7_Text_AbsnWo->Enable(bAbs1);
	p7_List_AbsnWo->Enable(bAbs1);

	p7_Text_AbsnWd->Enable(bAbs2);
	p7_MFld_AbsnWd->Enable(bAbs2);
	p7_Text_AbsnHg->Enable(bAbs2);
	p7_MFld_AbsnHg->Enable(bAbs2);
}

void LetterDialog::SetLogoAbsnPrnDisable()
{
	const BOOL bLgo1=aPage1.aLogo.IsVisible();
	const BOOL bAbs1=aPage1.aAbsn.IsVisible();
	p9_Text_LgoPrn->Enable(bLgo1);
	p9_List_LgoPrn->Enable(bLgo1);
	p9_Text_AbsPrn->Enable(bAbs1);
	p9_List_AbsPrn->Enable(bAbs1);
}

////////////////////////////////////////////////////////////////////////////////
//
// @@  @@ @@     @@@@@ @@  @@ @@@@@ @@    @@    @@  @@ @@  @@  @@@@
// @@  @@ @@     @@    @@  @@ @@    @@    @@    @@  @@ @@@ @@ @@  @@
// @@  @@ @@     @@    @@  @@ @@    @@    @@    @@  @@ @@@@@@ @@
// @@  @@ @@ @@@ @@@@  @@  @@ @@@@  @@    @@    @@  @@ @@@@@@ @@ @@@
// @@  @@ @@     @@    @@  @@ @@    @@    @@    @@  @@ @@ @@@ @@  @@
// @@  @@ @@     @@    @@  @@ @@    @@    @@    @@  @@ @@  @@ @@  @@
//  @@@@  @@     @@     @@@@  @@@@@ @@@@@ @@@@@  @@@@  @@  @@  @@@@@
//
////////////////////////////////////////////////////////////////////////////////

void LetterDialog::InitElemUI()
{
	// Datumslistbox fuellen
	FillFldListBox( a5_List_Datum, TYP_FIXDATEFLD );

	// PageNumberslistbox fuellen
	FillFldListBox( a5_List_PagNum, TYP_PAGENUMBERFLD );
	// wir brauchen aber nur die von 1..5 (Chars L/U, Roem. L/U, SVX_NUM_Arabic)
	while( 7 < a5_List_PagNum.GetEntryCount() )
		a5_List_PagNum.RemoveEntry( 7 );
}

void LetterDialog::InitFinaUI()
{
	// Druckerschaechte ermitteln
#ifndef NO_PAPERBIN
	p9_List_TrayS1->Clear();
	p9_List_TrayFF->Clear();

	Printer *pPrn;

	if (!pPrinter)
		pPrn = new Printer;
	else
		pPrn = pPrinter;

	USHORT nAnz = pPrn->GetPaperBinCount();
	USHORT i;

	for (i = 0; i < nAnz; i++)
	{
		String aNam(pPrn->GetPaperBinName(i));
		p9_List_TrayS1->InsertEntry(aNam);
		p9_List_TrayFF->InsertEntry(aNam);
	}
	if (!pPrinter)
		delete pPrn;
#endif
}

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////

void LetterDialog::FillDocInfoList()
{
	pDoku->MerkDocInfListSel();
	if (!a1_RBtn_PrvBrf.IsChecked())
	{
		USHORT nAnz=aEmpf.GetDBFieldAnz();
		pDoku->SetDBFieldAnz(nAnz);
		USHORT i,j;
		String aStr;
		for (i=0; i<nAnz; i++)
		{
			aStr=aEmpf.GetDBFieldNam(i);
			pDoku->SetDBFieldNam(i,aStr);
		}
		nAnz=0;
		for (i=0; i<5; i++)
			if (GetDocInfStrOk(i)) nAnz++;
		pDoku->SetTxFieldAnz(nAnz);
		j=0;
		for (i=0; i<5; i++) {
			if (GetDocInfStrOk(i))  {
				aStr=GetDocInfStr(i);
				pDoku->SetTxFieldNam(j,aStr);
				j++;
			}
		}
	} else {
		pDoku->SetDBFieldAnz(0); // Keine Datenbank beim Privatbrief
		pDoku->SetTxFieldAnz(0); // und auch keine Elemente
	}
	pDoku->RestDocInfListSel();
}

String LetterDialog::GetDocInfStr(USHORT nNum)
{
	Edit* pEd = 0;
	USHORT nRId;
	switch( nNum )
	{
	case 0: pEd = &a5_Edit_Elem1;	nRId = STR_Brf_DocInEl1; break;
	case 1: pEd = &a5_Edit_Elem2;	nRId = STR_Brf_DocInEl2; break;
	case 2: pEd = &a5_Edit_Elem3;	nRId = STR_Brf_DocInEl3; break;
	case 3: pEd = &a5_Edit_Elem4;	nRId = STR_Brf_DocInEl4; break;
	case 4: pEd = &a5_Edit_Betref;	nRId = STR_Brf_DocInBtr; break;
	}

	String aStr;
	if( pEd )
	{
		aStr = pEd->GetText();
		if( !aStr.Len() || !aStr.EraseTrailingChars().Len() )
			aStr = SW_RESSTR( nRId );
	}
	return aStr;
}

BOOL LetterDialog::GetDocInfStrOk(USHORT nNum)
{
	if (!a1_RBtn_PrvBrf.IsChecked()) { // nur beim Geschaeftsbrief
		BOOL bVisi=FALSE;
//      BOOL bEmpt;
		if (nNum<4) bVisi=aPage1.aElem.IsVisible(nNum);
		if (nNum==4) bVisi=aPage1.aBetr.IsVisible();
//      bEmpt=(GetDocInfStr(nNum).Len()==0);
		return bVisi /*&& !bEmpt*/;
	} else {
		return FALSE;
	}
}

BOOL LetterDialog::GetDocInfoGoDown(USHORT nNum)
{
	BOOL bRet;
	if( pDoku->IsDocInfoTxFeld( nNum ) && ( !GetDocInfStrOk( 4 ) ||
		nNum != (pDoku->GetTxFieldOfs() + pDoku->GetTxFieldAnz() - 1 ) ))
	{
		// Betreff ist das letzte der Elemente
		bRet = TRUE; // nur bei Betreff kein GoDown
	}
	else
		bRet = FALSE;
	return bRet;
}

void LetterDialog::AbsnToUI()
{
	a3_MEdt_AbsInp.SetText(aPage1.aAbsn.GetStr());
}

void LetterDialog::Absn1ToUI()
{
	a3_MFld_AbsnWd.SetValue(aPage1.aAbsn.GetWdt(), FUNIT_CM);
	a3_MFld_AbsnHg.SetValue(aPage1.aAbsn.GetHgt(), FUNIT_CM);
	a3_MFld_AbsnHo.SetValue(aPage1.aAbsn.GetHor(), FUNIT_CM);
	a3_MFld_AbsnVe.SetValue(aPage1.aAbsn.GetVer(), FUNIT_CM);
}

void LetterDialog::EmpfToUI()
{
	if( aPage1.aEmpf.IsAbsnShown() )
		a3_RBtn_WdhJaa.Check(TRUE);
	else
		a3_RBtn_WdhNee.Check(TRUE);
}

void LetterDialog::ElemToUI()
{
	a5_CBox_Elem1.Check(aPage1.aElem.IsVisible(0));
	a5_CBox_Elem2.Check(aPage1.aElem.IsVisible(1));
	a5_CBox_Elem3.Check(aPage1.aElem.IsVisible(2));
	a5_CBox_Elem4.Check(aPage1.aElem.IsVisible(3));
	a5_CBox_Datum.Check(aPage1.aElem.IsVisible(4));
	a5_CBox_Betref.Check(aPage1.aBetr.IsVisible());
}

void LetterDialog::PgNumToUI()
{
	a5_CBox_PagNum.Check(aPage1.aFusz.IsPgNum());
	a5_Edit_PagNum.SetText(aPage1.aFusz.GetPgNumStr());

	USHORT nFmt = aPage1.aFusz.GetPgNumFmt();
	for (USHORT i = 0; i < a5_List_PagNum.GetEntryCount(); i++)
	{
		if (nFmt == (USHORT)(ULONG)a5_List_PagNum.GetEntryData(i))
		{
			a5_List_PagNum.SelectEntryPos(i);
			break;
		}
	}

	a5_CBox_PagGes.Check(aPage1.aFusz.IsPgNumGes());
	a5_Edit_PagGes.SetText(aPage1.aFusz.GetPgNumGesStr());
}

/*
void LetterDialog::Fusz1ToUI()
{
	a6_CBox_FussAn.Check(aPage1.aFusz.IsVisible());
	a6_CBox_TrennL.Check(aPage1.aFusz.IsTrennlinie());
	a6_MFld_VonUnt.SetValue(aPage1.aFusz.GetVer(), FUNIT_CM);
	a6_MFld_ZumTxt.SetValue(aPage1.aFusz.GetTextDst(), FUNIT_CM);
}*/

/*void LetterDialog::RandToUI()
{
	a6_MFld_VonLks.SetValue(aPage1.RandL, FUNIT_CM);
	a6_MFld_VonRts.SetValue(aPage1.RandR, FUNIT_CM);
}*/

void LetterDialog::LogoFToUI()
{
	p7_MFld_LogoWd->SetValue(aPageF.aKopz.GetLogoWdt(), FUNIT_CM);
	p7_MFld_LogoHg->SetValue(aPageF.aKopz.GetLogoHgt(), FUNIT_CM);

	USHORT nPos = 0;
	if( aPageF.aKopz.LogoIsVisible() )
		switch( aPageF.aKopz.GetLogoAlign() )
		{
		case ALIGN_LiOb: nPos = 1; break;
		case ALIGN_MiOb: nPos = 2; break;
		case ALIGN_ReOb: nPos = 3; break;
		}

	p7_List_LogoWo->SelectEntryPos( nPos );
}

void LetterDialog::AbsnFToUI()
{
	p7_MFld_AbsnWd->SetValue( aPageF.aKopz.GetAbsnWdt(), FUNIT_CM );
	p7_MFld_AbsnHg->SetValue( aPageF.aKopz.GetAbsnHgt(), FUNIT_CM );

	USHORT nPos = 0;
	if( aPageF.aKopz.AbsnIsVisible() )
		switch (aPageF.aKopz.GetAbsnAlign())
		{
		case ALIGN_LiOb: nPos = 1; break;
		case ALIGN_MiOb: nPos = 2; break;
		case ALIGN_ReOb: nPos = 3; break;
		}

	p7_List_AbsnWo->SelectEntryPos( nPos );
}

void LetterDialog::KopzFToUI()
{
	p7_MFld_KLinOb->SetValue(aPageF.aKopz.GetVer(), FUNIT_CM);
	p7_MFld_KLinTx->SetValue(aPageF.aKopz.GetTextDst(), FUNIT_CM);
}

void LetterDialog::FuszFToUI()
{
	p7_CBox_FusAnz->Check(aPageF.aFusz.IsVisible());
	p7_MFld_FLinOb->SetValue(aPageF.aFusz.GetVer(), FUNIT_CM);
	p7_MFld_FLinTx->SetValue(aPageF.aFusz.GetTextDst(), FUNIT_CM);
}

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

void LetterDialog::SetEventHandler()
{
	Link aLk = LINK(this,LetterDialog,StyleClickHdl);
	a1_RBtn_Stil1.SetClickHdl ( aLk );
	a1_RBtn_Stil2.SetClickHdl ( aLk );
	a1_RBtn_Stil3.SetClickHdl ( aLk );

	aLk = LINK(this,LetterDialog,PrivRadioClickHdl);
	a1_RBtn_GesBrf.SetClickHdl( aLk );
	a1_RBtn_PrvBrf.SetClickHdl( aLk );

	aLk = LINK(this,LetterDialog,LogoBBtnHdl);
	aLogo.pL_BBtn_LogoLi->SetClickHdl( aLk );
	aLogo.pL_BBtn_LogoMi->SetClickHdl( aLk );
	aLogo.pL_BBtn_LogoRe->SetClickHdl( aLk );

	aLk = LINK(this,LetterDialog,LogoMFldHdl);
	aLogo.pL_MFld_LogoWd->SetModifyHdl( aLk );
	aLogo.pL_MFld_LogoHg->SetModifyHdl( aLk );
	aLogo.pL_MFld_LogoHo->SetModifyHdl( aLk );
	aLogo.pL_MFld_LogoVe->SetModifyHdl( aLk );

	aLk = LINK(this,LetterDialog,LogoRBtnHdl);
	aLogo.pL_RBtn_NoLogo->SetClickHdl( aLk );
	aLogo.pL_RBtn_GrLogo->SetClickHdl( aLk );
	aLogo.pL_RBtn_TxLogo->SetClickHdl( aLk );

	a3_MEdt_AbsInp.SetModifyHdl(LINK(this,LetterDialog,EditModifyHdl));
	a3_Btn_LoadAdr.SetClickHdl(LINK(this, LetterDialog, UpdateAdressHdl));

	aLk = LINK(this,LetterDialog,AbsnBBtnHdl);
	a3_BBtn_AbsnOL.SetClickHdl( aLk );
	a3_BBtn_AbsnOR.SetClickHdl( aLk );
	a3_BBtn_AbsnUL.SetClickHdl( aLk );
	a3_BBtn_AbsnUR.SetClickHdl( aLk );
	a3_BBtn_AbsnMi.SetClickHdl( aLk );

	{
		aLk = LINK(this,LetterDialog,AbsnMFldHdl);
		a3_MFld_AbsnWd.SetModifyHdl( aLk );
		a3_MFld_AbsnHg.SetModifyHdl( aLk );
		a3_MFld_AbsnHo.SetModifyHdl( aLk );
		a3_MFld_AbsnVe.SetModifyHdl( aLk );

		aLk = LINK(this,LetterDialog,AbsnGschRadioClickHdl);
		a3_RBtn_WdhJaa.SetClickHdl( aLk );
		a3_RBtn_WdhNee.SetClickHdl( aLk );

		aLk = LINK(this,LetterDialog,AbsnPrivRadioClickHdl);
		a3_RBtn_AnzJaa.SetClickHdl( aLk );
		a3_RBtn_AnzNee.SetClickHdl( aLk );
	}
	{
		aLk = LINK(this,LetterDialog,ElemCheckClickHdl);
		a5_CBox_Elem1.SetClickHdl( aLk );
		a5_CBox_Elem2.SetClickHdl( aLk );
		a5_CBox_Elem3.SetClickHdl( aLk );
		a5_CBox_Elem4.SetClickHdl( aLk );
		a5_CBox_Datum.SetClickHdl( aLk );
		a5_CBox_Betref.SetClickHdl( aLk );

		aLk = LINK(this,LetterDialog,PNumCheckClickHdl);
		a5_CBox_PagNum.SetClickHdl( aLk );
		a5_CBox_PagGes.SetClickHdl( aLk );

		aLk = LINK(this,LetterDialog,PNumModifyHdl);
		a5_Edit_PagGes.SetModifyHdl( aLk );
		a5_Edit_PagNum.SetModifyHdl( aLk );

		a5_List_PagNum.SetSelectHdl(LINK(this,LetterDialog,PNumSelectHdl));

		aLk = LINK(this,LetterDialog,ElemModifyHdl);
		a5_Edit_Elem1 .SetModifyHdl( aLk );
		a5_Edit_Elem2 .SetModifyHdl( aLk );
		a5_Edit_Elem3 .SetModifyHdl( aLk );
		a5_Edit_Elem4 .SetModifyHdl( aLk );
		a5_Edit_Betref.SetModifyHdl( aLk );
	}

	{
		aEmpf.pE_List_DBase->SetSelectHdl(LINK(this,LetterDialog,EmpfDBasListHdl)); // Meine eigenen Handler
		pFusz->pF_MEdt_FusZei->SetModifyHdl(LINK(this,LetterDialog,Fuss1ModifyHdl));

		aLk = LINK(this,LetterDialog,Fuss1CheckClickHdl);
		pFusz->pF_CBox_FussAn->SetClickHdl( aLk );
		pFusz->pF_CBox_TrennL->SetClickHdl( aLk );

		aLk = LINK(this,LetterDialog,RandMetrcModifyHdl);
		pMarg->pM_MFld_VonLks->SetModifyHdl( aLk );
		pMarg->pM_MFld_VonRts->SetModifyHdl( aLk );
	}
	{
		p7_CBox_FusAnz->SetClickHdl(LINK(this,LetterDialog,FussFCheckClickHdl));

		aLk = LINK(this,LetterDialog,FussFMetrModifyHdl);
		p7_MFld_FLinOb->SetModifyHdl( aLk );
		p7_MFld_FLinTx->SetModifyHdl( aLk );

		aLk = LINK(this,LetterDialog,KopzFMetrModifyHdl);
		p7_MFld_KLinOb->SetModifyHdl( aLk );
		p7_MFld_KLinTx->SetModifyHdl( aLk );
		p7_MFld_LogoWd->SetModifyHdl( aLk );
		p7_MFld_LogoHg->SetModifyHdl( aLk );
		p7_MFld_AbsnWd->SetModifyHdl( aLk );
		p7_MFld_AbsnHg->SetModifyHdl( aLk );

		aLk = LINK(this,LetterDialog,KopzFListSelectHdl);
		p7_List_LogoWo->SetSelectHdl( aLk );
		p7_List_AbsnWo->SetSelectHdl( aLk );

		p9_Btn_PrSetup->SetClickHdl( LINK(this,LetterDialog,SelPrtHdl) );
	}
}

////////////////////////////////////////////////////////////////////////////////
//
// @@  @@ @@ @@@@@  @@@@@@ @@  @@ @@@@@ @@   @@
// @@  @@ @@ @@  @@   @@   @@  @@ @@    @@   @@
// @@  @@ @@ @@  @@   @@   @@  @@ @@    @@   @@
// @@@@@@ @@ @@@@@    @@   @@  @@ @@@@  @@   @@
//  @@@@  @@ @@  @@   @@   @@  @@ @@    @@   @@
//  @@@@  @@ @@  @@   @@   @@  @@ @@    @@   @@
//   @@   @@ @@  @@   @@    @@@@  @@@@@ @@@@ @@@@
//
////////////////////////////////////////////////////////////////////////////////

BOOL LetterDialog::Possible(USHORT StepNum)
{
	if (a1_RBtn_PrvBrf.IsChecked()) {
		if (StepNum==3 || StepNum==4) return FALSE;
	}
	return(TRUE);
}

void LetterDialog::Enter(USHORT StepNum)
{
	if (StepNum==8) aPrevWin.Hide(); // Fuer die Fahne
	if (StepNum==6) aPrevWin.SetPage(&aPageF);
}

void LetterDialog::Leave(USHORT StepNum)
{
	if (StepNum==8) aPrevWin.Show(); // Fuer die Fahne
	if (StepNum==6) aPrevWin.SetPage(&aPage1);
}

void LetterDialog::Fill(USHORT StepNum, MultiOne& WinArr)
{
	switch (StepNum) {
		case 0: {
			WinArr.AddWin(&a1_Text_BrfArt);
			WinArr.AddWin(&a1_RBtn_GesBrf, TRUE);
			WinArr.AddWin(&a1_RBtn_PrvBrf, TRUE);
			WinArr.AddWin(&a1_Text_Stil  );
			WinArr.AddWin(&a1_RBtn_Stil1, TRUE );
			WinArr.AddWin(&a1_RBtn_Stil2, TRUE );
			WinArr.AddWin(&a1_RBtn_Stil3, TRUE );
			WinArr.SetHelpId( HID_LETTER_PAGE1 );
		} break;
		case 1: {
			aLogo.Fill(WinArr);
			WinArr.SetHelpId( HID_LETTER_PAGE2 );
		} break;
		case 2: {
			WinArr.AddWin(&a3_Text_AbsInp);
			WinArr.AddWin(&a3_MEdt_AbsInp, TRUE);
			WinArr.AddWin(&a3_Btn_LoadAdr);
			WinArr.AddWin(&a3_Text_AbsWdh);
			WinArr.AddWin(&a3_RBtn_WdhJaa, TRUE);
			WinArr.AddWin(&a3_RBtn_WdhNee, TRUE);
			WinArr.AddWin(&a3_Text_AbsAnz);
			WinArr.AddWin(&a3_RBtn_AnzJaa, TRUE);
			WinArr.AddWin(&a3_RBtn_AnzNee, TRUE);
			WinArr.AddWin(&a3_BBtn_AbsnOL, TRUE);
			WinArr.AddWin(&a3_BBtn_AbsnOR, TRUE);
			WinArr.AddWin(&a3_BBtn_AbsnUL, TRUE);
			WinArr.AddWin(&a3_BBtn_AbsnUR, TRUE);
			WinArr.AddWin(&a3_BBtn_AbsnMi, TRUE);
			WinArr.AddWin(&a3_Text_AbsnHo);
			WinArr.AddWin(&a3_MFld_AbsnHo, TRUE);
			WinArr.AddWin(&a3_Text_AbsnVe);
			WinArr.AddWin(&a3_MFld_AbsnVe, TRUE);
			WinArr.AddWin(&a3_Text_AbsnWd);
			WinArr.AddWin(&a3_MFld_AbsnWd, TRUE);
			WinArr.AddWin(&a3_Text_AbsnHg);
			WinArr.AddWin(&a3_MFld_AbsnHg, TRUE);
            WinArr.AddWin(&a3_FL_AbsPos,FALSE,TRUE);
			WinArr.SetHelpId( HID_LETTER_PAGE3 );
		} break;
		case 3: {
			aEmpf.Fill(WinArr);
			WinArr.SetHelpId( HID_LETTER_PAGE4 );
		} break;
		case 4: {
			WinArr.AddWin(&a5_Text_Welche);
			WinArr.AddWin(&a5_CBox_Elem1, TRUE );
			WinArr.AddWin(&a5_Edit_Elem1, TRUE );
			WinArr.AddWin(&a5_CBox_Elem2, TRUE );
			WinArr.AddWin(&a5_Edit_Elem2, TRUE );
			WinArr.AddWin(&a5_CBox_Elem3, TRUE );
			WinArr.AddWin(&a5_Edit_Elem3, TRUE );
			WinArr.AddWin(&a5_CBox_Elem4, TRUE );
			WinArr.AddWin(&a5_Edit_Elem4, TRUE );
			WinArr.AddWin(&a5_CBox_Datum, TRUE );
			WinArr.AddWin(&a5_List_Datum, TRUE );
			WinArr.AddWin(&a5_CBox_Betref, TRUE);
			WinArr.AddWin(&a5_Edit_Betref, TRUE);
			WinArr.AddWin(&a5_CBox_KopiAn, TRUE);
			WinArr.AddWin(&a5_CBox_Anlagn, TRUE);
			WinArr.AddWin(&a5_CBox_PagNum, TRUE);
			WinArr.AddWin(&a5_Edit_PagNum, TRUE);
			WinArr.AddWin(&a5_List_PagNum, TRUE);
			WinArr.AddWin(&a5_CBox_PagGes, TRUE);
			WinArr.AddWin(&a5_Edit_PagGes, TRUE);
			WinArr.SetHelpId( HID_LETTER_PAGE5 );
		} break;
		case 5: {
			pFusz->Fill(WinArr);
			pMarg->Fill(WinArr);
			WinArr.SetHelpId( HID_LETTER_PAGE6 );
		} break;
		case 6: {
			WinArr.AddWin(p7_Text_FolgPg);
			WinArr.AddWin(p7_Text_KLinOb);
			WinArr.AddWin(p7_MFld_KLinOb, TRUE);
			WinArr.AddWin(p7_Text_KLinTx);
			WinArr.AddWin(p7_MFld_KLinTx, TRUE);
			WinArr.AddWin(p7_Text_LogoWo);
			WinArr.AddWin(p7_List_LogoWo, TRUE);
			WinArr.AddWin(p7_Text_LogoWd);
			WinArr.AddWin(p7_MFld_LogoWd, TRUE);
			WinArr.AddWin(p7_Text_LogoHg);
			WinArr.AddWin(p7_MFld_LogoHg, TRUE);
			WinArr.AddWin(p7_Text_AbsnWo);
			WinArr.AddWin(p7_List_AbsnWo, TRUE);
			WinArr.AddWin(p7_Text_AbsnWd);
			WinArr.AddWin(p7_MFld_AbsnWd, TRUE);
			WinArr.AddWin(p7_Text_AbsnHg);
			WinArr.AddWin(p7_MFld_AbsnHg, TRUE);
            WinArr.AddWin(p7_FL_KopLin,FALSE,TRUE);
			WinArr.AddWin(p7_CBox_FusAnz, TRUE);
			WinArr.AddWin(p7_Text_FLinOb);
			WinArr.AddWin(p7_MFld_FLinOb, TRUE);
			WinArr.AddWin(p7_Text_FLinTx);
			WinArr.AddWin(p7_MFld_FLinTx, TRUE);
            WinArr.AddWin(p7_FL_FusLin,FALSE,TRUE);
			WinArr.SetHelpId( HID_LETTER_PAGE7 );
		} break;
		case 7: {
			pDoku->Fill(WinArr);
			WinArr.SetHelpId( HID_LETTER_PAGE8 );
		} break;
		case 8: {
			WinArr.AddWin(p9_BMap_Fahne );
			WinArr.AddWin(p9_Text_WanPrn);
			WinArr.AddWin(p9_Text_LgoPrn);
			WinArr.AddWin(p9_List_LgoPrn, TRUE);
			WinArr.AddWin(p9_Text_AbsPrn);
			WinArr.AddWin(p9_List_AbsPrn, TRUE);
			WinArr.AddWin(p9_Text_Tip   );
			WinArr.AddWin(p9_Text_TipPrn);
#ifndef NO_PAPERBIN
			WinArr.AddWin(p9_Text_PrTray);
			WinArr.AddWin(p9_Text_TrayS1);
			WinArr.AddWin(p9_List_TrayS1, TRUE);
			WinArr.AddWin(p9_Text_TrayFF);
			WinArr.AddWin(p9_List_TrayFF, TRUE);
#endif
            WinArr.AddWin(p9_FL_Prn, FALSE, TRUE);
			WinArr.AddWin(p9_Btn_PrSetup, TRUE);
			WinArr.AddWin(p9_Text_PrName);

			WinArr.SetHelpId( HID_LETTER_PAGE9 );
		} break;
		case 0xFFFF: {
			FillDefElems(WinArr); // Defaultelemente (Buttons, PrevWin)
		} break;
	}
}

