/*************************************************************************
 *
 *  $RCSfile: sample.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:01:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "so2.hxx"

#pragma hdrstop

#include <svtool.hxx>
#include <sfx.hrc>
#include "sample.hrc"
#include "dialogs.hrc"

#define ITEMID_ULSPACE SID_PAGE_MARGIN
#define ITEMID_LRSPACE SID_PAGE_MARGIN2
#define ITEMID_TABSTOP SID_ATTR_TABSTOP
#define ITEMID_FONTLIST SID_ATTR_CHAR_FONT
#define ITEMID_FONTHEIGHT 2
#define ITEMID_FONT 3
#define ITEMID_SIZE SID_ATTR_SIZE

#include <sfx.hxx>
#include <sfxdlg.hxx>
#include "svxitems.hxx"
#include "sample.hxx"
#include "mnuctrls.hxx"
#include "tbxctrls.hxx"
#include "stbctrls.hxx"

DBG_NAME(TestView);

#ifdef DEBUGLIN

inline long ToMM(Window *pWin, long lVal)
{
	return pWin->PixelToLogic(Size(lVal, 0), MapMode(MAP_MM)).Width();
}

static void Debug(Window *pWin, SvxObjectItem& rItem)
{
	String aTmp("StartX: ");
	aTmp +=  String(ToMM(pWin, rItem.GetStartX()));
	aTmp += "   EndX: ";
	aTmp +=  String(ToMM(pWin, rItem.GetEndX()));
	aTmp +=  " StartY: ";
	aTmp +=  String(ToMM(pWin, rItem.GetStartY()));
	aTmp += "   EndY: ";
	aTmp +=  String(ToMM(pWin, rItem.GetEndY()));

	InfoBox(0, aTmp).Execute();
}

static void Debug(Window *pWin, const SvxLRSpaceItem& rLRSpace)
{
	String aTmp("Left: ");
	aTmp += pWin->PixelToLogic(Size(rLRSpace.GetLeft(), 0), MapMode(MAP_MM)).Width();
	aTmp += "   Right: ";
	aTmp +=pWin->PixelToLogic(Size(rLRSpace.GetRight(), 0), MapMode(MAP_MM)).Width();
	InfoBox(0, aTmp).Execute();
}


#endif

#ifdef WNT

extern "C" {
	void StartCAP();
	void StopCAP();
	void DumpCAP();
};

#endif


//==================================================================

Example aExample;

// -----------------------------------------------------------------------


#define ShellClass Example
SFX_SLOTMAP(Example)
{
	SFX_SLOT( SID_ATTR_SPELL, GID_OPT,
					Execute, GetState, SFX_SLOT_CACHABLE, SfxVoidItem )
};
#undef ShellClass

SFX_IMPL_INTERFACE(Example,SfxApplication, RID_APPTITLE)
{
}

//==================================================================

Example::Example():
	SfxApplication( 0 )
{
	ChangeAppName( "Sample" );
}

//------------------------------------------------------------------

Example::~Example()
{
}

//------------------------------------------------------------------

void Example::Execute( SfxRequest& rReq )
{
	switch ( rReq.GetSlot() )
	{
		case SID_ATTR_SPELL:
			//!
			break;
	}
}

void Example::GetState(SfxItemSet &rSet)
{
	SfxWhichIter aIter(rSet);
	USHORT nWhich = aIter.FirstWhich();
	while(nWhich) {
		switch ( nWhich ) {
		}
		nWhich = aIter.NextWhich();
	}
}

StatusBar* Example::CreateStatusBar()
{
	// This virtual function becomes called from the SFx to create the
	// main status bar.

	StatusBar* pStatusBar = new StatusBar(GetAppWindow(), WinBits(WB_BORDER|WB_SVLOOK) );
	pStatusBar->InsertItem( SID_CONTEXT, pStatusBar->GetTextSize(
		String().Fill( 64, 'x' ) ).Width() );
	pStatusBar->InsertItem( SID_MOUSEPOS, pStatusBar->GetTextSize(
		String("9999:9999") ).Width() );
	pStatusBar->InsertItem( SID_CURRENTTIME, pStatusBar->GetTextSize(
		String("::") + pApp->GetAppInternational().GetTime( Time() ) ).Width() );
	pStatusBar->InsertItem( SID_CURRENTDATE, pStatusBar->GetTextSize(
		String("::") + pApp->GetAppInternational().GetDate( Date() ) ).Width() );

	pStatusBar->InsertItem( SID_ATTR_INSERT, pStatusBar->GetTextSize(
		String("XXXX") ).Width() );
	pStatusBar->InsertItem( SID_ATTR_ZOOM, pStatusBar->GetTextSize(
		String("200%") ).Width() );
	pStatusBar->InsertItem( SID_ATTR_SIZE, pStatusBar->GetTextSize(
		String().Fill( 25, 'x' ) ).Width() );
	return pStatusBar;
}

//------------------------------------------------------------------

void Example::Init( int nArgs, char* pArgs[] )
{
	// This virtual function will be called from the SFx to initialize the
	// application. It is called from Application::Main(), though you can
	// create StarView objects. The Application Window does exist, but
	// isn't visible. No controller does exist and the configuration isn't
	// loaded.

	ChangeAppName( "Sample" );

	Example::RegisterInterface();

	TestDoc::RegisterFactory(1);
	TestDoc::RegisterInterface();

	TestView::RegisterFactory(1);
	TestView::RegisterInterface();

	SvxTableToolBoxControl::RegisterControl( SID_ATTR_TABLE );
	SvxColumnsToolBoxControl::RegisterControl( SID_ATTR_COLUMNS );

	SvxFontMenuControl::RegisterControl();
	SvxFontSizeMenuControl::RegisterControl( SID_ATTR_CHAR_FONTHEIGHT );

	SvxInsertStatusBarControl::RegisterControl( SID_ATTR_INSERT );
	SvxZoomStatusBarControl::RegisterControl( SID_ATTR_ZOOM );
	SvxPosSizeStatusBarControl::RegisterControl( SID_ATTR_SIZE );
}

//------------------------------------------------------------------

void Example::Main( int nArgs, char* pArgs[] )
{
	ChangeAppName("Peter");

	SvxDialogDll	aSvxDll;

	SfxApplication::Main(nArgs, pArgs);
}

//------------------------------------------------------------------

void Example::Exit()
{
	// This virtual function becomes called from the SFx to deinitialize
	// the appication. It is called from Application::Main() after
	// Application::Execute(). The Application Window does exist, but
	// isn't visible. All Controllers, Documents and Views are destroyed
	// and the configuration is already stored.


#ifdef WNT
	StopCAP();
	DumpCAP();
#endif
}


class TestItemPool: public SfxItemPool
{
	SfxPoolItem         **ppPoolDefaults;

public:
						TestItemPool();
						~TestItemPool();
};


TestItemPool::TestItemPool():
	SfxItemPool( "SvxTest", ATR_START, ATR_END, 0 )
{
//     ppPoolDefaults = new SfxPoolItem*[4];
//     ppPoolDefaults[0] = &aDefaultAlign;
//     ppPoolDefaults[1] = &aDefaultBold;
//     ppPoolDefaults[2] = new TestAttrib( *this );
//     ppPoolDefaults[3] = &aDefaultPrinterWarn;
//     SetDefaults( ppPoolDefaults );
}

TestItemPool::~TestItemPool()
{
//     SetRef( *ppPoolDefaults[2], 0 );
//     delete ppPoolDefaults[2];
//     delete ppPoolDefaults;
}

SFX_IMPL_DOCUMENTFACTORY( TestDoc, Sample,
	0xBB0D2801L,0x73EE,0x101B, 0x80,0x4C,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD )
{
	const ULONG lStd = Clipboard::RegisterFormatName("Sfx TestDokument");
	SFX_FILTER_REGISTRATION( "Sfx Test-Document", "*.tst",
							SfxFilter::OWN_FORMAT, lStd, 0x00000000L,
							"Sfx Dokument", 0, "" );
}

void TestDoc::Init()
{
	eViewType = VIEW_STD;

	pLRSpaceItem = new 	SvxLRSpaceItem(SID_ATTR_LRSPACE);
	pLRSpaceItem->SetLeft(50);
	pLRSpaceItem->SetRight(50);

	pULSpaceItem = new SvxULSpaceItem(SID_ATTR_ULSPACE);
	pULSpaceItem->SetUpper(70);
	pULSpaceItem->SetLower(70);

	// pPagePosItem = new SvxPagePosSizeItem(0, 5600);

	pParaItem = new  SvxLRSpaceItem(SID_ATTR_PARA_LRSPACE);
	pParaItem->SetLeft(15);
	pParaItem->SetRight(10);
	pParaItem->SetTxtFirstLineOfst(-5);

	pTabStopItem = new SvxTabStopItem(0, 50);
	pTabStopItem->Insert(SvxTabStop(45));
	pTabStopItem->Insert(SvxTabStop(75));
	pTabStopItem->Insert(SvxTabStop(155));

	pObjectItem = new SvxObjectItem(75, 85, 85, 100);

	InitColumns();
	InitTable();

	FontList *pFontList = new FontList(pApp->GetAppWindow());
	SvxFontListItem aFonts(pFontList);
	PutItem(aFonts);
}

void TestDoc::InitColumns()
{
	delete pColumnItem;
	pColumnItem = new SvxColumnItem(1);
	SvxColumnDescription aCols;
	aCols.nStart = 0;
	aCols.nEnd = 90;
	pColumnItem->Append(aCols);
	aCols.nStart = 100;
	aCols.nEnd = 170;
	pColumnItem->Append(aCols);
	aCols.nStart = 200;
	aCols.nEnd = 0xffff;
	pColumnItem->Append(aCols);
}

void TestDoc::InitTable()
{
	delete pTableItem;
	pTableItem = new SvxColumnItem(0,50,50);
	SvxColumnDescription aCols;
	aCols.nStart = 0;
	aCols.nEnd = 150;
	pTableItem->Append(aCols);
	aCols.nStart = 150;
	aCols.nEnd = 400;
	pTableItem->Append(aCols);

	delete pVTableItem;
	pVTableItem = new SvxColumnItem(0,20,20);
	aCols.nStart = 0;
	aCols.nEnd = 80;
	pVTableItem->Append(aCols);
	aCols.nStart = 80;
	aCols.nEnd = 120;
	pVTableItem->Append(aCols);
}

void TestDoc::SetViewType(int eType)
{
	eViewType = eType;
	switch(eViewType) {
	case VIEW_STD:

		break;
	case VIEW_COLUMNS:
		break;
	case VIEW_TABLE:
		break;
	}
	SFX_BINDINGS().Invalidate(SID_ATTR_LRSPACE);
	SFX_BINDINGS().Invalidate(SID_ATTR_TABSTOP);
	SFX_BINDINGS().Invalidate(SID_ATTR_PARA_LRSPACE);
	SFX_BINDINGS().Invalidate(SID_RULER_BORDERS);
	SFX_BINDINGS().Invalidate(SID_RULER_OBJECT);
}



TestDoc::TestDoc(SfxShellCreateMode eMode) :
	SfxDocumentShell(eMode),
  pLRSpaceItem(0),
  pULSpaceItem(0),
  pTabStopItem(0),
  pParaItem(0),
  pPagePosItem(0),
  pColumnItem(0),
  pObjectItem(0),
  pTableItem(0),
  pVTableItem(0),
  pPool(0),

	nZoom	( 100 ),
	nUser	( 0 ),
	bInsert	( TRUE ),
	aPos	( 10, 25 ),
	aSize	( 120, 150 )

{
	SetShell( this ); // unbedingt setzen, fuer InPlace-Editing
	Init();

	SetPool(pPool = new TestItemPool);
}


//------------------------------------------------------------------
TestDoc::~TestDoc()
{
	delete pLRSpaceItem; pLRSpaceItem = 0;
	delete pULSpaceItem; pULSpaceItem = 0;
	delete pTabStopItem; pTabStopItem = 0;
	delete pParaItem; pParaItem = 0;
	delete pPagePosItem; pPagePosItem = 0;
	delete pColumnItem; pColumnItem = 0;
	delete pTableItem; pTableItem = 0;
	delete pVTableItem; pVTableItem = 0;
	delete pPool; pPool = 0;
}

void TestDoc::Execute( SfxRequest& rReq )
{
	const SfxItemSet* pArgs = rReq.GetArgs();

	switch ( rReq.GetSlot() )
	{
		case SID_ATTR_LRSPACE:
			delete pLRSpaceItem;
			pLRSpaceItem = new SvxLRSpaceItem( ( (const SvxLRSpaceItem&)rReq.GetArgs()->
									Get(SID_ATTR_LRSPACE)));
#ifdef DEBUGLIN
			Debug((TestView *)SfxViewShell::Current(), *pLRSpaceItem);
#endif
			break;

		case SID_RULER_OBJECT:
			delete pObjectItem;
			pObjectItem =
				new SvxObjectItem(((const SvxObjectItem &)rReq.GetArgs()->
								Get(SID_RULER_OBJECT)));
#ifdef DEBUGLIN
			Debug((TestView *)SfxViewShell::Current(), *pObjectItem);
#endif
			break;

		case SID_ATTR_TABLE: {
			if ( !pArgs )
				InfoBox( SFX_APP()->GetAppWindow(), "hier den Table-Dialog" ).Execute();
			else
			{
				SfxUInt16Item* pCol =
					(SfxUInt16Item*)pArgs->Get( SID_ATTR_TABLE_COLUMN ).Clone();
				SfxUInt16Item* pRow =
					(SfxUInt16Item*)pArgs->Get( SID_ATTR_TABLE_ROW ).Clone();

				String aStr;

				if ( pCol )
				{
					aStr += pCol->GetValueText();
					aStr += ", ";
				}
				if ( pRow )
					aStr += pRow->GetValueText();

				InfoBox( SFX_APP()->GetAppWindow(), aStr ).Execute();
				delete pCol;
				delete pRow;
			}
			break;
		}

		case SID_ATTR_COLUMNS: {
			if ( pArgs )
			{
				SfxUInt16Item* pItem =
					(SfxUInt16Item*)pArgs->Get( SID_ATTR_COLUMNS ).Clone();
				InfoBox( SFX_APP()->GetAppWindow(), pItem->GetValueText() ).Execute();
				delete pItem;
			}
			break;
		}

		case SID_ATTR_INSERT: {
			if ( pArgs )
			{
				SfxBoolItem* pItem =
					(SfxBoolItem*)pArgs->Get( SID_ATTR_INSERT ).Clone();
				InfoBox( SFX_APP()->GetAppWindow(), pItem->GetValueText() ).Execute();
				bInsert = pItem->GetValue();
				delete pItem;
			}
			break;
		}

		case SID_ATTR_ZOOM: {
			if ( pArgs )
			{
				SfxUInt16Item* pItem =
					(SfxUInt16Item*)pArgs->Get( SID_ATTR_ZOOM ).Clone();
				if ( pItem && pItem->GetValue() )
					InfoBox( SFX_APP()->GetAppWindow(), pItem->GetValueText() ).Execute();
				else if ( pItem && !pItem->GetValue() )
				{
					SfxUInt16Item* pUser =
						(SfxUInt16Item*)pArgs->Get( SID_ATTR_ZOOM_USER ).Clone();
					if ( pUser )
						InfoBox( SFX_APP()->GetAppWindow(), pUser->GetValueText() ).Execute();
					nUser = pUser->GetValue();
					delete pUser;
				}
				nZoom = pItem->GetValue();
				delete pItem;
			}
			break;
		}
	}
}

void TestDoc::GetState(SfxItemSet &rSet)
{
	rSet.Put(*pLRSpaceItem);
#ifdef DEBUGLIN
	Debug((TestView *)SfxViewShell::Current(), *pLRSpaceItem);
#endif
	rSet.Put(*pULSpaceItem);
	if(VIEW_COLUMNS == eViewType) {
		rSet.Put(*pColumnItem);
	}
	else if(VIEW_TABLE == eViewType) {
		rSet.Put(*pTableItem);
	}
	else {
		rSet.DisableItem(pTableItem->Which());
	}
	if(VIEW_OBJECT == eViewType) {
		rSet.Put(*pObjectItem);
#ifdef DEBUGLIN
		Debug((TestView *)SfxViewShell::Current(), *pObjectItem);
#endif
		rSet.DisableItem(pParaItem->Which());
		rSet.DisableItem(pTabStopItem->Which());
	}
	else {
		rSet.DisableItem(pObjectItem->Which());
		rSet.Put(*pParaItem);
		rSet.Put(*pTabStopItem);
	}
	SvxFontItem  aFont(SID_ATTR_CHAR_FONT);
	aFont.GetFamilyName() = "Courier";
	rSet.Put(aFont);
	rSet.Put(SvxFontHeightItem(240, 100, SID_ATTR_CHAR_FONTHEIGHT));

	rSet.Put( SfxUInt16Item( SID_ATTR_ZOOM, nZoom ) );
	rSet.Put( SfxUInt16Item( SID_ATTR_ZOOM_USER, nUser ) );
	rSet.Put( SfxBoolItem( SID_ATTR_INSERT, bInsert ) );
	rSet.Put( SfxPointItem( SID_ATTR_POSITION, aPos ) );
	rSet.Put( SvxSizeItem( SID_ATTR_SIZE, aSize ) );
}

SfxItemPool &TestDoc::GetPool()
{
	if (!pPool)
	{
		pPool = new TestItemPool;
	}
	return *pPool;
}




#define ShellClass TestDoc
SFX_SLOTMAP(TestDoc)
{
	SFX_SLOT( SID_ATTR_CHAR_FONT, GID_DOC,
					Execute, GetState, 0, SvxFontItem ),
	SFX_SLOT( SID_ATTR_CHAR_FONTHEIGHT, GID_DOC,
					Execute, GetState, 0, SvxFontHeightItem ),
	SFX_SLOT(SID_ATTR_LRSPACE, 0, Execute, GetState, 0, SvxLRSpaceItem),
	SFX_SLOT(SID_ATTR_ULSPACE, 0, Execute, GetState, 0, SvxULSpaceItem),
	SFX_SLOT(SID_ATTR_TABSTOP, 0, Execute, GetState, 0, SvxLRSpaceItem),
	SFX_SLOT(SID_ATTR_PARA_LRSPACE, 0, Execute, GetState, 0, SvxLRSpaceItem),
	SFX_SLOT(SID_RULER_BORDERS, 0, Execute, GetState, 0, SvxColumnItem),
	SFX_SLOT(SID_RULER_OBJECT, 0, Execute, GetState, 0, SvxObjectItem),

	SFX_SLOT(SID_ATTR_TABLE, 0, Execute, GetState, 0, SfxUInt16Item),
	SFX_SLOT(SID_ATTR_COLUMNS, 0, Execute, GetState, 0, SfxUInt16Item),
	SFX_SLOT(SID_ATTR_INSERT, 0, Execute, GetState, 0, SfxBoolItem),
	SFX_SLOT(SID_ATTR_ZOOM, 0, Execute, GetState, 0, SfxUInt16Item),
	SFX_SLOT(SID_ATTR_ZOOM_USER, 0, Execute, GetState, 0, SfxUInt16Item),
	SFX_SLOT(SID_ATTR_POSITION, 0, Execute, GetState, 0, SfxPointItem),
	SFX_SLOT(SID_ATTR_SIZE, 0, Execute, GetState, 0, SvxSizeItem)

//    SFX_SLOT( SID_RULER_PAGE_POS, 0, Execute, GetState, 0, SvxPagePosSizeItem)
};

SFX_IMPL_INTERFACE(TestDoc, SfxDocumentShell, STR_TESTDOC)
{
	SFX_OBJECTBAR_REGISTRATION( 1, RID_DEFAULT_OBJECTBAR );
}
#undef ShellClass


SFX_IMPL_VIEWFACTORY(TestView, STR_DEFAULTVIEW )
{
	SFX_VIEW_REGISTRATION(TestDoc);
}

//------------------------------------------------------------------

void TestView::Paint( const Rectangle& )
{
}

//------------------------------------------------------------------
void	TestView::MenuSelect(Menu *pMenu)
{
	((TestDoc &)GetViewFrame()->GetObjectShell()).
		SetViewType(pMenu->GetCurItemId());
}

void	TestView::MenuActivate(Menu *pMenu)
{
	const int eType =
		((TestDoc &)GetViewFrame()->GetObjectShell()).GetViewType();

	const USHORT nCount = pMenu->GetItemCount();
	for(USHORT i = 0; i < nCount; ++i)
		pMenu->CheckItem(i+1, pMenu->GetItemId(i) == (USHORT)eType);
}

void TestView::Construct()
{
	aMenu.InsertItem( ( USHORT )VIEW_STD, "~Normal", MIB_AUTOCHECK | MIB_RADIOCHECK );
	aMenu.InsertItem( ( USHORT )VIEW_COLUMNS, "~Spalten", MIB_AUTOCHECK | MIB_RADIOCHECK );
	aMenu.InsertItem( ( USHORT )VIEW_TABLE, "~Tabelle", MIB_AUTOCHECK | MIB_RADIOCHECK );
	aMenu.InsertItem( ( USHORT )VIEW_OBJECT, "~Objekt", MIB_AUTOCHECK | MIB_RADIOCHECK );
//    aMenu.PushSelectHdl( LINK( this, TestView, MenuSelect ) );
//    aMenu.PushActivateHdl( LINK( this, TestView, MenuActivate ) );

	Show();
	aRuler.SetWinPos();
	aRuler.Show();
	aVRuler.SetWinPos();
	aVRuler.Show();

//	aRuler.ChangeExtraDownHdl(LINK(this, TestView, ExtraDownHandler));
}

#define ShellClass TestView
SFX_SLOTMAP(TestView)
{
	SFX_SLOT( SID_RULER_PAGE_POS, 0, Execute, GetState, 0, SvxPagePosSizeItem)
};

SFX_IMPL_INTERFACE(TestView, SfxViewShell,STR_DEFAULTVIEW)
{
}

#undef ShellClass
//------------------------------------------------------------------

TestView::TestView( SfxViewFrame *pFrame, const TestView& rWin ):
	SfxViewShell( pFrame, this ),
	Window( &pFrame->GetWindow(), WinBits(WB_BORDER|WB_CLIPCHILDREN) ),
	aRuler(GetParent(), this,
		   SVXRULER_SUPPORT_TABS |
		   SVXRULER_SUPPORT_PARAGRAPH_MARGINS |
		   SVXRULER_SUPPORT_OBJECT |
		   SVXRULER_SUPPORT_SET_NULLOFFSET|
		   SVXRULER_SUPPORT_BORDERS,
		   pFrame->GetBindings(),
		   WB_STDRULER | WB_EXTRAFIELD | WB_SVLOOK | WB_BORDER),
	aVRuler(GetParent(), this,
		   SVXRULER_SUPPORT_SET_NULLOFFSET|
		   SVXRULER_SUPPORT_OBJECT,
		   pFrame->GetBindings(),
		   WB_VSCROLL |  WB_SVLOOK | WB_BORDER)
{
	DBG_CTOR(TestView, 0);

	// Create a view, as a clone to another
	Construct();
}

//------------------------------------------------------------------


TestView::TestView( SfxViewFrame *pFrame, Window *pParent):
	SfxViewShell( pFrame, this ),
	Window( pParent, WinBits(WB_BORDER|WB_CLIPCHILDREN) ),
	bMouseCaptured(FALSE),
	aRuler(pParent, this,
		   SVXRULER_SUPPORT_TABS |
		   SVXRULER_SUPPORT_PARAGRAPH_MARGINS |
		   SVXRULER_SUPPORT_OBJECT |
		   SVXRULER_SUPPORT_SET_NULLOFFSET|
		   SVXRULER_SUPPORT_BORDERS,
		   pFrame->GetBindings(),
		   WB_STDRULER | WB_EXTRAFIELD | WB_SVLOOK | WB_BORDER),
	aVRuler(GetParent(), this,
		   SVXRULER_SUPPORT_SET_NULLOFFSET|
		   SVXRULER_SUPPORT_OBJECT,
		   pFrame->GetBindings(),
		   WB_VSCROLL  | WB_SVLOOK | WB_BORDER)
{
	DBG_CTOR(TestView, 0);

	// Create a view to the specified document
	Construct();
}

//------------------------------------------------------------------

TestView::TestView( SfxViewFrame *pFrame, SfxViewShell* ):
	SfxViewShell( pFrame, this ),
	Window( &pFrame->GetWindow(), WinBits(WB_BORDER|WB_CLIPCHILDREN) ),
	bMouseCaptured(FALSE),
	aRuler(GetParent(), this,
		   SVXRULER_SUPPORT_TABS |
		   SVXRULER_SUPPORT_PARAGRAPH_MARGINS |
		   SVXRULER_SUPPORT_OBJECT |
		   SVXRULER_SUPPORT_SET_NULLOFFSET|
		   SVXRULER_SUPPORT_BORDERS,
		   pFrame->GetBindings(),
		   WB_STDRULER | WB_EXTRAFIELD | WB_SVLOOK | WB_BORDER),
	aVRuler(GetParent(), this,
		   SVXRULER_SUPPORT_SET_NULLOFFSET|
		   SVXRULER_SUPPORT_OBJECT,
		   pFrame->GetBindings(),
		   WB_VSCROLL |  WB_SVLOOK | WB_BORDER)
{
	DBG_CTOR(TestView, 0);

	// Create a view, as a clone to another
	Construct();
}

//------------------------------------------------------------------

TestView::~TestView()
{
	DBG_DTOR(TestView, 0);

	// In destructors C++ calles at maximum the virtual function of the
	// class currently destroying. If StarFramework hides our window in its
	// DocView destructor, the Deactivate() function of class DocView, not
	// class TestView becomes called!
	Hide();
	SetWindow(0);
}

//------------------------------------------------------------------

Size TestView::GetOptimalSizePixel() const
{
	return LogicToPixel(aTotalSize);
}

//------------------------------------------------------------------

void TestView::OuterResizePixel( const Point &rPos, const Size &rSize )
{
	Point aPos(rPos);
	Size aSize(aRuler.GetSizePixel());
	Size aVSize(aVRuler.GetSizePixel());

	aSize.Width() = rSize.Width();
	aRuler.ChangeSizePixel(aSize);

	aVSize.Height() = rSize.Height() - aSize.Height();
	aVRuler.SetPosSizePixel(Point(0, aSize.Height()), aVSize);

	aPos.Y() += aSize.Height();
	aPos.X() += aVSize.Width();
	SetPosSizePixel( aPos, Size(rSize.Width() - aVSize.Width(),
								rSize.Height() - aSize.Height()));
	aTotalSize = rSize;
}

void TestDoc::Draw( OutputDevice * pDev, const Rectangle & rBound,
					  const JobSetup & rSetup, USHORT nAspect )
{
}



void TestView::Execute( SfxRequest& rReq )
{
	SFX_BINDINGS().Invalidate(rReq.GetSlot());
}

void TestView::GetState(SfxItemSet &rSet)
{
	SfxWhichIter aIter(rSet);
	USHORT nWhich = aIter.FirstWhich();
	while(nWhich) {
		switch(nWhich) {
			case SID_RULER_PAGE_POS: {
				rSet.Put(SvxPagePosSizeItem(Point(),
									GetTotalSize().Width(),
									GetTotalSize().Height()));
				break;
			}
			break;
		}
		nWhich = aIter.NextWhich();
	}

}

void TestView::MouseButtonDown( const MouseEvent& rMEvt )
{
	if(rMEvt.GetMode() & MOUSE_CONTEXTMENU)
		aMenu.Execute( OutputToScreenPixel( rMEvt.GetPosPixel() ) );
}

void TestView::ExtraDownHandler(Ruler *pRuler)
{
	pRuler->SetExtraType(RULER_EXTRA_NULLOFFSET, RULER_STYLE_HIGHLIGHT);
	CaptureMouse();
	bMouseCaptured = TRUE;
}

void  TestView::MouseMove( const MouseEvent& rMEvt )
{
	if(bMouseCaptured) {
		Point aMousePos(rMEvt.GetPosPixel());
		RulerLine aLine;
		aLine.nStyle = 0;
		aLine.nPos = GetPosPixel().X() + aMousePos.X() -
					 aRuler.Ruler::GetNullOffset();
		aRuler.SetLines(1, &aLine);
		aLine.nPos = aMousePos.Y() - aVRuler.Ruler::GetNullOffset();
		aVRuler.SetLines(1, &aLine);
	}
	else
		Window::MouseMove(rMEvt);

}

void  TestView::MouseButtonUp( const MouseEvent& rMEvt )
{
	if(bMouseCaptured) {
		Point aMousePos(rMEvt.GetPosPixel());
		bMouseCaptured = FALSE;
		ReleaseMouse();
		aRuler.SetExtraType(RULER_EXTRA_NULLOFFSET, 0);
		aRuler.SetLines();
		aVRuler.SetLines();
		// setzen NullOffset
		aRuler.SetNullOffsetLogic(GetPosPixel().X() + aMousePos.X());
		aVRuler.SetNullOffsetLogic(aMousePos.Y());
	}
	else
		Window::MouseButtonUp(rMEvt);
}

