/*************************************************************************
 *
 *  $RCSfile: svdsuro.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: sj $ $Date: 2001/05/22 10:24:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "svdsuro.hxx"
#include "svdobj.hxx"
#include "svdpage.hxx"
#include "svdmodel.hxx"

#ifndef _TOOLS_DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif

////////////////////////////////////////////////////////////////////////////////////////////////////

// fuer Schreiben
SdrObjSurrogate::SdrObjSurrogate(SdrObject* pObj1, const SdrObject* pRefObj1)
{
	ImpClearVars();
	pObj=pObj1;
	pRefObj=pRefObj1;
	ImpMakeSurrogate();
}

// fuer Lesen
SdrObjSurrogate::SdrObjSurrogate(const SdrModel& rMod, SvStream& rIn)
{
	ImpClearVars();
	pModel=&rMod;
	ImpRead(rIn);
}

// fuer Lesen
SdrObjSurrogate::SdrObjSurrogate(const SdrObject& rRefObj, SvStream& rIn)
{
	ImpClearVars();
	pRefObj=&rRefObj;
	pModel=rRefObj.GetModel();
	ImpRead(rIn);
}

SdrObjSurrogate::~SdrObjSurrogate()
{
	if (pGrpOrdNums!=NULL) delete [] pGrpOrdNums;
}

void SdrObjSurrogate::ImpClearVars()
{
	pObj=NULL;
	pRefObj=NULL;
	pList=NULL;
	pRootList=NULL;
	pPage=NULL;
	pModel=NULL;
	eList=SDROBJLIST_UNKNOWN;
	nOrdNum=0;
	pGrpOrdNums=NULL;
	nGrpLevel=0;
	nPageNum=0;
}

void SdrObjSurrogate::ImpMakeSurrogate()
{
	if (pObj!=NULL) { // ansonsten bleibt eList=SDROBJLIST_UNKNOWN, weil Obj=NULL
		FASTBOOL bSameList=FALSE;
		FASTBOOL bSamePage=FALSE;
		pModel=pObj->GetModel();
		pList=pObj->GetObjList();
		pRootList=pList;
		pPage=pObj->GetPage();
		nOrdNum=pObj->GetOrdNum();
		DBG_ASSERT(pModel!=NULL,"ImpMakeSurrogate(): Zielobjekt hat kein Model");
		DBG_ASSERT(pList!=NULL,"ImpMakeSurrogate(): Zielobjekt hat keine ObjList");
		if (pModel!=NULL && pList!=NULL) {
			if (pRefObj!=NULL) {
				if (pList==pRefObj->GetObjList()) bSameList=TRUE;
				else if (pPage!=NULL && pPage==pRefObj->GetPage()) bSamePage=TRUE;
			}
			if (!bSameList) {
				//if (eList==SDROBJLIST_UNKNOWN) eList=pList->GetListKind();
				SdrObjList* pL=pList->GetUpList();
				nGrpLevel=0;
				while (pL!=NULL) { pL=pL->GetUpList(); nGrpLevel++; }
				if (nGrpLevel!=0) { // Aha, verschachtelt
					pGrpOrdNums=new UINT32[nGrpLevel];
					const SdrObjList* pL=pRootList;
					for (unsigned i=nGrpLevel; i>0;) {
						i--;
						SdrObject* pGrp=pL->GetOwnerObj();
						if (pGrp!=NULL && pL->GetListKind()==SDROBJLIST_GROUPOBJ && pGrp->GetObjList()==pL->GetUpList() && pGrp->GetSubList()==pL) {
							pGrpOrdNums[i]=pGrp->GetOrdNum();
						} else { // sonst Fehlerhafte Verkettung
#ifdef DBG_UTIL
							ByteString aStr("ImpMakeSurrogate() - Inkonsistente Verkettung:\n");
							String aStr1;
							
							pObj->TakeObjNameSingul(aStr1);
							
							aStr += "Schleifendurchlauf="; 
							aStr += ByteString::CreateFromInt32( i );
							aStr += " GroupingLevel="; 
							aStr += ByteString::CreateFromInt32( nGrpLevel );
							aStr += " Ordnumgszahl="; 
							aStr += ByteString::CreateFromInt32( pObj->GetOrdNum() );
							aStr += "\nObjektbezeichnung='"; 
							aStr += ByteString(aStr1, gsl_getSystemTextEncoding()); 
							aStr += "'\n";

							if(pGrp) 
								aStr += "\n- Liste mit Parent hat kein OwnerObj.";
							
							if(pL->GetListKind()==SDROBJLIST_GROUPOBJ) 
								aStr += "\n- Liste mit Parent liefert ListKind!=SDROBJLIST_GROUPOBJ.";

							if(pGrp && pGrp->GetObjList() == pL->GetUpList()) 
								aStr += "\n- ObjList des OwnerObj und ParentList seiner SubList sind nicht identisch.";

							if(pGrp && pGrp->GetSubList() == pL) 
								aStr += "\n- Sublist des OwnerObj des OwnerObj entspricht nicht der Liste selbst.";

							DBG_ERROR(aStr.GetBuffer());
#endif
							delete [] pGrpOrdNums;
							pGrpOrdNums=NULL;
							nGrpLevel=0;
							return;
						}
						pL=pL->GetUpList();
					}
					pRootList=pL;
					if (pL==NULL || pL->GetUpList()!=NULL || pL->GetOwnerObj()!=NULL || pL->GetListKind()==SDROBJLIST_GROUPOBJ) {
						delete [] pGrpOrdNums;
						pGrpOrdNums=NULL;
						nGrpLevel=0;
						return;
					}
				} // if (nGrpLevel!=0)
			} // if (eList!=SDROBJLIST_SAMELIST)
			if (bSameList) eList=SDROBJLIST_SAMELIST;
			else if (bSamePage) eList=SDROBJLIST_SAMEPAGE;
			else eList=pRootList->GetListKind();
			if (eList==SDROBJLIST_GROUPOBJ || eList==SDROBJLIST_UNKNOWN) {
				if (pGrpOrdNums!=NULL) {
					delete [] pGrpOrdNums;
					pGrpOrdNums=NULL;
					nGrpLevel=0;
				}
				eList=SDROBJLIST_UNKNOWN;
				return;
			}
			if (SdrIsPageKind(eList)) {
				if (pPage!=NULL) {
					nPageNum=pPage->GetPageNum();
				} else {
					DBG_ERROR("ImpMakeSurrogate(): eList ist eine Page, aber pPage==NULL");
					if (pGrpOrdNums!=NULL) {
						delete [] pGrpOrdNums;
						pGrpOrdNums=NULL;
						nGrpLevel=0;
					}
					eList=SDROBJLIST_UNKNOWN;
					return;
				}
			}
			// so, nun ist alles beisammen und kann gestreamt werden.
		} // if (pModel!=NULL && pList!=NULL)
	} // if (pObj!=NULL)
}

void SdrObjSurrogate::ImpWriteValue(SvStream& rOut, UINT32 nVal, unsigned nByteAnz) const
{
	switch (nByteAnz) {
		case 0: rOut<<BYTE(nVal);   break;
		case 1: rOut<<UINT16(nVal); break;
		case 3: rOut<<nVal;         break;
		default: DBG_ERROR("ImpWriteValue(): Nur Bytelaengen 1, 2 oder 4 sind erlaubt!");
	} // switch
}

void SdrObjSurrogate::ImpReadValue(SvStream& rIn, UINT32& rVal, unsigned nByteAnz) const
{
	switch (nByteAnz) {
		case 0: { BYTE n;   rIn>>n; rVal=n; } break;
		case 1: { UINT16 n; rIn>>n; rVal=n; } break;
		case 3: {           rIn>>rVal;      } break;
		default: DBG_ERROR("ImpReadValue(): Nur Bytelaengen 1, 2 oder 4 sind erlaubt!");
	} // switch
}

SvStream& operator<<(SvStream& rOut, const SdrObjSurrogate& rSurro)
{
	BYTE nId=BYTE(rSurro.eList);
	if (rSurro.eList==SDROBJLIST_UNKNOWN) {
		rOut<<nId;
	} else {
		FASTBOOL bGrp=rSurro.nGrpLevel!=0;
		if (bGrp) nId|=0x20; // Gruppierung
		ULONG nMaxOrdNum=rSurro.nOrdNum;
		unsigned i;
		for (i=0; i<rSurro.nGrpLevel; i++) {
			if (nMaxOrdNum<rSurro.pGrpOrdNums[i]) nMaxOrdNum=rSurro.pGrpOrdNums[i];
		}
		unsigned nByteAnz=0;
		if (nMaxOrdNum>0xFF) nByteAnz++;
		if (nMaxOrdNum>0xFFFF) nByteAnz+=2;
		nId|=BYTE(nByteAnz<<6); // Byteanzahl an der richtigen Stelle im ID-Byte eintragen
		rOut<<nId;
		rSurro.ImpWriteValue(rOut,rSurro.nOrdNum,nByteAnz);
		if (SdrIsPageKind(rSurro.eList)) { // Seitennummer schreiben
			rOut<<rSurro.nPageNum;
		}
		if (bGrp) { // Gruppierung
			rOut<<rSurro.nGrpLevel;
			for (i=0; i<rSurro.nGrpLevel; i++) {
				rSurro.ImpWriteValue(rOut,rSurro.pGrpOrdNums[i],nByteAnz);
			}
		}
	}
	return rOut;
}

void SdrObjSurrogate::ImpRead(SvStream& rIn)
{
	BYTE nId;
	rIn>>nId;
	eList=SdrObjListKind(nId & 0x1F);
	if (eList!=SDROBJLIST_UNKNOWN) {
		FASTBOOL bGrp=(nId & 0x20)!=0;      // Id-Byte
		unsigned nByteAnz=(nId & 0xC0)>>6;  // aufschluesseln
		ImpReadValue(rIn,nOrdNum,nByteAnz); // Ordnungsnummer des Objekts
		if (SdrIsPageKind(eList)) { // Seitennummer schreiben
			rIn>>nPageNum;
		}
		if (bGrp) { // Gruppierung
			rIn>>nGrpLevel;
			pGrpOrdNums=new UINT32[nGrpLevel];
			for (unsigned i=0; i<nGrpLevel; i++) {
				ImpReadValue(rIn,pGrpOrdNums[i],nByteAnz);
			}
		}
	}
}

void SdrObjSurrogate::ImpFindObj()
{
	if (eList!=SDROBJLIST_UNKNOWN) {
		switch (eList) {
			case SDROBJLIST_SAMEPAGE: case SDROBJLIST_SAMELIST: {
				if (pRefObj!=NULL) {
					pPage=pRefObj->GetPage();
					if (eList==SDROBJLIST_SAMELIST) {
						pRootList=pRefObj->GetObjList();
						if (pRootList==NULL) {
							DBG_ERROR("SdrObjSurrogate::ImpFindObj(): eList=SDROBJLIST_SAMELIST, pRefObj hat jedoch keine ObjList");
							return;
						}
					} else {
						if (pPage!=NULL) {
							pRootList=pPage;
						} else {
							DBG_ERROR("SdrObjSurrogate::ImpFindObj(): eList=SDROBJLIST_SAMEPAGE, pRefObj hat jedoch keine Page");
							return;
						}
					}
				} else {
					DBG_ERROR("SdrObjSurrogate::ImpFindObj(): Relatives Surrogat benoetigt Referenzobjekt");
					return;
				}
			} break;
			case SDROBJLIST_DRAWPAGE: pPage=pModel->GetPage(nPageNum); pRootList=pPage; break;
			case SDROBJLIST_MASTERPAGE: pPage=pModel->GetMasterPage(nPageNum); pRootList=pPage; break;
			case SDROBJLIST_VIRTOBJECTS: {
				DBG_ERROR("SdrObjSurrogate::ImpFindObj(): Persistente virtuelle Objekte in dieser Version nicht verfuegbar");
				return;
			} break;
			case SDROBJLIST_SYMBOLTABLE: {
				DBG_ERROR("SdrObjSurrogate::ImpFindObj(): Symbole in dieser Version nicht verfuegbar");
				return;
			} break;
			default: {
				DBG_ERROR("SdrObjSurrogate::ImpFindObj(): Unbekannter oder unsinniger Objektlistentyp");
				return;
			}
		} // switch
		pList=pRootList;
		for (unsigned i=0; i<nGrpLevel; i++) {
			SdrObject* pO=pList->GetObj(pGrpOrdNums[i]);
			if (pO!=NULL) {
				pList=pO->GetSubList();
				if (pList==NULL) {
					DBG_ERROR("SdrObjSurrogate::ImpFindObj(): Objekt ist kein Gruppenobjekt");
					return;
				}
			} else {
				DBG_ERROR("SdrObjSurrogate::ImpFindObj(): Gruppenobjekt nicht gefunden");
				return;
			}
		}
		pObj=pList->GetObj(nOrdNum);
		DBG_ASSERT(pObj!=NULL,"SdrObjSurrogate::ImpFindObj(): Zielobjekt nicht gefunden");
	}
}

SdrObject* SdrObjSurrogate::GetObject()
{
	if (pObj==NULL && eList!=SDROBJLIST_UNKNOWN) ImpFindObj();
	return pObj;
}


