/*************************************************************************
 *
 *  $RCSfile: wpsimpl.c,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mh $ $Date: 2000/12/07 17:17:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define SD_OFFICE40

#include "wpsimpl.h"

BOOL SendCommand( PSZ pFullAppPath, PSZ pApp, PSZ pCommand, PSZ* pDocNames,
	USHORT nDocNameCount,
	PSZ pDeviceName, WPObject* pObject,AppOpenFct pFct,HWND hwndCnr );

typedef struct
{
	ULONG nMsg;
	HWND hWndServer;
} ImpWpsDdeMsg;

typedef struct
{
	USEITEM aUse;
	VIEWITEM aView;
} ImpMyView;


#define TIMEOUT_DDE 	(TID_USERMAX - 1)
#define TIMEOUT_5S		(TID_USERMAX - 2)
#define WM_RECONNECT	(WM_USER+1)

#define PRE_PRINTER		'@'

void MyMsgBox( PSZ pTitle, PSZ pMsg )
{
	WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,pMsg,pTitle,HWND_DESKTOP,MB_OK);
}

MRESULT EXPENTRY ConvWndProc(HWND hWnd,ULONG nMsg,MPARAM nPar1,MPARAM nPar2)
{
	ULONG nTimerId;
	ImpWpsDdeMsg* pData = (ImpWpsDdeMsg*)WinQueryWindowULong( hWnd, 0 );
	switch( nMsg )
	{
		case WM_DDE_INITIATEACK	:
			{
			PID pidApp; TID tid;
			HSWITCH hSwitch;
			SWCNTRL aSwitchEntry;

			WinQueryWindowProcess( (HWND)nPar1, &pidApp, &tid );
			hSwitch = WinQuerySwitchHandle( NULLHANDLE, pidApp );
			if( hSwitch )
			{
				if( !WinQuerySwitchEntry( hSwitch, &aSwitchEntry ) )
				{
					if( strstr( aSwitchEntry.szSwtitle, "%PRODUKTNAME"))
					{
						pData->nMsg = nMsg;
						pData->hWndServer = (HWND)nPar1;
					}
				}
			}
			DosFreeMem( (void*)nPar2 );
			}
			return (MRESULT)TRUE;

		case WM_DDE_ACK	:
		case WM_DDE_TERMINATE :
			pData->nMsg = nMsg;
			pData->hWndServer = (HWND)nPar1;
			DosFreeMem( (void*)nPar2 );
			return (MRESULT)0;

		case WM_TIMER :
			nTimerId = (ULONG)nPar1;
			if( nTimerId == TIMEOUT_DDE )
				pData->nMsg = WM_TIMER;
			else
				pData->nMsg = WM_RECONNECT;
			break;

	}
	return (MRESULT)1;
}

HWND CreateConversationWnd()
{
	ImpWpsDdeMsg* pData;
	HWND hWnd = WinCreateWindow( HWND_OBJECT, WC_FRAME, "DDEConvWnd", 0,
					0,0,0,0, HWND_DESKTOP, HWND_BOTTOM, 0, 0,  0 );
	WinSubclassWindow( hWnd, (PFNWP)ConvWndProc );
	pData = (ImpWpsDdeMsg*)malloc((size_t)sizeof(ImpWpsDdeMsg));
	pData->nMsg = 0;
	pData->hWndServer = 0;
	WinSetWindowULong( hWnd, 0, (ULONG)pData );
	return hWnd;
}

void DestroyConversationWnd( HWND hWnd )
{
	ImpWpsDdeMsg* pData = (ImpWpsDdeMsg*)WinQueryWindowULong( hWnd, 0 );
	WinDestroyWindow( hWnd );
	free( pData );
}

typedef struct
{
	char aPgmName[ 256 ];
	char aArgs[ 256 ];
	WPObject* pObject;
} MyStartData;


void _Optlink ThreadStartApp( MyStartData* pData )
{
	RESULTCODES aResult;
	APIRET nRet;
	ImpMyView aViewItem;
	WPObject* pObject;
	HAB hAB;
	HMQ hMQ;

	hAB = WinInitialize( 0 );
	hMQ = WinCreateMsgQueue( hAB, 0 );
	if( hMQ )
	{
		WinCancelShutdown( hMQ, TRUE );
		pObject = pData->pObject;

		//
		//  In-Use-Emphasis setzen
		//

		if( pObject )
		{
			aViewItem.aUse.type = USAGE_OPENVIEW;
			aViewItem.aView.view = OPEN_RUNNING;
			aViewItem.aView.handle = HWND_DESKTOP;
			_wpAddToObjUseList( pObject, (PUSEITEM)&aViewItem);
			_wpCnrSetEmphasis( pObject, CRA_INUSE, TRUE );
		}

		memset( (void*)&aResult, 0, sizeof(aResult));
		nRet = DosExecPgm( 0,0,EXEC_SYNC,
			(PSZ)pData->aArgs, 0, &aResult, (PSZ)pData->aPgmName );
		if( nRet && nRet != 457  /* ERROR_SMG_START_IN_BACKGROUND */ )
		{
			char aNumber[20];
			char* pMsg;
			pMsg = (char*)malloc( 512 );
			strcpy( pMsg, "Cannot start Application\n");
			strcat( pMsg, pData->aPgmName );
			strcat( pMsg, "\nErrorcode:" );
			ltoa( (long)nRet, aNumber, 10 );
			strcat( pMsg, aNumber );
			free( pMsg );
		}
		//
		//  In-Use-Emphasis loeschen
		//
		_wpDeleteFromObjUseList( pObject, (PUSEITEM)&aViewItem);
		if( !_wpFindUseItem( pObject, USAGE_OPENVIEW, NULL ))
			_wpCnrSetEmphasis( pObject, CRA_INUSE, FALSE );

		WinDestroyMsgQueue( hMQ );
		WinTerminate( hAB );
	}
	free( pData );
}

BOOL MyExec( const char* pPgm, const char* pPar, WPObject* pSomSelf )
{
	MyStartData* pData;
	int nPgmLen;
	char* pNext;
	TID tid;
	APIRET nRet;
	RESULTCODES aResult;
	PSZ pResultPointer;
	BYTE pResultBuffer[ 128 ];

	if(!(nRet=DosSearchPath(
		SEARCH_CUR_DIRECTORY | SEARCH_ENVIRONMENT,
		"PATH",pPgm,pResultBuffer,127)))
	{
		pPgm = (const char*)pResultBuffer;
		//MyMsgBox("MyExec", pPgm );
	}
	else
	{
		//MyMsgBox("MyExec", "Not in Path" );

	}
	//MyMsgBox("MyExec2", pPgm );


	pData = (MyStartData*)malloc( sizeof(MyStartData) );
	memset( (void*)pData, 0, sizeof(MyStartData) );
	nPgmLen = strlen( pPgm );
	nPgmLen++;
	memcpy( pData->aPgmName, pPgm, nPgmLen );
	memcpy( pData->aArgs, pPgm, nPgmLen );
	pNext = pData->aArgs;
	pNext += nPgmLen;
	memcpy( pNext, pPar, strlen(pPar)+1 );
	pData->pObject = pSomSelf;
	//nRet = DosCreateThread( &tid, (PFNTHREAD)ThreadStartApp,
	//	(ULONG)pData, 0, 32768 );
	_beginthread( ThreadStartApp,0,32768, pData );
	return TRUE;
}

BOOL BoostApplication( PSZ pApp, PSZ pParams, WPObject* pObject )
{
	if( MyExec( pApp, pParams, pObject ) )
		return FALSE;
	return TRUE;
}

typedef struct
{
	HWND hWndServer;
	WPObject* pObject;
} MyAppData;

void _Optlink ThreadWaitApp( MyAppData* pData )
{
	ImpMyView aViewItem;
	WPObject* pObject;
	HEV hev;
	BOOL bIsWin;
	HAB hAB, hABServer;
	HMQ hMQ;

	hAB = WinInitialize( 0 );
	hMQ = WinCreateMsgQueue( hAB, 0 );
	if( hMQ )
	{
		WinCancelShutdown( hMQ, TRUE );
		pObject = pData->pObject;

		//
		//  In-Use-Emphasis setzen
		//
		if( pObject )
		{
			aViewItem.aUse.type = USAGE_OPENVIEW;
			aViewItem.aView.view = OPEN_RUNNING;
			aViewItem.aView.handle = HWND_DESKTOP;
			_wpAddToObjUseList( pObject,(PUSEITEM)&aViewItem);
			_wpCnrSetEmphasis( pObject, CRA_INUSE, TRUE );
		}
		DosCreateEventSem( 0, &hev, 0, 0 );
		bIsWin = TRUE;
		hABServer = WinQueryAnchorBlock( pData->hWndServer );
		while( bIsWin )
		{
			// alle n Millisek pruefen, ob App noch lebt
			DosWaitEventSem( hev, 2500 ); // so sparen wir einen Timer
			bIsWin = WinIsWindow( hABServer, pData->hWndServer );
		}
		DosCloseEventSem( hev );
		//
		//  In-Use-Emphasis loeschen
		//
		_wpDeleteFromObjUseList( pObject, (PUSEITEM)&aViewItem);
		if( !_wpFindUseItem( pObject, USAGE_OPENVIEW, NULL ))
			_wpCnrSetEmphasis( pObject, CRA_INUSE, FALSE );

		WinDestroyMsgQueue( hMQ );
		WinTerminate( hAB );
	}
	free( pData );
}


void GetConvContext( CONVCONTEXT* pCC )
{
	ULONG       nLen;
	COUNTRYCODE aCountryCode;
	COUNTRYINFO aCountryInfo;
	memset( &aCountryCode, 0, sizeof( COUNTRYCODE ) );
	memset( &aCountryInfo, 0, sizeof( COUNTRYINFO ) );
	DosQueryCtryInfo( sizeof( COUNTRYINFO ), &aCountryCode, &aCountryInfo, &nLen );
	pCC->cb          = sizeof( CONVCONTEXT );
	pCC->fsContext   = 0;
	pCC->idCountry   = aCountryInfo.country;
	pCC->usCodepage  = aCountryInfo.codepage;
	pCC->usLangID    = 0;
	pCC->usSubLangID = 0;
}

PSZ GetAppName( PSZ pPathName )
{
	char *pAppName, *pLast, *pNextLast;
	if( !pPathName )
		return 0;
	pAppName = (char*)malloc( 256 );

	// alle Backslashes ueberspringen
	pLast = strrchr( pPathName, (int)'\\' );
	if( !pLast )
		pLast = pPathName;
	else
		pLast++;

	// alle Doppelpunkte ueberspringen
	pNextLast = strrchr( pLast, ':' );
	if( !pNextLast )
		pNextLast = pLast;
	else
		pNextLast++;

	strcpy( pAppName, pNextLast );

	// Extension abschneiden
	pNextLast = strrchr( pAppName, '.' );
	if( pNextLast )
		*pNextLast = 0;

	return pAppName;
}

PSZ GetAppNameFromExt( PSZ pExt )
{
	static const char* pExts[] =
	{
		"sdd", "soffice",
		"sdw", "soffice",
		"sda", "soffice",
		"sdc", "soffice",
		"smf", "soffice",
		"frm", "soffice",
		"scd", "soffice",
		"bmp", "soffice",
		"soc", "soffice",	// Farben
		"sog", "soffice",    // Farbverlaeufe
		"sob", "soffice",    // Bitmaps
		"soh", "soffice",    // Schraffuren
		"sod", "soffice",    // Linienstile
		"soe", "soffice",    // Linienenden
		"sop", "soffice",    // Polygone
		"sgl", "soffice",    // Master Doc
		"htm", "soffice",
		"html", "soffice",
		0
	};
	int nIdx = 0;
	char* pApp = (char*)pExts[0];

	if( !pExt )
		return 0;

	do
	{
		if( strcmp( pApp, pExt ) == 0 )
			return (PSZ)(pExts[ nIdx + 1 ]);
		nIdx += 2;
		pApp = (char*)pExts[ nIdx ];
	} while( pApp );
	return 0;
}

PSZ GetAppNameFromType( PSZ pType )
{
	static const char* pTypes[] =
	{
		"StarImpress 5.0",	"soffice",
		"StarWriter 5.0", 	"soffice",
		"StarCalc 5.0", 	"soffice",
		"StarChart 5.0",	"soffice",
		"StarDraw 5.0",		"soffice",
		"StarMath 5.0",		"soffice",
		"StarWriter/Global 5.0", "soffice",
		"StarWriter/Web 5.0", 	"soffice",
		"StarDraw", 		"soffice",
		"StarWriter", 		"soffice",
		"StarCalc", 		"soffice",
		"StarImpress 4.0",	"soffice",
		"StarWriter 4.0", 	"soffice",
		"StarCalc 4.0", 	"soffice",
		"StarChart 4.0",	"soffice",
		"StarMath 4.0",		"soffice",
		"StarDraw 3.0", 	"soffice",
		"StarWriter 3.0", 	"soffice",
		"StarCalc 3.0", 	"soffice",
		"StarChart 3.0",	"soffice",
		"StarMath 3.0",		"soffice",
		"StarCalc Datei",	"soffice",
		"StarCalc File",	"soffice",
		"Grafik",			"soffice",
		"Master Document",	"soffice",
		"HTML",				"soffice",
		"HTM",				"soffice",
		0
	};
	int nIdx = 0;
	char* pApp = pTypes[0];

	if( !pType )
		return 0;

	do
	{
		if( strcmp( pApp, pType ) == 0 )
			return (PSZ)(pTypes[ nIdx + 1 ]);
		nIdx += 2;
		pApp = (char*)pTypes[ nIdx ];
	} while( pApp );
	return 0;
}

PSZ GetExtension( PSZ pAppName )
{
	char* pLast, *pBuf;

	if( !pAppName )
		return 0;

	pLast = strrchr( pAppName, '.' );
	if( pLast )
	{
		pBuf = (char*)malloc( 256 );
		pLast++;
		strcpy( pBuf, pLast );
		return (PSZ)pBuf;
	}
	return 0;
}

static void FillCommand(PSZ pBuf,PSZ pDocName,PSZ pDeviceName,PSZ pCommand)
{
	strcpy( pBuf, pCommand );
	strcat( pBuf,"(\"" );
	if( !pDeviceName || strlen(pDeviceName) < 2 )
	{
		// Open("Test.sdw")
		strcat( pBuf, pDocName );
	}
	else
	{
		// Print("@Printer" "Test.sdw")
		strcat( pBuf, pDeviceName );
		strcat( pBuf, "\" \"" );
		strcat( pBuf, pDocName );
	}
	strcat( pBuf, "\")" );
}

BOOL SendCommand( PSZ pFullAppPath, PSZ pApp, PSZ pCommand, PSZ* pDocNames,
	USHORT nDocNameCount,
	PSZ pDeviceName, WPObject* pObject, AppOpenFct pFct, HWND hwndCnr )
{
#if 0
	static char pAppParams[2] = "";
	if( pFct )
	{
		// ueber WPS starten, damit Minimieren der App
		// (Desktop oder Ordner) richtig funktioniert
		(*pFct)( pObject, hwndCnr, OPEN_RUNNING, 0 );
		return TRUE;
	}
	else
	{
		return BoostApplication( pFullAppPath, pAppParams, pObject );
	}
#else
	HWND hWndClient;
	HAB hAB;
	CONVCONTEXT aContext;

	ULONG nTimeoutId = TIMEOUT_DDE;
	ULONG nReconnect = TIMEOUT_5S;

	QMSG aMsgQueue;
	ULONG nMsg;
	HWND hWndServer;
	PDDESTRUCT pOutDdeData;
	USHORT nCommandLen;
	USHORT nAppDataLen;
	APIRET nRet;
	USHORT n;
	ImpWpsDdeMsg* pData;
	ULONG nLen;
	TID tid;
	MyAppData* pThreadData;

//	MyMsgBox("SendCommand", "" );

	if( !pCommand || !pApp )
	{
		//MyMsgBox("No command or no app","");
		return FALSE;
	}
	hWndClient = CreateConversationWnd();
	pData = (ImpWpsDdeMsg*)WinQueryWindowULong(hWndClient, 0);
	hAB	= WinQueryAnchorBlock( hWndClient );

	GetConvContext( &aContext );

	WinDdeInitiate( hWndClient, (PSZ)"soffice", (PSZ)"System", &aContext );
	if( pData->nMsg != WM_DDE_INITIATEACK )
	{
		char*	pAppParams;
		char*	pPrinter;
//		MyMsgBox("App not startet", "" );
		// Applikation ist nicht oben
		pAppParams = (char*)malloc( 1024 );
		if( !pDocNames || (
			strlen(pDocNames[0]) == 0 && strlen(pDeviceName) == 0) )
			*pAppParams = 0;
		else
		{
			if( !stricmp(pCommand,"Print")  )
				strcpy( pAppParams, "/p" );
			else
				pAppParams[0] = 0;
			if( pDeviceName )
			{
				strcat( pAppParams, "\"");
				strcat( pAppParams, pDeviceName );
				strcat( pAppParams,"\"" );
			}
			for( n = 0; n < nDocNameCount; n++ )
			{
				strcat( pAppParams," \"");
				strcat( pAppParams, pDocNames[n] );
				strcat( pAppParams,"\"" );
			}
		}
		//MyMsgBox("StartApplication/CommandLine", pAppParams );
		DestroyConversationWnd( hWndClient );
		if( ((*pAppParams) == 0 && pFct) )
		{
			// ueber WPS starten, damit Minimieren der App
			// (Desktop oder Ordner) richtig funktioniert
			(*pFct)( pObject, hwndCnr, OPEN_RUNNING, 0 );
			return TRUE;
		}
		else
			return BoostApplication( pFullAppPath, pAppParams, pObject );
	}

	hWndServer = pData->hWndServer;
	for( n = 0; n < nDocNameCount; n++ )
	{
		char* pBuf;

		// Alloc shared mem
		DosAllocSharedMem( (PPVOID)&pOutDdeData, NULL, 4000,
						   PAG_READ | PAG_WRITE | PAG_COMMIT |
						   OBJ_GIVEABLE | OBJ_GETTABLE );

		pOutDdeData->cbData        = 4000;
		pOutDdeData->fsStatus      = DDE_FACKREQ;
		pOutDdeData->usFormat      = DDEFMT_TEXT;
		pOutDdeData->offszItemName = sizeof( DDESTRUCT );
		pOutDdeData->offabData     = sizeof( DDESTRUCT ) + 5;

		*(char*)(((char*)pOutDdeData)+pOutDdeData->offszItemName) = 0;

		pBuf = ((char*)pOutDdeData)+pOutDdeData->offabData;
		*pBuf = 0;
		FillCommand( pBuf, pDocNames[n], pDeviceName, pCommand );

//		MyMsgBox("Sending Evt", pBuf );

		if( WinDdePostMsg( hWndServer,hWndClient,WM_DDE_EXECUTE,
					   pOutDdeData,DDEPM_RETRY) == FALSE )
		{
			DosFreeMem( pOutDdeData );
		}
	}
	WinDdePostMsg(hWndServer,hWndClient,WM_DDE_TERMINATE,NULL,DDEPM_RETRY);
	DestroyConversationWnd( hWndClient );
	if( pObject )
	{
		pThreadData = (MyAppData*)malloc( sizeof(MyAppData) );
		pThreadData->hWndServer = hWndServer;
		pThreadData->pObject = pObject;
		_beginthread( ThreadWaitApp,0, 16384, (void*)pThreadData );
	}
	return TRUE;
#endif
}

void Drop( WPProgram *somSelf, HWND hwndCnr, PDRAGINFO pdrgInfo,
	PDRAGITEM pdrgItem, AppOpenFct pFct  )
{
	char*			pAllDocNames[256];
	USHORT			nItems, n;
	char*			pSourceName;
	char*			pAppData;
	PPROGDETAILS	pProgDetails;	// "d:\bin\sdesktop.exe", ...
	char*			pAppName;       // "sdesktop"
	char*			pRecAppName; 	// recommended app name
	ULONG   		cb;
	char			aAppWithExe[13]; // "sdesktop.exe"
	WPObject* 		pObj;
	WPFolder*		pFolder;

	nItems = pdrgInfo->cditem;
	if( !nItems )
		return;

	//MyMsgBox("DropCalled", "" );

	pSourceName = (char*)malloc( 256 ); // Dokumentname
	for( n = 0; n < nItems; n++ )
	{
		char* pDocName = (char*)malloc( 256 ); // Dokumentpfad
		cb = DrgQueryStrName( pdrgItem->hstrContainerName, 254, pDocName );
		DrgQueryStrName( pdrgItem->hstrSourceName, 254, pSourceName ); // Name
		strcat( pDocName, pSourceName );
		pAllDocNames[n] = pDocName;
		pdrgItem++;
	}
	free( pSourceName );
	pSourceName = 0;

	pObj = somSelf;


	/* zur In-Use-Emphasis: siehe Rev. 1.15 */


	// ******** Applikation ********
	cb = 0;
	_wpQueryProgDetails( somSelf, 0, &cb );
	pAppData = (char*)malloc( cb );
	memset( pAppData, 0, cb );
	pProgDetails = (PPROGDETAILS)pAppData;
	pProgDetails->Length = cb;
	_wpQueryProgDetails( somSelf, pProgDetails, &cb );
	if( !pProgDetails->pszExecutable )
	{
		free( pAppData );
		free( pAllDocNames );
		return;
	}

	// App-Namen ohne Pfad & Extension extrahieren
	pAppName = (char*)GetAppName( pProgDetails->pszExecutable );
	strlwr( pAppName );

	if( nItems == 1 )
	{
		char* pDocType;
		char* pExtension;

		pDocType = (char*)malloc( 64 );
		cb = DrgQueryStrName( pdrgItem->hstrType, 63, pDocType );

		pExtension = GetExtension( pAllDocNames[0] );
		if( pExtension )
			strlwr( pExtension );

		// App-Namen entsprechend Filetype suchen
		pRecAppName = GetAppNameFromType( pDocType );
		if( !pRecAppName )
			pRecAppName = GetAppNameFromExt( pExtension );
		free( pDocType );

		if( pExtension )
			free( pExtension );
	}
	else
		pRecAppName = 0;

	if( pRecAppName )
	{
		strcpy( aAppWithExe, pRecAppName );
		strcat( aAppWithExe, ".exe" );
		//MyMsgBox("First Docname:", pAllDocNames[0] );
		SendCommand(aAppWithExe,pRecAppName,"Open",pAllDocNames,nItems,"",
			pObj,pFct,hwndCnr );
	}
	else
	{
		//MyMsgBox("First Docname:", pAllDocNames[0] );
		SendCommand(pProgDetails->pszExecutable,pAppName,"Open",pAllDocNames,
			nItems,	"",	pObj, pFct,hwndCnr );
	}

	if( pRecAppName )
		free( pRecAppName );
	if( pAppName )
		free( pAppName );
	free( pAppData );
	for( n=0; n < nItems; n++ )
		free( pAllDocNames[n] );
}


void Print( WPDataFile *somSelf, PPRINTDEST pPrintDest, ULONG ulReserved )
{
#if 0
	return;
#else
	char*   	pDocName;
	char* 		pDeviceName;
	char*		pExtension;
	char*		pType;
	char*  		pRecAppName;
	char		aAppName[13];
	ULONG   	cb;
	BOOL		bRet;
	char* 		pBuffer;
	ULONG     	ulRet;
	ULONG     	ulQueues;
	ULONG     	ulBufferNeeded;
	PPRQINFO3 	pQueueInfo;
	USHORT 		i, n, nLen;
	PPRDINFO3   pInfo;

	// MyMsgBox("Doc","Printing");

	pDocName = (char*)malloc( 512 ); // App + Printer
	pDeviceName = (char*)malloc( 256 );

	// WPStarWriterData *somThis = WPStarWriterGetData(somSelf);
	// WPStarWriterMethodDebug("WPStarWriter","wpwriter_wpPrintObject");
	cb = 255;
	_wpQueryRealName ( somSelf, pDocName, &cb, TRUE );
	// MyMsgBox("Document name", pDocName );
	pExtension = GetExtension( pDocName );
	if( pExtension )
	{
		strlwr( pExtension );
		// MyMsgBox("Doc extension", pExtension );
	}
	pType = _wpQueryType( somSelf );
	// MyMsgBox("Document type", pType );
	// Applikationsnamen ermitteln
	pRecAppName = GetAppNameFromType( pType );
	if( !pRecAppName )
		pRecAppName = GetAppNameFromExt( pExtension );
	// MyMsgBox("App name", pRecAppName );
	strcpy( aAppName, pRecAppName );
	strcat( aAppName, ".exe");

	// Namen des Druckers ermitteln
	cb = 0;
	// Anzahl der Queues abfragen
	SplEnumQueue( NULL, 3, 0, 0, &ulRet, &ulQueues, &cb, NULL );
	pBuffer = (char*)malloc( cb );

	SplEnumQueue( NULL, 3, pBuffer, cb, &ulRet, &ulQueues, &cb, NULL );
	pQueueInfo = (PPRQINFO3)pBuffer;
	for ( i=0; i < ulQueues; i++ )
	{
		strcpy( pDeviceName,(pQueueInfo[i].pszPrinters) );
		nLen = strlen( pDeviceName );
		for( n=0; n< nLen; n++ )
		{
			if ( pDeviceName[n] == ',' )
				pDeviceName[n] = (char)0;
		}
		SplQueryDevice( NULL, pDeviceName, 3, NULL, 0, &cb );

		pInfo = (PPRDINFO3)malloc( cb );
		SplQueryDevice( NULL, pDeviceName, 3, pInfo, cb, &cb );
		// MyMsgBox( "Printer name", pInfo->pszPrinterName );
		if( strcmp(pInfo->pszPrinterName, pPrintDest->pszPrinter) == 0 )
		{
			// pQueueInfo->pszComment == Name Workplace Objekt
			pDeviceName[0] = PRE_PRINTER;
			pDeviceName[1] = 0;
			strcat( pDeviceName, pQueueInfo[i].pszComment );
			// MyMsgBox( "Printer gefunden", pDeviceName );
			break;
		}
		free( pInfo );
	}
	free( pBuffer );
	// MyMsgBox( "Target printer", pDeviceName );

	// SendCommand( aAppName, pRecAppName, "Open", pDocName );
	//strcat( pDocName, "\n" ); // APPEVENT_PARAM_DELIMITER
	//strcat( pDocName, pDeviceName );
	SendCommand(aAppName, pRecAppName, "Print", &pDocName, 1,
		pDeviceName, (WPObject*)somSelf,0,0);

	free( pDocName );
	free( pDeviceName );
	free( pRecAppName );
#endif
}

void OpenDoc( WPDataFile *somSelf, HWND hwndCnr, ULONG ulView, ULONG param )
{
#if 0
	return;
#else
	char*   pDocName;
	char*	pExtension;
	char*	pType;
	char*	pRecAppName;
	ULONG   cb;

	char	aAppName[25];

	pDocName = (char*)malloc( 256 );
	cb = 255;
	_wpQueryRealName ( somSelf, pDocName, &cb, TRUE );

	//MyMsgBox( "wpOpen called", "" );


	pExtension = GetExtension( pDocName );
	if( pExtension )
		strlwr( pExtension );
	pType = _wpQueryType( somSelf );

	// Applikationsnamen ermitteln
	pRecAppName = GetAppNameFromType( pType );
	if( !pRecAppName )
		pRecAppName = GetAppNameFromExt( pExtension );

	if( pRecAppName )
	{
		strcpy( aAppName, pRecAppName );
		strcat( aAppName,".exe");
		SendCommand(aAppName,pRecAppName,"Open",&pDocName,1,"",(WPObject*)somSelf,0,0);
	}
	else
		MyMsgBox("%PRODUKTNAME Template","Unknown file type and extension");

	free( pDocName );
#endif
}

USHORT OpenExe( WPProgram *somSelf, HWND hwndCnr, ULONG ulView, ULONG param,
	AppOpenFct pFct)
{
	char*			pAppData;
	PPROGDETAILS	pProgDetails;
	char*			pAppName;
	ULONG   		cb;
	char			aAppWithExe[13];

	cb = 0;
	_wpQueryProgDetails( somSelf, 0, &cb );
	if( !cb )
	{
		//MyMsgBox("App not set","");
		return 0;
	}

	pAppData = (char*)malloc( cb );
	memset( pAppData, 0, cb );
	pProgDetails = (PPROGDETAILS)pAppData;
	pProgDetails->Length = cb;
	_wpQueryProgDetails( somSelf, pProgDetails, &cb );
	if( !pProgDetails->pszExecutable || !strlen(pProgDetails->pszExecutable) )
	{
		//MyMsgBox("App not set 2","");
		free( pAppData );
		return 1;
	}
	// App-Namen ohne Pfad & Extension extrahieren
	pAppName = (char*)GetAppName( pProgDetails->pszExecutable );
	strlwr( pAppName );

	//MyMsgBox("In OpenExe", "" );

	SendCommand(pProgDetails->pszExecutable,pAppName,"APPEAR",0,0,"",
		(WPObject*)somSelf, pFct, hwndCnr );
/*
BOOL SendCommand( PSZ pFullAppPath, PSZ pApp, PSZ pCommand, PSZ* pDocNames,
	USHORT nDocNameCount,
	PSZ pDeviceName, WPObject* pObject, AppOpenFct pFct, HWND hwndCnr )
*/

	if( pAppName )
		free( pAppName );
	free( pAppData );

	return 0;
}




