/*************************************************************************
 *
 *  $RCSfile: helpopt.hxx,v $
 *
 *  $Revision: 1.7.286.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/15 15:06:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef INCLUDED_SVTOOLS_HELPOPT_HXX
#define INCLUDED_SVTOOLS_HELPOPT_HXX

#include <list>
#include <tools/string.hxx>

typedef std::list< sal_Int32 > IdList;

class SvtHelpOptions_Impl;
class SvtHelpOptions
{
    SvtHelpOptions_Impl*    pImp;

public:
                    SvtHelpOptions();
                    ~SvtHelpOptions();

    void            SetExtendedHelp( sal_Bool b );
    sal_Bool        IsExtendedHelp() const;
    void            SetHelpTips( sal_Bool b );
    sal_Bool        IsHelpTips() const;

    void            SetHelpAgentAutoStartMode( sal_Bool b );
    sal_Bool        IsHelpAgentAutoStartMode() const;
	void			SetHelpAgentTimeoutPeriod( sal_Int32 _nSeconds );
	sal_Int32		GetHelpAgentTimeoutPeriod( ) const;
	void			SetHelpAgentRetryLimit( sal_Int32 _nTrials );
	sal_Int32		GetHelpAgentRetryLimit( ) const;

    void            SetHelpOnStartupAvailable( sal_Bool b );
    sal_Bool        IsHelpOnStartupAvailable() const;

    const String&   GetHelpStyleSheet()const;
    void            SetHelpStyleSheet(const String& rStyleSheet);

    /** retrieves the help agent's ignore counter for the given URL.
		<p>	If the counter returned 0, the agent should silently drop any requests for this URL.<br/>
			If the counter is greater 0, the agent should display the URL and, if the user ignores it,
			decrement the counter by 1.
		</p>
	*/
	sal_Int32		getAgentIgnoreURLCounter( const ::rtl::OUString& _rURL );
	/** decrements the help agent's ignore counter for the given URL
		@see getAgentIgnoreURLCounter
	*/
	void			decAgentIgnoreURLCounter( const ::rtl::OUString& _rURL );
	/** resets the help agent's ignore counter for the given URL
	*/
	void			resetAgentIgnoreURLCounter( const ::rtl::OUString& _rURL );
	/** resets the help agent's ignore counter for all URL's
	*/
	void			resetAgentIgnoreURLCounter();

    void            SetWelcomeScreen( sal_Bool b );
    sal_Bool        IsWelcomeScreen() const;

    IdList*         GetPIStarterList();
    void            AddToPIStarterList( sal_Int32 nId );
    void            RemoveFromPIStarterList( sal_Int32 nId );

	String			GetLocale() const;
	String			GetSystem() const;
};

#endif

