/*************************************************************************
 *
 *  $RCSfile: PropertyEditor.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:54:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package stardiv.controller;

public class PropertyEditor extends java.awt.Dialog
	implements java.awt.event.ItemListener,
				java.awt.event.ActionListener,
				java.awt.event.TextListener
{
    /** A table of hex digits */
    private static final char[] hexDigit =
    	{'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};

	static final String FILENAME = "staroffice.properties";
	static final char DELEMITER = ' ';

	static java.util.Vector c_DefaultProperties = null;

    java.util.Properties m_Properties = new java.util.Properties();
    java.awt.List m_DefaultList = new java.awt.List();
    java.awt.List m_List = new java.awt.List();
    java.awt.TextField m_KeyInput = new java.awt.TextField();
    java.awt.TextField m_ValueInput = new java.awt.TextField();
    java.awt.Button m_SetButton = new java.awt.Button("   set   ");
    java.awt.Button m_DeleteButton = new java.awt.Button("  delete  ");
    java.awt.Button m_OkButton = new java.awt.Button("   OK   ");
    char[] m_Delemiters = new char[0];

    public PropertyEditor(java.awt.Frame parent)
    {
        super(parent, "Java Property Editor");

		// setting the layout and adding the components
        java.awt.Panel mainPanel = new java.awt.Panel(new java.awt.GridBagLayout());
        mainPanel.setBackground(java.awt.Color.lightGray);

        java.awt.GridBagConstraints constraints = new java.awt.GridBagConstraints();
        constraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        constraints.insets = new java.awt.Insets(10, 10, 0, 10);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = java.awt.GridBagConstraints.BOTH;
        m_DefaultList.setBackground(java.awt.Color.white);
        mainPanel.add(m_DefaultList, constraints);
        m_List.setBackground(java.awt.Color.white);
        mainPanel.add(m_List, constraints);

        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        constraints.gridwidth = java.awt.GridBagConstraints.RELATIVE;
        mainPanel.add(new java.awt.Label("variable:"), constraints);
        constraints.weightx = 1.0;
        constraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        m_KeyInput.setBackground(java.awt.Color.white);
        mainPanel.add(m_KeyInput, constraints);

        constraints.weightx = 0.0;
        constraints.gridwidth = java.awt.GridBagConstraints.RELATIVE;
        mainPanel.add(new java.awt.Label("value:"), constraints);
        constraints.weightx = 1.0;
        constraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        m_ValueInput.setBackground(java.awt.Color.white);
        mainPanel.add(m_ValueInput, constraints);

		java.awt.Panel buttonPanel = new java.awt.Panel(
			new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 10, 0));
        buttonPanel.add(m_SetButton);
        buttonPanel.add(m_DeleteButton);

        constraints.weightx = 0.0;
        constraints.fill = java.awt.GridBagConstraints.NONE;
        constraints.anchor = java.awt.GridBagConstraints.WEST;
        constraints.gridwidth = java.awt.GridBagConstraints.RELATIVE;
        constraints.insets = new java.awt.Insets(10, 10, 10, 0);
        mainPanel.add(m_OkButton, constraints);
        constraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        constraints.anchor = java.awt.GridBagConstraints.EAST;
        mainPanel.add(buttonPanel, constraints);

        add(mainPanel);

        // set the font
        java.awt.Font font = new java.awt.Font("Courier", java.awt.Font.PLAIN, 10);

	    m_List.setFont(font);
	    m_DefaultList.setFont(font);

        // add the listeners
        addWindowListener(new java.awt.event.WindowAdapter()
        {
        	public void windowClosing(java.awt.event.WindowEvent evt)
        	{
        		setVisible(false);
        	}
        });

        m_KeyInput.addTextListener(this);
        m_ValueInput.addTextListener(this);

        m_ValueInput.addKeyListener(new java.awt.event.KeyAdapter()
        {
        	public void keyReleased(java.awt.event.KeyEvent evt)
        	{
        		if (evt.getKeyChar() == java.awt.event.KeyEvent.VK_BACK_SLASH)
        		{
			        int caretPosition = m_ValueInput.getCaretPosition();

	                m_ValueInput.setText(
	                	m_ValueInput.getText().substring(0, caretPosition)
	                	+ "\\"
	                	+ m_ValueInput.getText().substring(caretPosition));
	                m_ValueInput.setCaretPosition(++caretPosition);
        		}
        	}
        });

        m_SetButton.setEnabled(false);
        m_DeleteButton.setEnabled(false);

        m_OkButton.addActionListener(this);
        m_SetButton.addActionListener(this);
        m_DeleteButton.addActionListener(this);
        m_List.addItemListener(this);

        setSize(500, 600);
    }

    public void setVisible(boolean isVisible)
    {
    	if (isVisible)
    	{
	        try
	        {
	            m_Properties = System.getProperties();
	        }
	        catch (Exception ignore) {}

			actualizeDelemiterArray();

			m_DefaultList.removeAll();
			m_List.removeAll();
	        java.util.Enumeration enum = m_Properties.propertyNames();
	        while (enum.hasMoreElements())
	        {
	            String strKey = (String)enum.nextElement();

	            if (isDefaultKey(strKey))
	            	addToList(m_DefaultList, strKey, m_Properties.getProperty(strKey));
	            else
	            	addToList(m_List, strKey, m_Properties.getProperty(strKey));
	        }
    	}

    	super.setVisible(isVisible);
    }

    protected void actualizeDelemiterArray()
    {
		int nMaxKeyLength = getMaxKeyLength(m_Properties);

		if (nMaxKeyLength != m_Delemiters.length)
		{
			m_Delemiters = new char[nMaxKeyLength];
			for (int i=0; i<nMaxKeyLength; i++)
				m_Delemiters[i] = DELEMITER;
		}
    }

    public void itemStateChanged(java.awt.event.ItemEvent evt)
    {
		String strSelected = m_List.getSelectedItem();

		if (strSelected != null)
		{
			String[] str = getKeyValue(strSelected);

				m_KeyInput.setText(str[0]);
				m_ValueInput.setText(str[1]);
		}
		else
		{
			m_KeyInput.setText("");
			m_ValueInput.setText("");
		}
    }

    protected String[] getKeyValue(String str)
    {
    	String[] ret = { "", "" };
		java.util.StringTokenizer st = new java.util.StringTokenizer(str, " ");

		if (st.hasMoreTokens())
			ret[0] = st.nextToken();

		if (st.hasMoreTokens())
			ret[1] = st.nextToken();

		while (st.hasMoreTokens())
			ret[1] = ret[1] + " " + st.nextToken();

		return ret;
    }

    public void actionPerformed(java.awt.event.ActionEvent evt)
    {
        if (evt.getSource() == m_OkButton)
        		setVisible(false);
        else
        {
        	m_KeyInput.setText(m_KeyInput.getText().trim());
        	m_ValueInput.setText(m_ValueInput.getText().trim());

        	if (isDefaultKey(m_KeyInput.getText()))
        		return;

        	java.util.Properties tempProperties =
        		(java.util.Properties)m_Properties.clone();

        	if (evt.getSource() == m_SetButton)
        		tempProperties.put(m_KeyInput.getText(),
        			convertOutToString(m_ValueInput.getText()));
        	else if (evt.getSource() == m_DeleteButton)
        		tempProperties.remove(m_KeyInput.getText());

        	try
        	{
        		System.setProperties(tempProperties);
        		m_Properties = tempProperties;
	        	saveProperties();

	        	if (evt.getSource() == m_SetButton)
	        	{
	        		String[] items = m_List.getItems();

	        		int nFound = -1;
	        		for (int i=0; i<items.length; i++)
	        		{
	        			if (items[i].startsWith(m_KeyInput.getText() + DELEMITER))
	        				nFound = i;
	        		}

	        		if (nFound != -1)
	        			m_List.replaceItem(createListItem(m_KeyInput.getText(),
	        				convertOutToString(m_ValueInput.getText())), nFound);
	        		else
	        			nFound = addToList(m_List, m_KeyInput.getText(), m_ValueInput.getText());

	        		m_List.select(nFound);
	        	}
	        	else if (evt.getSource() == m_DeleteButton)
	        	{
	        		String[] items = m_List.getItems();

	        		for (int i=0; i<items.length; i++)
	        		{
	        			if (items[i].startsWith(m_KeyInput.getText() + DELEMITER))
	        				m_List.remove(i);
	        		}
	        	}

	        	updateDelemiters();
        	}
        	catch (Exception ignore) {}

        	setButtons();
        }
    }

    public void textValueChanged(java.awt.event.TextEvent evt)
    {
    	setButtons();
    }

    protected void setButtons()
    {
		if ( (!m_KeyInput.getText().trim().equals(""))
			&& (m_KeyInput.getText().trim().indexOf(DELEMITER, 0) == -1)
			&& (!isDefaultKey(m_KeyInput.getText().trim())) )
		{
			try
			{
				if (System.getProperty(m_KeyInput.getText()) != null)
		    		m_DeleteButton.setEnabled(true);
		    	else
		    		throw new Exception();
		    }
		    catch (Exception e)
		    {
		    	m_DeleteButton.setEnabled(false);
		    }

    		m_SetButton.setEnabled(!m_ValueInput.getText().trim().equals(""));
		}
		else
		{
    		m_DeleteButton.setEnabled(false);
    		m_SetButton.setEnabled(false);
    	}
    }

    protected int addToList(java.awt.List list, String strKey, String strValue)
    {
    	String[] items = list.getItems();

		String strItem = createListItem(strKey, strValue);

    	int nIndex = 0;
    	while ((nIndex < items.length) && (items[nIndex].compareTo(strItem) < 0))
    		nIndex++;

	    list.addItem(strItem, nIndex);

	    return nIndex;
    }

    protected void updateDelemiters()
    {
    	int nMax = getMaxKeyLength(m_Properties);

    	if (nMax != m_Delemiters.length)
    	{
    		actualizeDelemiterArray();

    		updateDelemiters(nMax, m_List);
    	}
    }

    protected void updateDelemiters(int nMax, java.awt.List list)
    {
    	list.setVisible(false);

		String[] items = list.getItems();

		for (int i=0; i<items.length; i++)
		{
			String[] keyValue = getKeyValue(items[i]);
			list.replaceItem(createListItem(keyValue[0], keyValue[1]), i);
		}

		list.setVisible(true);
    }

    protected String createListItem(String strKey, String strValue)
    {
    	char[] delim = null;

    	if (m_Delemiters.length - strKey.length() > 0)
    	{
			delim = new char[m_Delemiters.length-strKey.length()];
			for (int j=0; j<m_Delemiters.length-strKey.length(); j++)
				delim[j] = DELEMITER;
		}
		else
		{
			delim = new char[1];
			delim[0] = DELEMITER;
		}

		return strKey + new String(delim) + convertStringToOut(strValue);
    }

    protected static String convertStringToOut(String str)
    {
    	StringBuffer sb = new StringBuffer(str.length());

	    for (int i = 0 ; i < str.length() ; i++)
	    {
			char ch = str.charAt(i);

			switch (ch)
			{
				case '\\': sb.append('\\'); sb.append('\\'); break;
				case '\t': sb.append('\\'); sb.append('t'); break;
				case '\n': sb.append('\\'); sb.append('n'); break;
				case '\r': sb.append('\\'); sb.append('r'); break;

				default:
					if ((ch < ' ') || (ch >= 127))
					{
					    sb.append('\\');
					    sb.append('u');
					    sb.append(toHex((ch >> 12) & 0xF));
					    sb.append(toHex((ch >>  8) & 0xF));
					    sb.append(toHex((ch >>  4) & 0xF));
					    sb.append(toHex((ch >>  0) & 0xF));
				    }
				    else
				    {
						sb.append(ch);
				    }
			}
		}

    	return sb.toString();
    }

    protected static String convertOutToString(String str)
    {
    	StringBuffer sb = new StringBuffer(str.length());

    	if (str.length() > 1)
    	{
	    	int nPos = 0;
	    	char next, ch = str.charAt(0);
	    	while (nPos < str.length()-1)
	    	{
	    		next = str.charAt(++nPos);

	    		if (ch == '\\')
	    		{
	    			if (next == '\\')
	    				sb.append('\\');
	    			else if (next == 't')
	    				sb.append('\t');
	    			else if (next == 'n')
	    				sb.append('\n');
	    			else if (next == 'r')
	    				sb.append('\r');
	    			else if (next == 'u')
	    			{
	    				if (nPos + 5 <= str.length())
	    				{
	    					int nVal = hexToInt(str.substring(nPos+1, nPos+5));

	    					if (nVal != -1)
	    					{
	    						sb.append((char)nVal);
	    						nPos += 4;
	    						next = str.charAt(nPos);
	    					}
	    					else
	    						sb.append("\\");
	    				}
	    				else
	    					sb.append("\\u");
	    			}
	    			else
	    			{
	    				sb.append('\\');
	    				sb.append(next);
	    			}

	    			next = str.charAt(++nPos);
	    		}
	    		else
	    			sb.append(ch);

	    		ch = next;

	    		if (nPos == str.length()-1)
	    			sb.append(ch);
	    	}
	    }
	    else
	    	return str;

	    return sb.toString();
    }

	protected static int hexToInt(String str)
	{
		if (str.length() != 4)
			return -1;

		int nValue = 0;
		for (int i=0; i<4; i++)
		{
			char ch = str.charAt(i);

			if ((ch >= 'A') && (ch <= 'Z'))
				nValue += (ch-'A'+10)*Math.pow(16,3-i);
			else if ((ch >= 'a') && (ch <= 'f'))
				nValue += (ch-'a'+10)*Math.pow(16,3-i);
			else if ((ch >= '0') && (ch <= '9'))
				nValue += (ch-'0')*Math.pow(16,3-i);
			else
				return -1;
		}

		return nValue;
	}

    /**
     * Convert a nibble to a hex character
     * @param	nibble	the nibble to convert.
     */
    private static char toHex(int nibble)
    {
		return hexDigit[(nibble & 0xF)];
    }

    protected static int getMaxKeyLength(java.util.Properties props)
    {
    	int nMax = 0;

    	java.util.Enumeration enum = props.propertyNames();
    	while (enum.hasMoreElements())
    		nMax = Math.max(nMax, ((String)enum.nextElement()).length());

    	return nMax+2;
    }

    protected static boolean isDefaultKey(String strKey)
    {
    	java.util.Enumeration enum = c_DefaultProperties.elements();
    	while (enum.hasMoreElements())
    	{
    		if (strKey.equals((String)enum.nextElement()))
    			return true;
    	}

    	return false;
    }

    protected void saveProperties()
    {
    	java.util.Properties saveProps = new java.util.Properties();

    	java.util.Enumeration enum = m_Properties.propertyNames();
    	while (enum.hasMoreElements())
    	{
    		String strKey = (String)enum.nextElement();

    		if (!isDefaultKey(strKey))
	    		saveProps.put(strKey, m_Properties.getProperty(strKey));
    	}

    	// try to save the properties to java.home
    	// this might fail if java.home is a network location
    	try
    	{
    		saveProperties(saveProps, System.getProperty("java.home"));
    		return;
    	}
    	catch (Exception ignore1) {}

    	// if no access, try to save the properties to user.home
		try
		{
    		saveProperties(saveProps, System.getProperty("user.home"));
    		return;
		}
		catch (Exception ignore2) {}
    }

    protected static void saveProperties(java.util.Properties props, String strPath)
    	throws java.io.IOException
    {
		if (!strPath.endsWith(java.io.File.separator))
			strPath = strPath + java.io.File.separator;

		strPath = strPath + FILENAME;

		java.io.FileOutputStream fos = new java.io.FileOutputStream(strPath);
		props.save(fos, "properties");
		fos.flush();
		fos.close();
    }

    private static void initializeProperties()
    {
    	if (c_DefaultProperties == null)
    	{
    		c_DefaultProperties = new java.util.Vector();

	    	try
	    	{
	    		java.util.Enumeration enum = System.getProperties().propertyNames();
	    		while (enum.hasMoreElements())
	    			c_DefaultProperties.addElement(enum.nextElement());
	    	}
	    	catch (Exception ignore0) {}
	    }


    	java.util.Properties props = new java.util.Properties();

    	// first try to load the properties from user.home
    	try
    	{
    		loadProperties(props, System.getProperty("user.home"));
    	}
    	catch (Exception e)
    	{
	    	// if no access, try to load the properties from java.home
	    	try
	    	{
	    		loadProperties(props, System.getProperty("java.home"));
	    	}
	    	catch (Exception ignore1) {}
		}

    	java.util.Properties newProps = new java.util.Properties();

    	try
    	{
    		newProps = (java.util.Properties)System.getProperties().clone();
    	}
    	catch (Exception ignore2) {}

    	java.util.Enumeration enum = props.propertyNames();
    	while (enum.hasMoreElements())
    	{
    		String propKey = (String)enum.nextElement();

    		// if the key is not a default put the new property into the table
    		if (!isDefaultKey(propKey))
    			newProps.put(propKey, props.get(propKey));
    	}

    	System.setProperties(newProps);
    }

    protected static void loadProperties(java.util.Properties props, String strPath)
    	throws java.io.IOException, ClassNotFoundException
    {
		if (!strPath.endsWith(java.io.File.separator))
			strPath = strPath + java.io.File.separator;

		strPath = strPath + FILENAME;

		java.io.FileInputStream fis = new java.io.FileInputStream(strPath);
		props.load(fis);
		fis.close();
    }

    public static void main(String[] args)
    {
    	PropertyEditor.initializeProperties();
        java.awt.Frame frame = new java.awt.Frame();
        PropertyEditor editor = new PropertyEditor(frame);
        editor.setVisible(true);
    }
}


