/*************************************************************************
 *
 *  $RCSfile: metaaccessor.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: tra $ $Date: 2002/08/26 10:53:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONFIG_HXX_
#include "config.hxx"
#endif

#ifndef _METAACCESSOR_HXX_
#include "metaaccessor.hxx"
#endif

#ifndef _XMLPRSR_HXX_
#include "xmlprsr.hxx"
#endif

#ifndef SAXDOCHDL_HXX_
#include "saxdochdl.hxx"
#endif

#ifndef _SAXPRSREXCPTN_HXX_
#include "saxprsrexcptn.hxx"
#endif

#ifndef _DBGMACROS_H_
#include "dbgmacros.hxx"
#endif

//-------------------------------
/** ctor
		
	@param DocumentName
	the name of the document to 
	access

	@throws IOException if the 
	specified file could not be
	accessed
*/
DocumentMetaInfoAccessor::DocumentMetaInfoAccessor(const std::string& DocumentName) :
	m_ZipArchive(DocumentName)
{
}

//-------------------------------
/** dtor
*/
DocumentMetaInfoAccessor::~DocumentMetaInfoAccessor()
{
}

//-------------------------------
/** Read the requested meta 
	information. The caller has 
	to fill the MetaInfoList with
	the names of the requested 
	meta information and default
	values in case a meta 
	information was not found, e.g.

	<code>

	MetaInfo["title"]   = "Default title";
	MetaInfo["invalid"] = "Invalid";
	...

	Read(MetaInfo);
	...

	</code>

	@precond read access granted
*/
void DocumentMetaInfoAccessor::Read(/*inout*/ XmlTags_t& RequestedMetaInfo)
{
	try
	{
		if (m_ZipContent.empty())
			m_ZipArchive.GetUncompressedContent(META_CONTENT_NAME, m_ZipContent);
	
		SaxParser parser;
		CSaxDocumentHandler DocHandler(RequestedMetaInfo);

		parser.SetDocumentHandler(&DocHandler);
		parser.Parse(&m_ZipContent[0], m_ZipContent.size());		
	}
	catch(SaxParserException& ex)
	{
		ENSURE(false, ex.what());
	}	
	catch(...)
	{
		ENSURE(false, "Unknown error");
	}
}

