/*************************************************************************
 *
 *  $RCSfile: tbxchild.cxx,v $
 *
 *  $Revision: 1.34 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/15 10:54:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef SOLARIS
// HACK: prevent conflict between STLPORT and Workshop headers on Solaris 8
#include <ctime>
#endif

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
#include <com/sun/star/util/XURLTransformer.hpp>
#endif

#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_MISCOPT_HXX
#include <svtools/miscopt.hxx>
#endif
#include <svtools/imageitm.hxx>
#include <svtools/eitem.hxx>
#include <comphelper/processfactory.hxx>


#pragma hdrstop

#include "tbxchild.hxx"
#include "tbxmgr.hxx"
#include "dispatch.hxx"
#include "tbxctrl.hxx"
#include "resmgr.hxx"
#include "app.hxx"
#include "objface.hxx"
#include "bindings.hxx"
#include "workwin.hxx"
#include "viewfrm.hxx"
#include "genlink.hxx"
#include "tbxcust.hxx"
#include "toolbox.hrc"
#include "mnumgr.hxx"
#include "tbxconf.hxx"
#include "msgpool.hxx"
#include "virtmenu.hxx"
#include "childwin.hxx"
#include "cfgmgr.hxx"
#include "request.hxx"
#include "objsh.hxx"
#include "docfile.hxx"

using namespace rtl;
using namespace com::sun::star::uno;
using namespace com::sun::star::frame;
using namespace com::sun::star::util;

class SfxToolBoxImageControl_Impl : public SfxControllerItem
{
    SfxToolbox*         pToolBox;
    long                lRotation;
    BOOL                bIsMirrored;

protected:
    virtual void        StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState );
public:
                        SfxToolBoxImageControl_Impl( USHORT nSlotId, SfxBindings& rBindings, SfxToolbox* pBox )
                            : SfxControllerItem( nSlotId, rBindings )
                            , pToolBox( pBox )
                            , lRotation( 0 )
                            , bIsMirrored( FALSE )
                        {}
    void                Update();
};

void SfxToolBoxImageControl_Impl::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
{
    const SfxImageItem* pItem = PTR_CAST( SfxImageItem, pState );
    if ( pItem )
    {
        lRotation = pItem->GetRotation();
        bIsMirrored = pItem->IsMirrored();
    }

    Update();
}

void SfxToolBoxImageControl_Impl::Update()
{
    SfxViewFrame* pViewFrame = GetBindings().GetDispatcher_Impl()->GetFrame();
    SfxSlotPool& rPool = SFX_APP()->GetSlotPool( pViewFrame );
    for (USHORT nPos = 0; nPos<pToolBox->GetItemCount(); nPos++)
    {
        USHORT nId = pToolBox->GetItemId( nPos );
        const SfxSlot* pSlot = rPool.GetSlot( nId );
        if ( pSlot && pSlot->IsMode( SFX_SLOT_IMAGEROTATION ) )
        {
            pToolBox->SetItemImageMirrorMode( nId, FALSE );
            pToolBox->SetItemImageAngle( nId, lRotation );
        }
        if ( pSlot && pSlot->IsMode( SFX_SLOT_IMAGEREFLECTION ) )
            pToolBox->SetItemImageMirrorMode( nId, bIsMirrored );
    }
}

class SfxToolBox_Impl
{
public:
    Timer                   aTimer;
    Point                   aPos;
    Point                   aFloatPos;
    SfxToolBoxControl*      pControl;
    SfxPopupWindow*         pPopup;
    SfxToolbox*             pToolBox;
    SfxToolBoxImageControl_Impl*
                            pImageControl;

						SfxToolBox_Impl( SfxToolbox *pBox )
							: pControl( 0 )
							, pPopup( 0 )
                            , pImageControl( 0 )
							, pToolBox( pBox )
						{
							aTimer.SetTimeout( 250 );
							aTimer.SetTimeoutHdl( LINK( this, SfxToolBox_Impl, TimerHdl ) );
						}

	DECL_LINK(			PopupDeleted, void* );
	DECL_LINK( 			TimerHdl, Timer* );
	void				EndPopupMode();
};

IMPL_LINK( SfxToolBox_Impl, PopupDeleted, void*, pVoid )
{
	pPopup = 0;
	pControl = 0;
	return 0L;
}

IMPL_LINK( SfxToolBox_Impl, TimerHdl, Timer*, pTimer )
{
	if ( !pControl )
		return 0L;

	pControl->GetBindings().ENTERREGISTRATIONS();
	pPopup = pControl->CreatePopupWindowCascading();
	pControl->GetBindings().LEAVEREGISTRATIONS();

	if ( pPopup )
	{
		pPopup->SetDeleteLink_Impl( LINK( this, SfxToolBox_Impl, PopupDeleted ) );
		Rectangle aRect = pToolBox->GetItemRect( pControl->GetId() );
		Point aPos;
        aPos = pPopup->GetParent()->
            OutputToScreenPixel( pPopup->GetParent()->AbsoluteScreenToOutputPixel( pToolBox->OutputToAbsoluteScreenPixel(aRect.TopLeft() ) ) );
		aRect.SetPos( aPos );
		pPopup->StartPopupMode( aRect, 0 );
	}
	else
		pControl = 0;

	return 0L;
}

void SfxToolBox_Impl::EndPopupMode()
{
	DBG_ASSERT( pControl && pPopup, "EndPopupMode ohne Popup!" );
	if ( !pPopup )
	{
		pControl = 0;
		return;
	}

	pPopup->SetDeleteLink_Impl( Link() );
	pPopup->EndPopupMode();
	pPopup = 0;
	pControl = 0;
}

// Hilfsfunktion zum Umrechnen eines SfxChildAlignments in ein SV-WindowAlign
WindowAlign ConvertAlign_Impl( SfxChildAlignment eAlign )
{
	switch ( eAlign )
	{
		case SFX_ALIGN_HIGHESTTOP:
		case SFX_ALIGN_TOOLBOXTOP:
		case SFX_ALIGN_LOWESTTOP:
		case SFX_ALIGN_TOP:
			return WINDOWALIGN_TOP;
			break;

		case SFX_ALIGN_LOWESTBOTTOM:
		case SFX_ALIGN_BOTTOM:
		case SFX_ALIGN_TOOLBOXBOTTOM:
		case SFX_ALIGN_HIGHESTBOTTOM:
			return WINDOWALIGN_BOTTOM;
			break;

		case SFX_ALIGN_FIRSTLEFT:
		case SFX_ALIGN_LEFT:
		case SFX_ALIGN_LASTLEFT:
		case SFX_ALIGN_TOOLBOXLEFT:
			return WINDOWALIGN_LEFT;
			break;

		case SFX_ALIGN_LASTRIGHT:
		case SFX_ALIGN_RIGHT:
		case SFX_ALIGN_FIRSTRIGHT:
		case SFX_ALIGN_TOOLBOXRIGHT:
			return WINDOWALIGN_RIGHT;
			break;
	}

	DBG_ERROR("Toolboxalign im FloatingMode ?" );
	return WINDOWALIGN_TOP;
}

SfxToolbox::~SfxToolbox()
{
    delete pImp->pImageControl;
	delete pImp;
}

SfxToolbox::SfxToolbox( SfxToolBoxManager &rMgr, Window *pParent, WinBits nBits ):
	ToolBox( pParent, nBits ),
	bEmpty(FALSE),
	bConstructed(FALSE),
	bHelpInitialized(FALSE),
	bCopyCtor(FALSE),
	pMgr( &rMgr ),
	bActivated(FALSE),
	bDeleteToolBox(FALSE),
	bReconfigure(FALSE),
	nPos(0xFFFF),
	aLink( LINK( this, SfxToolbox, TimeHdl ) ),
	nActivated(0)
{
	Construct();
}

SfxToolbox::SfxToolbox( SfxToolBoxManager &rMgr, Window *pParent, ResId &rResId ):
	ToolBox( pParent, rResId ),
	bConstructed(FALSE),
	bHelpInitialized(FALSE),
	bCopyCtor(FALSE),
	bEmpty(FALSE),
	bWaitSuppressed(FALSE),
	pMgr( &rMgr ),
	bActivated(FALSE),
	bDeleteToolBox(FALSE),
	bReconfigure(FALSE),
	nPos(0xFFFF),
	aLink( LINK( this, SfxToolbox, TimeHdl ) ),
	nActivated(0)
{
	Construct();
}

//-------------------------------------------------------------------------

void SfxToolbox::Construct()
{
	pImp = new SfxToolBox_Impl( this );
    pMgr->GetBindings().ENTERREGISTRATIONS();
    pImp->pImageControl = new SfxToolBoxImageControl_Impl( SID_IMAGE_ORIENTATION, pMgr->GetBindings(), this );
    pMgr->GetBindings().LEAVEREGISTRATIONS();
	pControl = 0;
	bMod1 = bMod2 = bShift = FALSE;
	aTimer.SetTimeout( 250 );
	aTimer.SetTimeoutHdl( LINK( this, SfxToolbox, TimeHdl ) );
	aAsyncStoreCfgTimer.SetTimeout( 100 );
	aAsyncStoreCfgTimer.SetTimeoutHdl( LINK( this, SfxToolbox, AsyncStoreCfgHdl ) );
	pMgr->SetHiContrast( IsHiContrastMode() );
//    EnableDrop(TRUE);
}

//--------------------------------------------------------------------

IMPL_LINK( SfxToolbox, Delete, void *, pvoid )
{
	delete pMgr;
	return 0;
}

//-------------------------------------------------------------------------

long SfxToolbox::Notify( NotifyEvent& rNEvt )
{
	return ToolBox::Notify( rNEvt );
}

//-------------------------------------------------------------------------

BOOL SfxToolbox::IsHiContrastMode()
{
	Color aBackColor = GetBackground().GetColor();
	if ( aBackColor.IsDark() )
		return TRUE;
	else
		return FALSE;
}

//-------------------------------------------------------------------------

void SfxToolbox::StateChanged( StateChangedType nType )
{
	ToolBox::StateChanged( nType );

	if ( nType == STATE_CHANGE_CONTROLBACKGROUND )
	{
		// Check if we need to get new images for normal/high contrast mode
		CheckAndUpdateImages();
	}
	else if ( nType == STATE_CHANGE_TEXT )
	{
		// The physical toolbar changed its outlook and shows another logical toolbar!
		// We have to set the correct high contrast mode on the new tbx manager.
		pMgr->SetHiContrast( IsHiContrastMode() );
	}
	else if ( nType == STATE_CHANGE_INITSHOW && pMgr->GetType() == 558 ) // fullscreenbar
	{
		// This code is a special implementation for the fullscreenbar!!
		if ( aFloatPos.X() == LONG_MAX && aFloatPos.Y() == LONG_MAX )
		{
			// Place the fullscreenbar to the right-bottom corner of the window
			// if we don't have a user position!
			Window*		pFloatWindow	= GetFloatingWindow();
            // use absolute screen coordinates here, otherwise floating windows do not include their decoration
			Rectangle   aRect			= pFloatWindow ? pFloatWindow->GetWindowExtentsRelative( NULL ) : GetWindowExtentsRelative( NULL );
            Size        aSize( aRect.GetSize() );
			Size		aWinSize		= GetParent()->GetSizePixel(); // the full screen size

			Point	aNewPos( aWinSize.Width() - 1 - aSize.Width(),
							 aWinSize.Height() - 1 - aSize.Height() );

			const StyleSettings& rSettings = Application::GetSettings().GetStyleSettings();
			long				 aDecoSize = rSettings.GetBorderSize();

            Window* pParent = &(pMgr->GetBindings().GetDispatcher()->GetFrame()->GetWindow());
            if ( pParent->IsScrollable() )
                aDecoSize += rSettings.GetScrollBarSize();

			// Fullscreen mode does always show horz. and vertical scrollbar. Currently it is not possible
			// to detect that a window shows it scrollbars. VCL limitation.
			aNewPos.X() -= aDecoSize;
			aNewPos.Y() -= aDecoSize;

			SetPosPixel( GetParent()->AbsoluteScreenToOutputPixel( aNewPos ));
		}
	}
}

void SfxToolbox::DataChanged( const DataChangedEvent& rDCEvt )
{
	ToolBox::DataChanged( rDCEvt );

	if ((( rDCEvt.GetType() == DATACHANGED_SETTINGS	)	||
		( rDCEvt.GetType() == DATACHANGED_DISPLAY	))	&&
        ( rDCEvt.GetFlags() & SETTINGS_STYLE		))
	{
		// Check if we need to get new images for normal/high contrast mode
		CheckAndUpdateImages();
	}

    for ( USHORT nPos = 0; nPos<GetItemCount(); ++nPos )
	{
        const USHORT nId = GetItemId(nPos);
        Window* pWindow = GetItemWindow( nId );
        if ( pWindow )
            pWindow->DataChanged( rDCEvt );
    }

    if ( !IsFloatingMode() )
    {
        Size aActSize( GetSizePixel() );
        Size aSize( CalcWindowSizePixel() );
        if ( IsHorizontal() )
            aSize.Width() = aActSize.Width();
        else
            aSize.Height() = aActSize.Height();

        SetSizePixel( aSize );
    }
}

//-------------------------------------------------------------------------

void SfxToolbox::CheckAndUpdateImages()
{
    BOOL bRefreshImages = FALSE;

    // Check if high contrast/normal mode have changed
	if ( IsHiContrastMode() )
	{
		if ( !pMgr->IsHiContrast() )
		{
            bRefreshImages = TRUE;
			pMgr->SetHiContrast( TRUE );
		}
	}
	else if ( pMgr->IsHiContrast() )
    {
        bRefreshImages = TRUE;
	    pMgr->SetHiContrast( FALSE );
	}
	
    // Refresh images if requested
    if ( bRefreshImages )
        pMgr->RefreshImages_Impl();
}

//-------------------------------------------------------------------------

USHORT SfxToolbox::GetItemAt( const CommandEvent &rEvt )
{
	Point aMousePos = rEvt.GetMousePosPixel();
	for (USHORT nPos = 0; nPos<GetItemCount(); nPos++)
	{
		USHORT nId = GetItemId( nPos );
		Rectangle aItemRect( GetItemRect( nId ) );
		if ( aItemRect.IsInside( aMousePos ) )
			return nId;
	}

	return 0;
}


//-------------------------------------------------------------------------

void SfxToolbox::MouseMove( const MouseEvent& rMEvt )
{
	Point aPos;
	if ( GetParent()->GetType() == RSC_FLOATINGWINDOW
		&& ((FloatingWindow*)GetParent())->IsInPopupMode() )
	{
		aPos = rMEvt.GetPosPixel();
		USHORT nId = GetItemId( aPos );
		pControl = pMgr->FindControl_Impl( nId );
		if ( pControl )
		{
			SfxPopupWindowType eType = pControl->GetPopupWindowType();
			if ( SFX_POPUPWINDOW_ONTIMEOUTANDMOVE == eType ||
				 SFX_POPUPWINDOW_ONCLICKANDMOVE == eType )
			{
				// Es k"onnte ein kaskadierendes Popup angefordert werden
				if ( !pImp->pControl || pImp->pControl->GetId() != nId )
				{
					// Id merken; wenn nach Ablauf des Timers der Mauszeiger
					// immer noch auf dem Control steht, wird das Popup
					// aufgeklappt
					if ( pImp->pPopup )
						pImp->EndPopupMode();

					pImp->pControl = pControl;
					pImp->aTimer.Start();
				}
			}
		}
	}

	if ( pImp->pControl )
	{
		if ( pImp->pPopup )
		{
			// Das Popup ist offen; wenn der Mauszeiger ein anderes Control
			// erreicht hat, wird das Popup geschlossen
			BOOL bEnd = FALSE;

			Rectangle aRect( pImp->pPopup->GetPosPixel(), pImp->pPopup->GetSizePixel() );

			Point aScrPos = OutputToScreenPixel( aPos );
			BOOL bOverPopup = aRect.IsInside( aScrPos );

			if ( pControl && pImp->pControl != pControl && !bOverPopup )
				bEnd = TRUE;
			if ( bEnd )
				pImp->EndPopupMode();
		}
		else if ( pImp->pControl != pControl )
		{
			// Bevor das Popup ge"offnet wurde, hat der Mauszeiger das
			// Control verlassen
			pImp->aTimer.Stop();
			pImp->pControl = 0;
		}

		// Mausposition merken
		pImp->aPos = aPos;
	}

	ToolBox::MouseMove( rMEvt );
	return;
/*
	if ( SID_BROWSE_STOP == GetItemId( rMEvt.GetPosPixel() ) )
	{
		Application::LeaveWait();
		bWaitSuppressed = TRUE;
	}
	else if ( bWaitSuppressed )
		Application::EnterWait();
*/
}

//-------------------------------------------------------------------------

void SfxToolbox::MouseButtonDown( const MouseEvent& rMEvt )
{
	// um im Click zu wissen, ob Ctrl gedr"uckt wurde
	bMod1 = rMEvt.IsMod1();
	bMod2 = rMEvt.IsMod2();
	bShift = rMEvt.IsShift();

	// Es mu\s "uberpr"uft werden, ob die Toolbox konfigurierbar ist.
	// Wenn nicht, wird der Handler der Basisklasse nur aufgerufen, wenn
	// die Maus "uber einem Item steht, damit kein Docking erfolgt.
	BOOL bCancel = FALSE;
	Point aMousePos = rMEvt.GetPosPixel();
	if ( !IsCustomize() )
	{
		// Nicht konfigurierbare Toolbox
		bCancel = TRUE;
		for (USHORT nPos = 0; nPos<GetItemCount(); nPos++)
		{
			USHORT nId = GetItemId( nPos );
			Rectangle aItemRect( GetItemRect( nId ) );
			if ( aItemRect.IsInside( aMousePos ) )
			{
				// Maus "uber Item
				bCancel = FALSE;
				break;
			}
		}
	}

	if ( bCancel )
	{
		// Wenn nicht "uber einem Item, dann vielleicht "uber den Scroll-
		// pfeilen ?

		Rectangle aRect = GetScrollRect();
		if ( aRect.IsInside( aMousePos ) )
			bCancel = FALSE;
	}

	// Soll abgebrochen werden ?
	if ( !bCancel )
		ToolBox::MouseButtonDown( rMEvt );
}

//-------------------------------------------------------------------------

void SfxToolbox::MouseButtonUp( const MouseEvent& rMEvt )
{
	bMod1 = bMod2 = bShift = FALSE;
	if ( pImp->pPopup )
	{
		Rectangle aRect( pImp->pPopup->GetPosPixel(), pImp->pPopup->GetSizePixel() );
		USHORT nId = pImp->pControl->GetId();
		Point aPos = rMEvt.GetPosPixel();
		Point aScrPos = OutputToScreenPixel( aPos );

		// Die Berechnung f"ur den kaskadierten Modus beruht darauf, da\s das
		// Popupwindow keine Titlebar hat; im MouseButtonUp ist das aber nicht
		// gew"ahrleistet; daher Position korrigieren ( f"uhrt zu einem
		// Fehler der Gr"o\se des Borders des FloatingWindows ).
		pImp->EndPopupMode();

		// Den Vater-Kontroller von der ausgef"uhrten Id unterrichten, sofern
		// die Funktion auch tats"achlich ausgef"uhrt wird
		if( aRect.IsInside( aScrPos ) )
		{
			USHORT nControllerId = ((SfxPopupWindow*)GetParent())->GetId();
			SfxUInt16Item aItem( nControllerId, nId );
			pMgr->GetBindings().GetDispatcher_Impl()->Execute(
					nControllerId, SFX_CALLMODE_SYNCHRON, &aItem, 0L );
		}
	}

	ToolBox::MouseButtonUp( rMEvt );
}

//-------------------------------------------------------------------------

void SfxToolbox::Click()
{
	// Wenn die ToolBox zum Deleten vorgemerkt ist, soll nichts mehr
	// selektiert werden koennen.
	if (bDeleteToolBox)
		return;

	pControl = pMgr->FindControl_Impl( GetCurItemId() );
	if ( pControl )
	{
		pControl->Click();

		SfxPopupWindowType eType = pControl->GetPopupWindowType();
		if ( SFX_POPUPWINDOW_ONTIMEOUT == eType ||
			 SFX_POPUPWINDOW_ONTIMEOUTANDMOVE == eType )
		{
            if( IsKeyEvent() )
            {
                if( IsShift() )
                {
		            pMgr->GetBindings().ENTERREGISTRATIONS();
			        Window *pWin = pControl->CreatePopupWindow();
                    if( pWin )
                    {
                        // enable dialog key handling for popup when activated through keyboard
                        pWin->SetStyle( (pWin->GetStyle() | WB_DIALOGCONTROL) & ~(WB_NODIALOGCONTROL|WB_TABSTOP) );
                        pWin->GrabFocus();
                    }
		            pMgr->GetBindings().LEAVEREGISTRATIONS();
                }
            }
            else if ( bShift )
            {
		        pMgr->GetBindings().ENTERREGISTRATIONS();
				pControl->CreatePopupWindow();
		        pMgr->GetBindings().LEAVEREGISTRATIONS();
            }
			else
				aTimer.Start();
		}
		else if ( SFX_POPUPWINDOW_ONCLICK == eType ||
				 SFX_POPUPWINDOW_ONCLICKANDMOVE == eType )
            {
		        pMgr->GetBindings().ENTERREGISTRATIONS();
			    Window *pWin = pControl->CreatePopupWindow();
                if( IsKeyEvent() && pWin )
                {
                    // enable dialog key handling for popup when activated through keyboard
                    pWin->SetStyle( (pWin->GetStyle() | WB_DIALOGCONTROL) & ~(WB_NODIALOGCONTROL|WB_TABSTOP) );
                    pWin->GrabFocus();
                }
		        pMgr->GetBindings().LEAVEREGISTRATIONS();
            }
	}

	ToolBox::Click();
}

//-------------------------------------------------------------------------

void SfxToolbox::Deactivate()
{
	aTimer.Stop();
	ToolBox::Deactivate();
}


//-------------------------------------------------------------------------

IMPL_LINK_INLINE_START( SfxToolbox, TimeHdl, Timer *, pTimer )
{
    pMgr->GetBindings().ENTERREGISTRATIONS();

	if ( pTimer )
		aLink.Call( 0 );
	else
		pControl->CreatePopupWindow();

    pMgr->GetBindings().LEAVEREGISTRATIONS();
	return 0;
}
IMPL_LINK_INLINE_END( SfxToolbox, TimeHdl, Timer *, pTimer )


IMPL_LINK( SfxToolbox, AsyncStoreCfgHdl, Timer *, pTimer )
{
      pMgr->GetBindings().GetToolBoxConfig()->Configure_Impl( pMgr );
      return 0;
}

//-------------------------------------------------------------------------

void SfxToolbox::Command ( const CommandEvent& rCEvt )
{
    if ( bDeleteToolBox )
        return;

	if ( rCEvt.GetCommand() != COMMAND_CONTEXTMENU )
	{
		ToolBox::Command( rCEvt );
		return;
	}

	USHORT nId = GetItemAt (rCEvt);

    if ( IsInCustomizeMode() && nId )
	{
		// Wenn gerade das "Toolbox bearbeiten"-Fenster aktiv ist, kann durch
		// Click mit der rechten Maustaste auf einen Button das Image des
		// Buttons ausgetauscht werden
		String aText = GetItemText(nId);
        SfxChildWindow *pChild = pMgr->GetBindings().GetDispatcher()->GetFrame()->GetChildWindow( SfxToolboxCustomWindow::GetChildWindowId());
		DBG_ASSERT(pChild,"Wo ist der ToolboxCustomizer ??");

        if ( pChild )
        {
            SfxToolboxCustomizer *pCust =
                (SfxToolboxCustomizer*) pChild->GetWindow();
            SfxUserBitmapDialog_Impl *pDlg =
                pCust->ConnectUserBitmapDialog_Impl( nId, *this, pMgr );
            if (pDlg && pDlg->Execute())
            {
                if ( aText != GetItemText(nId) )
                    pMgr->SetDefault(FALSE);
            }
        }

		return;
	}

	// No context menu if slots/commands SID_CONFIG/SID_TOOLBOXOPTIONS//ConfigureDialog are not enabled
	SfxDispatcher *pDispat = pMgr->GetBindings().GetDispatcher();
    Reference< XFrame > xFrame = pDispat->GetFrame()->GetFrame()->GetFrameInterface();
    if ( xFrame.is() )
    {
        Reference< XDispatchProvider > xProv( xFrame, UNO_QUERY );
        Reference< XURLTransformer > xTrans( ::comphelper::getProcessServiceFactory()->createInstance( 
                                                OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.util.URLTransformer" ))), UNO_QUERY );
        com::sun::star::util::URL aURL;
        aURL.Complete = OUString( RTL_CONSTASCII_USTRINGPARAM( ".uno:ConfigureDialog" ));
        xTrans->parseStrict( aURL );
        Reference< XDispatch > xDisp = xProv->queryDispatch( aURL, ::rtl::OUString(), 0 );
        
        if ( !xDisp.is() )
            return;
    }
    
    // Check also with QueryState to support the old slots.cfg file
    const SfxPoolItem* pDummy = NULL;
    SfxItemState eState1 = pDispat->QueryState( SID_CONFIG, pDummy );
	SfxItemState eState2 = pDispat->QueryState( SID_TOOLBOXOPTIONS, pDummy );
	if (( SFX_ITEM_DISABLED == eState1 ) || ( SFX_ITEM_DISABLED == eState2 ))
		return;

	if ( pMgr->GetBindings().GetDispatcher_Impl()->IsLocked())
		return;

	// Gegen Zerst"orung sch"utzen
	bActivated = 2;
    if ( !pMgr->IsInternal() && pMgr->GetBindings().GetDispatcher_Impl() )
	{
		SfxDispatcher *pDispat = pMgr->GetBindings().GetDispatcher_Impl();
		SfxViewFrame *pFrame  = pDispat->GetFrame();
		SfxObjectShell* pSh = pFrame->GetObjectShell();
		SFX_ITEMSET_ARG( pSh->GetMedium()->GetItemSet(), pEditItem, SfxBoolItem, SID_VIEWONLY, sal_False );
		BOOL bIsViewer = pEditItem && pEditItem->GetValue();
		if ( bIsViewer )
			return;

		// Nur bei konfigurierbaren Toolboxen wird auch das Context-Menu
		// angeboten
		SfxPopupMenuManager aPop(SfxResId(RID_SFX_TOOLBOX_POPUP), pMgr->GetBindings());
		aPop.Initialize();
		Menu *pMenu 	= aPop.GetMenu()->GetSVMenu();

		// Alle nicht belegten Positionen rauswerfen
		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
		if ( !pWorkWin->KnowsObjectBar_Impl(SFX_OBJECTBAR_APPLICATION) )
			pMenu->RemoveItem(pMenu->GetItemPos(SID_TOGGLEFUNCTIONBAR));
		if ( !pWorkWin->KnowsObjectBar_Impl(SFX_OBJECTBAR_OBJECT) )
			pMenu->RemoveItem(pMenu->GetItemPos(SID_TOGGLEOBJECTBAR));
		if ( !pWorkWin->KnowsObjectBar_Impl(SFX_OBJECTBAR_TOOLS) )
			pMenu->RemoveItem(pMenu->GetItemPos(SID_TOGGLETOOLBAR));
		if ( !pWorkWin->KnowsObjectBar_Impl(SFX_OBJECTBAR_OPTIONS) )
			pMenu->RemoveItem(pMenu->GetItemPos(SID_TOGGLEOPTIONBAR));
		if ( !pWorkWin->KnowsObjectBar_Impl(SFX_OBJECTBAR_COMMONTASK) )
			pMenu->RemoveItem(pMenu->GetItemPos(SID_TOGGLECOMMONTASKBAR));
		if ( !pWorkWin->KnowsObjectBar_Impl(SFX_OBJECTBAR_MACRO) )
			pMenu->RemoveItem(pMenu->GetItemPos(SID_TOGGLEMACROBAR));
		if ( !pWorkWin->KnowsObjectBar_Impl(SFX_OBJECTBAR_NAVIGATION) )
			pMenu->RemoveItem(pMenu->GetItemPos(SID_TOGGLENAVBAR));

		// Position dieser Toolbox holen
		USHORT nPos=0xFFFF;
		SfxShell *pShell=0;
		USHORT nIdx;
		for (nIdx=0; (pShell=pDispat->GetShell(nIdx)); nIdx++)
		{
			const SfxInterface *pIFace = pShell->GetInterface();

			for (USHORT nNo=0; nNo<pIFace->GetObjectBarCount(); nNo++)
			{
				USHORT nID = pIFace->GetObjectBarResId(nNo).GetId();
				USHORT nId = pMgr->GetType();
				if (pIFace->GetObjectBarResId(nNo).GetId() == pMgr->GetType())
				{
					nPos = pIFace->GetObjectBarPos(nNo);
					break;
				}
			}
			if (nPos != 0xFFFF) break;
		}

		USHORT nItems=0;
		SvUShorts aIds;
		if ( nPos != 0xFFFF )
		{
			// Alle im Kontext moeglichen Toolboxen einsammeln
			ResMgr *pResMgr=0;
			for (nIdx=0; (pShell=pDispat->GetShell(nIdx)); nIdx++)
			{
				const SfxInterface *pIFace = pShell->GetInterface();

				for ( USHORT nNo = 0; pIFace && nNo<pIFace->GetObjectBarCount(); ++nNo )
				{
/*
					// Test ...
					USHORT nPos1 = pIFace->GetObjectBarPos(nNo) & SFX_POSITION_MASK;
					USHORT nPos2 = nPos & SFX_POSITION_MASK;
					USHORT nItemPos =
						pMenu->GetItemPos( pIFace->GetObjectBarResId(nNo).GetId() );
					BOOL bVisible = pIFace->IsObjectBarVisible(nNo);
*/
					USHORT nActPos = pIFace->GetObjectBarPos(nNo);
					if ( (nActPos & SFX_POSITION_MASK) == (nPos & SFX_POSITION_MASK) &&
						 pMenu->GetItemPos(pIFace->GetObjectBarResId(nNo).GetId()) == MENU_ITEM_NOTFOUND &&
						 pIFace->IsObjectBarVisible(nNo) )
					{
						USHORT nId = pIFace->GetObjectBarResId(nNo).GetId();
						ULONG nFeature = pIFace->GetObjectBarFeature( nNo );
						if ( nFeature && !pShell->HasUIFeature( nFeature ) )
							continue;
						BOOL bViewerTbx = SFX_VISIBILITY_VIEWER == ( nActPos & SFX_VISIBILITY_VIEWER );
						if ( bIsViewer != bViewerTbx )
							continue;

						USHORT n;
						for (n=0; n<aIds.Count(); n++)
						{
							if ( aIds[n] == nId )
								break;
						}

						if ( n == aIds.Count() )
						{
							aIds.Insert( nId, aIds.Count() );
							pMenu->InsertItem( aIds.Count(), *(pIFace->GetObjectBarName(nNo)),
								MIB_CHECKABLE|MIB_RADIOCHECK, nItems++);
						}
					}
				}
			}

			if (nItems == 1)
				pMenu->RemoveItem(--nItems);
			else
			{
				pMenu->InsertSeparator(nItems);
				for ( USHORT n=0; n<aIds.Count(); n++ )
					if ( aIds[n] == pMgr->GetType() )
						pMenu->CheckItem( n+1 );
			}
		}

		// SubMenu f"ur erweiterte Konfigurierbarkeit
		PopupMenu *pItemMenu = pMenu->GetPopupMenu( ITEM_ID_VISIBLE_ITEMS );
		if ( IsCustomize() )
		{
			for ( nPos = 0; nPos < GetItemCount(); ++nPos )
			{
				if ( GetItemType(nPos) == TOOLBOXITEM_BUTTON )
				{
					USHORT nId = GetItemId(nPos);
					if ( !pMgr->IsRuntimeItem( nId ))
					{
					    pItemMenu->InsertItem( nPos+nItems+1, GetItemText( nId ), MIB_CHECKABLE );
					    pItemMenu->CheckItem( nPos+nItems+1, IsItemVisible( nId ) );
					    pItemMenu->SetItemImage( nPos+nItems+1, GetItemImage( nId ) );
					}
				}
				else
				{
					pItemMenu->InsertSeparator();
				}
			}
		}
		else
		{
			pMenu->RemoveItem( pMenu->GetItemPos( ITEM_ID_VISIBLE_ITEMS ) );
		}

		SfxUInt16Item aConfigItem ( SID_CONFIGITEMID, pMgr->GetType() );
		SfxUInt16Item *pItem = &aConfigItem;

        Point aPoint( rCEvt.GetMousePosPixel() );
        USHORT nId = aPop.Execute( aPoint, this, (const SfxPoolItem*)pItem, 0L );

		if ( nId && pMenu->GetItemPos(nId) < nItems )
			pDispat->ShowObjectBar(aIds[nId-1]);
		else if ( nId == ITEM_ID_RESET_ITEMS )
		{
			SfxConfigManager* pCfg = pMgr->GetConfigManager();
			USHORT nType = pMgr->GetType();
			pCfg->ResetConfigItem( nType );
			pCfg->ReInitialize( nType );
		}
		else if ( pMenu->GetItemPos(nId) == TOOLBOX_ITEM_NOTFOUND )
		{
			// Item aus dem SubMenu
			USHORT nItemId = GetItemId( nId-nItems-1 );
			if ( IsItemVisible( nItemId ) )
				HideItem( nItemId );
			else
				ShowItem( nItemId );
			pMgr->SetDefault( FALSE );
            pMgr->StoreConfig();
		}
	}

	// ggf. Kontext-Menu-Event an den Controller weiterleiten
	if ( nId && 0 != ( pControl = pMgr->FindControl_Impl( nId ) ) )
	{
		SfxPopupWindowType eType = pControl->GetPopupWindowType();
		if ( SFX_POPUPWINDOW_CONTEXTMENU == eType )
			pControl->CreatePopupWindow();
	}

	bActivated = FALSE;
}

void SfxToolbox::NextToolBox()
{
	pMgr->NextToolBox();
}

//-------------------------------------------------------------------------

void SfxToolbox::DoubleClick()
{
	if ( !GetCurItemId() )
	{
		ToolBox::DoubleClick();
	}
	else
	{
		SfxToolBoxControl *pControl = pMgr->FindControl_Impl( GetCurItemId() );
		if ( pControl )
			pControl->DoubleClick();
	}
}


//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHandler; die Docking rectangles
//	werden gesetzt, die alten Attribute zu Vergleichszwecken aufgehoben.

void SfxToolbox::StartDocking()
{
	nLines = GetLineCount();            // alte Werte merken wg. SetModified()
	nFloatLines = GetFloatingLines();
    aFloatPos = GetFloatingPosition();
	eAlign = GetAlign();

	SfxDispatcher* pDisp = pMgr->GetBindings().GetDispatcher_Impl();
	if ( bConstructed && pDisp )
	{
		SfxViewFrame  *pFrame  = pDisp ->GetFrame();
		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
		pWorkWin->ConfigChild_Impl
			( SFX_CHILDWIN_OBJECTBAR, SFX_SETDOCKINGRECTS, pMgr->GetType() );
	}

	ToolBox::StartDocking();
}

BOOL SfxToolbox::Docking( const Point& rPos, Rectangle& rRect )
{
	SfxDispatcher* pDisp = pMgr->GetBindings().GetDispatcher_Impl();
	if ( !pDisp )
		return IsFloatingMode();

	Rectangle aRect( rRect );
	BOOL bRet = ToolBox::Docking( rPos, aRect );

	if ( !bRet )
	{
		SfxViewFrame  *pFrame  = pDisp->GetFrame();
		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
		if ( !pWorkWin->IsDockingAllowed() )
			return TRUE;
	}

	rRect = aRect;
	return bRet;
}

//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander. Ueber den Dispatcher
//  wird das parent window benachrichtigt und die Funktion ausgefuehrt.
//	Die neuen Attribute werden mit den alten verglichen und ggf. eine
//	Veraenderung registriert.

void SfxToolbox::EndDocking(const Rectangle& rRect, BOOL bFloatMode)
{
	ToolBox::EndDocking(rRect, bFloatMode);
	BOOL bChange = FALSE;

	SfxDispatcher* pDisp = pMgr->GetBindings().GetDispatcher_Impl();
	if ( !bConstructed || !pDisp )
		return;

	if ( bConstructed && !IsDockingCanceled() )
	{
        if (aFloatPos != GetFloatingPosition())
		{
			bChange = TRUE;
            aFloatPos = GetFloatingPosition();
		}

		if (nLines != GetLineCount())
		{
			bChange = TRUE;
			nLines = GetLineCount();
		}

		if ( eAlign != GetAlign() )
		{
			bChange = TRUE;
			eAlign = GetAlign() ;

			// Das SV-Toolbox-Alignment in einen SFX-enum umsetzen
			if ( !IsFloatingMode() )
				SetChildAlignment_Impl( GetAlign() );
		}

		if (nFloatLines != GetFloatingLines())
		{
			bChange = TRUE;
			nFloatLines = GetFloatingLines();
		}

		if (bChange)
			pMgr->GetBindings().GetToolBoxConfig()->Configure_Impl( pMgr );

		SfxViewFrame  *pFrame  = pMgr->GetBindings().GetDispatcher_Impl()->GetFrame();
		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
		pWorkWin->ConfigChild_Impl
			( SFX_CHILDWIN_OBJECTBAR, SFX_ALIGNDOCKINGWINDOW, pMgr->GetType() );
	}
}


//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander. Die Daten des floating
//  window werden gemerkt. Wenn in den floating mode umgeschaltet werden
//	soll und aktuell noch keine FloatingMode-Daten gesetzt waren, werden
//	defaults ausgerechnet.

BOOL SfxToolbox::PrepareToggleFloatingMode()
{
	SfxDispatcher* pDisp = pMgr->GetBindings().GetDispatcher_Impl();
	if ( !bConstructed || !pDisp )
		return ToolBox::PrepareToggleFloatingMode();

	if (!IsFloatingMode() && bConstructed)
	{
		if ( GetFloatingLines() == 0 ) // noch keine Daten gesetzt
		{
            Point aFloatPos = GetPosPixel();
			long nWidth  = GetSizePixel().Width();
			long nHeight = GetSizePixel().Height();
			switch (GetAlign())
			{
				case WINDOWALIGN_LEFT:
					nHeight =   nWidth;
					break;
				case WINDOWALIGN_RIGHT:
					nHeight =   nWidth;
					nWidth  = - nWidth;
					break;
				case WINDOWALIGN_TOP:
					nWidth  =   nHeight;
					break;
				case WINDOWALIGN_BOTTOM:
					nWidth  =   nHeight;
					nHeight = - nHeight;
					break;
			}

			aFloatPos.X() += 2 * nWidth;
			aFloatPos.Y() += 2 * nHeight;
            nFloatLines = GetLineCount() * 2U;
			aFloatPos = GetParent()->OutputToScreenPixel(aFloatPos);

			SetFloatingLines(nFloatLines);
            SetFloatingPosition(aFloatPos);
		}
	}
	else if ( IsFloatingMode() )
	{
		SfxViewFrame  *pFrame  = pMgr->GetBindings().GetDispatcher_Impl()->GetFrame();
		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
		if ( !pWorkWin->IsDockingAllowed() )
			return FALSE;
	}

	return ToolBox::PrepareToggleFloatingMode();
}


//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander. Ueber den Dispatcher
//  wird das parent window benachrichtigt und die Funktion ausgefuehrt.

void SfxToolbox::ToggleFloatingMode()
{
	SfxDispatcher* pDisp = pMgr->GetBindings().GetDispatcher_Impl();
	if ( !bConstructed || !pDisp )
	{
		ToolBox::ToggleFloatingMode();
		return;
	}

	BOOL bWasConstructed = bConstructed;
	bConstructed = FALSE;               // Resize-Handler abklemmen
	ToolBox::ToggleFloatingMode();
	bConstructed = bWasConstructed;

	if (bConstructed)
	{
		pMgr->Align();

		// Das SV-Toolbox-Alignment in einen SFX-enum umsetzen
		if ( !IsFloatingMode() )
			SetChildAlignment_Impl( GetAlign() );

		if (IsConstructed())
			pMgr->GetBindings().GetToolBoxConfig()->Configure_Impl( pMgr );

		SfxViewFrame  *pFrame  = pMgr->GetBindings().GetDispatcher_Impl()->GetFrame();
		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
		pWorkWin->ConfigChild_Impl
			( SFX_CHILDWIN_OBJECTBAR, SFX_TOGGLEFLOATMODE, pMgr->GetType() );
	}
}

//-------------------------------------------------------------------------


void SfxToolbox::Highlight()
{
	USHORT nId = GetCurItemId();
	if ( nId && !GetHelpText(nId).Len() )
	{
		SfxSlotPool &rSlotPool = SFX_SLOTPOOL();
		SetHelpText( nId, rSlotPool.GetSlotHelpText_Impl(nId) );
	}

	ToolBox::Highlight();
}

//--------------------------------------------------------------------

void SfxToolbox::RequestHelp( const HelpEvent& rHEvt )
{
	if ( !bHelpInitialized )
	{
		// Hilfetexte aus dem SlotPool (IDL-Slot-Ressourcen) laden
		bHelpInitialized = TRUE;
		SfxSlotPool &rSlotPool = SFX_SLOTPOOL();
		for ( USHORT nPos = 0; nPos < GetItemCount(); ++nPos )
		{
			USHORT nId = GetItemId(nPos);
			if ( nId )
			{
#if 0
//! (pb) what about help?
				if ( nHelpMode & HELPTEXTMODE_EXTERN )
				{
					ULONG nHelpId = GetHelpId( nId );
					if( nHelpId )
						SetHelpText( nId, String() );
				}
				else if ( nHelpMode & HELPTEXTMODE_NORESHELPTEXT )
				{
					SetHelpText( nId, String() );
				}
				else
#endif
					SetHelpText( nId, rSlotPool.GetSlotHelpText_Impl( nId ) );
			}
		}
	}

	ToolBox::RequestHelp(rHEvt);
}

//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander (leitet an Mgr weiter)

void SfxToolbox::Customize( const ToolBoxCustomizeEvent& rCEvt )
{
	if (! (GetStyle() & WB_DOCKABLE) )
		return;
	pMgr->Customize(rCEvt);
}

//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander. Die Toolbox wird nicht
//  entfernt, sondern nur der Mode umgeschaltet.

BOOL SfxToolbox::Close()
{
	USHORT nPos=0xFFFF;
	SfxShell *pShell=0;
	SfxInterface *pIFace=0;
	SfxBindings& rBindings = pMgr->GetBindings();
	SfxDispatcher *pDispat = rBindings.GetDispatcher_Impl();
	if ( !pDispat )
		return FALSE;

	for (USHORT nIdx=0; (pShell=pDispat->GetShell(nIdx)); nIdx++)
	{
		pIFace = pShell->GetInterface();
		for (USHORT nNo=0; nNo<pIFace->GetObjectBarCount(); nNo++)
		{
			if (pIFace->GetObjectBarResId(nNo).GetId() == pMgr->GetType())
			{
				nPos = pIFace->GetObjectBarPos(nNo) & SFX_POSITION_MASK;
				break;
			}
		}

		if (nPos != 0xFFFF)
			break;
	}

	SfxApplication *pSfxApp = SFX_APP();
	if (nPos != 0xFFFF)
	{
		pMgr->GetBindings().GetToolBoxConfig()->SetToolBoxPositionVisible(nPos, FALSE);
		if (nPos == SFX_OBJECTBAR_APPLICATION)
			rBindings.Invalidate(SID_TOGGLEFUNCTIONBAR);
		else if (nPos == SFX_OBJECTBAR_OBJECT)
			rBindings.Invalidate(SID_TOGGLEOBJECTBAR);
		else if (nPos == SFX_OBJECTBAR_TOOLS)
			rBindings.Invalidate(SID_TOGGLETOOLBAR);
		else if (nPos == SFX_OBJECTBAR_OPTIONS)
			rBindings.Invalidate(SID_TOGGLEOPTIONBAR);
		else if (nPos == SFX_OBJECTBAR_COMMONTASK)
			rBindings.Invalidate(SID_TOGGLECOMMONTASKBAR);
		else if (nPos == SFX_OBJECTBAR_MACRO)
			rBindings.Invalidate(SID_TOGGLEMACROBAR);
		else if (nPos == SFX_OBJECTBAR_NAVIGATION)
			rBindings.Invalidate(SID_TOGGLENAVBAR);

		bActivated = 2;
		pMgr->GetBindings().GetDispatcher_Impl()->Update_Impl(TRUE);
		bActivated = FALSE;
		return TRUE;
	}

	return FALSE;
}

//--------------------------------------------------------------------

//  Ueberlagert den entsprechenden ToolBoxHander. Die Groesse des floating
//  windows wird gemerkt.
//	Behandelte events : floating window wurde umgegroessert.

void SfxToolbox::Resize()
{
	ToolBox::Resize();
	if (IsFloatingMode() && bConstructed)
	{
        if (!IsVisible())
            return;

        USHORT nActLines = GetFloatingLines();
        if ( nActLines == nFloatLines )
            return;

        // if VCL does not return real line count for line count 0xFFFF
        USHORT nLines = nFloatLines;
        if ( nLines == 0xFFFF )
        {
            // every item takes on line
            nLines = GetItemCount();
            for ( USHORT nPos=0; nPos<GetItemCount(); ++nPos )
            {
                USHORT nId = GetItemId(nPos);
                if ( !IsItemVisible( nId ) )
                    nLines--;
            }
        }

        if ( nLines != nActLines )
		{
            nFloatLines = nActLines;
			pMgr->GetBindings().GetToolBoxConfig()->Configure_Impl( pMgr );
		}
	}
}

void SfxToolbox::FillInfo(SfxChildWinInfo&) const
{
}

void SfxToolbox::SetToolBoxAlignment_Impl( SfxChildAlignment eTbxAlign )
{
	eAlignment = eTbxAlign;
	if ( eTbxAlign != SFX_ALIGN_NOALIGNMENT )
		SetAlign( ConvertAlign_Impl( eAlignment ) );
}


void SfxToolbox::SetChildAlignment_Impl( WindowAlign eTbxAlign )
{
	eAlign = eTbxAlign;

	// doll ausserhalb von Childwins angedockt werden?
	if ( eAlign != SFX_ALIGN_NOALIGNMENT && nPos == SFX_OBJECTBAR_APPLICATION )
	{
		eAlignment =
		(SfxChildAlignment)
			( eTbxAlign == WINDOWALIGN_TOP ? SFX_ALIGN_HIGHESTTOP :
			eTbxAlign == WINDOWALIGN_LEFT ? SFX_ALIGN_LEFT :
			eTbxAlign == WINDOWALIGN_RIGHT ? SFX_ALIGN_RIGHT :
			SFX_ALIGN_BOTTOM );
	}
	else
	{
		eAlignment =
		(SfxChildAlignment)
			( eTbxAlign == WINDOWALIGN_TOP ? SFX_ALIGN_TOOLBOXTOP :
			eTbxAlign == WINDOWALIGN_LEFT ? SFX_ALIGN_TOOLBOXLEFT :
			eTbxAlign == WINDOWALIGN_RIGHT ? SFX_ALIGN_TOOLBOXRIGHT :
			SFX_ALIGN_TOOLBOXBOTTOM );
	}
}

void SfxToolbox::ClearItemText_Impl()
{
	aItems.Remove( 0, aItems.Count() );
}

void SfxToolbox::SetItemText_Impl( USHORT nId, BOOL bSet )
{
	USHORT nCount = aItems.Count();
	USHORT n;
	for ( n=0; n<nCount; n++ )
	{
		if ( aItems[n] > nId )
		{
			break;
		}
		else if ( aItems[n] == nId )
		{
			aItems.Remove( n );
			break;
		}
	}

	if ( bSet )
		aItems.Insert( nId, n );
}

BOOL SfxToolbox::HasItemText_Impl( USHORT nId )
{
	USHORT nCount = aItems.Count();
	for ( USHORT n=0; n<nCount; n++ )
		if ( aItems[n] == nId )
			return TRUE;
	return FALSE;
}

void SfxToolbox::SetFloatingPosition( const Point& rPos )
{
    aFloatPos = rPos;
    SetFloatingPos( rPos );
}

Point SfxToolbox::GetFloatingPosition() const
{
/*
    if ( IsFloatingMode() )
    {
		SfxDispatcher *pDispat = pMgr->GetBindings().GetDispatcher_Impl();
		SfxViewFrame  *pFrame  = pDispat->GetFrame();

		// Alle nicht belegten Positionen rauswerfen
		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
        Rectangle aRect = ((SfxToolbox*)this)->GetWindowExtentsRelative( pWorkWin->GetWindow() );
        return aRect.TopLeft();
    }
    else
    {
        return GetFloatingPos();
    }
*/
    return aFloatPos;
}

void SfxToolbox::Move()
{
    if ( IsFloatingMode() && IsReallyVisible() )
    {
/*
		SfxDispatcher *pDispat = pMgr->GetBindings().GetDispatcher_Impl();
		SfxViewFrame  *pFrame  = pDispat->GetFrame();

        SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
        Window *pWindow = pWorkWin->GetWindow();
        while ( !pWindow->IsSystemWindow() )
            pWindow = pWindow->GetParent();

        Rectangle aRect = ((SfxToolbox*)this)->GetWindowExtentsRelative( pWindow );
        aFloatPos = aRect.TopLeft();
*/
		aFloatPos = GetFloatingPos();
		aAsyncStoreCfgTimer.Start();

//        pMgr->GetBindings().GetToolBoxConfig()->Configure_Impl( pMgr );
        //pWorkWin->ConfigChild_Impl( SFX_CHILDWIN_OBJECTBAR, SFX_ALIGNDOCKINGWINDOW, pMgr->GetType() );
    }
}
