/*************************************************************************
 *
 *  $RCSfile: contenv.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mba $ $Date: 2001/05/10 08:04:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFX_CONTENV_HXX
#define _SFX_CONTENV_HXX


#ifndef _IPENV_HXX //autogen
#include <so3/ipenv.hxx>
#endif
//=========================================================================

class SvInPlaceMenuBar;
class SvInPlaceClient;
class SfxInPlaceClient;
class SfxViewFrame;
class INetURLObject;

//=========================================================================

class SfxContainerEnv_Impl: public SvContainerEnvironment

/*	[Beschreibung]

	"Uber eine Instanz dieser internen Klasse selektiert ein In-Place-aktives
	Objekt seine Tools (z.B. Menu) in die SFx-Applikation, die Container
	ist.
*/

{
	SfxViewFrame*		pFrame;
	SvInPlaceMenuBar*	pMenuBar;

protected:
	virtual MenuBar* 	QueryMenu( USHORT *, USHORT *, USHORT * );
	virtual void    	SetInPlaceMenu( MenuBar * pIPMenu, BOOL bSet );
	virtual void    	MenuReleased();
	virtual void    	RequestObjAreaPixel( const Rectangle & rObjRect );
	virtual void        UIToolsShown( BOOL bShow );
	virtual BOOL		SetTopToolSpacePixel( const SvBorder& );

public:
						SfxContainerEnv_Impl( SfxInPlaceClient *pClient,
									SfxViewFrame* pViewFrame,
									WorkWindow* pTopWin,
									Window* pEditWin );
	virtual 			~SfxContainerEnv_Impl();

	virtual BOOL    	SetStatusText( const String & rText );
	virtual void 		ShowDocument( const INetURLObject &,
									const XubString & );
	virtual BOOL 		DispatchAccel( const KeyCode & );
};



#endif
