/*************************************************************************
 *
 *  $RCSfile: infodlgs.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: dv $ $Date: 2001/07/03 12:37:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _HELP_HXX //autogen
#include <vcl/help.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#pragma hdrstop

// includes ******************************************************************

#include "infodlgs.hxx"
#include "sfxresid.hxx"
#include "exptypes.hxx"
#include "explorer.hrc"
#include "infodlgs.hrc"
#include "sfxuno.hxx"

//****************************************************************************
// SfxShortFixedText_Impl
//****************************************************************************

SfxShortFixedText_Impl::SfxShortFixedText_Impl( Window* pParent,
												USHORT nResId, const String& rText ) :

	FixedText( pParent, SfxResId( nResId ) )

{
	SetText( rText );
}

//****************************************************************************

SfxShortFixedText_Impl::SfxShortFixedText_Impl( Window* pParent, const ResId& rResId ) :

	FixedText( pParent, rResId )

{
}

//****************************************************************************

void SfxShortFixedText_Impl::SetText( const String& rText )
{
	String aCutText( rText );
	long nWidth = GetSizePixel().Width();
	if ( !nWidth )
		return;

	BOOL bCut = FALSE;
	while ( GetTextWidth( aCutText ) > nWidth )
	{
		bCut = TRUE;
		aCutText.Erase( aCutText.Len() - 4 );
		aCutText += DEFINE_CONST_UNICODE("...");
	}

	if ( bCut )
		_aQuickHelpText = rText;
	else
		_aQuickHelpText.Erase();

	FixedText::SetText( aCutText );
}

//****************************************************************************

void SfxShortFixedText_Impl::RequestHelp( const HelpEvent& rEvt )

/*	[Beschreibung]

	Die Methode wird gerufen, um Hilfe f"ur das Fenster anzuzeigen. Zeigt das
	Fenster einen gek"urzten Text an, so wird selbiger in voller "ange angezeigt.
*/

{
	if ( ( rEvt.GetMode() & HELPMODE_QUICK ) == HELPMODE_QUICK && _aQuickHelpText.Len() )
	{
		Rectangle aRect( rEvt.GetMousePosPixel(),
						 Size( GetTextWidth( _aQuickHelpText ), GetTextHeight() ) );
		Help::ShowQuickHelp( this, aRect, _aQuickHelpText );
	}
	else
		FixedText::RequestHelp( rEvt );
}

//****************************************************************************
// SfxQueryDeleteDlg_Impl
//****************************************************************************

SfxQueryDeleteDlg_Impl::SfxQueryDeleteDlg_Impl
(
	Window* pParent,
	const String& rLabel,    // Bezeichner fuer den Eintrag
	const String& rName,     // Eintragsname
	const String& rMsg,      // anzuzeigende Nachricht
	BOOL bWithAll            /* FALSE - 'Alle'-Knopf abschalten
								... */
) :

	ModalDialog( pParent, SfxResId( DLG_SFX_QUERYDELETE ) ),

	_aEntryLabel	( this, ResId( TXT_ENTRY ) ),
	_aEntry		( this, TXT_ENTRYNAME, rName ),
	_aQueryMsg	( this, ResId( TXT_QUERYMSG ) ),
	_aYesButton	( this, ResId( BTN_YES ) ),
	_aAllButton	( this, ResId( BTN_ALL ) ),
	_aNoButton	( this, ResId( BTN_NO ) ),
	_aCancelButton( this, ResId( BTN_SFX_CANCEL ) )

{
	FreeResource();

	// Handler
	Link aLink( STATIC_LINK( this, SfxQueryDeleteDlg_Impl, ClickLink ) );
	_aYesButton.SetClickHdl( aLink );
	_aAllButton.SetClickHdl( aLink );
	_aNoButton.SetClickHdl( aLink );

	// Anzeige der spezifizierten Texte
	_aEntryLabel.SetText( rLabel );
	_aQueryMsg.SetText( rMsg );

	// Alle-Knopf
	_aAllButton.Enable( bWithAll );
}

//****************************************************************************

IMPL_STATIC_LINK( SfxQueryDeleteDlg_Impl, ClickLink, PushButton*, pBtn )

/*	[Beschreibung]

	Die Methode wertet das Resultat der Abfrage aus.
*/

{
	if ( pBtn == &pThis->_aYesButton )
		pThis->_eResult = SFX_QUERYDELETE_YES;
	else if ( pBtn == &pThis->_aNoButton )
		pThis->_eResult = SFX_QUERYDELETE_NO;
	else if ( pBtn == &pThis->_aAllButton )
		pThis->_eResult = SFX_QUERYDELETE_ALL;
	pThis->EndDialog( RET_OK );
	return 0;
}

