/*************************************************************************
 *
 *  $RCSfile: topfrm.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: mba $ $Date: 2002/10/07 09:50:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFX_TOPFRM_HXX
#define _SFX_TOPFRM_HXX

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _SV_DOCKWIN_HXX //autogen
#include <vcl/dockwin.hxx>
#endif
#include <vcl/wrkwin.hxx>

#include "frame.hxx"
#include "viewfrm.hxx"

class SfxViewShell;
class SfxTopFrame;
namespace svtools { class AsynchronLink; }

// class SfxTopFrame -----------------------------------------------------

class SfxTopFrame :	public SfxFrame
{
friend class SfxTopWindow_Impl;
friend class SfxTopFrameWindow_Impl;
friend class SfxTopFrame_Impl;

	SfxTopFrame_Impl*	pImp;
    Window*             pWindow;
                        SfxTopFrame( Window* pWindow=NULL, sal_Bool bHidden = sal_False );
    virtual             ~SfxTopFrame();
public:
                        TYPEINFO();

    static SfxTopFrame* Create( ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > xFrame );
    static SfxTopFrame* Create( SfxObjectShell* pDoc=0, USHORT nViewId=0, BOOL bHidden=sal_False, const SfxItemSet* pSet=NULL );
    static SfxTopFrame* Create( SfxObjectShell* pDoc, Window* pWindow, USHORT nViewId=0, BOOL bHidden=sal_False, const SfxItemSet* pSet=NULL );

	virtual Window&		GetWindow() const;
	virtual BOOL		Close();
	virtual	BOOL		InsertDocument( SfxObjectShell *pDoc );
	String				GetWindowData();

    void                SetPresentationMode( BOOL bSet );

#if _SOLAR__PRIVATE
    void                LockResize_Impl( BOOL bLock );
    void                SetMenuBar_Impl( MenuBar* pMenu );
    void                SetMenuBarOn_Impl( BOOL bOn );
    BOOL                IsMenuBarOn_Impl() const;
    MenuBar*            GetMenuBar_Impl() const;
	BOOL				InsertDocument_Impl( SfxObjectShell *pDoc, USHORT nViewId=0 );
    SystemWindow*       GetTopWindow_Impl() const;
	void				CheckMenuCloser_Impl( MenuBar* pMenubar );
#endif
};

// class SfxTopViewFrame -------------------------------------------------

class SfxTopViewFrame : public SfxViewFrame
{
friend class SfxTopWindow_Impl;
friend class SfxTopViewFrame_Impl;

	SfxTopViewFrame_Impl*	pImp;
    svtools::AsynchronLink* pCloser;

protected:

	virtual void            Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
	virtual void            Activate( BOOL bUI );
	virtual void            Deactivate( BOOL bUI );
	virtual BOOL            Close();
	virtual                 ~SfxTopViewFrame();

public:
							TYPEINFO();
							SFX_DECL_INTERFACE(SFX_INTERFACE_SFXTOPFRM);

                            SfxTopViewFrame( SfxFrame* pFrame, SfxObjectShell *pDoc=NULL, USHORT nViewId=0 );

    virtual void            SetZoomFactor( const Fraction &rZoomX, const Fraction &rZoomY );
	virtual BOOL			SetBorderPixelImpl( const SfxViewShell *pSh, const SvBorder &rBorder );
	virtual void			InvalidateBorderImpl( const SfxViewShell *pSh );
	virtual String			UpdateTitle();

#if _SOLAR__PRIVATE
	void					Exec_Impl(SfxRequest &);
	void                    GetState_Impl(SfxItemSet &);
	void					INetExecute_Impl(SfxRequest &);
	void					INetState_Impl(SfxItemSet &);
    SfxTopFrame*            GetTopFrame_Impl()
                            { return (SfxTopFrame*) GetFrame(); }
#endif
};

#endif // #ifndef _SFX_TOPFRM_HXX


