/*************************************************************************
 *
 *  $RCSfile: paddr.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: vg $ $Date: 2003/07/09 10:07:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 - 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _PADDR_HXX
#define _PADDR_HXX

#ifndef _AGENTPG_HXX
#include "agentpg.hxx"
#endif

#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif

#ifndef _SV_LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif

#define PADDR_NORMAL		1
#define PADDR_WARN			2

class PageAddress : public SvAgentPage
{
		FixedText		m_aFTInfo1;
		FixedText 		m_aCompanyLbl;
		Edit 			m_aCompanyEdit;
		FixedText 		m_aNameLbl;
		FixedText 		m_aNameLblRuss;
		Edit 			m_aFirstName;
		Edit			m_aFatherName;
		Edit 			m_aName;
		Edit 			m_aShortName;
		FixedText 		m_aStreetLbl;
		FixedText 		m_aStreetLblRuss;
		Edit 			m_aStreetEdit;
		Edit 			m_aApartmentEdit;
		FixedText 		m_aCityLbl;
// 		Edit 			m_aCountryEdit;
		Edit 			m_aPLZEdit;
		Edit 			m_aCityEdit;
		Edit			m_aUsCityEdit;
		Edit 			m_aStateEdit;
		Edit 			m_aUsStateEdit;
		Edit 			m_aUsPLZEdit;
//		Edit 			m_aUsCountryEdit;
		FixedText 		m_aCountryLbl;
		ListBox			m_aCountryList;
		FixedText 		m_aTitlePosLbl;
		Edit 			m_aTitleEdit;
		Edit 			m_aPositionEdit;
		FixedText 		m_aTelPrivLbl;
		Edit 			m_aTelPrivEdit;
		FixedText 		m_aTelCompanyLbl;
		Edit 			m_aTelCompanyEdit;
		FixedText 		m_aFaxLbl;
		Edit 			m_aFaxEdit;
		FixedText 		m_aEmailLbl;
		Edit 			m_aEmailEdit;

		String 			m_aWarnUser;
		String 			m_aWarnUserPuff;
		String 			m_aWarnUserCampus;

		void 			Userdata2Env();
		void			SelectInitialLanguage();
		void 			SelectLanguageByIdx(USHORT nIdx);

						DECL_LINK( ModifyHdl, Edit* );

	String 		 		GetCompanyName() const;
	String	 			GetUserName() const;
	String	 			GetUserFirstName() const;
	String	 			GetUserId() const;
	String 	 			GetEMail() const;
	
	String 		 		GetCtrl(const Edit& rEdit) const;
public:
		PageAddress( SvAgentDlg* pParent, const ResId& rResId );
		~PageAddress();

	static SvAgentPage*		Create(SvAgentDlg* pParent, const ResId& rResId);

	virtual USHORT 			GetReturnVal();
	virtual ULONG  			GetProperty();
	virtual BOOL 			AllowNext();

};

#endif //_PADDR_HXX
