/*************************************************************************
 *
 *  $RCSfile: sios.cxx,v $
 *
 *  $Revision: 1.3.114.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/09 18:52:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "decltor.hxx"
#include "compiler.hxx"
#include "fields.hxx"
#include "instdb.hxx"
#include "sihelp.hxx"

TYPEINIT1(SiOs2Class,SiDeclarator);
TYPEINIT1(SiOs2Creator,SiDeclarator);
TYPEINIT1(SiOs2Template,SiDeclarator);


///////////////////////////////////////////////////////////////////////////////
//
//		SiOs2Class
//

SiOs2Class::SiOs2Class( SiIdentifier const& ID, SiCompiler* pCompiler, BOOL bSystemObject ) :
		SiDeclarator(ID,pCompiler, bSystemObject)
{
	INIT_MULTI_LANG_MEMBER( pModule );
	INIT_MULTI_LANG_MEMBER( aName );
	INIT_MULTI_LANG_MEMBER( pDLL );

	m_pModule = NULL;
	m_pDLL    = NULL;
}

void SiOs2Class::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiOs2Class* pParent = (SiOs2Class*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER( pModule );
	JOIN_MULTI_LANG_MEMBER( aName );
	JOIN_MULTI_LANG_MEMBER( pDLL );
}

BOOL SiOs2Class::SetProperty(ByteString const& aProperty, ByteString const& aValue)
{
	if (aProperty == PROPERTY_NAME)
	{
		SET_MULTI_LANG_MEMBER( aName, aValue );
		return TRUE;
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

BOOL SiOs2Class::SetProperty(ByteString const& aProperty, SiDeclarator* aValue)
{
	if (aProperty == PROPERTY_MODULEID)
	{
		m_pModule = PTR_CAST(SiModule,aValue);
		if (m_pModule == NULL)
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a module";
			Error( aMsg );
			return FALSE;
		}

		// SiOs2Class in die Liste des Moduls haengen.
		// Achtung: Selbst wenn Check() FALSE zurueckliefert
		//          (siehe SiCompiler::OnDeclarationEnd()) mu
		//          sichergestellt werden, dass das Objekt nicht
		//          zerstoert wird.
		m_pModule->Add(this);
		m_IspModule = TRUE;
		return TRUE;
	}

	if (aProperty == PROPERTY_DLL)
	{
		m_pDLL = PTR_CAST(SiFile,aValue);
		if (m_pDLL == NULL)
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a SiFile";
			Error( aMsg );
			return FALSE;
		}
		m_IspDLL = TRUE;
		return TRUE;
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

BOOL SiOs2Class::Check()
{
	BOOL bOk = TRUE;
	bOk = bOk && CheckField(m_aName, PROPERTY_NAME);
	return bOk ? SiDeclarator::Check() : FALSE;
}

BOOL SiOs2Class::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration("Os2Class", this);

	// PROPERTY_MODULEID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_MODULEID, pModule );

	// PROPERTY_NAME
	WRITE_MULTI_LANG_MEMBER( PROPERTY_NAME, aName );

	// PROPERTY_DLL
	WRITE_MULTI_LANG_MEMBER( PROPERTY_DLL, pDLL );

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiOs2Class* pOs2Class = (SiOs2Class*) m_aLangRefs.GetObject(nIdx);
		pOs2Class->WriteTo( aStream );
	}

	if( !IsLangRef() )
		aStream.EndDeclaration();
	return TRUE;
}

ByteString SiOs2Class::GetNaturalID() const
{
	ByteString aNatID( m_aName );
	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += ByteString::CreateFromInt32( m_nLanguage );
	}
	return aNatID;
}

///////////////////////////////////////////////////////////////////////////////
//
//		SiOs2Creator
//

SiOs2Creator::SiOs2Creator(SiIdentifier const& ID, SiCompiler *pCompiler)
: SiDeclarator(ID,pCompiler)
{
	INIT_MULTI_LANG_MEMBER( aName );
	INIT_MULTI_LANG_MEMBER( anIcon );
	INIT_MULTI_LANG_MEMBER( pIconDir );
	m_pIconDir = NULL;
}

void SiOs2Creator::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiOs2Creator* pParent = (SiOs2Creator*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER( aName );
	JOIN_MULTI_LANG_MEMBER( anIcon );
	JOIN_MULTI_LANG_MEMBER( pIconDir );
}

BOOL SiOs2Creator::SetProperty(ByteString const& aProperty, ByteString const& aValue)
{
	if (aProperty == PROPERTY_NAME)
	{
		SET_MULTI_LANG_MEMBER( aName, aValue );
		return TRUE;
	}

	if (aProperty == PROPERTY_ICON)
	{
		SET_MULTI_LANG_MEMBER( anIcon, aValue );
		return TRUE;
	}
	return SiDeclarator::SetProperty(aProperty,aValue);
}

BOOL SiOs2Creator::SetProperty(ByteString const& aProperty, SiDeclarator* aValue)
{
	if( aProperty == PROPERTY_ICONDIR )
	{
		m_pIconDir = PTR_CAST(SiDirectory,aValue);
		if (m_pIconDir == NULL)
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a directory";
			Error( aMsg );
			return FALSE;
		}
		else
			m_pIconDir->AddRefCount();

		m_IspIconDir = TRUE;
		return TRUE;
	}
	return SiDeclarator::SetProperty(aProperty,aValue);
}

BOOL SiOs2Creator::Check()
{
	BOOL bOk = TRUE;

	bOk = bOk && CheckField(m_aName,    PROPERTY_NAME);
	bOk = bOk && CheckField(m_anIcon,   PROPERTY_ICON);
	bOk = bOk && CheckField(m_pIconDir, PROPERTY_ICONDIR);

	return bOk ? SiDeclarator::Check() : FALSE;
}

BOOL SiOs2Creator::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration("Os2Creator", this);

	// PROPERTY_NAME
	WRITE_MULTI_LANG_MEMBER( PROPERTY_NAME, aName );

	// PROPERTY_ICON
	WRITE_MULTI_LANG_MEMBER( PROPERTY_ICON, anIcon );

	// PROPERTY_ICONDIR
	WRITE_MULTI_LANG_MEMBER( PROPERTY_ICONDIR, pIconDir );

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiOs2Creator* pOs2Creator = (SiOs2Creator*) m_aLangRefs.GetObject(nIdx);
		pOs2Creator->WriteTo( aStream );
	}

	if( !IsLangRef() )
		aStream.EndDeclaration();
	return TRUE;
}

ByteString SiOs2Creator::GetNaturalID() const
{
	ByteString aNatID( m_aName );
	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += ByteString::CreateFromInt32( m_nLanguage );
	}
	return aNatID;
}

///////////////////////////////////////////////////////////////////////////////
//
//		SiOs2Template
//

SiOs2Template::SiOs2Template(SiIdentifier const& ID, SiCompiler *pCompiler) :
		SiDeclarator(ID,pCompiler)
{
	INIT_MULTI_LANG_MEMBER( pOs2Class );
	INIT_MULTI_LANG_MEMBER( anID );
	INIT_MULTI_LANG_MEMBER( pIcon );

	m_pOs2Class = NULL;
	m_pIcon     = NULL;
}

void SiOs2Template::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiOs2Template* pParent = (SiOs2Template*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER( pOs2Class );
	JOIN_MULTI_LANG_MEMBER( anID );
	JOIN_MULTI_LANG_MEMBER( pIcon );
}

BOOL SiOs2Template::SetProperty(ByteString const& aProperty, ByteString const& aValue)
{
	if( aProperty == PROPERTY_ID )
	{
		SET_MULTI_LANG_MEMBER( anID, aValue );
		return TRUE;
	}
	return SiDeclarator::SetProperty(aProperty,aValue);
}

BOOL SiOs2Template::SetProperty(ByteString const& aProperty, SiDeclarator* aValue)
{
	if( aProperty == PROPERTY_OS2_CLASSID )
	{
		m_pOs2Class = PTR_CAST(SiOs2Class,aValue);
		if (m_pOs2Class == NULL)
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not an OS/2 class";
			Error( aMsg );
			return FALSE;
		}

		// SiOs2Template in die Liste des Moduls haengen.
		// Achtung: Selbst wenn Check() FALSE zurueckliefert
		//          (siehe SiCompiler::OnDeclarationEnd()) mu
		//          sichergestellt werden, dass das Objekt nicht
		//          zerstoert wird.
		if (m_pOs2Class->GetModule() != NULL)
			m_pOs2Class->GetModule()->Add(this);

		m_IspOs2Class = TRUE;
		return TRUE;
	}

	if( aProperty == PROPERTY_ICON )
	{
		m_pIcon = PTR_CAST(SiFile,aValue);

		if( m_pIcon == NULL )
		{
			ByteString aMsg( aValue->GetID() );
			aMsg += " is not a file";
			Error( aMsg );
			return FALSE;
		}
		m_IspIcon = TRUE;
		return TRUE;
	}
	return SiDeclarator::SetProperty(aProperty,aValue);
}

BOOL SiOs2Template::Check()
{
	BOOL bOk = TRUE;

	bOk = bOk && CheckField(m_anID,		 PROPERTY_ID);
	bOk = bOk && CheckField(m_pOs2Class, PROPERTY_OS2_CLASSID);
	// bOk = bOk && CheckField(m_pIcon,	 PROPERTY_ICON);

	return bOk ? SiDeclarator::Check() : FALSE;
}

BOOL SiOs2Template::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration("Os2Template", this);

	// PROPERTY_OS2_CLASSID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_OS2_CLASSID, pOs2Class );

	// PROPERTY_ID
	WRITE_MULTI_LANG_MEMBER( PROPERTY_ID, anID );

	// PROPERTY_ICON
	WRITE_MULTI_LANG_MEMBER( PROPERTY_ICON, pIcon );

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiOs2Template* pOs2Template = (SiOs2Template*) m_aLangRefs.GetObject(nIdx);
		pOs2Template->WriteTo( aStream );
	}

	if( !IsLangRef() )
		aStream.EndDeclaration();
	return TRUE;
}

ByteString SiOs2Template::GetNaturalID() const
{
	ByteString aNatID( m_anID );
	if( IsLangRef() ) {
		aNatID += "__";
		aNatID += ByteString::CreateFromInt32( m_nLanguage );
	}
	return aNatID;
}

