/*************************************************************************
 *
 *  $RCSfile: OfficeRunningCheck.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dv $ $Date: 2002/11/18 14:35:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _OFFICERUNNINGCHECK_HXX
#define _OFFICERUNNINGCHECK_HXX

// header for class Window
#ifndef _SV_WINDOW_HXX
#include <vcl/window.hxx>
#endif

#include "strings.hrc"

// -----------------------------------------------------------------------------
class OfficeRunning
{
	Window *m_pParentWindow;
	String  m_aStrQuitAppWin;
	String  m_aStrQuitApp;
	
public:
	OfficeRunning(Window *_pParent, ResMgr* _pResMgr)
			:m_pParentWindow(_pParent),
			 m_aStrQuitAppWin( ResId(STR_QUIT_OFFICE_WIN, _pResMgr) ),
			 m_aStrQuitApp ( ResId(STR_QUIT_OFFICE, _pResMgr) )
		{
		}

	OfficeRunning(Window *_pParent, const ResId& _rResId)
			:m_pParentWindow(_pParent),
			 m_aStrQuitAppWin( ResId(STR_QUIT_OFFICE_WIN, _rResId.GetResMgr()) ),
			 m_aStrQuitApp ( ResId(STR_QUIT_OFFICE, _rResId.GetResMgr()) )
		{
		}

	/*
		Check via pipe if office is running, usefull after shutdown quickstarter,
		if a window of soffice.exe is open.
		TRUE: window is open
		FALSE: no window is open
	 */
    BOOL isRunning( SiEnvironment* _pEnv, const String &rProdName );
    BOOL isRunning( SiEnvironment* _pEnv);
};

#endif
