/*************************************************************************
 *
 *  $RCSfile: fuinstit.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: bm $ $Date: 2000/09/21 12:03:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop
#ifndef _CTRLTOOL_HXX //autogen
#include <svtools/ctrltool.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#include <svx/flstitem.hxx>
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
#ifndef _SFX_OBJSH_HXX //autogen
#include <sfx2/objsh.hxx>
#endif

#include "app.hrc"
#include "schresid.hxx"
#include "schdll.hxx"
#include "strings.hrc"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "viewshel.hxx"
#include "title.hxx"
#include "uninstit.hxx"
#include "fuinstit.hxx"

TYPEINIT1(SchFuInsertTitle, SchFuPoor);


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuInsertTitle::SchFuInsertTitle(SchViewShell* pViewSh, SchWindow* pWin,
								   SchView* pView, ChartModel* pDoc,
								   SfxRequest& rReq)
	   : SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	nMarkedID           = 0;

	BOOL bOldShowMain	= pDoc->ShowMainTitle();
	String aOldMain		= pDoc->MainTitle();
	BOOL bOldShowSub	= pDoc->ShowSubTitle();
	String aOldSub		= pDoc->SubTitle();
	BOOL bOldShowXAxis	= pDoc->ShowXAxisTitle();
	String aOldXAxis	= pDoc->XAxisTitle();
	BOOL bOldShowYAxis	= pDoc->ShowYAxisTitle();
	String aOldYAxis	= pDoc->YAxisTitle();
	BOOL bOldShowZAxis	= pDoc->ShowZAxisTitle();
	String aOldZAxis	= pDoc->ZAxisTitle();

	const SfxItemSet* pArgs = rReq.GetArgs();

	if (!pArgs)
	{
		SfxItemSet aNewAttr(pViewSh->GetPool(), CHATTR_TITLE_START,
												CHATTR_TITLE_END);
		aNewAttr.Put(SfxBoolItem(CHATTR_TITLE_SHOW_MAIN, bOldShowMain));
		aNewAttr.Put(SfxStringItem(CHATTR_TITLE_MAIN, aOldMain));
		aNewAttr.Put(SfxBoolItem(CHATTR_TITLE_SHOW_SUB, bOldShowSub));
		aNewAttr.Put(SfxStringItem(CHATTR_TITLE_SUB, aOldSub));
		aNewAttr.Put(SfxBoolItem(CHATTR_TITLE_SHOW_X_AXIS, bOldShowXAxis));
		aNewAttr.Put(SfxStringItem(CHATTR_TITLE_X_AXIS, aOldXAxis));
		aNewAttr.Put(SfxBoolItem(CHATTR_TITLE_SHOW_Y_AXIS, bOldShowYAxis));
		aNewAttr.Put(SfxStringItem(CHATTR_TITLE_Y_AXIS, aOldYAxis));
		aNewAttr.Put(SfxBoolItem(CHATTR_TITLE_SHOW_Z_AXIS, bOldShowZAxis));
		aNewAttr.Put(SfxStringItem(CHATTR_TITLE_Z_AXIS, aOldZAxis));

//      FG: Mit dieser Zeile erhaelt man keinen modalen Dialog => Absturz falls ein Resize im Chart
//      stattfindet waehrend dieser Dialog geoeffnet ist.
//		SchTitleDlg* pDlg =	new SchTitleDlg(&pViewSh->GetViewFrame()->GetWindow(),
//				  		                	aNewAttr, pDoc->IsAxisChart() && !pDoc->IsNetChart (), pDoc->Is3DChart());
		SchTitleDlg* pDlg =	new SchTitleDlg(NULL,
											aNewAttr, pDoc->IsAxisChart() && !pDoc->IsNetChart (), pDoc->Is3DChart());

		if(pDlg->Execute() == RET_OK)
		{
			pDlg->GetAttr(aNewAttr);
			rReq.Done(aNewAttr);
			pArgs = rReq.GetArgs();
			delete pDlg;
		}
		else
		{
			delete pDlg;
			return;
		}

		pChDoc->CanRebuild (TRUE);
	}
	else pChDoc->CanRebuild (FALSE);

	pViewSh->GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

	// MainTitle
	SFX_REQUEST_ARG( rReq, pNewShowMainItem, SfxBoolItem, CHATTR_TITLE_SHOW_MAIN, FALSE );
	BOOL bNewShowMain = pNewShowMainItem ? pNewShowMainItem->GetValue() : bOldShowMain;

	SFX_REQUEST_ARG( rReq, pNewMainItem, SfxStringItem, CHATTR_TITLE_MAIN, FALSE );
#ifdef IRIX
	const String& aNewMain = pNewMainItem ? (String)pNewMainItem->GetValue() : aOldMain;
#else
	const String& aNewMain = pNewMainItem ? pNewMainItem->GetValue() : aOldMain;
#endif

	// SubTitle
	SFX_REQUEST_ARG( rReq, pNewShowSubItem, SfxBoolItem, CHATTR_TITLE_SHOW_SUB, FALSE );
	BOOL bNewShowSub = pNewShowSubItem ? pNewShowSubItem->GetValue() : bOldShowSub;

	SFX_REQUEST_ARG( rReq, pNewSubItem, SfxStringItem, CHATTR_TITLE_SUB, FALSE );
#ifdef IRIX
	const String& aNewSub = pNewSubItem ? (String)pNewSubItem->GetValue() : aOldSub;
#else
	const String& aNewSub = pNewSubItem ? pNewSubItem->GetValue() : aOldSub;
#endif

	// X-Axis
	SFX_REQUEST_ARG( rReq, pNewShowXAxisItem, SfxBoolItem, CHATTR_TITLE_SHOW_X_AXIS, FALSE );
	BOOL bNewShowXAxis = pNewShowXAxisItem ? pNewShowXAxisItem->GetValue() : bOldShowXAxis;

	SFX_REQUEST_ARG( rReq, pNewXAxisItem, SfxStringItem, CHATTR_TITLE_X_AXIS, FALSE );
#ifdef IRIX
	const String& aNewXAxis = pNewXAxisItem ? (String)pNewXAxisItem->GetValue() : aOldXAxis;
#else
	const String& aNewXAxis = pNewXAxisItem ? pNewXAxisItem->GetValue() : aOldXAxis;
#endif

	// Y-Axis
	SFX_REQUEST_ARG( rReq, pNewShowYAxisItem, SfxBoolItem, CHATTR_TITLE_SHOW_Y_AXIS, FALSE );
	BOOL bNewShowYAxis = pNewShowYAxisItem ? pNewShowYAxisItem->GetValue() : bOldShowYAxis;

	SFX_REQUEST_ARG( rReq, pNewYAxisItem, SfxStringItem, CHATTR_TITLE_Y_AXIS, FALSE );
#ifdef IRIX
	const String& aNewYAxis = pNewYAxisItem ? (String)pNewYAxisItem->GetValue() : aOldYAxis;
#else
	const String& aNewYAxis = pNewYAxisItem ? pNewYAxisItem->GetValue() : aOldYAxis;
#endif

	// Z-Axis
	SFX_REQUEST_ARG( rReq, pNewShowZAxisItem, SfxBoolItem, CHATTR_TITLE_SHOW_Z_AXIS, FALSE );
	BOOL bNewShowZAxis = pNewShowZAxisItem ? pNewShowZAxisItem->GetValue() : bOldShowZAxis;

	SFX_REQUEST_ARG( rReq, pNewZAxisItem, SfxStringItem, CHATTR_TITLE_Z_AXIS, FALSE );
#ifdef IRIX
	const String& aNewZAxis = pNewZAxisItem ? (String)pNewZAxisItem->GetValue() : aOldZAxis;
#else
	const String& aNewZAxis = pNewZAxisItem ? pNewZAxisItem->GetValue() : aOldZAxis;
#endif


	if (pDoc->ChangeTitle(bNewShowMain, aNewMain, bNewShowSub, aNewSub,
						  bNewShowXAxis, aNewXAxis, bNewShowYAxis,
						  aNewYAxis, bNewShowZAxis, aNewZAxis))
	{
		SchUndoInsertTitle* pUndo =
				new SchUndoInsertTitle(*pDoc,
									   bOldShowMain, aOldMain,
									   bOldShowSub, aOldSub,
									   bOldShowXAxis, aOldXAxis,
									   bOldShowYAxis, aOldYAxis,
									   bOldShowZAxis, aOldZAxis,
									   bNewShowMain, aNewMain,
									   bNewShowSub, aNewSub,
									   bNewShowXAxis, aNewXAxis,
									   bNewShowYAxis, aNewYAxis,
									   bNewShowZAxis, aNewZAxis);
		pUndo->SetComment(String(SchResId(STR_UNDO_INSERT_TITLE)));
		pViewSh->GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
	}

	RemarkObject ();
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuInsertTitle::Activate()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuInsertTitle::Deactivate()
{
}


