/*************************************************************************
 *
 *  $RCSfile: databrws.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/26 18:01:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _ZFORLIST_HXX //autogen
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif


#include "memchrt.hxx"
#include "chtmodel.hxx"
#include "schresid.hxx"
#include "schdll.hxx"
#include "float.h"
#include "databrws.hxx"
#include "glob.hrc"
#include "strings.hrc"


/*  BROWSER_COLUMNSELECTION :  single cells may be selected rather than only
                               entire rows
    BROWSER_(H|V)LINES :       show horizontal or vertical grid-lines

    BROWSER_AUTO_(H|V)SCROLL : scroll automated horizontally or vertically when
                               cursor is moved beyond the edge of the dialog
    BROWSER_HIGHLIGHT_NONE :   Do not mark the current row with selection color
                               (usually blue)

 */
#define BROWSER_STANDARD_FLAGS  \
    BROWSER_COLUMNSELECTION | \
    BROWSER_HLINES | BROWSER_VLINES | \
    BROWSER_AUTO_HSCROLL | BROWSER_AUTO_VSCROLL | \
    BROWSER_HIGHLIGHT_NONE

// BROWSER_HIDECURSOR would prevent flickering in edit fields, but navigating
// with shift up/down, and entering non-editable cells would be problematic,
// e.g.  the first cell, or when being in read-only mode

using namespace ::svt;

ChartDataBrowseBox::ChartDataBrowseBox(Window* pParent, const ResId& rId) :
	::svt::EditBrowseBox( pParent, rId, EBBF_SMART_TAB_TRAVEL | EBBF_HANDLE_COLUMN_TEXT, BROWSER_STANDARD_FLAGS ),
	m_pModel( NULL ),
	m_pLogBook( NULL ),
	m_nSeekRow( 0 ),
    m_bIsReadOnly( false ),
    m_bIsDirty( false ),
    m_aEditField( & EditBrowseBox::GetDataWindow(), WB_NOBORDER ),
    m_rEditController( new ::svt::EditCellController( & m_aEditField ))
{
    RenewTable();
    SetClean();
}

ChartDataBrowseBox::~ChartDataBrowseBox()
{
}

bool ChartDataBrowseBox::MayInsertRow() const
{
    return ! IsReadOnly();
}

bool ChartDataBrowseBox::MayInsertColumn() const
{
    return ! IsReadOnly();
}

bool ChartDataBrowseBox::MayDeleteRow() const
{
    return ! IsReadOnly()
        && ( GetCurRow() > 0 )
        && ( GetRowCount() > 2 );
}

bool ChartDataBrowseBox::MayDeleteColumn() const
{
    return ! IsReadOnly()
        && ( GetCurColumnId() > 1 )
        && ( ColCount() > 3 );
}

bool ChartDataBrowseBox::MaySwapRows() const
{
    return ! IsReadOnly()
        && ( GetCurRow() > 0 )
        && ( GetCurRow() < GetRowCount() - 1 );
}

bool ChartDataBrowseBox::MaySwapColumns() const
{
    return ! IsReadOnly()
        && ( GetCurColumnId() > 1 )
        && ( GetCurColumnId() < ColCount() - 1 );
}

bool ChartDataBrowseBox::MaySortRow() const
{
    return ! IsReadOnly() && ( GetCurRow() > 0 );
}

bool ChartDataBrowseBox::MaySortColumn() const
{
    return ! IsReadOnly() && ( GetCurColumnId() > 1 );
}



void ChartDataBrowseBox::RenewTable()
{
    long nOldRow     = GetCurRow();
    USHORT nOldColId = GetCurColumnId();

	BOOL bLastUpdateMode = GetUpdateMode();
	SetUpdateMode( FALSE );

    if( IsModified() )
        SaveModified();

    DeactivateCell();

    RemoveColumns();
    RowRemoved( 1, GetRowCount() );

    // for row numbers
	InsertHandleColumn( static_cast< sal_uInt16 >(
                            GetDataWindow().LogicToPixel( Size( 42, 0 )).getWidth() ));

    if( m_apMemChart.get() )
    {
        const long nColWidth = GetDataWindow().LogicToPixel( Size( 72, 0 )).getWidth();
        const short nColCnt  = m_apMemChart->GetColCount() + 1;

		for( short i = 1; i <= nColCnt; ++i )
			InsertDataColumn( i, GetColString( i ), nColWidth );

		short nRowCnt = m_apMemChart->GetRowCount() + 1;

 		RowInserted( 1, nRowCnt );

		GoToRow( ::std::min< long >( nOldRow, GetRowCount() - 1 ));
        GoToColumnId( ::std::min< USHORT >( nOldColId, ColCount() - 1 ));
    }

    SetDirty();

	SetUpdateMode( bLastUpdateMode );
    ActivateCell();
    Invalidate();
}

String ChartDataBrowseBox::GetColString(USHORT nColumnId) const
{
	if (nColumnId >= 1)
	{
		String aColString( (sal_Unicode)('A' + (nColumnId - 1) % 26));

		ULONG nFact = 27;

		for (;;)
		{
			ULONG nDiv = nColumnId / nFact;
			if (nDiv == 0)
				break;

			aColString.Insert( (sal_Unicode)('A' + ((nDiv - 1) % 26)), 0 );

			nFact *= 26;
		}

		return aColString;
	}

	return String();
}

String ChartDataBrowseBox::GetRowString(long _Row) const
{
	return String::CreateFromInt32( _Row + 1 );
}

String ChartDataBrowseBox::GetCellText( long _nRow, USHORT _nColumnId ) const
{
	String aResult;

	if( _nColumnId == 0 )
	{
		aResult = GetRowString( _nRow );
	}
	else if( _nRow == 0 )
	{
		if( _nColumnId > 1 && m_apMemChart.get() )
			aResult = m_apMemChart->GetColText(
                static_cast< short >( _nColumnId - 2 ));
	}
	else if( _nRow > 0 )			// can be -1
	{
        if( m_apMemChart.get())
        {
            if( _nColumnId == 1 )
            {
                aResult = m_apMemChart->GetRowText(
                    static_cast< short >( _nRow - 1 ));
            }
            else
            {
                DBG_ASSERT( m_pModel, "No Model" );
                double fData = m_apMemChart->GetData(
                    static_cast< short >( _nColumnId - 2 ),
                    static_cast< short >( _nRow - 1 ));

                if( fData != DBL_MIN )
                {
                    SvNumberFormatter* pFormatter = m_pModel->GetNumFormatter();
                    Color* pDummy = NULL;
                    pFormatter->GetOutputString( fData,
                                                 pFormatter->GetStandardFormat(
                                                     m_apMemChart->GetDataType(), LANGUAGE_SYSTEM ),
                                                 aResult, &pDummy );
                }
                // else string remains empty
            }
        }
    }

	return aResult;
}

bool ChartDataBrowseBox::SetReadOnly( bool bNewState )
{
    bool bResult = m_bIsReadOnly;

    if( m_bIsReadOnly != bNewState )
    {
        m_bIsReadOnly = bNewState;
        Invalidate();
        DeactivateCell();
    }

    return bResult;
}

bool ChartDataBrowseBox::IsReadOnly() const
{
    return m_bIsReadOnly;
}


bool ChartDataBrowseBox::IsDirty() const
{
    return m_bIsDirty;
}

void ChartDataBrowseBox::SetClean()
{
    m_bIsDirty = false;
}

void ChartDataBrowseBox::SetDirty()
{
    m_bIsDirty = true;
}

void ChartDataBrowseBox::CursorMoved()
{
	EditBrowseBox::CursorMoved();

	if( GetUpdateMode() )
		m_aCursorMovedHdlLink.Call( this );
}

void ChartDataBrowseBox::SetCellModifiedHdl( const Link& rLink )
{
    m_aCellModifiedLink = rLink;
}

void ChartDataBrowseBox::CellModified()
{
    SetDirty();
    m_aCursorMovedHdlLink.Call( this );
}

void ChartDataBrowseBox::SetDataFromModel( const ChartModel* pDoc )
{
	if( pDoc != m_pModel )
	{
		m_pModel = pDoc;
        m_apMemChart.reset();

        if( m_pModel )
		{
			SchMemChart* pData = m_pModel->GetChartData();
            ChartModel * pMutableModel = const_cast< ChartModel * >( m_pModel );

			if( ! pData )
			{
                pMutableModel->InitChartData();
				pData = m_pModel->GetChartData();
			}
            DBG_ASSERT( pData, "No MemChart" );

			if( pData->GetColCount() && pData->GetRowCount() )
			{
				m_apMemChart.reset( new SchMemChart( *pData ));

                RenewTable();
				GoToRow( 1 );
				GoToColumnId( 2 );
			}
			else
			{
				RenewTable();
			}

            // logbook to trace row/column swappings.  This enables a correct
            // setting of attributes later
            if( m_apMemChart.get() )
				m_pLogBook = new SchDataLogBook( *m_apMemChart );

            // the log-book will be removed by the ChartModel
            pMutableModel->SetDataLogBook( m_pLogBook );
		}
		else
		{
			RenewTable();
		}
        SetClean();
	}
}

const SchMemChart* ChartDataBrowseBox::GetData() const
{
    return m_apMemChart.get();
}

void ChartDataBrowseBox::InsertColumn()
{
	DBG_ASSERT( m_apMemChart.get(), "No MemChart" );
	DBG_ASSERT( m_pLogBook, "No LogBook" );

	USHORT nCurId = GetCurColumnId();

	if( nCurId > 0 )
	{
		m_apMemChart->InsertCols( nCurId - 1, 1 );
		m_pLogBook->InsertCol( nCurId - 1 );

		RenewTable();
	}
}

void ChartDataBrowseBox::RemoveColumn()
{
	DBG_ASSERT( m_apMemChart.get(), "No MemChart" );
	DBG_ASSERT( m_pLogBook, "No LogBook" );

    USHORT nCurId = GetCurColumnId();

	if( nCurId > 1 )
	{
        m_apMemChart->RemoveCols( nCurId - 2, 1 );
        m_pLogBook->DeleteCol( nCurId - 2 );

		RenewTable();
	}
}

void ChartDataBrowseBox::InsertRow()
{
	DBG_ASSERT( m_apMemChart.get(), "No MemChart" );

	long nCurRow = GetCurRow();

	if( nCurRow >= 0 )
	{
		m_apMemChart->InsertRows( static_cast< short >( nCurRow ), 1 );
		m_pLogBook->InsertRow( nCurRow );

		RenewTable();
	}
}

void ChartDataBrowseBox::RemoveRow()
{
	DBG_ASSERT( m_apMemChart.get(), "No MemChart" );

	long nCurRow = GetCurRow();

	if( nCurRow > 0 )
	{
        m_apMemChart->RemoveRows( static_cast< short >( nCurRow - 1 ), 1 );
        m_pLogBook->DeleteRow( nCurRow -1 );

		RenewTable();
	}
}

void ChartDataBrowseBox::SwapColumn()
{
	USHORT nCurId = GetCurColumnId();

	if( nCurId > 1 )
	{
		m_apMemChart->SwapCols( nCurId - 2, nCurId - 1 );
		m_pLogBook->SwapCols(   nCurId - 2, nCurId - 1 );

		if( nCurId < ColCount() - 1 )
		{
            Dispatch( BROWSER_CURSORRIGHT );
		}
		Invalidate();
        SetDirty();
	}
}

void ChartDataBrowseBox::SwapRow()
{
	long nCurRow = GetCurRow();

	if( nCurRow > 0 )
	{
		m_apMemChart->SwapRows(
            static_cast< short >( nCurRow - 1 ),
            static_cast< short >( nCurRow ) );
		m_pLogBook->SwapRows( nCurRow - 1, nCurRow );

		if( nCurRow < GetRowCount() - 1 )
		{
            Dispatch( BROWSER_CURSORDOWN );
		}
		Invalidate();
        SetDirty();
	}
}

void ChartDataBrowseBox::SetCursorMovedHdl( const Link& rLink )
{
    m_aCursorMovedHdlLink = rLink;
}

const Link& ChartDataBrowseBox::GetCursorMovedHdl() const
{
    return m_aCursorMovedHdlLink;
}

void ChartDataBrowseBox::QuickSortCol()
{
    DeactivateCell();
	m_apMemChart->SortCols( GetCurRow () - 1 );
	m_pLogBook->SetValid( FALSE );
	Invalidate();
    ActivateCell();
    SetDirty();
}

void ChartDataBrowseBox::QuickSortRow()
{
    DeactivateCell();
	m_apMemChart->SortRows( GetCurColumnId () - 2 );
	m_pLogBook->SetValid( FALSE );
	Invalidate();
    ActivateCell();
    SetDirty();
}

void ChartDataBrowseBox::QuickSortTableCols ()
{
    DeactivateCell();
	m_apMemChart->SortTableRows( GetCurColumnId () - 2 );
	m_pLogBook->SetValid( FALSE );
	Invalidate();
    ActivateCell();
    SetDirty();
}

void ChartDataBrowseBox::QuickSortTableRows ()
{
	m_apMemChart->SortTableCols( GetCurRow () - 1 );
	m_pLogBook->SetValid( FALSE );
	Invalidate();
    ActivateCell();
    SetDirty();
}

// implementations for ::svt::EditBrowseBox (pure virtual methods)
void ChartDataBrowseBox::PaintCell(
    OutputDevice& _rDev, const Rectangle& _rRect, sal_uInt16 _nColumnId ) const
{
    Point aPos( _rRect.TopLeft());
    aPos.X() += 1;

    String aText = GetCellText( m_nSeekRow, _nColumnId );
    Size TxtSize( GetDataWindow().GetTextWidth( aText ), GetDataWindow().GetTextHeight());

    // clipping
    if( aPos.X() < _rRect.Right() || aPos.X() + TxtSize.Width() > _rRect.Right() ||
        aPos.Y() < _rRect.Top() || aPos.Y() + TxtSize.Height() > _rRect.Bottom())
        _rDev.SetClipRegion( _rRect );

    // allow for a disabled control ...
    sal_Bool bEnabled = IsEnabled();
    Color aOriginalColor = _rDev.GetTextColor();
    if( ! bEnabled )
        _rDev.SetTextColor( GetSettings().GetStyleSettings().GetDisableColor() );

    // draw the text
    _rDev.DrawText( aPos, aText );

    // reset the color (if necessary)
    if( ! bEnabled )
        _rDev.SetTextColor( aOriginalColor );

    if( _rDev.IsClipRegion())
        _rDev.SetClipRegion();
}

sal_Bool ChartDataBrowseBox::SeekRow( long nRow )
{
    if( ! EditBrowseBox::SeekRow( nRow ))
        return sal_False;

    if( nRow < 0 )
        m_nSeekRow = - 1;
    else
        m_nSeekRow = nRow;

    return sal_True;
}

sal_Bool ChartDataBrowseBox::IsTabAllowed( sal_Bool bForward ) const
{
    long nRow = GetCurRow();
    long nCol = GetCurColumnId();

    // column 0 is header-column
    long nBadCol = bForward
        ? GetColumnCount() - 1
        : 1;
    long nBadRow = bForward
        ? GetRowCount() - 1
        : 0;

    return ( nRow != nBadRow ||
             nCol != nBadCol );
}

::svt::CellController* ChartDataBrowseBox::GetController( long nRow, sal_uInt16 nCol )
{
    // column 0 is header-column
    return ( m_bIsReadOnly || ( nRow == 0 && nCol == 1 ) )
        ? 0
        : & m_rEditController;
}

void ChartDataBrowseBox::InitController(
    ::svt::CellControllerRef& rController, long nRow, sal_uInt16 nCol )
{
    String aText( GetCellText( nRow, nCol ) );
    m_aEditField.SetText( aText );
    m_aEditField.SetSelection( Selection( 0, aText.Len() ));
}

sal_Bool ChartDataBrowseBox::SaveModified()
{
    if( ! IsModified() )
        return sal_True;

    DBG_ASSERT( m_apMemChart.get(), "No MemChart" );

    sal_Bool bChangeValid = sal_True;

    const short nRow = static_cast< short >( GetCurRow() );
    const short nCol = static_cast< short >( GetCurColumnId() );
    const String aText( m_aEditField.GetText() );

    DBG_ASSERT( nRow > 0 || nCol > 1, "This cell should not be modified!" );

    if( nRow == 0 )
    {
        m_apMemChart->SetColText( nCol - 2, aText );
    }
    else if( nCol == 1 )
    {
        m_apMemChart->SetRowText( nRow - 1, aText );
    }
    else
    {
        // convert text to number
        double fData = DBL_MIN;

        if( aText.Len() > 0 )
        {
			SvNumberFormatter* pFormatter = m_pModel->GetNumFormatter();
			ULONG nFormat =
				pFormatter->GetStandardFormat( m_apMemChart->GetDataType(),
                                               LANGUAGE_SYSTEM );
			if( ! pFormatter->IsNumberFormat( aText, nFormat, fData ))
			{
				( WarningBox( this, WinBits( WB_OK ),
                              String( SchResId( STR_INVALID_NUMBER )))).Execute();
				bChangeValid = false;
			}
        }

        if( bChangeValid )
            m_apMemChart->SetData( nCol - 2, nRow - 1, fData );
    }

    // the first valid change changes this to true
    m_bIsDirty = m_bIsDirty || bChangeValid;

    if( m_bIsDirty )
    {
        RowModified( nRow, nCol );
        ::svt::CellController* pCtrl = GetController( nRow, nCol );
        if( pCtrl )
            pCtrl->ClearModified();
    }

    return bChangeValid;
}

void ChartDataBrowseBox::EndEditing()
{
    if( IsModified())
        SaveModified();
}
