/*************************************************************************
 *
 *  $RCSfile: schmod.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: bm $ $Date: 2001/09/12 16:24:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define ITEMID_SEARCH           SID_SEARCH_ITEM

#pragma hdrstop

#ifndef _FACTORY_HXX //autogen
#include <so3/factory.hxx>
#endif

#include <svx/svxids.hrc>

#include "schdll0.hxx"

#ifndef _SFXOBJFACE_HXX //autogen
#include <sfx2/objface.hxx>
#endif

#ifndef _SFXMSG_HXX //autogen
#include <sfx2/msg.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX
#include <sfx2/viewfrm.hxx>
#endif
#ifndef _SV_STATUS_HXX //autogen
#include <vcl/status.hxx>
#endif
#ifndef _SVDOBJ_HXX //autogen
#include <svx/svdobj.hxx>
#endif
#ifndef _OBJFAC3D_HXX //autogen
#include <svx/objfac3d.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
#ifndef _SFXITEMSET_HXX //autogen
#include <svtools/itemset.hxx>
#endif
#ifndef _XPOOL_HXX //autogen
#include <svx/xpool.hxx>
#endif

#define _SCH_DLL                 // fuer SD_MOD()
#include "schmod.hxx"
#include "schdll.hxx"
#include "schresid.hxx"
#include "objfac.hxx"

#include "app.hrc"
#include "glob.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "cfgids.hxx"

TYPEINIT1( SchModuleDummy, SfxModule );
TYPEINIT1( SchModule, SchModuleDummy );


#define SchModule
#include "schslots.hxx"

#ifndef _SVX_MODCTRL_HXX //autogen
#include <svx/modctrl.hxx>
#endif

SFX_IMPL_INTERFACE( SchModule, SfxModule, SchResId( STR_APPLICATIONOBJECTBAR ) )
// from macro: void SchModule::InitInterface_Impl()
{
	SFX_STATUSBAR_REGISTRATION( RID_STATUSBAR );
}

/*************************************************************************
|*
|* Ctor
|*
\************************************************************************/

SchModule::SchModule(SvFactory* pObjFact) :
	SchModuleDummy(SFX_APP()->CreateResManager("sch"), FALSE, pObjFact),
	pXOutDevPool( NULL ),
	pDragData( NULL ),
	pClipboardData( NULL ),
	mpTransferDragDrop( NULL ),
	mpTransferClipboard( NULL ),
	mpTransferSelectionClipbd( NULL ),
	pChartOptions( NULL )
{
	pSchObjFactory = new SchObjFactory();

	if (!pSchObjFactory->GetInserted())
	{
		SdrObjFactory::InsertMakeObjectHdl(LINK(pSchObjFactory, SchObjFactory, MakeObject));
		SdrObjFactory::InsertMakeUserDataHdl(LINK(pSchObjFactory, SchObjFactory, MakeUserData));

		pSchObjFactory->SetInserted(TRUE);
	}

	// #62493# this factory exists already
	//pE3dFactory = new E3dObjFactory();
	//SdrObjFactory::InsertMakeObjectHdl(LINK(pE3dFactory, E3dObjFactory, MakeObject));

	SetName( String( RTL_CONSTASCII_USTRINGPARAM( "StarChart" )) );

	// establish listener, so that the module is informed
	// right before the application is going to be shut down
	StartListening( *SFX_APP() );
}

/*************************************************************************
|*
|* Dtor
|*
\************************************************************************/

SchModule::~SchModule()
{
	if (pSchObjFactory)
	{
		if (pSchObjFactory->GetInserted())
		{
			SdrObjFactory::RemoveMakeObjectHdl(LINK(pSchObjFactory, SchObjFactory, MakeObject));
			SdrObjFactory::RemoveMakeUserDataHdl(LINK(pSchObjFactory, SchObjFactory, MakeUserData));
		}

		delete pSchObjFactory;
	}
}

/*************************************************************************
|*
|* SfxRequests bearbeiten
|*
\************************************************************************/

void SchModule::Execute(SfxRequest& rReq)
{
	switch (rReq.GetSlot())
	{
		case SID_START_APP:
			if( GetFrame())
				GetFrame()->GetDispatcher()->Execute( SID_NEWDOCDIRECT,
													  SFX_CALLMODE_SYNCHRON );
			break;

// deprecated, but might be reactivated for portal version
//
//  		case SID_OPTIONS:
//  			ExecuteOptionsDlg(rReq);
//  			break;
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchModule::GetState(SfxItemSet& rItemSet)
{
	rItemSet.DisableItem(SID_CONFIGEVENT);
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

XOutdevItemPool* SchModule::GetXOutDevPool()
{
	if (!pXOutDevPool) pXOutDevPool = new XOutdevItemPool;

	return pXOutDevPool;
}

/*************************************************************************
|*
|* Statusbar erzeugen; virtuell, wird vom SFX gerufen
|*
\************************************************************************/

void SchModule::FillStatusBar(StatusBar &rBar)
{
	String aDummy;
	aDummy.Fill( 20, (sal_Unicode)('x') );
	long nWidth = rBar.GetTextWidth( aDummy );

	rBar.InsertItem(SID_CONTEXT, nWidth, SIB_IN | SIB_AUTOSIZE | SIB_LEFT);
	rBar.InsertItem(SID_CONTEXT_TYPE, nWidth, SIB_IN | SIB_AUTOSIZE | SIB_LEFT);
	rBar.InsertItem(SID_DOC_MODIFIED, SvxModifyControl::GetDefItemWidth(rBar));
	rBar.SetHelpId( SID_DOC_MODIFIED, SID_DOC_MODIFIED );

	aDummy.Fill( 30, (sal_Unicode)('x') );
	nWidth = rBar.GetTextWidth( aDummy );

	rBar.InsertItem(SID_ATTR_SIZE, nWidth, SIB_IN | SIB_USERDRAW);
}

/*************************************************************************
|*
|* Lade Module von aussen
|*
\************************************************************************/

SfxModule *SchModuleDummy::Load()
{
	return NULL;
}

/*************************************************************************
|*
|* Lade Module von aussen
|*
\************************************************************************/

SfxModule *SchModule::Load()
{
	return this;
}

/*************************************************************************
|*
|* Loesche Module
|*
\************************************************************************/

void SchModule::Free()
{
//    FreeLibSch ();
}

SchOptions* SchModule::GetSchOptions()
{
	if( ! pChartOptions )
		pChartOptions = new SchOptions();

	return pChartOptions;	
}

/*************************************************************************
|*
|* get notifications
|*
\************************************************************************/

void SchModule::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	if( rHint.ISA( SfxSimpleHint ) && 
		( (SfxSimpleHint&) rHint ).GetId() == SFX_HINT_DEINITIALIZING )
	{
		delete pChartOptions, pChartOptions = NULL;
	}
}
