/*************************************************************************
 *
 *  $RCSfile: schdll.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/16 14:29:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop


#ifndef _STDCTRL_HXX
#include <svtools/stdctrl.hxx>
#endif

#ifndef _SVX_PSZCTRL_HXX
#include <svx/pszctrl.hxx>
#endif

#ifndef _SVX_MODCTRL_HXX
#include <svx/modctrl.hxx>
#endif

#ifndef _SVX_XLINEIT0_HXX
#include <svx/xlineit0.hxx>
#endif

#ifndef _SVX_XLNWTIT_HXX
#include <svx/xlnwtit.hxx>
#endif

#ifndef _SVX_XLNCLIT_HXX
#include <svx/xlnclit.hxx>
#endif

#ifndef _SVX_XFLCLIT_HXX
#include <svx/xflclit.hxx>
#endif

#ifndef _SVX_XFILLIT0_HXX
#include <svx/xfillit0.hxx>
#endif

#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#ifndef _SVX_F3DCHILD_HXX //autogen
#include <svx/f3dchild.hxx>
#endif
// header for XFillTransparenceItem
#ifndef _SVX_XFLTRIT_HXX
#include <svx/xfltrit.hxx>
#endif
#ifndef _COM_SUN_STAR_CHART_CHARTDATACHANGEEVENT_HPP_
#include <com/sun/star/chart/ChartDataChangeEvent.hpp>
#endif


#include "schdll0.hxx"
#include "docshell.hxx"
#include "schmod.hxx"
#include "app.hrc"
#include "schresid.hxx"
#include "schdll.hxx"
#include "memchrt.hxx"
#include "viewshel.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "dgrdata.hxx"
#include "dlggraut.hxx"
#include "objfac.hxx"
#include "res_bmp.hrc"	// contains define for RID_MENU, RID_ACCEL

#include "globopt.hxx"

/*************************************************************************
|*
|* Initialisierung aus SfxApplicaton::Init()
|*
\************************************************************************/

void __EXPORT SchDLL::Init()
{
	// called directly after loading the DLL
	// do whatever you want, you may use Sd-DLL too

	// the SchModule must be created (may loaded by doc-fac or direct)
	SchModuleDummy** ppShlPtr = (SchModuleDummy**) GetAppData(SHL_SCH);
	if ( (*ppShlPtr)->IsLoaded() ) return;

	SvFactory* pFact = PTR_CAST(SvFactory,(*ppShlPtr)->pSchChartDocShellFactory);

	delete (*ppShlPtr);
	(*ppShlPtr) = new SchModule(pFact);

	SchChartDocShell::Factory().RegisterAccel(SchResId(RID_ACCEL));
	SchChartDocShell::Factory().RegisterMenuBar(SchResId(RID_MENU));

	// register menu for Star Portal
 	SchChartDocShell::Factory().RegisterPluginMenuBar( SchResId( RID_PORTAL_MENU ));

	SchViewShell::RegisterFactory(1);

	SfxModule* pMod = SCH_MOD();
	SchModule::RegisterInterface(pMod);
	SchChartDocShell::RegisterInterface(pMod);
	SchViewShell::RegisterInterface(pMod);

	SchDiagramDataWrapper::RegisterChildWindow(0, pMod);
	Svx3DChildWindow::RegisterChildWindow(0, pMod);
	SvxPosSizeStatusBarControl::RegisterControl(SID_ATTR_SIZE, pMod);
	SvxModifyControl::RegisterControl(SID_DOC_MODIFIED, pMod);

    pMod->PutItem( SfxUInt16Item( SID_ATTR_METRIC, ::sch::util::GetMeasureUnit() ));
}

/*************************************************************************
|*
|* Deinitialisierung
|*
\************************************************************************/

void __EXPORT SchDLL::Exit()
{
	// the SchModule must be destroyed
	SchModuleDummy** ppShlPtr = (SchModuleDummy**) GetAppData(SHL_SCH);
	delete (*ppShlPtr);
	(*ppShlPtr) = NULL;
}


extern_c void __LOADONCALLAPI SchSetTransparent( SvInPlaceObjectRef aIPObj, BOOL bTransp )
{
	SchChartDocShellRef aSchChartDocShellRef = &aIPObj;

	if (aSchChartDocShellRef.Is())
	{
		ChartModel& rDoc = aSchChartDocShellRef->GetDoc();

		const SfxItemSet &rAttr = rDoc.GetDiagramAreaAttr();

		SAL_CONST_CAST( SfxItemSet &, rAttr).Put( XLineStyleItem( XLINE_NONE ));
		SAL_CONST_CAST( SfxItemSet &, rAttr).Put( XLineWidthItem( 0 ));
		SAL_CONST_CAST( SfxItemSet &, rAttr).Put( XLineColorItem( String(), COL_BLACK ));
		SAL_CONST_CAST( SfxItemSet &, rAttr).Put( XFillColorItem( String(), COL_WHITE ));

		if( bTransp )
			SAL_CONST_CAST( SfxItemSet &, rAttr).Put( XFillTransparenceItem( 100 ) );
		else
			SAL_CONST_CAST( SfxItemSet &, rAttr).ClearItem( XATTR_FILLTRANSPARENCE );

        rDoc.PageColorChanged( rAttr );

        // #109154# propagate changes in chart item set to drawing object
        rDoc.BuildChart( FALSE );
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c void __LOADONCALLAPI SchUpdate( SvInPlaceObjectRef aIPObj,
										 SchMemChart* pData, OutputDevice* pOut )
{
	SchChartDocShellRef aSchChartDocShellRef = &aIPObj;

	if( aSchChartDocShellRef.Is() )
	{
#ifdef DBG_UTIL
		if( !pData )
			DBG_TRACE( "SchUpdate was called without MemChart" );
#endif
		ChartModel& rDoc = aSchChartDocShellRef->GetDoc();

		if( pData )
		{
			rDoc.SetChartDataBuffered( *pData, FALSE );		// don't update titles. This can't be done via SchUpdate
			rDoc.CheckForNewAxisNumFormat();
			rDoc.SetChanged();								// #72576#

			com::sun::star::chart::ChartDataChangeEvent aEvent;
			aEvent.Type = com::sun::star::chart::ChartDataChangeType_ALL;
			aEvent.StartColumn = 0;
			aEvent.EndColumn = 0;
			aEvent.StartRow = 0;
			aEvent.EndRow = 0;

			aSchChartDocShellRef->DataModified( aEvent );
		}
		else
		{
			rDoc.BuildChart( FALSE );
		}
	}

	aIPObj->SendViewChanged();
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c void __LOADONCALLAPI SchUpdateAttr( SvInPlaceObjectRef aIPObj,
											 SchMemChart* pData,
											 const SfxItemSet& rAttr,
											 OutputDevice* pOut )
{
	DBG_ASSERT(pData, "Kein Chart-Datenobjekt angegeben!");
	if(!pData)return;

	SchChartDocShellRef aSchChartDocShellRef = &aIPObj;

	if (aSchChartDocShellRef.Is())
	{

		ChartModel& rDoc = aSchChartDocShellRef->GetDoc();

		rDoc.SetChartData(*new SchMemChart(*pData));
		rDoc.PutAttr(rAttr);

		if( pOut )
			aSchChartDocShellRef->UpdateChart(pOut);
		else
			rDoc.BuildChart(TRUE);
	}

	aIPObj->SendViewChanged();
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c ModalDialog* __LOADONCALLAPI SchCreateDiagramAutoPilotDlg
												(Window* pParent,
												 SchMemChart* pData,
												 const SfxItemSet& rInAttrs,
												 SfxItemSet& rOutAttrs,
												 BOOL bPrePage)
{
	DBG_ASSERT(pData, "Kein Chart-Datenobjekt angegeben!");

	if(!pData)return NULL;
	return new SchDiagramAutoPilotDlg( pParent, *new SchMemChart(*pData), rInAttrs,
									   rOutAttrs, bPrePage );
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c void __LOADONCALLAPI SchChangeChartData(ModalDialog* pDlg,
												 SchMemChart* pData)
{
	DBG_ASSERT(pData, "Kein Chart-Datenobjekt angegeben!");

	((SchDiagramAutoPilotDlg*)pDlg)->ChangeChartData(*new SchMemChart(*pData));
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c SfxTabDialog* __LOADONCALLAPI SchCreateOptionsDlg(Window* pParent,
														   const SfxItemSet& rInAttrs,
														   XOutdevItemPool* pItemPool)
{
	return( NULL );
	//return new SchOptionsDlg(pParent, rInAttrs, pItemPool);
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c SchMemChart* __LOADONCALLAPI SchGetChartData (SvInPlaceObjectRef aIPObj)
{
	SchChartDocShellRef aSchChartDocShellRef = &aIPObj;

	if (aSchChartDocShellRef.Is())
	{
		ChartModel& rDoc = aSchChartDocShellRef->GetDoc();
		SchMemChart* pMemChart = rDoc.GetChartData ();

		if (pMemChart)
		{
			pMemChart->SetMainTitle(rDoc.MainTitle());
			pMemChart->SetSubTitle(rDoc.SubTitle());
			pMemChart->SetXAxisTitle(rDoc.XAxisTitle());
			pMemChart->SetYAxisTitle(rDoc.YAxisTitle());
			pMemChart->SetZAxisTitle(rDoc.ZAxisTitle());
		}

		return pMemChart;
	}
	else return 0;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c SchMemChart* __LOADONCALLAPI SchNewMemChartNone ()
{
	return new SchMemChart;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c SchMemChart* __LOADONCALLAPI SchNewMemChartXY (short nCols, short nRows)
{
	return new SchMemChart (nCols, nRows);
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c SchMemChart* __LOADONCALLAPI SchNewMemChartCopy (const SchMemChart &rMemChart)
{
	return new SchMemChart (rMemChart);
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

extern_c ChartModel* __LOADONCALLAPI SchGetModel (SvInPlaceObjectRef aIPObj)
{
	SchChartDocShellRef aSchChartDocShellRef = &aIPObj;

	if (aSchChartDocShellRef.Is()) return &aSchChartDocShellRef->GetDoc();
	else return 0;
}

extern_c void __LOADONCALLAPI SchGetDefaultForColumnText(
				const SchMemChart& rMemChart, sal_Int32 nCol, String& aResult )
{
	aResult = rMemChart.GetDefaultColumnText( nCol );
}

extern_c void __LOADONCALLAPI SchGetDefaultForRowText(
			const SchMemChart& rMemChart, sal_Int32 nRow, String& aResult )
{
	aResult = rMemChart.GetDefaultRowText( nRow );
}

extern_c void __LOADONCALLAPI SchConvertChartRangeForWriter(
							SchMemChart& rMemChart, BOOL bOldToNew )
{
	rMemChart.ConvertChartRangeForWriter( bOldToNew );
}

extern_c void __LOADONCALLAPI SchConvertChartRangeForCalc(
							SchMemChart& rMemChart, BOOL bOldToNew )
{
	rMemChart.ConvertChartRangeForCalc( bOldToNew );
}

extern_c void __LOADONCALLAPI SchMemChartResetTranslation(
							SchMemChart& rMemChart, long *pTable,long nCnt )
{
	rMemChart.ResetTranslation( pTable, nCnt );
}

extern_c void __LOADONCALLAPI SchMemChartUpdateTranslation(
							SchMemChart& rMemChart, long *pTable, long nCnt )
{
	rMemChart.UpdateTranslation( pTable, nCnt );
}

extern_c void __LOADONCALLAPI SchMemChartInsertCols( SchMemChart& rMemChart,
												short nAtCol, short nCount)
{
	rMemChart.InsertCols( nAtCol, nCount );
}

extern_c void __LOADONCALLAPI SchMemChartRemoveCols( SchMemChart& rMemChart,
												short nAtCol, short nCount)
{
	rMemChart.RemoveCols( nAtCol, nCount );
}

extern_c void __LOADONCALLAPI SchMemChartInsertRows( SchMemChart& rMemChart,
												short nAtRow, short nCount)
{
	rMemChart.InsertRows( nAtRow, nCount );
}

extern_c void __LOADONCALLAPI SchMemChartRemoveRows( SchMemChart& rMemChart,
												short nAtRow, short nCount)
{
	rMemChart.RemoveRows( nAtRow, nCount );
}

extern_c void __LOADONCALLAPI SchMemChartSwapCols( SchMemChart& rMemChart,
								  				int nAtCol1, int nAtCol2)
{
	rMemChart.SwapCols( nAtCol1, nAtCol2 );
}

extern_c void __LOADONCALLAPI SchMemChartSwapRows( SchMemChart& rMemChart,
								  				int nAtRow1,int nAtRow2)
{
	rMemChart.SwapRows( nAtRow1, nAtRow2 );
}


