/*************************************************************************
 *
 *  $RCSfile: chtmode8.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: bm $ $Date: 2002/07/30 13:16:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "chtmodel.hxx"

/*
  ------------------------------------------------------------
  Some Information about chart types. This may be used as a
  basis for creating some chart classes (!)  with
  corresponding members.
  ------------------------------------------------------------
 
        Styles                     Basic:        Perc  Stack  Bar  3D   Symbols Net Axis sign neg. spline  XY Stat.

CHSTYLE_2D_LINE,                   Line           -      -     -     -      -     -    -   x    x    -       -   x
CHSTYLE_2D_STACKEDLINE,            Line           -      x     -     -      -     -    -   x    x    -       -   -
CHSTYLE_2D_PERCENTLINE,            Line           x      x     -     -      -     -    -   -    x    -       -   -
CHSTYLE_2D_COLUMN,                 Column         -      -     -     -      -     -    -   x    x    -       -   x
CHSTYLE_2D_STACKEDCOLUMN,          Column         -      x     -     -      -     -    -   x    x    -       -   -
CHSTYLE_2D_PERCENTCOLUMN,          Column         x      x     -     -      -     -    -   -    x    -       -   -
CHSTYLE_2D_BAR,                    *Column        -      -     x     -      -     -    -   x    x    -       -   x
CHSTYLE_2D_STACKEDBAR,             *Column        -      x     x     -      -     -    -   x    x    -       -   -
CHSTYLE_2D_PERCENTBAR,             *Column        x      x     x     -      -     -    -   -    x    -       -   -
CHSTYLE_2D_AREA,                   Area           -      -     -     -      -     -    -   x    x    -       -   -
CHSTYLE_2D_STACKEDAREA,            Area           -      x     -     -      -     -    -   x    x    -       -   -
CHSTYLE_2D_PERCENTAREA,            Area           x      x     -     -      -     -    x   -    x    -       -   -
CHSTYLE_2D_PIE,                    Pie            x      x     -     -      -     -    -   -    x    -       -   -
CHSTYLE_3D_STRIPE,                 Stripe?        -      -     -     x      -     -    -   x    x    -       -   -
CHSTYLE_3D_COLUMN,                 Column         -      -     -     x      -     -    -   x    x    -       -   -
CHSTYLE_3D_FLATCOLUMN,             Column?        -      -     -     x      -     -    -   x    x    -       -   -
CHSTYLE_3D_STACKEDFLATCOLUMN       Column         -      x     -     x      -     -    -   x    x    -       -   -
CHSTYLE_3D_PERCENTFLATCOLUMN       Column         x      x     -     x      -     -    -   -    x    -       -   -
CHSTYLE_3D_AREA,                   Area           -      -     -     x      -     -    -   x    x    -       -   -
CHSTYLE_3D_STACKEDAREA,            Area           -      x     -     x      -     -    -   x    x    -       -   -
CHSTYLE_3D_PERCENTAREA,            Area           x      x     -     x      -     -    -   -    -    -       -   -
CHSTYLE_3D_SURFACE,                Surface        -      -     -     x      -     -    -   x    x    -       -   -
CHSTYLE_3D_PIE,                    Pie            x      x     ?     x      -     -    x   -    x    -       -   -
CHSTYLE_2D_XY,                     XYZ            -      -     -     -      -     -    -   x    x    -       x   x
CHSTYLE_3D_XYZ,                    XYZ            -      -     -     x      -     -    -   x    x    -       x   -
CHSTYLE_2D_LINESYMBOLS,            Line           -      -     -     -      x     -    -   x    x    -       -   x
CHSTYLE_2D_STACKEDLINESYM,         Line           -      x     -     -      x     -    -   x    x    -       -   -
CHSTYLE_2D_PERCENTLINESYM,         Line           x      x     -     -      x     -    -   -    x    -       -   -
CHSTYLE_2D_XYSYMBOLS,              XYZ            -      -     -     -      x     -    -   x    x    -       x   x
CHSTYLE_3D_XYZSYMBOLS,             XYZ            -      -     -     x      x     -    -   x    x    -       x   -
CHSTYLE_2D_DONUT1,                 *PIE           ?      ?     ?     -      -     -    x   -    x    -       -   -
CHSTYLE_2D_DONUT2,                 *PIE           ?      ?     ?     -      -     -    x   -    x    -       -   -
CHSTYLE_3D_BAR,                    *Column        -      -     x     x      -     -    -   x    x    -       -   -
CHSTYLE_3D_FLATBAR,                *Column        -      -     x     x      -     -    -   x    x    -       -   -
CHSTYLE_3D_STACKEDFLATBAR,         *Column        -      x     x     x      -     -    -   x    x    -       -   -
CHSTYLE_3D_PERCENTFLATBAR,         *Column        x      x     x     x      -     -    -   -    x    -       -   -
CHSTYLE_2D_PIE_SEGOF1,             PIE            x      x     ?     -      -     -    x   -    x    -       -   -
CHSTYLE_2D_PIE_SEGOFALL,           PIE            x      x     ?     -      -     -    x   -    x    -       -   -
CHSTYLE_2D_NET,                    Net            -      -     -     -      -     x    -   x    x    -       -   -
CHSTYLE_2D_NET_SYMBOLS,            Net            -      -     -     -      x     x    -   x    x    -       -   -
CHSTYLE_2D_NET_STACK,              Net            -      x     -     -      -     x    -   x    x    -       -   -
CHSTYLE_2D_NET_SYMBOLS_STACK,      Net            -      x     -     -      x     x    -   x    x    -       -   -
CHSTYLE_2D_NET_PERCENT,            Net            x      x     -     -      -     x    -   -    x    -       -   -
CHSTYLE_2D_NET_SYMBOLS_PERCENT,    Net            x      x     -     -      x     x    -   -    x    -       -   -
CHSTYLE_2D_CUBIC_SPLINE,           SplineC        -      -     -     -      -     -    -   x    x    C       -   x
CHSTYLE_2D_CUBIC_SPLINE_SYMBOL,    SplineC        -      -     -     -      x     -    -   x    x    C       -   x
CHSTYLE_2D_B_SPLINE,               SplineB        -      -     -     -      -     -    -   x    x    B       -   x
CHSTYLE_2D_B_SPLINE_SYMBOL,        SplineB        -      -     -     -      x     -    -   x    x    B       -   x
CHSTYLE_2D_CUBIC_SPLINE_XY,        SplineC        -      -     -     -      -     -    -   x    x    C       x   x
CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY, SplineC        -      -     -     -      x     -    -   x    x    C       x   x
CHSTYLE_2D_B_SPLINE_XY,            SplineB        -      -     -     -      -     -    -   x    x    B       x   x
CHSTYLE_2D_B_SPLINE_SYMBOL_XY,     SplineB        -      -     -     -      x     -    -   x    x    B       x   x
CHSTYLE_2D_XY_LINE,                Line_&_XYZ     -      -     -     -      -     -    -   x    x    -       x   -
CHSTYLE_2D_LINE_COLUMN,            Column+1_Line  -      -     -     -      -     -    -   x    x    -       -   -
CHSTYLE_2D_LINE_STACKEDCOLUMN Column+1_Line - x - - - - - x x - - - */

// meaning supports symbols
BOOL ChartModel::HasSymbols(const long nRow) const
{

	switch(eChartStyle)
	{
		case CHSTYLE_2D_STOCK_1:
		case CHSTYLE_2D_STOCK_2:



		case CHSTYLE_2D_XY :
			DBG_TRACE("ChartModel::HasSymbols:Achtung, neuer Typ, ungetestet");

		case CHSTYLE_2D_LINESYMBOLS:
		case CHSTYLE_2D_STACKEDLINESYM:
		case CHSTYLE_2D_PERCENTLINESYM:
		case CHSTYLE_2D_XYSYMBOLS:
		case CHSTYLE_3D_XYZSYMBOLS:
		case CHSTYLE_2D_NET_SYMBOLS_STACK:
		case CHSTYLE_2D_NET_SYMBOLS:
		case CHSTYLE_2D_NET_SYMBOLS_PERCENT:
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL:
		case CHSTYLE_2D_B_SPLINE_SYMBOL:
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY:
		case CHSTYLE_2D_B_SPLINE_SYMBOL_XY:
			return TRUE;
			break;

		case CHSTYLE_2D_STOCK_3:
		case CHSTYLE_2D_STOCK_4:
			return (nRow!=0);

		case CHSTYLE_2D_LINE_STACKEDCOLUMN:
		case CHSTYLE_2D_LINE_COLUMN:
			if(nRow >= (GetRowCount() - nNumLinesInColChart))
				return TRUE;
			return FALSE;
			break;

		default:
			break;
	}
	return FALSE;
}

BOOL ChartModel::IsLine(const long nRow) const
{
	switch( eChartStyle )
	{
		case CHSTYLE_2D_STOCK_3:
		case CHSTYLE_2D_STOCK_4:
			return nRow ? TRUE : FALSE;

		case CHSTYLE_2D_STOCK_1:
		case CHSTYLE_2D_STOCK_2:

		// lines and symbol types
		case CHSTYLE_2D_XY :
		case CHSTYLE_2D_NET_SYMBOLS_STACK :
		case CHSTYLE_2D_NET_SYMBOLS :
		case CHSTYLE_2D_NET_SYMBOLS_PERCENT :
		case CHSTYLE_2D_LINESYMBOLS:
		case CHSTYLE_2D_STACKEDLINESYM:
		case CHSTYLE_2D_PERCENTLINESYM:
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL:
		case CHSTYLE_2D_B_SPLINE_SYMBOL:
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY:
		case CHSTYLE_2D_B_SPLINE_SYMBOL_XY:

		// lines only
		case CHSTYLE_2D_CUBIC_SPLINE_XY :
		case CHSTYLE_2D_B_SPLINE_XY :
		case CHSTYLE_2D_LINE :
		case CHSTYLE_2D_STACKEDLINE :
		case CHSTYLE_2D_PERCENTLINE :
		case CHSTYLE_2D_NET :
		case CHSTYLE_2D_NET_STACK :
		case CHSTYLE_2D_NET_PERCENT :
		case CHSTYLE_2D_CUBIC_SPLINE :
		case CHSTYLE_2D_B_SPLINE :
		case CHSTYLE_2D_XY_LINE :
			return TRUE;

		case CHSTYLE_2D_LINE_STACKEDCOLUMN:
		case CHSTYLE_2D_LINE_COLUMN:
			if( nRow >= (GetRowCount() - nNumLinesInColChart))
				return ( GetRowCount() > 1 ); // only one series => must be a bar
			return FALSE;

		default:
			return FALSE;
	}
}

// for all types which return TRUE here it is assumed
// that toggling bSwitchColRow is allowed
BOOL ChartModel::IsBar() const
{
	switch( eChartStyle )
	{
		case CHSTYLE_2D_BAR:
		case CHSTYLE_2D_STACKEDBAR:
		case CHSTYLE_2D_PERCENTBAR:
		case CHSTYLE_3D_BAR:
		case CHSTYLE_3D_FLATBAR:
		case CHSTYLE_3D_STACKEDFLATBAR:
		case CHSTYLE_3D_PERCENTFLATBAR:
			return TRUE;

		default:
			return FALSE;
	}
}
BOOL ChartModel::IsCol(long nRow) const
{
	switch( eChartStyle )
	{
		case CHSTYLE_2D_COLUMN:
		case CHSTYLE_2D_STACKEDCOLUMN:
		case CHSTYLE_2D_PERCENTCOLUMN:
		case CHSTYLE_3D_COLUMN:
		case CHSTYLE_3D_FLATCOLUMN:
		case CHSTYLE_3D_STACKEDFLATCOLUMN:
		case CHSTYLE_3D_PERCENTFLATCOLUMN:
			return TRUE;

		case CHSTYLE_2D_STOCK_3:
		case CHSTYLE_2D_STOCK_4:
			return nRow ? FALSE : TRUE ;

		case CHSTYLE_2D_LINE_STACKEDCOLUMN:
		case CHSTYLE_2D_LINE_COLUMN:
			return ! (nRow >= (GetRowCount() - nNumLinesInColChart));

		default:
			return FALSE;
	}
}

bool ChartModel::IsFlat3DChart() const
{
    switch( eChartStyle )
    {
		case CHSTYLE_3D_FLATCOLUMN:
		case CHSTYLE_3D_FLATBAR:
		case CHSTYLE_3D_STACKEDFLATCOLUMN:
		case CHSTYLE_3D_STACKEDFLATBAR:
		case CHSTYLE_3D_PERCENTFLATCOLUMN:
		case CHSTYLE_3D_PERCENTFLATBAR:
            return true;

        default:
            return false;
    }
}

BOOL ChartModel::Is3DChart() const
{
	switch( eChartStyle )
	{
		case CHSTYLE_3D_STRIPE:
		case CHSTYLE_3D_COLUMN:
		case CHSTYLE_3D_BAR:
		case CHSTYLE_3D_FLATCOLUMN:
		case CHSTYLE_3D_FLATBAR:
		case CHSTYLE_3D_STACKEDFLATCOLUMN:
		case CHSTYLE_3D_STACKEDFLATBAR:
		case CHSTYLE_3D_PERCENTFLATCOLUMN:
		case CHSTYLE_3D_PERCENTFLATBAR:
		case CHSTYLE_3D_AREA:
		case CHSTYLE_3D_STACKEDAREA:
		case CHSTYLE_3D_PERCENTAREA:
		case CHSTYLE_3D_SURFACE:
		case CHSTYLE_3D_PIE:
		// new since 380 Build 1502, but still not supported
		case CHSTYLE_3D_XYZ:
		case CHSTYLE_3D_XYZSYMBOLS:
			return TRUE;

		default:
			return FALSE;
	}
}

BOOL ChartModel::IsStackedChart() const
{
	switch( eChartStyle )
	{
		case CHSTYLE_2D_STACKEDLINE:
		case CHSTYLE_2D_PERCENTLINE:
		case CHSTYLE_2D_STACKEDAREA:
		case CHSTYLE_2D_PERCENTAREA:
		case CHSTYLE_2D_STACKEDCOLUMN:
		case CHSTYLE_2D_PERCENTCOLUMN:
		case CHSTYLE_2D_STACKEDBAR:
		case CHSTYLE_2D_PERCENTBAR:
		case CHSTYLE_3D_STACKEDFLATCOLUMN:
		case CHSTYLE_3D_PERCENTFLATCOLUMN:
		case CHSTYLE_3D_STACKEDFLATBAR:
		case CHSTYLE_3D_PERCENTFLATBAR:
		case CHSTYLE_3D_STACKEDAREA:
		case CHSTYLE_3D_PERCENTAREA:
		case CHSTYLE_2D_LINE_STACKEDCOLUMN:
			return TRUE;

		default:
			return FALSE;
	}
}

BOOL ChartModel::IsStacked() const
{
	if( IsPercent() )              // percent => stacked
		return TRUE;

	switch( eChartStyle )
	{
		case CHSTYLE_2D_STACKEDCOLUMN:
		case CHSTYLE_2D_STACKEDBAR:
		case CHSTYLE_2D_STACKEDLINE:
		case CHSTYLE_2D_STACKEDAREA:
		case CHSTYLE_3D_STACKEDFLATCOLUMN:
		case CHSTYLE_3D_STACKEDFLATBAR:
		case CHSTYLE_3D_STACKEDAREA:
		case CHSTYLE_2D_STACKEDLINESYM:
		case CHSTYLE_2D_NET_STACK:
		case CHSTYLE_2D_NET_SYMBOLS_STACK:
		case CHSTYLE_2D_LINE_STACKEDCOLUMN:
			return TRUE;

		default:
			return FALSE;
	}
}

BOOL ChartModel::IsPercentChart() const
{
	switch( eChartStyle )
	{
		case CHSTYLE_2D_PERCENTLINE:
		case CHSTYLE_2D_PERCENTAREA:
		case CHSTYLE_2D_PERCENTCOLUMN:
		case CHSTYLE_2D_PERCENTBAR:
		case CHSTYLE_3D_PERCENTFLATCOLUMN:
		case CHSTYLE_3D_PERCENTAREA:
			return TRUE;

		default:
			return FALSE;
	}
}

BOOL ChartModel::IsPercent() const
{
	switch( eChartStyle )
	{
		case CHSTYLE_2D_PERCENTCOLUMN:
		case CHSTYLE_2D_PERCENTBAR:
		case CHSTYLE_2D_PERCENTLINE:
		case CHSTYLE_2D_PERCENTAREA:
		case CHSTYLE_3D_PERCENTFLATCOLUMN:
		case CHSTYLE_3D_PERCENTAREA:
		case CHSTYLE_2D_NET_PERCENT:
		case CHSTYLE_2D_NET_SYMBOLS_PERCENT:
		case CHSTYLE_2D_PERCENTLINESYM:
		case CHSTYLE_3D_PERCENTFLATBAR:
			return TRUE;

		default:
			return FALSE;
	}
}

BOOL ChartModel::IsArea(long nRow)
{
	switch( eChartStyle )
	{
		case CHSTYLE_2D_AREA:
		case CHSTYLE_2D_STACKEDAREA:
		case CHSTYLE_2D_PERCENTAREA:
		case CHSTYLE_3D_AREA:
		case CHSTYLE_3D_STACKEDAREA:
		case CHSTYLE_3D_PERCENTAREA:
			return TRUE;

		default:
			return FALSE;
	}
}

BOOL ChartModel::IsAxisChart() const
{
	switch( eChartStyle )
	{
		case CHSTYLE_2D_DONUT1:
		case CHSTYLE_2D_DONUT2:
		case CHSTYLE_2D_PIE:
		case CHSTYLE_2D_PIE_SEGOF1:
		case CHSTYLE_2D_PIE_SEGOFALL:
		case CHSTYLE_3D_PIE:
			return FALSE;

		default:
			return TRUE;
	}
}

BOOL ChartModel::IsNegativeChart( SvxChartStyle* pStyle ) const
{
	switch( pStyle? *pStyle: eChartStyle )
	{
		case CHSTYLE_3D_PERCENTAREA:
			return FALSE;

		default:
			return TRUE;
	}
}

BOOL ChartModel::IsSignedChart( SvxChartStyle* pStyle ) const
{
	switch( pStyle? *pStyle: eChartStyle )
	{
		case CHSTYLE_3D_PIE :
		case CHSTYLE_2D_PIE :
		case CHSTYLE_2D_PIE_SEGOF1:
		case CHSTYLE_2D_PIE_SEGOFALL:
		case CHSTYLE_2D_DONUT1:
		case CHSTYLE_2D_DONUT2:
		case CHSTYLE_2D_PERCENTLINE :
		case CHSTYLE_2D_PERCENTCOLUMN :
		case CHSTYLE_2D_PERCENTAREA :
		case CHSTYLE_3D_PERCENTFLATCOLUMN :
		case CHSTYLE_3D_PERCENTAREA :
		case CHSTYLE_2D_PERCENTBAR :
			return FALSE;

		default :
			return TRUE;
	}
}

BOOL ChartModel::IsPieOrDonutChart() const
{
	switch( eChartStyle )
	{
		case CHSTYLE_3D_PIE :
		case CHSTYLE_2D_PIE :
		case CHSTYLE_2D_PIE_SEGOF1:
		case CHSTYLE_2D_PIE_SEGOFALL:
		case CHSTYLE_2D_DONUT1:
		case CHSTYLE_2D_DONUT2:
			return TRUE;

		default:
			return FALSE;
	}
}

BOOL ChartModel::IsPieChart() const
{
	switch( eChartStyle )
	{
		case CHSTYLE_3D_PIE :
		case CHSTYLE_2D_PIE :
		case CHSTYLE_2D_PIE_SEGOF1:
		case CHSTYLE_2D_PIE_SEGOFALL:
			return TRUE;

		default:
			return FALSE;
	}
}

BOOL ChartModel::IsXYChart( SvxChartStyle* pStyle ) const
{
	// if pStyle == NULL (default) the current style of 'this' is used

	switch( pStyle? *pStyle: eChartStyle )
	{
		case CHSTYLE_2D_XY :
		case CHSTYLE_3D_XYZ :
		case CHSTYLE_2D_XYSYMBOLS :
		case CHSTYLE_3D_XYZSYMBOLS :
		case CHSTYLE_2D_CUBIC_SPLINE_XY :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
		case CHSTYLE_2D_B_SPLINE_XY :
		case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
		case CHSTYLE_2D_XY_LINE :
			return TRUE;

		case CHSTYLE_ADDIN:
			return TRUE;

		default :
			return FALSE;
	}
}


BOOL ChartModel::IsSplineChart () const
{
	switch( eChartStyle )
	{
		case CHSTYLE_2D_CUBIC_SPLINE :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL :
		case CHSTYLE_2D_B_SPLINE :
		case CHSTYLE_2D_B_SPLINE_SYMBOL :
		case CHSTYLE_2D_CUBIC_SPLINE_XY :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
		case CHSTYLE_2D_B_SPLINE_XY :
		case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
			return TRUE;

		default :
			return FALSE;
	}
}

BOOL ChartModel::IsStatisticChart() const
{
	switch( eChartStyle )
	{
		case CHSTYLE_2D_BAR :
		case CHSTYLE_2D_B_SPLINE :
		case CHSTYLE_2D_B_SPLINE_SYMBOL :
		case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
		case CHSTYLE_2D_B_SPLINE_XY :
		case CHSTYLE_2D_COLUMN :
		case CHSTYLE_2D_CUBIC_SPLINE :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
		case CHSTYLE_2D_CUBIC_SPLINE_XY :
		case CHSTYLE_2D_LINE :
		case CHSTYLE_2D_LINESYMBOLS :
		case CHSTYLE_2D_STOCK_1:
		case CHSTYLE_2D_STOCK_2:
		case CHSTYLE_2D_STOCK_3:
		case CHSTYLE_2D_STOCK_4:
		case CHSTYLE_2D_XY :
		case CHSTYLE_2D_XYSYMBOLS :
		case CHSTYLE_2D_XY_LINE :
			return TRUE;

		default :
			return FALSE;
	}
}

BOOL ChartModel::IsNetChart() const
{
	switch( eChartStyle )
	{
		case CHSTYLE_2D_NET :
		case CHSTYLE_2D_NET_SYMBOLS :
		case CHSTYLE_2D_NET_STACK :
		case CHSTYLE_2D_NET_SYMBOLS_STACK :
		case CHSTYLE_2D_NET_PERCENT :
		case CHSTYLE_2D_NET_SYMBOLS_PERCENT :
			return TRUE;

		default :
			return FALSE;
	}
}

// ========================================
// return base type
// ========================================

long ChartModel::GetBaseType() const
{
	switch( eChartStyle )
	{
		case CHSTYLE_2D_B_SPLINE :
		case CHSTYLE_2D_B_SPLINE_SYMBOL :
		case CHSTYLE_2D_LINE:
		case CHSTYLE_2D_STACKEDLINE:
		case CHSTYLE_2D_PERCENTLINE:
		case CHSTYLE_2D_LINESYMBOLS:
		case CHSTYLE_2D_STACKEDLINESYM:
		case CHSTYLE_2D_PERCENTLINESYM:
		case CHSTYLE_2D_CUBIC_SPLINE :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL :
		case CHSTYLE_3D_STRIPE:
			return CHTYPE_LINE;

		case CHSTYLE_2D_AREA:
		case CHSTYLE_2D_STACKEDAREA:
		case CHSTYLE_2D_PERCENTAREA:
		case CHSTYLE_3D_AREA:
		case CHSTYLE_3D_STACKEDAREA:
		case CHSTYLE_3D_PERCENTAREA:
			return CHTYPE_AREA;

		case CHSTYLE_2D_PIE:
		case CHSTYLE_2D_PIE_SEGOF1:
		case CHSTYLE_2D_PIE_SEGOFALL:
		case CHSTYLE_3D_PIE:
			return CHTYPE_CIRCLE;

		case CHSTYLE_2D_DONUT1:
		case CHSTYLE_2D_DONUT2:
			return CHTYPE_DONUT;

		case CHSTYLE_2D_B_SPLINE_XY :
		case CHSTYLE_2D_XY_LINE :
		case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
		case CHSTYLE_2D_XYSYMBOLS:
		case CHSTYLE_2D_XY:
		case CHSTYLE_2D_CUBIC_SPLINE_XY :
		case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
			return CHTYPE_XY;

		case CHSTYLE_2D_NET:
		case CHSTYLE_2D_NET_SYMBOLS:
		case CHSTYLE_2D_NET_STACK:
		case CHSTYLE_2D_NET_SYMBOLS_STACK:
		case CHSTYLE_2D_NET_PERCENT:
		case CHSTYLE_2D_NET_SYMBOLS_PERCENT:
			return CHTYPE_NET;

		case CHSTYLE_2D_COLUMN:
		case CHSTYLE_2D_STACKEDCOLUMN:
		case CHSTYLE_2D_PERCENTCOLUMN:
		case CHSTYLE_2D_LINE_COLUMN:
		case CHSTYLE_2D_LINE_STACKEDCOLUMN:
		case CHSTYLE_3D_COLUMN:
		case CHSTYLE_3D_FLATCOLUMN:
		case CHSTYLE_3D_STACKEDFLATCOLUMN:
		case CHSTYLE_3D_PERCENTFLATCOLUMN:
			return CHTYPE_COLUMN;

		case CHSTYLE_2D_STOCK_1:
		case CHSTYLE_2D_STOCK_2:
		case CHSTYLE_2D_STOCK_3:
		case CHSTYLE_2D_STOCK_4:
			return CHTYPE_STOCK;

		case CHSTYLE_2D_BAR:
		case CHSTYLE_2D_STACKEDBAR:
		case CHSTYLE_2D_PERCENTBAR:
		case CHSTYLE_3D_BAR:
		case CHSTYLE_3D_FLATBAR:
		case CHSTYLE_3D_STACKEDFLATBAR:
		case CHSTYLE_3D_PERCENTFLATBAR:
			return CHTYPE_BAR;

		case CHSTYLE_ADDIN:
			return CHTYPE_ADDIN;

		default:
			DBG_ERROR( "Invalid Chart style given!" );
			return CHTYPE_INVALID;
	}
}

BOOL ChartModel::SetBaseType(long nBaseType)
{
	// setting the basetype currently sets the default type in the base category
	// returns TRUE, iff chart type has been changed

	SvxChartStyle eNewStyle = eChartStyle;

	switch( nBaseType )
	{
		case CHTYPE_LINE:
			eNewStyle = CHSTYLE_2D_LINE;
			break;
		case CHTYPE_AREA:
			eNewStyle = CHSTYLE_2D_AREA;
			break;
		case CHTYPE_DONUT:
			eNewStyle = CHSTYLE_2D_DONUT1;
			break;
		case CHTYPE_CIRCLE:
			eNewStyle = CHSTYLE_2D_PIE;
			break;
		case CHTYPE_XY:
			eNewStyle = CHSTYLE_2D_XY;
			break;
		case CHTYPE_NET:
			eNewStyle = CHSTYLE_2D_NET;
			break;
		case CHTYPE_COLUMN: // == BAR
		case CHTYPE_BAR:
			eNewStyle = CHSTYLE_2D_COLUMN;
			break;
		case CHTYPE_STOCK:
			eNewStyle = CHSTYLE_2D_STOCK_1;
			break;
		case CHTYPE_ADDIN:
			eNewStyle = CHSTYLE_ADDIN;
			break;
		default:
			DBG_ERROR( "ChartModel::SetBaseType: Invalid Type!" );
			break;
	}

	if( eChartStyle != eNewStyle )
	{
		ChangeChart( eNewStyle );
		BuildChart( FALSE );
		return TRUE;
	}

	return FALSE;
}

