/*************************************************************************
 *
 *  $RCSfile: SchPersistentObjectPointer.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: af $ $Date: 2001/05/02 11:20:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Andre Fischer <andre.w.fischer@germany.sun.com>
 *
 *
 ************************************************************************/
 
#ifndef	_SCH_PERSISTENT_OBJECT_POINTER
#define	_SCH_PERSISTENT_OBJECT_POINTER

#ifndef _SOLAR_H
# include	<tools/solar.h>
#endif

#include	<vector>

class	SdrObject;
class	ChartModel;


/**
	@descr	A persisten pointer lets you identify an SdrObject of the chart
		unambiguously.  Its main use is to rember the marked object before a
		BuildChart() is called and remark it afterwards.  This is done by
		storing an object's id and some additionall data.
	@todo	There is no invalid object id available.
*/
class	SchPersistentObjectPointer
{
public:
	/**	@desr Create a persistent object pointer for an CHOBJID_...
			and optional indices to specify a data row or data point.
		@param	nObjectId	This has to be a valid CHOBJID_...
		@param	nSeries		Specifies a data row.
		@param	nIndex		Specifies a data point in a data row.
	*/
	SchPersistentObjectPointer	(UINT16		nObjectId, 
								long 		nSeries = -1,
								long		nIndex = -1);
	/** @descr Creates a persistent object pointer for the given object.
		@param pObject Object that is represented by this class.
	*/
	SchPersistentObjectPointer	(const SdrObject * pObject);
	~SchPersistentObjectPointer	(void);
	
	/**	@descr	Return the object id of the represented object.
		@return	The object id of the represented object.  If that is invalid,
			the return value is undefined, because there is no proper id for this.
	*/
	UINT16			GetObjectId	(void)	const;
	
	/**	@descr	Return the index of the data series or -1 if the represented 
		object is neither a data row nor a data point.
	*/
	long			GetSeries	(void)	const;
	
	/**	@descr	Return the index of the data point inside its data series 
		or -1 if the represented object is not a data point.
	*/
	long			GetIndex	(void)	const;
	
	/**	@descr	Return a list of pointers of the represented objects with respect to
			the given model.  The returned value is list rather then a single pointer
			because for instance a single data series may be represented by a set of
			individual objects.
		@param	pModel	The returned object belongs to this chart model.
		@return	A possibly empty list of pointers to SdrObjects.  If between two
			calls a BuildChart was carried out, the results will be different from
			the pointer given to the constructor.
	*/
	const std::vector<SdrObject*>	&	GetPointers	(ChartModel * pModel);

private:
	UINT16	mnObjectId;		///	CHOBJID_... for the represented object.
	long	mnSeries;		///	Index of the data row or -1 if not applicable.
	long	mnIndex;		///	Index of the data point inside its row or -1.
	std::vector<SdrObject*>
			maObjectList;	///	List of represented objects.
};

#endif
