/*************************************************************************
 *
 *  $RCSfile: autofmt.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: nn $ $Date: 2002/12/04 18:54:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "ui_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------

#include "scitems.hxx"
#include <svx/algitem.hxx>
#include <svx/boxitem.hxx>
#include <svx/brshitem.hxx>
#include <svx/cntritem.hxx>
#include <svx/colritem.hxx>
#include <svx/crsditem.hxx>
#include <svx/fontitem.hxx>
#include <svx/postitem.hxx>
#include <svx/shdditem.hxx>
#include <svx/udlnitem.hxx>
#include <svx/wghtitem.hxx>
#include <svtools/zforlist.hxx>
#include <vcl/msgbox.hxx>
#include <comphelper/processfactory.hxx>

#include "sc.hrc"
#include "scmod.hxx"
#include "attrib.hxx"
#include "zforauto.hxx"
#include "scitems.hxx"
#include "global.hxx"
#include "globstr.hrc"
#include "autoform.hxx"
#include "sclnlnk.hxx"
#include "strindlg.hxx"
#include "miscdlgs.hrc"
#include "autofmt.hxx"
#include "scresid.hxx"
#include "document.hxx"

#define FRAME_OFFSET 4

USHORT AutoFmtPreview::aFmtMap[] = { 0,  1,  2,  1,  3, // Zuordnung:
									 4,  5,  6,  5,  7, // Zelle->Format
									 8,  9, 10,  9, 11,
									 4,  5,  6,  5,  7,
									12, 13, 14, 13, 15	};

BOOL bIsOlk = FALSE;


//========================================================================
// AutoFormat-Dialog:

ScAutoFormatDlg::ScAutoFormatDlg( Window*					pParent,
								  ScAutoFormat* 			pAutoFormat,
                                  const ScAutoFormatData*   pSelFormatData,
                                  ScDocument*               pDoc ) :

	ModalDialog 	( pParent, ScResId( RID_SCDLG_AUTOFORMAT ) ),
	//
	aLbFormat		( this, ScResId( LB_FORMAT ) ),
    aFlFormat       ( this, ScResId( FL_FORMAT ) ),
    pWndPreview     ( new AutoFmtPreview( this, ScResId( WND_PREVIEW ), pDoc ) ),
	aBtnNumFormat	( this, ScResId( BTN_NUMFORMAT ) ),
	aBtnBorder		( this, ScResId( BTN_BORDER ) ),
	aBtnFont		( this, ScResId( BTN_FONT ) ),
	aBtnPattern 	( this, ScResId( BTN_PATTERN ) ),
	aBtnAlignment	( this, ScResId( BTN_ALIGNMENT ) ),
	aBtnAdjust		( this, ScResId( BTN_ADJUST ) ),
    aFlFormatting   ( this, ScResId( FL_FORMATTING ) ),
	aBtnOk			( this, ScResId( BTN_OK ) ),
	aBtnCancel		( this, ScResId( BTN_CANCEL ) ),
	aBtnHelp		( this, ScResId( BTN_HELP ) ),
	aBtnAdd 		( this, ScResId( BTN_ADD ) ),
	aBtnRemove		( this, ScResId( BTN_REMOVE ) ),
	aBtnMore		( this, ScResId( BTN_MORE ) ),
	aBtnRename		( this, ScResId( BTN_RENAME ) ),
    aStrTitle       ( ScResId( STR_ADD_TITLE ) ),
    aStrLabel       ( ScResId( STR_ADD_LABEL ) ),
    aStrRename      ( ScResId( STR_RENAME_TITLE ) ),
    aStrClose       ( ScResId( STR_BTN_CLOSE ) ),
    aStrDelTitle    ( ScResId( STR_DEL_TITLE ) ),
    aStrDelMsg      ( ScResId( STR_DEL_MSG ) ) ,
	//
	nIndex			( 0 ),
	bFmtInserted	( FALSE ),
	bCoreDataChanged( FALSE ),
	pFormat 		( pAutoFormat ),
	pSelFmtData 	( pSelFormatData )
{
	Init();
	pWndPreview->NotifyChange( (*pFormat)[0] );
	FreeResource();
}

//------------------------------------------------------------------------

__EXPORT ScAutoFormatDlg::~ScAutoFormatDlg()
{
	delete pWndPreview;
}

//------------------------------------------------------------------------

void ScAutoFormatDlg::Init()
{
	USHORT nCount;
	String aEntry;

	aLbFormat	 .SetSelectHdl( LINK( this, ScAutoFormatDlg, SelFmtHdl ) );
	aBtnNumFormat.SetClickHdl ( LINK( this, ScAutoFormatDlg, CheckHdl ) );
	aBtnBorder	 .SetClickHdl ( LINK( this, ScAutoFormatDlg, CheckHdl ) );
	aBtnFont	 .SetClickHdl ( LINK( this, ScAutoFormatDlg, CheckHdl ) );
	aBtnPattern  .SetClickHdl ( LINK( this, ScAutoFormatDlg, CheckHdl ) );
	aBtnAlignment.SetClickHdl ( LINK( this, ScAutoFormatDlg, CheckHdl ) );
	aBtnAdjust	 .SetClickHdl ( LINK( this, ScAutoFormatDlg, CheckHdl ) );
	aBtnAdd 	 .SetClickHdl ( LINK( this, ScAutoFormatDlg, AddHdl ) );
	aBtnRemove	 .SetClickHdl ( LINK( this, ScAutoFormatDlg, RemoveHdl ) );
	aBtnOk		 .SetClickHdl ( LINK( this, ScAutoFormatDlg, CloseHdl ) );
	aBtnCancel	 .SetClickHdl ( LINK( this, ScAutoFormatDlg, CloseHdl ) );
	aBtnRename	 .SetClickHdl ( LINK( this, ScAutoFormatDlg, RenameHdl ) );
	aLbFormat	 .SetDoubleClickHdl( LINK( this, ScAutoFormatDlg, DblClkHdl ) );

	aBtnMore.AddWindow( &aBtnRename );
	aBtnMore.AddWindow( &aBtnNumFormat );
	aBtnMore.AddWindow( &aBtnBorder );
	aBtnMore.AddWindow( &aBtnFont );
	aBtnMore.AddWindow( &aBtnPattern );
	aBtnMore.AddWindow( &aBtnAlignment );
	aBtnMore.AddWindow( &aBtnAdjust );
    aBtnMore.AddWindow( &aFlFormatting );

	nCount = pFormat->GetCount();

	for ( USHORT i = 0; i < nCount; i++ )
	{
		((*pFormat)[i])->GetName( aEntry );
		aLbFormat.InsertEntry( aEntry );
	}

	if ( nCount == 1 )
		aBtnRemove.Disable();

	aLbFormat.SelectEntryPos( 0 );
	aBtnRename.Disable();
	aBtnRemove.Disable();

	nIndex = 0;
	UpdateChecks();

	if ( !pSelFmtData )
	{
		aBtnAdd.Disable();
		aBtnRemove.Disable();
		bFmtInserted = TRUE;
	}
}

//------------------------------------------------------------------------

void ScAutoFormatDlg::UpdateChecks()
{
	ScAutoFormatData* pData = (*pFormat)[nIndex];

	aBtnNumFormat.Check( pData->GetIncludeValueFormat() );
	aBtnBorder	 .Check( pData->GetIncludeFrame() );
	aBtnFont	 .Check( pData->GetIncludeFont() );
	aBtnPattern  .Check( pData->GetIncludeBackground() );
	aBtnAlignment.Check( pData->GetIncludeJustify() );
	aBtnAdjust	 .Check( pData->GetIncludeWidthHeight() );
}

//------------------------------------------------------------------------
// Handler:
//---------

IMPL_LINK( ScAutoFormatDlg, CloseHdl, PushButton *, pBtn )
{
	if ( pBtn == &aBtnOk || pBtn == &aBtnCancel )
	{
		if ( bCoreDataChanged )
			ScGlobal::GetAutoFormat()->Save();

		EndDialog( (pBtn == &aBtnOk) ? RET_OK : RET_CANCEL );
	}
	return 0;
}

//------------------------------------------------------------------------

IMPL_LINK_INLINE_START( ScAutoFormatDlg, DblClkHdl, void *, EMPTYARG )
{
	if ( bCoreDataChanged )
		ScGlobal::GetAutoFormat()->Save();

	EndDialog( RET_OK );
	return 0;
}
IMPL_LINK_INLINE_END( ScAutoFormatDlg, DblClkHdl, void *, EMPTYARG )

//------------------------------------------------------------------------

IMPL_LINK( ScAutoFormatDlg, CheckHdl, Button *, pBtn )
{
	ScAutoFormatData* pData  = (*pFormat)[nIndex];
	BOOL			  bCheck = ((CheckBox*)pBtn)->IsChecked();

	if ( pBtn == &aBtnNumFormat )
		pData->SetIncludeValueFormat( bCheck );
	else if ( pBtn == &aBtnBorder )
		pData->SetIncludeFrame( bCheck );
	else if ( pBtn == &aBtnFont )
		pData->SetIncludeFont( bCheck );
	else if ( pBtn == &aBtnPattern )
		pData->SetIncludeBackground( bCheck );
	else if ( pBtn == &aBtnAlignment )
		pData->SetIncludeJustify( bCheck );
	else if ( pBtn == &aBtnAdjust )
		pData->SetIncludeWidthHeight( bCheck );

	if ( !bCoreDataChanged )
	{
		aBtnCancel.SetText( aStrClose );
		bCoreDataChanged = TRUE;
	}

	pWndPreview->NotifyChange( pData );

	return 0;
}

//------------------------------------------------------------------------

IMPL_LINK( ScAutoFormatDlg, AddHdl, void *, EMPTYARG )
{
	if ( !bFmtInserted && pSelFmtData )
	{
		String				aStrStandard( ScResId(STR_STANDARD) );
		String				aFormatName;
		ScStringInputDlg*	pDlg;
		BOOL				bOk = FALSE;

		while ( !bOk )
		{
			pDlg = new ScStringInputDlg( this,
										 aStrTitle,
										 aStrLabel,
										 aFormatName,
										 HID_SC_ADD_AUTOFMT );

			if ( pDlg->Execute() == RET_OK )
			{
				pDlg->GetInputString( aFormatName );

				if ( (aFormatName.Len() > 0) && (aFormatName != aStrStandard) )
				{
					ScAutoFormatData* pNewData
						= new ScAutoFormatData( *pSelFmtData );

					pNewData->SetName( aFormatName );
					bFmtInserted = pFormat->Insert( pNewData );

					if ( bFmtInserted )
					{
						USHORT nAt = pFormat->IndexOf( pNewData );

						aLbFormat.InsertEntry( aFormatName, nAt );
						aLbFormat.SelectEntry( aFormatName );
						aBtnAdd.Disable();

						if ( !bCoreDataChanged )
						{
							aBtnCancel.SetText( aStrClose );
							bCoreDataChanged = TRUE;
						}

						SelFmtHdl( 0 );
						bOk = TRUE;
					}
					else
						delete pNewData;

				}

				if ( !bFmtInserted )
				{
					USHORT nRet = ErrorBox( this,
											WinBits( WB_OK_CANCEL | WB_DEF_OK),
											ScGlobal::GetRscString(STR_INVALID_AFNAME)
										  ).Execute();

					bOk = ( nRet == RET_CANCEL );
				}
			}
			else
				bOk = TRUE;

			delete pDlg;
		}
	}

	return 0;
}

//------------------------------------------------------------------------

IMPL_LINK( ScAutoFormatDlg, RemoveHdl, void *, EMPTYARG )
{
	if ( (nIndex > 0) && (aLbFormat.GetEntryCount() > 0) )
	{
		String aMsg( aStrDelMsg.GetToken( 0, '#' ) );

		aMsg += aLbFormat.GetSelectEntry();
		aMsg += aStrDelMsg.GetToken( 1, '#' );

		if ( RET_YES ==
			 QueryBox( this, WinBits( WB_YES_NO | WB_DEF_YES ), aMsg ).Execute() )
		{
			aLbFormat.RemoveEntry( nIndex );
			aLbFormat.SelectEntryPos( nIndex-1 );

			if ( nIndex-1 == 0 )
				aBtnRemove.Disable();

			if ( !bCoreDataChanged )
			{
				aBtnCancel.SetText( aStrClose );
				bCoreDataChanged = TRUE;
			}

			pFormat->AtFree( nIndex ); // in der Core loeschen
			nIndex--;

			SelFmtHdl( 0 );
		}
	}

	SelFmtHdl( 0 );

	return 0;
}

IMPL_LINK( ScAutoFormatDlg, RenameHdl, void *, pBtn)
{
	BOOL bOk = FALSE;
	while( !bOk )
	{

		String aFormatName=aLbFormat.GetSelectEntry();
		String aEntry;

		ScStringInputDlg* pDlg = new ScStringInputDlg( this,
										 aStrRename,
										 aStrLabel,
										 aFormatName,
										 HID_SC_RENAME_AUTOFMT );
		if( pDlg->Execute() == RET_OK )
		{
			BOOL bFmtRenamed = FALSE;
			pDlg->GetInputString( aFormatName );

			if ( aFormatName.Len() > 0 )
			{
				for( USHORT n = 0; n < pFormat->GetCount(); ++n )
				{
					(*pFormat)[n]->GetName(aEntry);
					if ( aEntry== aFormatName)
						break;
				}
				if( n >= pFormat->GetCount() )
				{
					// Format mit dem Namen noch nicht vorhanden, also
					// umbenennen

					aLbFormat.RemoveEntry(nIndex );
					ScAutoFormatData* p=(*pFormat)[ nIndex ];
					ScAutoFormatData* pNewData
						= new ScAutoFormatData(*p);

					pFormat->AtFree( nIndex );

					pNewData->SetName( aFormatName );

					pFormat->Insert( pNewData);

					USHORT nCount = pFormat->GetCount();

					aLbFormat.SetUpdateMode(FALSE);
					aLbFormat.Clear();
					for ( USHORT i = 0; i < nCount; i++ )
					{
						((*pFormat)[i])->GetName( aEntry );
						aLbFormat.InsertEntry( aEntry );
					}

					aLbFormat.SetUpdateMode( TRUE);
					aLbFormat.SelectEntry( aFormatName);

					if ( !bCoreDataChanged )
					{
						aBtnCancel.SetText( aStrClose );
						bCoreDataChanged = TRUE;
					}


					SelFmtHdl( 0 );
					bOk = TRUE;
					bFmtRenamed = TRUE;
				}
			}
			if( !bFmtRenamed )
			{
				bOk = RET_CANCEL == ErrorBox( this,
									WinBits( WB_OK_CANCEL | WB_DEF_OK),
									ScGlobal::GetRscString(STR_INVALID_AFNAME)
									).Execute();
			}
		}
		else
			bOk = TRUE;
		delete pDlg;
	}

	return 0;
}

//------------------------------------------------------------------------

IMPL_LINK( ScAutoFormatDlg, SelFmtHdl, void *, EMPTYARG )
{
	nIndex = aLbFormat.GetSelectEntryPos();
	UpdateChecks();

	if ( nIndex == 0 )
	{
		aBtnRename.Disable();
		aBtnRemove.Disable();
	}
	else
	{
		aBtnRename.Enable();
		aBtnRemove.Enable();
	}

	pWndPreview->NotifyChange( (*pFormat)[nIndex] );

	return 0;
}

//------------------------------------------------------------------------

String __EXPORT ScAutoFormatDlg::GetCurrFormatName()
{
	String	aResult;

	((*pFormat)[nIndex])->GetName( aResult );

	return aResult;
}

//========================================================================
// AutoFmtPreview

AutoFmtPreview::AutoFmtPreview( Window* pParent, const ResId& rRes, ScDocument* pDoc ) :
		Window			( pParent, rRes ),
		aVD 			( *this ),
        aScriptedText   ( aVD ),
        xBreakIter      ( pDoc->GetBreakIterator() ),
		pCurData		( NULL ),
		bFitWidth		( FALSE ),
        aStrJan         ( ScResId( STR_JAN ) ),
        aStrFeb         ( ScResId( STR_FEB ) ),
        aStrMar         ( ScResId( STR_MAR ) ),
        aStrNorth       ( ScResId( STR_NORTH ) ),
        aStrMid         ( ScResId( STR_MID ) ),
        aStrSouth       ( ScResId( STR_SOUTH ) ),
        aStrSum         ( ScResId( STR_SUM ) ),
		aPrvSize		( GetSizePixel().Width()  - 6,
						  GetSizePixel().Height() - 30 ),
		nLabelColWidth	( (USHORT)(((aPrvSize.Width()-4)/4)-12) ),
		nDataColWidth1	( (USHORT)(((aPrvSize.Width()-4)-(nLabelColWidth*2)) / 3) ),
		nDataColWidth2	( (USHORT)(((aPrvSize.Width()-4)-(nLabelColWidth*2)) / 4) ),
		nRowHeight		( (USHORT)((aPrvSize.Height()-4) / 5) ),
		pNumFmt			( new SvNumberFormatter( ::comphelper::getProcessServiceFactory(), ScGlobal::eLnge ) )
{
	Init();
	if( bIsOlk )
		((String&)aStrMar).AssignAscii(RTL_CONSTASCII_STRINGPARAM( "Olk" ));
}

//------------------------------------------------------------------------

__EXPORT AutoFmtPreview::~AutoFmtPreview()
{
	for ( USHORT i=0; i<=35; i++ )
	{
		delete aLinePtrArray[i];
	}
	delete pNumFmt;
}

//------------------------------------------------------------------------

void lcl_AssignLine( SvxBorderLine&		 dest,
					const SvxBorderLine* src )
{
	dest.SetColor	 ( (src) ? src->GetColor()	  : Color( COL_WHITE ) );
	dest.SetOutWidth ( (src) ? src->GetOutWidth() : 0 );
	dest.SetInWidth  ( (src) ? src->GetInWidth()  : 0 );
	dest.SetDistance ( (src) ? src->GetDistance() : 0 );
}

//------------------------------------------------------------------------

void lcl_GetLineStruct( ScLineStruct&		rLine,
					   const SvxBorderLine& rBoxLine )
{
	if ( rBoxLine.GetOutWidth() > 0 )
	{
		rLine.nLeft 	= rBoxLine.GetOutWidth();
		rLine.nMiddle	= rBoxLine.GetDistance();
		rLine.nRight	= rBoxLine.GetInWidth();

		/* Linienstaerke auf dick/duenn abbilden:
		 *
		 * (in TWIPS, 1pt = 20 TWIPS = duenn)
		 * alles was <=0  ist -> (0,0,0)
		 * alles was <=20 ist -> (1,0,0)/(1,1,1)
		 * alles andere 	  -> (3,0,0)/(2,1,2)
		 */

		if ( rLine.nMiddle == 0 ) // einfache Linie?
		{
			rLine.nRight = 0; // sicher ist sicher

			if ( rLine.nLeft <= 20 )
			{
				rLine.nLeft = 1;
			}
			else if ( rLine.nLeft > 20 )
			{
				rLine.nLeft = 3;
			}
		}
		else // doppelte Linie
		{
			rLine.nMiddle = 1;
			if ( rLine.nLeft <= 20 )
			{
				rLine.nLeft = rLine.nRight = 1;
			}
			else if ( rLine.nLeft > 20 )
			{
				rLine.nLeft = rLine.nRight = 2;
			}
		}
	}
	else
	{
		rLine.nLeft 	= 0;
		rLine.nMiddle	= 0;
		rLine.nRight	= 0;
	}
}

//------------------------------------------------------------------------

void AutoFmtPreview::CheckPriority( USHORT			nCurLine,
									AutoFmtLine 	eLine,
									SvxBorderLine&	rLine )
{
	const SvxBorderLine*	pDrawLine;
	USHORT					nOther = 0;

	switch ( eLine )
	{
		case TOP_LINE:
			{
				lcl_AssignLine( rLine, aLinePtrArray[nCurLine]->GetTop() );
				nOther = nCurLine-7;
				pDrawLine = aLinePtrArray[nOther]->GetBottom();

				if ( HasPriority( pDrawLine, &rLine ) )
					lcl_AssignLine( rLine, pDrawLine );
			}
			break;

		case BOTTOM_LINE:
			{
				lcl_AssignLine( rLine, aLinePtrArray[nCurLine]->GetBottom() );
				nOther = nCurLine+7;
				pDrawLine = aLinePtrArray[nOther]->GetTop();

				if ( HasPriority( pDrawLine, &rLine ) )
					lcl_AssignLine( rLine, pDrawLine );
			}
			break;

		case LEFT_LINE:
			{
				lcl_AssignLine( rLine, aLinePtrArray[nCurLine]->GetLeft() );
				nOther = nCurLine-1;
				pDrawLine = aLinePtrArray[nOther]->GetRight();

				if ( HasPriority( pDrawLine, &rLine ) )
					lcl_AssignLine( rLine, pDrawLine );
			}
			break;

		case RIGHT_LINE:
			{
				lcl_AssignLine( rLine, aLinePtrArray[nCurLine]->GetRight() );
				nOther = nCurLine+1;
				pDrawLine = aLinePtrArray[nOther]->GetLeft();

				if ( HasPriority( pDrawLine, &rLine ) )
					lcl_AssignLine( rLine, pDrawLine );
			}
			break;
	}
}

//------------------------------------------------------------------------

void AutoFmtPreview::GetLines( USHORT nIndex, AutoFmtLine eLine,
							   SvxBorderLine&	rLineD,
							   SvxBorderLine&	rLineLT,
							   SvxBorderLine&	rLineL,
							   SvxBorderLine&	rLineLB,
							   SvxBorderLine&	rLineRT,
							   SvxBorderLine&	rLineR,
							   SvxBorderLine&	rLineRB )
{
	{
		SvxBorderLine aNullLine;

		lcl_AssignLine( rLineD,  &aNullLine);
		lcl_AssignLine( rLineLT, &aNullLine);
		lcl_AssignLine( rLineL,  &aNullLine);
		lcl_AssignLine( rLineLB, &aNullLine);
		lcl_AssignLine( rLineRT, &aNullLine);
		lcl_AssignLine( rLineR,  &aNullLine);
		lcl_AssignLine( rLineRB, &aNullLine);
	}

	if ( pCurData )
	{
		USHORT	nCurLine   = nIndex + 8 + ((nIndex/5)*2);
		USHORT	nOther	   = 0;

		switch ( eLine )
		{
			case TOP_LINE:
				{
					// obere Linien werden nur in der
					// ersten Zeile gemalt:
					if ( (nIndex >= 0) && (nIndex <= 4) )
					{
						// links
						CheckPriority( nCurLine, eLine, rLineD );
						nOther = nCurLine-7;
						CheckPriority( nOther, LEFT_LINE, rLineLT );
						nOther = nCurLine-1;
						CheckPriority( nOther, TOP_LINE, rLineL );
						CheckPriority( nCurLine, LEFT_LINE, rLineLB );
						// rechts
						nOther = nCurLine-7;
						CheckPriority( nOther, RIGHT_LINE, rLineRT );
						nOther = nCurLine+1;
						CheckPriority( nOther, TOP_LINE, rLineR );
						CheckPriority( nCurLine, RIGHT_LINE, rLineRB );
					}
				}
				break;

			case BOTTOM_LINE:
				{
					// links
					CheckPriority( nCurLine, eLine, rLineD );
					CheckPriority( nCurLine, LEFT_LINE, rLineLT );
					nOther = nCurLine-1;
					CheckPriority( nOther, BOTTOM_LINE, rLineL );
					nOther = nCurLine+7;
					CheckPriority( nOther, LEFT_LINE, rLineLB );
					// rechts
					CheckPriority( nCurLine, RIGHT_LINE, rLineRT );
					nOther = nCurLine+1;
					CheckPriority( nOther, BOTTOM_LINE, rLineR );
					nOther = nCurLine+7;
					CheckPriority( nOther, RIGHT_LINE, rLineRB );
				}
				break;

			case LEFT_LINE:
				{
					// linke Linien werden nur in der
					// ersten Spalte gemalt:
					if ( (nIndex%5) == 0 )
					{
						// oben
						CheckPriority( nCurLine, eLine, rLineD );
						CheckPriority( nCurLine, TOP_LINE, rLineLT );
						nOther = nCurLine-7;
						CheckPriority( nOther, LEFT_LINE, rLineL );
						nOther = nCurLine-1;
						CheckPriority( nOther, TOP_LINE, rLineLB );
						// unten
						CheckPriority( nCurLine, BOTTOM_LINE, rLineRT );
						nOther = nCurLine+7;
						CheckPriority( nOther, LEFT_LINE, rLineR );
						nOther = nCurLine-1;
						CheckPriority( nOther, BOTTOM_LINE, rLineRB );
					}
				}
				break;

			case RIGHT_LINE:
				{
					// oben
					CheckPriority( nCurLine, eLine, rLineD );
					nOther = nCurLine+1;
					CheckPriority( nOther, TOP_LINE, rLineLT );
					nOther = nCurLine-7;
					CheckPriority( nOther, RIGHT_LINE, rLineL );
					CheckPriority( nCurLine, TOP_LINE, rLineLB );
					// unten
					nOther = nCurLine+1;
					CheckPriority( nOther, BOTTOM_LINE, rLineRT );
					nOther = nCurLine+7;
					CheckPriority( nOther, RIGHT_LINE, rLineR );
					CheckPriority( nCurLine, BOTTOM_LINE, rLineRB );
				}
				break;
		}
	}
}

//------------------------------------------------------------------------

void lcl_DrawHorizontalLine( OutputDevice& rDev, const Point& rStart, const Point& rEnd )
{
    DBG_ASSERT( rStart.Y() <= rEnd.Y(), "lcl_DrawHorizontalLine - wrong point order" );
    Point aLineStart( rStart );
    Point aLineEnd( rEnd.X(), rStart.Y() );
    while( aLineStart.Y() <= rEnd.Y() )
    {
        rDev.DrawLine( aLineStart, aLineEnd );
        ++aLineStart.Y();
        ++aLineEnd.Y();
    }
}

void lcl_DrawVerticalLine( OutputDevice& rDev, const Point& rStart, const Point& rEnd )
{
    DBG_ASSERT( rStart.X() <= rEnd.X(), "lcl_DrawVerticalLine - wrong point order" );
    Point aLineStart( rStart );
    Point aLineEnd( rStart.X(), rEnd.Y() );
    while( aLineStart.X() <= rEnd.X() )
    {
        rDev.DrawLine( aLineStart, aLineEnd );
        ++aLineStart.X();
        ++aLineEnd.X();
    }
}

void AutoFmtPreview::DrawFrameLine( const SvxBorderLine&	rLineD,
									Point					from,
									Point					to,
									BOOL					bHorizontal,
									const SvxBorderLine&	rLineLT,
									const SvxBorderLine&	rLineL,
									const SvxBorderLine&	rLineLB,
									const SvxBorderLine&	rLineRT,
									const SvxBorderLine&	rLineR,
									const SvxBorderLine&	rLineRB )
{
	if ( pCurData )
	{
		ScLineStruct	dLine;
		ScLineStruct	ltLine;
		ScLineStruct	lLine;
		ScLineStruct	lbLine;
		ScLineStruct	rtLine;
		ScLineStruct	rLine;
		ScLineStruct	rbLine;
		short			dxArr[4];

		lcl_GetLineStruct( dLine,	rLineD	);
		lcl_GetLineStruct( ltLine,	rLineLT );
		lcl_GetLineStruct( lLine,	rLineL	);
		lcl_GetLineStruct( lbLine,	rLineLB );
		lcl_GetLineStruct( rtLine,	rLineRT );
		lcl_GetLineStruct( rLine,	rLineR	);
		lcl_GetLineStruct( rbLine,	rLineRB );

		if ( dLine.nLeft > 0 )
		{
			BOOL bHadLine  = aVD.IsLineColor();
			Color aOldLine = aVD.GetLineColor();
			BOOL bHadFill  = aVD.IsFillColor();
			Color aOldFill = aVD.GetFillColor();

			USHORT	nHeight  = dLine.nLeft + dLine.nMiddle + dLine.nRight;
			Point	from2	 = from;
			Point	to2 	 = to;

            aVD.SetLineColor( rLineD.GetColor() );

			ScLinkLine( dLine,
						ltLine, lLine, lbLine,
						rtLine, rLine, rbLine,
						dxArr );

			if ( bHorizontal )
			{
				from.Y() -= nHeight/2;
				to.Y()	 -= nHeight/2;
				to.Y()	 += (dLine.nLeft-1);

				from.X() += dxArr[0];
				to.X()	 += dxArr[2];

                lcl_DrawHorizontalLine( aVD, from, to );

				// noch eine zweite Linie zu malen?
				if ( dLine.nRight != 0 )
				{
					from2.Y() -= nHeight/2;
					from2.Y() += dLine.nLeft+dLine.nMiddle;
					to2.Y()   -= nHeight/2;
					to2.Y()   += dLine.nMiddle+dLine.nLeft;
					to2.Y()   += (dLine.nRight-1);

					from2.X() += dxArr[1];
					to2.X()   += dxArr[3];

                    lcl_DrawHorizontalLine( aVD, from2, to2 );
				}
			}
			else
			{
				from.X() += nHeight/2;
				from.X() -= (dLine.nLeft-1);
				to.X()	 += nHeight/2;

				from.Y() += dxArr[0];
				to.Y()	 += dxArr[2];

                lcl_DrawVerticalLine( aVD, from, to );

				// noch eine zweite Linie zu malen?
				if ( dLine.nRight != 0 )
				{
					from2.X() -= nHeight/2;
					to2.X()   -= nHeight/2;
					to2.X()   += (dLine.nRight-1);

					from2.Y() += dxArr[1];
					to2.Y()   += dxArr[3];

                    lcl_DrawVerticalLine( aVD, from2, to2 );
				}
			}

			if (bHadFill) aVD.SetFillColor(aOldFill); else aVD.SetFillColor();
			if (bHadLine) aVD.SetLineColor(aOldLine); else aVD.SetLineColor();
		}
	}
}

//------------------------------------------------------------------------

void AutoFmtPreview::DrawFrame( USHORT nIndex )
{
	if ( pCurData )
	{
		//----------------------
		// Malen des Zellrahmens
		//----------------------

		SvxBorderLine	aLineD;
		SvxBorderLine	aLineLT;
		SvxBorderLine	aLineL;
		SvxBorderLine	aLineLB;
		SvxBorderLine	aLineRT;
		SvxBorderLine	aLineR;
		SvxBorderLine	aLineRB;
		Rectangle		cellRect	= aCellArray[nIndex];

		//---------
		// TopLine ---------------------------------------------
		//---------
		GetLines( nIndex, TOP_LINE, aLineD,
				  aLineLT, aLineL, aLineLB,
				  aLineRT, aLineR, aLineRB );

		DrawFrameLine( aLineD,
					   cellRect.TopLeft(), cellRect.TopRight(), TRUE,
					   aLineLT,  aLineL, aLineLB,
					   aLineRT,  aLineR, aLineRB );

		//------------
		// BottomLine ------------------------------------------
		//------------
		GetLines( nIndex, BOTTOM_LINE, aLineD,
				  aLineLT, aLineL, aLineLB,
				  aLineRT, aLineR, aLineRB );

		DrawFrameLine( aLineD,
					   cellRect.BottomLeft(), cellRect.BottomRight(), TRUE,
					   aLineLT,  aLineL, aLineLB,
					   aLineRT,  aLineR, aLineRB );

		//----------
		// LeftLine --------------------------------------------
		//----------
		GetLines( nIndex, LEFT_LINE, aLineD,
				  aLineLT, aLineL, aLineLB,
				  aLineRT, aLineR, aLineRB );

		DrawFrameLine( aLineD,
					   cellRect.TopLeft(), cellRect.BottomLeft(), FALSE,
					   aLineLT,  aLineL, aLineLB,
					   aLineRT,  aLineR, aLineRB );

		//-----------
		// RightLine -------------------------------------------
		//-----------
		GetLines( nIndex, RIGHT_LINE, aLineD,
				  aLineLT, aLineL, aLineLB,
				  aLineRT, aLineR, aLineRB );

		DrawFrameLine( aLineD,
					   cellRect.TopRight(), cellRect.BottomRight(), FALSE,
					   aLineLT,  aLineL, aLineLB,
					   aLineRT,  aLineR, aLineRB );
	}
}

//------------------------------------------------------------------------

void lcl_SetFontProperties(
        Font& rFont,
        const SvxFontItem& rFontItem,
        const SvxWeightItem& rWeightItem,
        const SvxPostureItem& rPostureItem )
{
    rFont.SetFamily     ( rFontItem.GetFamily() );
    rFont.SetName       ( rFontItem.GetFamilyName() );
    rFont.SetStyleName  ( rFontItem.GetStyleName() );
    rFont.SetCharSet    ( rFontItem.GetCharSet() );
    rFont.SetPitch      ( rFontItem.GetPitch() );
    rFont.SetWeight     ( (FontWeight)rWeightItem.GetValue() );
    rFont.SetItalic     ( (FontItalic)rPostureItem.GetValue() );
}

void AutoFmtPreview::MakeFonts( USHORT nIndex, Font& rFont, Font& rCJKFont, Font& rCTLFont )
{
	if ( pCurData )
	{
        rFont = rCJKFont = rCTLFont = GetFont();
        Size aFontSize( rFont.GetSize().Width(), 10 );

        const SvxFontItem*        pFontItem       = (const SvxFontItem*)      pCurData->GetItem( nIndex, ATTR_FONT );
        const SvxWeightItem*      pWeightItem     = (const SvxWeightItem*)    pCurData->GetItem( nIndex, ATTR_FONT_WEIGHT );
        const SvxPostureItem*     pPostureItem    = (const SvxPostureItem*)   pCurData->GetItem( nIndex, ATTR_FONT_POSTURE );
        const SvxFontItem*        pCJKFontItem    = (const SvxFontItem*)      pCurData->GetItem( nIndex, ATTR_CJK_FONT );
        const SvxWeightItem*      pCJKWeightItem  = (const SvxWeightItem*)    pCurData->GetItem( nIndex, ATTR_CJK_FONT_WEIGHT );
        const SvxPostureItem*     pCJKPostureItem = (const SvxPostureItem*)   pCurData->GetItem( nIndex, ATTR_CJK_FONT_POSTURE );
        const SvxFontItem*        pCTLFontItem    = (const SvxFontItem*)      pCurData->GetItem( nIndex, ATTR_CTL_FONT );
        const SvxWeightItem*      pCTLWeightItem  = (const SvxWeightItem*)    pCurData->GetItem( nIndex, ATTR_CTL_FONT_WEIGHT );
        const SvxPostureItem*     pCTLPostureItem = (const SvxPostureItem*)   pCurData->GetItem( nIndex, ATTR_CTL_FONT_POSTURE );
        const SvxUnderlineItem*   pUnderlineItem  = (const SvxUnderlineItem*) pCurData->GetItem( nIndex, ATTR_FONT_UNDERLINE );
        const SvxCrossedOutItem*  pCrossedOutItem = (const SvxCrossedOutItem*)pCurData->GetItem( nIndex, ATTR_FONT_CROSSEDOUT );
        const SvxContourItem*     pContourItem    = (const SvxContourItem*)   pCurData->GetItem( nIndex, ATTR_FONT_CONTOUR );
        const SvxShadowedItem*    pShadowedItem   = (const SvxShadowedItem*)  pCurData->GetItem( nIndex, ATTR_FONT_SHADOWED );
        const SvxColorItem*       pColorItem      = (const SvxColorItem*)     pCurData->GetItem( nIndex, ATTR_FONT_COLOR );

        lcl_SetFontProperties( rFont, *pFontItem, *pWeightItem, *pPostureItem );
        lcl_SetFontProperties( rCJKFont, *pCJKFontItem, *pCJKWeightItem, *pCJKPostureItem );
        lcl_SetFontProperties( rCTLFont, *pCTLFontItem, *pCTLWeightItem, *pCTLPostureItem );

        Color aColor( pColorItem->GetValue() );
        if( aColor.GetColor() == COL_TRANSPARENT )
            aColor = GetSettings().GetStyleSettings().GetWindowTextColor();

#define SETONALLFONTS( MethodName, Value ) \
rFont.MethodName( Value ); rCJKFont.MethodName( Value ); rCTLFont.MethodName( Value );

        SETONALLFONTS( SetUnderline,    (FontUnderline)pUnderlineItem->GetValue() )
        SETONALLFONTS( SetStrikeout,    (FontStrikeout)pCrossedOutItem->GetValue() )
        SETONALLFONTS( SetOutline,      pContourItem->GetValue() )
        SETONALLFONTS( SetShadow,       pShadowedItem->GetValue() )
        SETONALLFONTS( SetColor,        aColor )
        SETONALLFONTS( SetSize,         aFontSize )
        SETONALLFONTS( SetTransparent,  TRUE )

#undef SETONALLFONTS
	}
}

//------------------------------------------------------------------------

void AutoFmtPreview::DrawString( USHORT nIndex )
{
	if ( pCurData )
	{
		//------------------------
		// Ausgabe des Zelltextes:
		//------------------------

		String	cellString;
		BOOL	bNumFormat	= pCurData->GetIncludeValueFormat();
		ULONG   nNum;
		double  nVal;
		Color*  pDummy = NULL;

		switch( nIndex )
		{
			case  1: cellString = aStrJan;			break;
			case  2: cellString = aStrFeb;			break;
			case  3: cellString = aStrMar;			break;
			case  5: cellString = aStrNorth;		break;
			case 10: cellString = aStrMid;			break;
			case 15: cellString = aStrSouth;		break;
			case  4:
			case 20: cellString = aStrSum;			break;

			case  6:
			case  8:
			case 16:
			case 18: nVal = nIndex;
					 nNum = 5;
					 goto mknum;
			case 17:
			case  7: nVal = nIndex;
					 nNum = 6;
					 goto mknum;
			case 11:
			case 12:
			case 13: nVal = nIndex;
					 nNum = 12 == nIndex ? 10 : 9;
					 goto mknum;

			case  9: nVal = 21; nNum = 7; goto mknum;
			case 14: nVal = 36; nNum = 11; goto mknum;
			case 19: nVal = 51; nNum = 7; goto mknum;
			case 21: nVal = 33; nNum = 13; goto mknum;
			case 22: nVal = 36; nNum = 14; goto mknum;
			case 23: nVal = 39; nNum = 13; goto mknum;
			case 24: nVal = 108; nNum = 15;
			mknum:
                if( bNumFormat )
                {
                    ScNumFormatAbbrev& rNumFormat = (ScNumFormatAbbrev&)pCurData->GetNumFormat( (USHORT) nNum );
                    nNum = rNumFormat.GetFormatIndex( *pNumFmt );
                }
                else
                    nNum = 0;
				pNumFmt->GetOutputString( nVal, nNum, cellString, &pDummy );
				break;
		}

		if ( cellString.Len() > 0 )
		{
			Size				aStrSize;
			USHORT				nFmtIndex		= aFmtMap[nIndex];
			Rectangle			cellRect		= aCellArray[nIndex];
			Point				aPos			= aCellArray[nIndex].TopLeft();
			USHORT				nRightX 		= 0;
			BOOL				bJustify		= pCurData->GetIncludeJustify();
			SvxHorJustifyItem	 aHorJustifyItem;
			SvxCellHorJustify	   eJustification;

			//-------------
			// Ausrichtung:
			//-------------
            eJustification = bJustify ?
                (SvxCellHorJustify)(((const SvxHorJustifyItem*)pCurData->GetItem( nFmtIndex, ATTR_HOR_JUSTIFY ))->GetValue()) :
                SVX_HOR_JUSTIFY_STANDARD;

			if ( pCurData->GetIncludeFont() )
			{
                Font aFont, aCJKFont, aCTLFont;
				Size theMaxStrSize;

                MakeFonts( nFmtIndex, aFont, aCJKFont, aCTLFont );

				theMaxStrSize			= cellRect.GetSize();
				theMaxStrSize.Width()  -= FRAME_OFFSET;
				theMaxStrSize.Height() -= FRAME_OFFSET;

                aScriptedText.SetFonts( &aFont, &aCJKFont, &aCTLFont );
                aScriptedText.SetText( cellString, xBreakIter );
                aStrSize = aScriptedText.GetTextSize();

				if ( theMaxStrSize.Height() < aStrSize.Height() )
				{
					// wenn der String in diesem Font nicht
					// in die Zelle passt, wird wieder der
					// Standard-Font genommen:
                    aScriptedText.SetDefaultFont();
                    aStrSize = aScriptedText.GetTextSize();
				}
				while ( ( theMaxStrSize.Width() <= aStrSize.Width() )
					&& ( cellString.Len() > 1 ) )
				{
					if( eJustification == SVX_HOR_JUSTIFY_RIGHT )
						cellString.Erase( 0, 1 );
					else
						cellString.Erase( cellString.Len() - 1 );

                    aScriptedText.SetText( cellString, xBreakIter );
                    aStrSize = aScriptedText.GetTextSize();
				}
			}
			else
			{
                aScriptedText.SetDefaultFont();
                aScriptedText.SetText( cellString, xBreakIter );
                aStrSize = aScriptedText.GetTextSize();
			}

			nRightX  = (USHORT)(  cellRect.GetWidth()
								  - aStrSize.Width()
								  - FRAME_OFFSET );

			//-----------------------------
			// vertikal (immer zentrieren):
			//-----------------------------
			aPos.Y() += (nRowHeight - (USHORT)aStrSize.Height()) / 2;

			//-----------
			// horizontal
			//-----------
			if ( eJustification != SVX_HOR_JUSTIFY_STANDARD )
			{
				USHORT nHorPos = (USHORT)
								 ((cellRect.GetWidth()-aStrSize.Width())/2);

				switch ( eJustification )
				{
					case SVX_HOR_JUSTIFY_LEFT:
						aPos.X() += FRAME_OFFSET;
						break;
					case SVX_HOR_JUSTIFY_RIGHT:
						aPos.X() += nRightX;
						break;
					case SVX_HOR_JUSTIFY_BLOCK:
					case SVX_HOR_JUSTIFY_REPEAT:
					case SVX_HOR_JUSTIFY_CENTER:
						aPos.X() += nHorPos;
						break;
					case SVX_HOR_JUSTIFY_STANDARD:
					default:
						// Standard wird hier nicht behandelt
						break;
				}
			}
			else
			{
				//---------------------
				// Standardausrichtung:
				//---------------------
                if ( ((nIndex%5) == 0) || (nIndex < 5) )
				{
					// Text-Label links oder Summe linksbuendig
					aPos.X() += FRAME_OFFSET;
				}
				else
				{
					 // Zahlen/Datum rechtsbuendig
					aPos.X() += nRightX;
				}
			}

			//-------------------------------
            aScriptedText.DrawText( aPos );
			//-------------------------------
		}
	}
}

#undef FRAME_OFFSET

//------------------------------------------------------------------------

void AutoFmtPreview::DrawBackground( USHORT nIndex )
{
	if ( pCurData )
	{
		USHORT			nFmtIndex = aFmtMap[nIndex];
		Rectangle		cellRect  = aCellArray[nIndex];

		BOOL bHadLine  = aVD.IsLineColor();
		Color aOldLine = aVD.GetLineColor();
		BOOL bHadFill  = aVD.IsFillColor();
		Color aOldFill = aVD.GetFillColor();

        aVD.SetFillColor( ((const SvxBrushItem*)pCurData->GetItem( nFmtIndex, ATTR_BACKGROUND ))->GetColor() );
		aVD.SetLineColor();
		//-----------------------
		aVD.DrawRect( cellRect );
		//-----------------------
		if (bHadFill) aVD.SetFillColor(aOldFill); else aVD.SetFillColor();
		if (bHadLine) aVD.SetLineColor(aOldLine); else aVD.SetLineColor();
	}
}

//------------------------------------------------------------------------

void AutoFmtPreview::PaintCells()
{
	if ( pCurData )
	{
		USHORT i = 0;

        // 1) background
		if ( pCurData->GetIncludeBackground() )
            for ( i=0; i<25; i++ )
				DrawBackground( i );

        // 2) border
		if ( pCurData->GetIncludeFrame() )
            for ( i=0; i<25; i++ )
				DrawFrame( i );

        // 3) values
        for ( i = 0; i<25; i++ )
			DrawString( i );
	}
}

//------------------------------------------------------------------------

void __EXPORT AutoFmtPreview::Init()
{
	SvxBoxItem aEmptyBoxItem;
	aEmptyBoxItem.SetLine( NULL, BOX_LINE_TOP );
	aEmptyBoxItem.SetLine( NULL, BOX_LINE_BOTTOM );
	aEmptyBoxItem.SetLine( NULL, BOX_LINE_LEFT );
	aEmptyBoxItem.SetLine( NULL, BOX_LINE_RIGHT );
	aEmptyBoxItem.SetDistance( 0 );
    SetBorderStyle( WINDOW_BORDER_MONO );

	//------------------------
	// Linienattribut-Feld mit
	// Null-BoxItems fuellen
	//------------------------
	for ( USHORT i=0; i<=48; i++ )
	{
		aLinePtrArray[i] = new SvxBoxItem( aEmptyBoxItem );
	}

	CalcCellArray( FALSE );
	CalcLineMap();
}

//------------------------------------------------------------------------

void AutoFmtPreview::CalcCellArray( BOOL bFitWidth )
{
	// Initialisieren des Zellfeldes (5x5 Zellen).
	// Rectangles enthalten Position und Groesse einer Zelle.
	// abhaengig, ob Zellbreite an Format angepasst werden soll (bFitWidth)
	USHORT	nRow;
	USHORT	nDataColWidth = (bFitWidth) ? nDataColWidth2 : nDataColWidth1;

	for ( nRow=0; nRow<=4; nRow++ )
	{
		Point	topLeftPos ( 2, (nRowHeight * nRow) + 2 );
		Size	rectSize   ( 0, nRowHeight );
		USHORT	nCell;
		USHORT	nFirst = nRow*5;
		USHORT	nLast  = nFirst+4;

		for ( nCell=nFirst; nCell<=nLast; nCell++ )
		{
			//--------------------
			// Position berechnen:
			//--------------------
			if ( nCell == 0 )
			{
				// erste Zelle benoetigt keine Sonderbehandlung
			}
			else if ( (nCell <= 4) && (nCell != 0) )
			{
				// Zelle aus der ersten Zeile
				topLeftPos = aCellArray[nCell-1].TopRight();
			}
			else
			{
				topLeftPos = aCellArray[nCell-5].BottomLeft();
			}

			//-------------------
			// Groesse berechnen:
			//-------------------
			if ( (nCell == nFirst) || (nCell == nLast) )
				rectSize.Width() = nLabelColWidth;
			else
				rectSize.Width() = nDataColWidth;

			aCellArray[nCell] = Rectangle( topLeftPos, rectSize );
		}
	}
	aPrvSize.Width()  = aCellArray[24].BottomRight().X() + 3;
	aPrvSize.Height() = aCellArray[24].BottomRight().Y() + 3;
}

//------------------------------------------------------------------------

void AutoFmtPreview::CalcLineMap()
{
	//----------------------------------------------------
	// Initialisieren des Linenattributfeldes (7x7 Zellen)
	// Ein Eintrag dieses Feldes enthaelt einen Verweis
	// auf die Linienattribute des zugehoerigen Feldes.
	// Dieses Feld "umschliesst" das Zellfeld mit einer
	// Reihe "leerer" Zellen.
	//----------------------------------------------------

	if ( pCurData )
	{
		SvxBoxItem	aFrameItem;
		USHORT		nRow;

		for ( nRow=0; nRow<=4; nRow++ )
		{
			USHORT	nLine;
			USHORT	nCell;
			USHORT	nFirst = (nRow*5);
			USHORT	nLast  = nFirst+4;

			for ( nCell=nFirst; nCell<=nLast; nCell++ )
			{
				nLine = nCell + 8 + ((nCell/5)*2);
                *(aLinePtrArray[nLine]) = *(const SvxBoxItem*)pCurData->GetItem( aFmtMap[nCell], ATTR_BORDER );
			}
		}
	}
}

//------------------------------------------------------------------------

void AutoFmtPreview::NotifyChange( ScAutoFormatData* pNewData )
{
	if ( pNewData != pCurData )
	{
		pCurData  = pNewData;
		bFitWidth = pNewData->GetIncludeWidthHeight();
		CalcCellArray( bFitWidth );
		CalcLineMap();
	}
	else if ( bFitWidth != pNewData->GetIncludeWidthHeight() )
	{
		bFitWidth = !bFitWidth;
		CalcCellArray( bFitWidth );
	}

	DoPaint( Rectangle( Point(0,0), GetSizePixel() ) );
}

//------------------------------------------------------------------------

void AutoFmtPreview::DoPaint( const Rectangle& rRect )
{
    sal_uInt32 nOldDrawMode = aVD.GetDrawMode();
	//	#105733# SvtAccessibilityOptions::GetIsForBorders is no longer used (always assumed TRUE)
    if( GetSettings().GetStyleSettings().GetHighContrastMode() )
        aVD.SetDrawMode( DRAWMODE_SETTINGSLINE | DRAWMODE_SETTINGSFILL | DRAWMODE_SETTINGSTEXT | DRAWMODE_SETTINGSGRADIENT );

    Size aWndSize( GetSizePixel() );
    Font aFont( aVD.GetFont() );
    Color aBackCol( GetSettings().GetStyleSettings().GetWindowColor() );
    Point aTmpPoint;
    Rectangle aRect( aTmpPoint, aWndSize );

    aFont.SetTransparent( TRUE );
	aVD.SetFont( aFont );
	aVD.SetLineColor();
    aVD.SetFillColor( aBackCol );
    aVD.SetOutputSize( aWndSize );
    aVD.DrawRect( aRect );

	PaintCells();
    SetLineColor();
    SetFillColor( aBackCol );
    DrawRect( aRect );

    Point aPos( (aWndSize.Width() - aPrvSize.Width()) / 2, (aWndSize.Height() - aPrvSize.Height()) / 2 );
    DrawOutDev( aPos, aWndSize, Point(), aWndSize, aVD );

    aVD.SetDrawMode( nOldDrawMode );
}

//------------------------------------------------------------------------

void __EXPORT AutoFmtPreview::Paint( const Rectangle& rRect )
{
	DoPaint( rRect );
}

