/*************************************************************************
 *
 *  $RCSfile: gridctrl.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2001/10/12 15:41:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#pragma hdrstop
#include "gridctrl.hxx"
#include "gridctrl.hrc"

#ifndef _SVX_FMTOOLS_HXX
#include "fmtools.hxx"
#endif

#ifndef __SVTOOLS_SVTNUMF_HXX__
#include <svtools/svtnumf.hxx>
#endif

#ifndef __SVX_DBFIELD_HXX__
#include <svx/dbfield.hxx>
#endif

#ifndef _TOOLS_RESID_HXX //autogen
#include <tools/resid.hxx>
#endif

#ifndef _SV_SYSTEM_HXX //autogen
#include <vcl/system.hxx>
#endif

#ifndef _SV_SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif

#ifndef _SV_MENU_HXX //autogen
#include <vcl/menu.hxx>
#endif

#include <algorithm>

extern ResMgr* pResMgr;

DBG_NAME (DBGridControl);

#define HANDLE_ID	0

static USHORT ControlMap[] = {
					FT_RECORD,
					ED_ABSOLUTE,
					FT_OF,
					FT_TOTAL,
					PB_FIRST,
					PB_PREV,
					PB_NEXT,
					PB_LAST,
					PB_NEW,
					0	};


//------------------------------------------------------------------------------
DBGridControl::AbsolutePos::AbsolutePos(Window* pParent, WinBits nStyle)
				   :NumericField(pParent, nStyle)
{
	SetMin(1);
	SetFirst(1);
	SetSpinSize(1);

	International rInt = GetInternational();
	rInt.EnableNumThousandSep(FALSE);
	SetInternational(rInt);
	SetDecimalDigits(0);
	SetStrictFormat(TRUE);
}

//------------------------------------------------------------------------------
DBGridControl::AbsolutePos::AbsolutePos(Window* pParent, const ResId& rResId)
				   :NumericField(pParent, rResId)
{
	SetMin(1);
	SetFirst(1);
	SetSpinSize(1);

	International rInt = GetInternational();
	rInt.EnableNumThousandSep(FALSE);
	SetInternational(rInt);
	SetDecimalDigits(0);
	SetStrictFormat(TRUE);
}

//------------------------------------------------------------------------------
void DBGridControl::AbsolutePos::KeyInput(const KeyEvent& rEvt)
{
	if (rEvt.GetKeyCode() == KEY_RETURN && GetText().Len())
	{
		INT32 nRecord = GetValue();
		if (nRecord < GetMin() || nRecord > GetMax())
			return;
		else
			((DBGridControl*)GetParent())->MoveToPosition(nRecord - 1);
	}
	else if (rEvt.GetKeyCode() == KEY_TAB)
		GetParent()->GrabFocus();
	else
		NumericField::KeyInput(rEvt);
}

//------------------------------------------------------------------------------
void DBGridControl::AbsolutePos::LoseFocus()
{
	NumericField::LoseFocus();
	((DBGridControl*)GetParent())->InvalidateState(ED_ABSOLUTE);
}

//------------------------------------------------------------------------------
DBGridControl::DBGridControl(Window* pParentWin)
			  :DbBrowseBox(pParentWin, ResId(RID_WIN_GRID, pResMgr),
						   BROWSER_KEEPSELECTION |
						   BROWSER_COLUMNSELECTION |
						   BROWSER_MULTISELECTION |
						   BROWSER_TRACKING_TIPS |
						   BROWSER_HLINESFULL |
						   BROWSER_VLINESFULL)
#pragma warning (disable : 4355)
			  ,aRecordText(this,ResId(FT_RECORD))
			  ,aAbsolute(this,ResId(ED_ABSOLUTE))
			  ,aRecordOf(this,ResId(FT_OF))
			  ,aRecordCount(this,ResId(FT_TOTAL))
			  ,aFirstBtn(this,ResId(PB_FIRST))
			  ,aPrevBtn(this,ResId(PB_PREV))
			  ,aNextBtn(this,ResId(PB_NEXT))
			  ,aLastBtn(this,ResId(PB_LAST))
			  ,aNewBtn(this,ResId(PB_NEW))
#pragma warning (default : 4355)
			  ,nSeekPos(-1)
			  ,nCurrentPos(-1)
			  ,nTotalCount(-1)
			  ,bFrozen(FALSE)
			  ,bDesignMode(FALSE)
			  ,nRecordStatus(DBRECORDSTATUS_INVALID)
			  ,nOptions(READONLY)
			  ,nEditMode(DBEDITMODE_NONE)
{
	DBG_CTOR( DBGridControl, NULL );

	Font aFont(GetDataWindow().GetFont());
	aFont.SetWeight(WEIGHT_NORMAL);
	GetDataWindow().SetFont(aFont);

	aFont = GetFont();
	aFont.SetWeight(WEIGHT_LIGHT);
	SetFont(aFont);

	aNewBtn.SetImage(GetImage(NEW));

	// Handler fuer Buttons einrichten
	aFirstBtn.SetClickHdl(LINK(this,DBGridControl,OnClick));
	aPrevBtn.SetClickHdl(LINK(this,DBGridControl,OnClick));
	aNextBtn.SetClickHdl(LINK(this,DBGridControl,OnClick));
	aLastBtn.SetClickHdl(LINK(this,DBGridControl,OnClick));
	aNewBtn.SetClickHdl(LINK(this,DBGridControl,OnClick));

	InitColumns(XDatabaseFieldsRef());
	EnableDrop(TRUE);

	FreeResource();
}

//------------------------------------------------------------------------------
DBGridControl::~DBGridControl()
{
	DBG_DTOR(DBGridControl, NULL);
	CleanUp();
}

//------------------------------------------------------------------------------
void DBGridControl::Clear()
{
	if (xSeekCursor.is())
	{
		xSeekCursor->dispose();
		xSeekCursor = NULL;
	}

	nSeekPos	= nCurrentPos = -1;
	nTotalCount	= -1;
	nOptions	= READONLY;
	nEditMode   = DBEDITMODE_NONE;
	nRecordStatus = DBRECORDSTATUS_INVALID;

	DbBrowseBox::Clear();				// Anzahl Saetze im Browser auf 0 zuruecksetzen
	InvalidateAll();
}

//------------------------------------------------------------------------------
void DBGridControl::ArrangeControls(USHORT& nX, USHORT nY)
{
	// Positionierung der Controls

	// Basisgroessen ermitteln
	Rectangle	aRect(GetControlArea());
	const long	nH		= aRect.GetSize().Height() - 1;
	Size		aBorder = LogicToPixel(Size(3, 3),MAP_APPFONT);
	nY += 1;
	long		nStw = GetTextSize( "0000000" ).Width();

	// Controls Groessen und Positionen setzen
	//
	aRecordText.SetPosPixel(Point(nX,nY));
	String aText	= aRecordText.GetText();
	long nTextWidth = GetTextSize(aText).Width();
	aRecordText.SetPosPixel(Point(nX,nY) );
	aRecordText.SetSizePixel(Size(nTextWidth,nH));
	nX += (USHORT)(nTextWidth + aBorder.Width());

	aAbsolute.SetPosPixel( Point(nX,nY));
	aAbsolute.SetSizePixel( Size(3*nH,aRect.GetSize().Height()) ); // Heuristik XXXXXXX
	nX += (USHORT)((3*nH) + aBorder.Width());

	aRecordOf.SetPosPixel(Point(nX,nY));
	aText	   = aRecordOf.GetText();
	nTextWidth = GetTextSize(aText).Width();
	aRecordOf.SetPosPixel(Point(nX,nY) );
	aRecordOf.SetSizePixel(Size(nTextWidth,nH));
	nX += (USHORT)(nTextWidth + aBorder.Width());

	aRecordCount.SetPosPixel(Point(nX,nY));
	nTextWidth = GetTextSize( "0000000" ).Width();
	aRecordCount.SetPosPixel(Point(nX,nY) );
	aRecordCount.SetSizePixel(Size(nTextWidth,nH));
	nX += (USHORT)(nTextWidth + aBorder.Width());

	aFirstBtn.SetPosPixel( Point(nX,nY) );
	aFirstBtn.SetSizePixel( Size(nH,nH) );
	nX += (USHORT)nH;

	aPrevBtn.SetPosPixel( Point(nX,nY) );
	aPrevBtn.SetSizePixel( Size(nH,nH) );
	nX += (USHORT)nH;

	aNextBtn.SetPosPixel( Point(nX,nY) );
	aNextBtn.SetSizePixel( Size(nH,nH) );
	nX += (USHORT)nH;

	aLastBtn.SetPosPixel( Point(nX,nY) );
	aLastBtn.SetSizePixel( Size(nH,nH) );
	nX += (USHORT)nH;

	aNewBtn.SetPosPixel( Point(nX,nY) );
	aNewBtn.SetSizePixel( Size(nH,nH) );
	nX += (USHORT)(nH + aBorder.Width());

	// Ist der Font des Edits groesser als das Feld?
	Font aOutputFont = aAbsolute.GetFont();
	if (aOutputFont.GetSize().Height() > nH)
	{
		Font aApplFont = System::GetStandardFont(STDFONT_SWISS);
		aApplFont.SetSize(Size(0, nH-2));
		aAbsolute.SetFont(aApplFont);

		aApplFont.SetTransparent( TRUE );
		aRecordText.SetFont( aApplFont );
		aRecordOf.SetFont( aApplFont );
		aRecordCount.SetFont( aApplFont );
	}
}

//------------------------------------------------------------------------------
void DBGridControl::SetSource(XDatabaseCursorRef& _xCursor, USHORT nOpts)
{
	Clear();

	xDataCursor = _xCursor;

	if (_xCursor.is())
		xSeekCursor = _xCursor->cloneIterator();

	if (xSeekCursor.is())
	{
		nOptions = nOpts;

		XPropertySetRef xSet = QUERY_INTERFACE(XPropertySet, xDataCursor);
		if (xSet.is())
		{
			// feststellen welche Updatemglichkeiten bestehen
			if (xSet->getPropertyValue("CanInsert").getBOOL() && (nOpts & INSERT))
				nOptions |= INSERT;
			if (xSet->getPropertyValue("CanUpdate").getBOOL() && (nOpts & UPDATE))
				nOptions |= UPDATE;
			if (xSet->getPropertyValue("CanDelete").getBOOL() && (nOpts & DELETE))
				nOptions |= DELETE;
		}

		BrowserMode nMode = BROWSER_COLUMNSELECTION | BROWSER_MULTISELECTION | BROWSER_KEEPSELECTION |
							BROWSER_TRACKING_TIPS |
							BROWSER_HLINESFULL | BROWSER_VLINESFULL;
		if (nOptions & INSERT || nOptions & UPDATE)
			nMode |= BROWSER_HIDECURSOR;

		SetMode(nMode);

		InitColumns(xSeekCursor->getFields());
		if (ColCount() > 1)
		{
			xSet = QUERY_INTERFACE(XPropertySet, xSeekCursor);
			if (xSet.is())
			{
				UsrAny aVal   = xSet->getPropertyValue("RecordStatus");
				nRecordStatus = aVal.getUINT16();
			}

			if (IsValidRecord())
			{
				UINT32 nRecordCount	 = xSet->getPropertyValue("RecordCount").getUINT32();
				nSeekPos = 0;
				RowInserted(0, nRecordCount, !IsResizing());
			}

			if (nOptions & INSERT)
			{
				aAppendRecord = AnySequence(aColumns.Count());
				RowInserted(GetRowCount(), 1, !IsResizing());
			}
		}
	}

	// beim Resizen wird RecalcRows gerufen
	if (!IsResizing())
		RecalcRows(GetTopRow(), GetVisibleRows(), TRUE);

	InvalidateAll();
}

//------------------------------------------------------------------------------
void DBGridControl::CleanUp()
{
	for (UINT32 i = 0; i < aColumns.Count(); i++)
		delete aColumns.GetObject(i);
	aColumns.Clear();
}

//------------------------------------------------------------------------------
void DBGridControl::InitColumns(XDatabaseFieldsRef xFields)
{
	DBG_CHKTHIS( DBGridControl, NULL );

	//////////////////////////////////////////////////////////////////////
	// Falls alte Columns vorhanden, alte Columns loeschen
	DBG_ASSERT(!ColCount(), "Spalten nicht gelscht!");
	if (ColCount())
	{
		CleanUp();
		RemoveColumns();
	}

	//////////////////////////////////////////////////////////////////////
	// Handle Column einfuegen
	InsertHandleColumn(GetTextSize( "0" ).Width()*4, TRUE); //XXX

	if (!xFields.is())
		return;

	//////////////////////////////////////////////////////////////////////
	// Restliche Columns einfuegen
	INT32 nColCount = xFields->getCount();
	INT32 nCharWidth = GetTextSize("0").Width();

	for (INT32 i = 0; i < nColCount; i++ )
	{
		//////////////////////////////////////////////////////////////////////
		// Itemset der Spaltenbeschreibung holen
		XDatabaseFieldRef xField = xFields->getFieldByIndex(i);
		XPropertySetRef xSet	 = QUERY_INTERFACE(XPropertySet,xField);
		UINT32 nFormatKey		 = xSet->getPropertyValue("FormatKey").getUINT32();
		DBGridColumn*	  pColumn= new DBGridColumn(xField->getName(), xField->getType(), nFormatKey);
		aColumns.Insert(pColumn, LIST_APPEND);

		INT32 nLabWidth = GetTextSize(xField->getName()).Width() + nCharWidth*4;
		InsertDataColumn(i + 1, xField->getName(), nLabWidth);

		Edit* pEdit = NULL;

		// festlegen der Columns
		switch (pColumn->GetType())
		{
			case DBTYPE_BYTE:
			case DBTYPE_SMALLINT:
			case DBTYPE_INT:
			case DBTYPE_COUNTER:
			case DBTYPE_SINGLE:
			case DBTYPE_DATE:
			case DBTYPE_TIME:
			case DBTYPE_DATETIME:
			case DBTYPE_CURRENCY:
			case DBTYPE_BIGINT:
			case DBTYPE_DOUBLE:
			case DBTYPE_DECIMAL:
				pEdit = new Edit(&GetDataWindow(), WB_RIGHT);
				break;
			default:
				pEdit = new Edit(&GetDataWindow(), WB_LEFT);
				// Alles nur damit die Selektion bei Focuserhalt von rechts nach links geht
				AllSettings		aSettings = pEdit->GetSettings();
				StyleSettings	aStyleSettings = aSettings.GetStyleSettings();
				aStyleSettings.SetSelectionOptions(
					aStyleSettings.GetSelectionOptions() | SELECTION_OPTION_SHOWFIRST);
				aSettings.SetStyleSettings(aStyleSettings);
				pEdit->SetSettings(aSettings);
		}
		pColumn->SetController(new EditCellController(pEdit));
	}
}

//------------------------------------------------------------------------------
// positioniert auf einen bestimmten Datensatz
//------------------------------------------------------------------------------
BOOL DBGridControl::SeekRow(long nRow)
{
	if (!bFrozen)
	{
		if (SeekCursor(nRow) && xSeekCursor.is())
		{
			XPropertySetRef xSet = QUERY_INTERFACE(XPropertySet, xSeekCursor);
			if (xSet.is())
			{
				UsrAny aVal   = xSet->getPropertyValue("RecordStatus");
				nRecordStatus = aVal.getUINT16();
			}
			if (nRow == nCurrentPos)
				aSeekRecord = aCurrentRecord;
			else if (IsAppendRow(nRow))			// Leerzeile zum Einfuegen von Datensaetzen
				aSeekRecord = aAppendRecord;
			else
				aSeekRecord = xSeekCursor->getRecord();
		}
	}
	return !bFrozen && nSeekPos >= 0;
}

//------------------------------------------------------------------------------
// Wird aufgerufen, wenn die dargestellte Datenmenge sich aendert
//------------------------------------------------------------------------------
void DBGridControl::VisibleRowsChanged( long nNewTopRow, USHORT nLinesOnScreen )
{
	RecalcRows(nNewTopRow, nLinesOnScreen , FALSE);
}

//------------------------------------------------------------------------------
void DBGridControl::RecalcRows(long nNewTopRow, USHORT nLinesOnScreen, BOOL bUpdateCursor)
{
	DBG_CHKTHIS( DBGridControl, NULL );
	bFrozen = !bUpdateCursor;	// Jetzt Updates ignorieren

	// Wenn kein Cursor -> keine Rows im Browser.
	if (!xSeekCursor.is())
	{
		DBG_ASSERT(GetRowCount() == 0,"DBGridControl: ohne Cursor darf es keine Rows geben");
		bFrozen = FALSE;
		return;
	}
	// Cache an den sichtbaren Bereich anpassen
	XPropertySetRef xSet = (XPropertySet*)xSeekCursor->queryInterface(XPropertySet::getSmartUik());
	UINT16 nCacheSize	 = xSet->getPropertyValue("CacheSize").getUINT16();
	// Nach der Initialisierung (nSeekPos < 0) keine Cursorbewegung, da bereits auf den ersten
	// Satz positioniert
	long nDelta	= nNewTopRow - GetTopRow();
	// Limit fuer relative Positionierung
	long nLimit = (nCacheSize) ? nCacheSize / 2 : 0;

	// mehr Zeilen auf dem Bildschirm als im Cache
	if (nLimit < nLinesOnScreen)
	{
		xSet->setPropertyValue("CacheSize", UsrAny(UINT16(nLinesOnScreen * 2)));
		// jetzt auf alle Faelle den Cursor anpassen
		bUpdateCursor = TRUE;

		nLimit = nLinesOnScreen;
	}

	// Im folgenden werden die Positionierungen so vorgenommen, da sichergestellt ist
	// da ausreichend Zeilen im DatenCache vorhanden sind
	if (nDelta >= 0 && nDelta < nLimit)		// Fenster geht nach unten, weniger als zwei Fenster Differenz
		SeekCursor(nNewTopRow + nLinesOnScreen - 1, FALSE);
	else if (nDelta < 0 && Abs(nDelta) < nLimit)
		SeekCursor(nNewTopRow, FALSE);
	else if (nDelta != 0 || bUpdateCursor)
		SeekCursor(nNewTopRow, TRUE);

	AdjustRows();
	bFrozen = FALSE;	// Jetzt Updates nicht mehr ignorieren
}

//------------------------------------------------------------------------------
void DBGridControl::AdjustRows()
{
	XPropertySetRef xSet = QUERY_INTERFACE(XPropertySet, xSeekCursor);
	if (!xSet.is())
		return;

	// Aktualisieren des RecordCounts
	UINT32 nRecordCount		 = xSet->getPropertyValue("RecordCount").getUINT32();
	BOOL   bRecordCountFinal = xSet->getPropertyValue("RecordCountFinal").getBOOL();

	// hat sich die aktuelle Anzahl Rows veraendert
	// hierbei muss auch beruecksichtigt werden,
	// das eine zusaetzliche Zeile zum einfuegen von Datensaetzen vorhanden sein kann
	if (nOptions & INSERT)
		nRecordCount++;
	if (nRecordCount != (UINT32)GetRowCount())
	{
		long nDelta = GetRowCount() - (long)nRecordCount;
		if (nDelta > 0)											// zuviele
			RowRemoved(GetRowCount() - nDelta, nDelta, TRUE);
		else													// zuwenig
			RowInserted(GetRowCount(), -nDelta, TRUE);
	}

	if (bRecordCountFinal && nTotalCount < 0)
	{
		if (nOptions & INSERT)
			nTotalCount = GetRowCount() - 1;
		else
			nTotalCount = GetRowCount();

		InvalidateState(FT_TOTAL);
	}
}

//------------------------------------------------------------------------------
DbBrowseBox::RowStatus DBGridControl::GetRowStatus(long nRow) const
{
	if (nCurrentPos >= 0 && nSeekPos == nCurrentPos)
	{
		if (IsModified())
			return DbBrowseBox::MODIFIED;
		else if (nEditMode == DBEDITMODE_IN_ADD)
			return DbBrowseBox::CURRENTNEW;
		else
			return DbBrowseBox::CURRENT;
	}
	else if (IsAppendRow(nRow))
		return NEW;
	else if (!IsValidRecord())
		return DbBrowseBox::DELETED;
	else
		return DbBrowseBox::CLEAN;
}

//------------------------------------------------------------------------------
void DBGridControl::PaintStatusCell(OutputDevice& rDev, const Rectangle& rRect) const
{
	if (!bFrozen)
		DbBrowseBox::PaintStatusCell(rDev, rRect);
}

//------------------------------------------------------------------------------
void DBGridControl::PaintCell(OutputDevice& rDev, const Rectangle& rRect, USHORT nColumnId) const
{
	if (nSeekPos < 0 || bFrozen || !xSeekCursor.is())
		return;

	DBGridColumn* pColumn = aColumns.GetObject(nColumnId-1);

	String aText = GetCellText(nColumnId);

	Rectangle aOutRect(rRect);
	USHORT	  nStyle = TEXT_DRAW_CLIP;

	switch (pColumn->GetType())
	{
		case DBTYPE_BYTE:
		case DBTYPE_SMALLINT:
		case DBTYPE_INT:
		case DBTYPE_COUNTER:
		case DBTYPE_SINGLE:
		case DBTYPE_DATE:
		case DBTYPE_TIME:
		case DBTYPE_DATETIME:
		case DBTYPE_CURRENCY:
		case DBTYPE_BIGINT:
		case DBTYPE_DOUBLE:
		case DBTYPE_DECIMAL:
			nStyle |= TEXT_DRAW_RIGHT;
			break;
		default:
			nStyle |= TEXT_DRAW_LEFT;
	}
	rDev.DrawText(aOutRect, aText, nStyle);
}

//------------------------------------------------------------------------------
void DBGridControl::CursorMoving(long nNewRow, USHORT nNewCol)
{
	DBG_CHKTHIS( DBGridControl, NULL );
	DbBrowseBox::CursorMoving(nNewRow, nNewCol);
}

//------------------------------------------------------------------------------
void DBGridControl::CursorMoved()
{
	DBG_CHKTHIS( DBGridControl, NULL );
	long nNewRow = GetCurRow();
	if (xDataCursor.is() && nCurrentPos != nNewRow)
	{
		// Abgleichen der Positionen
		if (SeekCursor(nNewRow))
		{
			// Feststellen ob die aktuelle Zeile die InsertZeile ist
			if (IsAppendRow(nNewRow))
			{
				xDataCursor->addRecord();
				nEditMode = DBEDITMODE_IN_ADD;
			}
			else
			{
				UsrAny aBookmark = xSeekCursor->getBookmark();
				xDataCursor->moveToBookmark(aBookmark);
				nEditMode = DBEDITMODE_NONE;
			}

			aCurrentRecord = xDataCursor->getRecord();
			nCurrentPos	= nNewRow;
		}

		DbBrowseBox::CursorMoved();
		InvalidateAll();
	}
	else
		DbBrowseBox::CursorMoved();
}

//------------------------------------------------------------------------------
BOOL DBGridControl::SeekCursor(long nRow, BOOL bAbsolute)
{
	DBG_CHKTHIS( DBGridControl, NULL );

	if (!xSeekCursor.is())
		return FALSE;

	if (nEditMode & DBEDITMODE_IN_ADD)	// es wird gerade ein neuer Datensatz eingefuegt
		nSeekPos = nRow;
	else if (IsAppendRow(nRow))			// Leerzeile zum Einfuegen von Datensaetzen
		nSeekPos = nRow;
	else if (bAbsolute || xSeekCursor->getPosition() < 0)	// absolut positionierung
	{
		if (xSeekCursor->moveToPosition(nRow).isOk())
			nSeekPos = nRow;							// dann auf den letzten Satz
		else if (xSeekCursor->moveToLast().isOk())
			nSeekPos = xSeekCursor->getPosition();
		else
			nSeekPos = -1;						// kein Datensatz mehr vorhanden
	}
	else
	{
		long nSteps = nRow - xSeekCursor->getPosition();// Tatsaechliche Position im Cursor
		if (nSteps > 0)								// auf den letzten benoetigten Datensatz positionieren
		{
			if (!xSeekCursor->isAtEndOfSet() && xSeekCursor->moveRelative(nSteps).isOk())
				nSeekPos += nSteps;
			else if (xSeekCursor->moveToLast().isOk())
				nSeekPos = xSeekCursor->getPosition();
			else
				nSeekPos = - 1;					// keine Ergebniszeilen
		}
		else if (nSteps < 0)
		{
			if (!xSeekCursor->isAtStartOfSet() && xSeekCursor->moveRelative(nSteps).isOk())
				nSeekPos += nSteps;
			else if (xSeekCursor->moveToFirst().isOk())	// auf die erste Zeile Positionieren
				nSeekPos =  0;
			else									// keine Ergebniszeilen
				nSeekPos = -1;
		}
	}
	return nSeekPos >= 0;
}

//------------------------------------------------------------------------------
IMPL_LINK(DBGridControl, OnClick, Button *, pButton )
{
	DBG_CHKTHIS(DBGridControl, NULL );

	if (pButton == &aFirstBtn)
		MoveToFirst();
	else if( pButton == &aPrevBtn )
		MoveToPrev();
	else if( pButton == &aNextBtn )
		MoveToNext();
	else if( pButton == &aLastBtn )
		MoveToLast();
	else if( pButton == &aNewBtn )
		AppendNew();
	return 0;
}

//------------------------------------------------------------------------------
void DBGridControl::MoveToFirst()
{
	if (!xSeekCursor.is())
		return;

	if (GetCurRow() != 0)
		MoveToPosition(0);
}

//------------------------------------------------------------------------------
void DBGridControl::MoveToLast()
{
	if (!xSeekCursor.is())
		return;

	if (nTotalCount < 0)			// RecordCount steht noch nicht fest
	{
		if (xSeekCursor->moveToLast().isOk())
			AdjustRows();
	}

	// auf den letzen Datensatz positionieren, nicht auf die Leerzeile
	if (nOptions & INSERT)
	{
		if ((GetRowCount() - 1) > 0)
			MoveToPosition(GetRowCount() - 2);
	}
	else if (GetRowCount())
		MoveToPosition(GetRowCount() - 1);
}

//------------------------------------------------------------------------------
void DBGridControl::MoveToPrev()
{
	if (!xSeekCursor.is())
		return;

	long nNewRow = std::max(GetCurRow() - 1, 0);
	if (GetCurRow() != nNewRow)
		MoveToPosition(nNewRow);
}

//------------------------------------------------------------------------------
void DBGridControl::MoveToNext()
{
	if (!xSeekCursor.is())
		return;

	if (nTotalCount > 0)
	{
		long nNewRow = std::min(GetRowCount() - 1, GetCurRow() + 1);
		if (GetCurRow() != nNewRow)
			MoveToPosition(nNewRow);
	}
	else
	{
		// Versuchen auf die naechste Zeile zu Positionieren
		if (xSeekCursor->moveRelative(1).isOk())
		{
			MoveToPosition(GetCurRow() + 1);
		}
	}
}

//------------------------------------------------------------------------------
void DBGridControl::MoveToPosition(ULONG nPos)
{
	if (!xSeekCursor.is())
		return;

	if (nPos >= 0)
	{
		if (nTotalCount < 0 && (long)nPos >= GetRowCount())
		{
			if (!xSeekCursor->moveToPosition(nPos).isOk())
			{
				AdjustRows();
				Sound::Beep();
				return;
			}
			else
				AdjustRows();
		}
		DbBrowseBox::GoToRow(nPos);
		InvalidateAll();
	}
}

//------------------------------------------------------------------------------
void DBGridControl::AppendNew()
{
	if (!xSeekCursor.is() || !(nOptions & INSERT))
		return;

	if (nTotalCount < 0)			// RecordCount steht noch nicht fest
	{
		if (xSeekCursor->moveToLast().isOk())
			AdjustRows();
	}

	long nNewRow = nTotalCount + 1;
	if (nNewRow > 0 && GetCurRow() != nNewRow)
		MoveToPosition(nNewRow - 1);
}

//------------------------------------------------------------------------------
void DBGridControl::InvalidateAll()
{
	int i = 0;
	while (ControlMap[i])
		SetState(ControlMap[i++]);
}

//------------------------------------------------------------------------------
BOOL DBGridControl::GetState(USHORT nWhich) const
{
	if (!xSeekCursor.is() || bDesignMode)
		return FALSE;
	else
	{
		BOOL bAvailable = TRUE;
		switch (nWhich)
		{
			case PB_FIRST:
			case PB_PREV:
				bAvailable = GetCurRow() > 0;
				break;
			case PB_NEXT:
				bAvailable = GetRowCount() && GetCurRow() < (GetRowCount() - 1);
				break;
			case PB_LAST:
				bAvailable = GetRowCount() && (nOptions & INSERT) ?
							(GetCurRow() < (GetRowCount() - 2) || GetCurRow() == (GetRowCount() - 1))
							: GetCurRow() < (GetRowCount() - 1);
				break;
			case PB_NEW:
				bAvailable = (nOptions & INSERT) && GetRowCount() && GetCurRow() < (GetRowCount() - 1);
				break;
			case ED_ABSOLUTE:
				bAvailable = GetRowCount() > 0;
				break;
		}
		return bAvailable;
	}
}

//------------------------------------------------------------------------------
void DBGridControl::SetState(USHORT nWhich)
{
	BOOL bAvailable = GetState(nWhich);
	Window* pWnd = NULL;
	switch (nWhich)
	{
		case PB_FIRST:
			pWnd = &aFirstBtn;
			break;
		case PB_PREV:
			pWnd = &aPrevBtn;
			break;
		case PB_NEXT:
			pWnd = &aNextBtn;
			break;
		case PB_LAST:
			pWnd = &aLastBtn;
			break;
		case PB_NEW:
			pWnd = &aNewBtn;
			break;
		case ED_ABSOLUTE:
			pWnd = &aAbsolute;
			if (bAvailable)
			{
				if (nTotalCount >= 0)
					aAbsolute.SetMax(nTotalCount);
				else
					aAbsolute.SetMax(LONG_MAX);

				aAbsolute.SetValue(nCurrentPos + 1);
			}
			else
				aAbsolute.SetText("");
			break;
		case FT_RECORD:
			pWnd = &aRecordText;
			break;
		case FT_OF:
			pWnd = &aRecordOf;
			break;
		case FT_TOTAL:
		{
			pWnd = &aRecordCount;
			String aText;
			if (bAvailable && nTotalCount >= 0)
				aText = long(nTotalCount);
			else
				aText = '?';
			pWnd->SetText(aText);
		}	break;
	}
	DBG_ASSERT(pWnd, "kein Fenster");
	if (pWnd)
		pWnd->Enable(bAvailable);
}

//------------------------------------------------------------------------------
void DBGridControl::SetDesignMode(BOOL bMode)
{
	bDesignMode = bMode;
}

//------------------------------------------------------------------------------
String DBGridControl::GetCellText(USHORT nColId) const
{
	// Ausgabe des Textes fuer eine Zelle
	String aText;
	DBGridColumn* pColumn = aColumns.GetObject(nColId-1);
	if (!IsValidRecord())
		aText = "###";
	else if (pColumn)
	{
		aText = DBTypeConversion::toOutputString(xFormatter,
			aSeekRecord.getConstArray()[nColId-1], pColumn->GetType(), pColumn->GetKey());
	}
	return aText;
}

//------------------------------------------------------------------------------
ULONG DBGridControl::GetTotalCellWidth(long nRow, USHORT nColId)
{
	if (SeekRow(nRow))
		return GetDataWindow().GetTextSize(GetCellText(nColId)).Width();
	else
		return 30;	//xxxx
}

//------------------------------------------------------------------------------
void DBGridControl::Command(const CommandEvent& rEvt)
{
	switch (rEvt.GetCommand())
	{
		case COMMAND_CONTEXTMENU:
		{
			if (!rEvt.IsMouseEvent() || !xSeekCursor.is())
			{
				DbBrowseBox::Command(rEvt);
				return;
			}

			Point aPoint = OutputToScreenPixel(rEvt.GetMousePosPixel());
			USHORT nColId = GetColumnAtXPosPixel(rEvt.GetMousePosPixel().X());
			long   nRow = GetRowAtYPosPixel(rEvt.GetMousePosPixel().Y());

			if (nColId == HANDLE_ID)
			{
				PopupMenu aContextMenu(ResId(RID_MENU_ROWS,pResMgr));
				aContextMenu.EnableItem(SID_SVX_DELETEROWS, (nOptions & DELETE) && GetSelectRowCount());
				switch (aContextMenu.Execute(aPoint))
				{
					case SID_SVX_DELETEROWS:
						DeleteSelectedRows();
						break;
					default:
						break;
				}
			}
			else
			{
				DbBrowseBox::Command(rEvt);
				return;
			}
		}
		default:
			DbBrowseBox::Command(rEvt);
	}
}

//------------------------------------------------------------------------------
void DBGridControl::DeleteSelectedRows()
{
	DBG_ASSERT(GetSelection(), "keine selection!!!");

	if (!xSeekCursor.is())
		return;

	Application::EnterWait();
	XPropertySetRef xSet = (XPropertySet*)xSeekCursor->queryInterface(XPropertySet::getSmartUik());

	// wenn mehr als 25 Datensaetze geloescht werden, wird der Cache abgeschaltet
	UINT16 nCacheSize = 0;
	if (GetSelectRowCount() > 25)
	{
		// nCacheSize = xSet->getPropertyValue("CacheSize").getUINT16();
		if (nCacheSize)
			xSet->setPropertyValue("CacheSize", UsrAny(UINT16(0)));
	}

	long nIdx = FirstSelectedRow();
	while (nIdx >= 0)
	{
		// jetzt die Datensaetze loeschen
		// zunaechst den SeekCursor positionieren
		SeekCursor(nIdx);
		UsrAny aBookmark = xSeekCursor->getBookmark();
		xDataCursor->moveToBookmark(aBookmark);

		if (!xDataCursor->destroyRecord().isOk())
		{
			break;
		}
		else
		{
			// weg vom geloeschten Satz positionieren
			UINT32 nRecordCount	 = xSet->getPropertyValue("RecordCount").getUINT32();
			if (nRecordCount)
			{
				SeekCursor(nIdx);
			}
			else
			{
				SeekCursor(nIdx);
			}

			RowRemoved(nIdx, 1, (nCacheSize == 0));
			nIdx = FirstSelectedRow();
		}
	}

	RecalcRows(GetTopRow(), GetVisibleRows(), TRUE);

	InvalidateAll();
	Application::LeaveWait();
}

//------------------------------------------------------------------------------
CellController* DBGridControl::GetController(long nRow, USHORT nColumnId)
{
	if (!xDataCursor.is() || !(nOptions & UPDATE) || !IsValidRecord())
		return NULL;
	else
	{
		DBGridColumn* pColumn = aColumns.GetObject(nColumnId-1);
		return &pColumn->GetController();
	}
}

//------------------------------------------------------------------------------
void DBGridControl::InitController(CellControllerRef& rController, long nRow, USHORT nColumnId)
{
	if (!xDataCursor.is())
		return;

	DBGridColumn* pColumn = aColumns.GetObject(nColumnId-1);
	Edit& rEdit = (Edit&)rController->GetWindow();
	String aText = DBTypeConversion::toOutputString(xFormatter,
				   aCurrentRecord.getConstArray()[nColumnId-1], pColumn->GetType(), pColumn->GetKey());

	rEdit.SetText(aText);
	rEdit.SetSelection(Selection(SELECTION_MAX,SELECTION_MIN));
}

//------------------------------------------------------------------------------
void DBGridControl::CellModified()
{
	if (xDataCursor.is() && nRecordStatus == DBRECORDSTATUS_CLEAN)
	{
		InvalidateStatusCell(nCurrentPos);
		nRecordStatus = DBRECORDSTATUS_DIRTY;
	}
}

//------------------------------------------------------------------------------
BOOL DBGridControl::IsModified() const
{
	return nRecordStatus == DBRECORDSTATUS_DIRTY;
}

//------------------------------------------------------------------------------
BOOL DBGridControl::IsAppendRow(long nRow) const
{
	return (nOptions & INSERT) && nTotalCount >= 0 && (nRow >= nTotalCount);
}

//------------------------------------------------------------------------------
BOOL DBGridControl::SaveModified()
{
	// Uebernimmt die Dateneingabe fuer das Feld
	if (nRecordStatus == DBRECORDSTATUS_DIRTY)
	{
		String aStr(Controller()->GetWindow().GetText());
		UsrAny aTextVal = UsrAny(aStr);
		DBGridColumn* pColumn = aColumns.GetObject(GetCurColumnId()-1);
		UsrAny aValue   = DBTypeConversion::toDBValue(xFormatter, aTextVal, pColumn->GetType(), pColumn->GetKey());
		((UsrAny*)aCurrentRecord.getConstArray())[GetCurColumnId()-1] = aValue;

		Controller()->ClearModified();
	}
	return TRUE;
}




