
package org.netbeans.modules.openoffice.wizard.panels.idl;

import java.awt.*;
import java.awt.event.*;
import java.util.ResourceBundle;
import javax.swing.*;
import java.awt.event.ActionListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;


public class ConstantsPanel extends BasePanel implements DocumentListener
{
    private JLabel jLabel1;
    private JTextField name;
    
    public ConstantsPanel()
    {
        initComponents();
        postInitComponents();
    }

    public String getName()
    {
        return name.getText().trim();
    }

    public void setName(String s)
    {
        name.setText(s);
    }

    public void postInitComponents()
    {
        name.getDocument().addDocumentListener(this);
    }

    private void initComponents()
    {
        jLabel1 = new JLabel();
        name = new JTextField();
        setLayout(new GridBagLayout());
        setPreferredSize(new Dimension(250, 32));
        jLabel1.setText(ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("TXT_ConstantsName"));
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.insets = new Insets(8, 8, 8, 8);
        gridbagconstraints.anchor = 17;
        add(jLabel1, gridbagconstraints);
        name.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("TIP_Name"));
        name.setPreferredSize(new Dimension(100, 16));
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(8, 0, 8, 8);
        gridbagconstraints.anchor = 17;
        gridbagconstraints.weightx = 1.0D;
        add(name, gridbagconstraints);
    }

        
    private void checkState()
    {
//        if(IdlUtilities.isValidIDLIdentifier(name.getText()))
//            enableOk();
//        else
//            disableOk();
    }

    public void removeUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

    public void changedUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

    public void insertUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

   
}
