/*************************************************************************
 *
 *  $RCSfile: b3dvolum.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 18:28:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _B3D_VOLUM_HXX
#include "b3dvolum.hxx"
#endif

/*************************************************************************
|*
|* Konstruktor 1:                                               |
|* rPos: Zentrum oder minimale Koordinate links, unten, hinten  |__
|*       (abhaengig von bPosIsCenter)                          /
|*
\************************************************************************/

B3dVolume::B3dVolume(const Vector3D& rPos, const Vector3D& r3DSize,
					BOOL bPosIsCenter)
{
	if ( bPosIsCenter )	aMinVec = rPos - r3DSize / 2;
	else				aMinVec = rPos;

	aMaxVec = aMinVec + r3DSize;
}

/*************************************************************************
|*
|* Konstruktor 2 - leeres Volumen, Werte als ungueltig markieren
|*
\************************************************************************/

B3dVolume::B3dVolume() :
	aMinVec( DBL_MAX, DBL_MAX, DBL_MAX),
	aMaxVec(-DBL_MAX,-DBL_MAX,-DBL_MAX)
{
}

/*************************************************************************
|*
|* Volumen zuruecksetzen
|*
\************************************************************************/

void B3dVolume::Reset()
{
	aMinVec = Vector3D( DBL_MAX, DBL_MAX, DBL_MAX);
	aMaxVec = Vector3D(-DBL_MAX,-DBL_MAX,-DBL_MAX);
}

/*************************************************************************
|*
|* testen, ob Volumen vollstaendig gueltige Werte enthaelt
|*
\************************************************************************/

BOOL B3dVolume::IsValid() const
{
	return ( aMinVec.X() !=  DBL_MAX && aMinVec.Y() !=  DBL_MAX &&
			 aMinVec.Z() !=  DBL_MAX && aMaxVec.X() != -DBL_MAX &&
			 aMaxVec.Y() != -DBL_MAX && aMaxVec.Z() != -DBL_MAX );
}

/*************************************************************************
|*
|* einen 3D-Vektor in das Volumen einschliessen
|*
\************************************************************************/

B3dVolume& B3dVolume::Union(const B3dVolume& rVol2)
{
	if ( rVol2.IsValid() )
	{
		aMinVec.Min(rVol2.aMinVec);
		aMaxVec.Max(rVol2.aMaxVec);
	}
	return *this;
}

/*************************************************************************
|*
|* Vereinigung mit Vector3D
|*
\************************************************************************/

B3dVolume& B3dVolume::Union(const Vector3D& rVec)
{
	aMinVec.Min(rVec);
	aMaxVec.Max(rVec);
	return *this;
}

/*************************************************************************
|*
|* 3D-Groessenvektor zurueckgeben
|*
\************************************************************************/

Vector3D B3dVolume::GetSize() const
{
	return Vector3D(GetWidth(), GetHeight(), GetDepth());
}

/*************************************************************************
|*
|* Test auf Punkt innerhalb des Volumes
|*
\************************************************************************/

BOOL B3dVolume::IsInside(const Vector3D& rVec)
{
	return (rVec.X() >= aMinVec.X() && rVec.X() <= aMaxVec.X()
		&& rVec.Y() >= aMinVec.Y() && rVec.Y() <= aMaxVec.Y()
		&& rVec.Z() >= aMinVec.Z() && rVec.Z() <= aMaxVec.Z());
}

/*************************************************************************
|*
|* Stream-In-Operator fuer B3dVolume
|*
\************************************************************************/

SvStream& operator>>(SvStream& rIStream, B3dVolume& rB3dVolume)
{
	rIStream >> rB3dVolume.aMinVec;
	rIStream >> rB3dVolume.aMaxVec;

	return rIStream;
}

/*************************************************************************
|*
|* Stream-Out-Operator fuer B3dVolume
|*
\************************************************************************/

SvStream& operator<<(SvStream& rOStream, const B3dVolume& rB3dVolume)
{
	rOStream << rB3dVolume.aMinVec;
	rOStream << rB3dVolume.aMaxVec;

	return rOStream;
}

#pragma SEG_EOFMODULE
