/*************************************************************************
 *
 *  $RCSfile: b2dmtri.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:30:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _B2D_MTRI_HXX
#include "b2dmtri.hxx"
#endif

#ifndef _SV_BMPACC_HXX
#include <vcl/bmpacc.hxx>
#endif

//************************************************************
//   InterActionObjectLine
//************************************************************

TYPEINIT1(B2dIAOTriangle, B2dIAObject);

B2dIAOTriangle::B2dIAOTriangle(B2dIAOManager* pMan, Point aEdge1, Point aEdge2, Point aEdge3, Color aCol)
:	B2dIAObject(pMan, aEdge1, aCol),
	a2ndPosition(GetGeomPositions(), aEdge2),
	a3rdPosition(GetGeomPositions(), aEdge3)
{
}

B2dIAOTriangle::~B2dIAOTriangle() 
{
}

void B2dIAOTriangle::CreateGeometry()
{
	Region aOverRegion = GetManager()->GetClipRegion();
	aOverRegion.Intersect(Region(GetBaseRect()));

	if(!aOverRegion.IsEmpty())
		AddTriangle(GetBasePositionPixel(), Get2ndPositionPixel(), Get3rdPositionPixel());
}

void B2dIAOTriangle::CreateBaseRect()
{
	INT32 nMinX = GetBasePositionPixel().X();
	INT32 nMaxX = nMinX;
	INT32 nMinY = GetBasePositionPixel().Y();
	INT32 nMaxY = nMinY;

	if(Get2ndPositionPixel().X() > nMaxX)
		nMaxX = Get2ndPositionPixel().X();
	if(Get2ndPositionPixel().X() < nMinX)
		nMinX = Get2ndPositionPixel().X();

	if(Get2ndPositionPixel().Y() > nMaxY)
		nMaxY = Get2ndPositionPixel().Y();
	if(Get2ndPositionPixel().Y() < nMinY)
		nMinY = Get2ndPositionPixel().Y();

	if(Get3rdPositionPixel().X() > nMaxX)
		nMaxX = Get3rdPositionPixel().X();
	if(Get3rdPositionPixel().X() < nMinX)
		nMinX = Get3rdPositionPixel().X();

	if(Get3rdPositionPixel().Y() > nMaxY)
		nMaxY = Get3rdPositionPixel().Y();
	if(Get3rdPositionPixel().Y() < nMinY)
		nMinY = Get3rdPositionPixel().Y();

	SetBaseRect(Rectangle(nMinX, nMinY, nMaxX, nMaxY));
}

void B2dIAOTriangle::Set2ndPosition(Point aNew) 
{ 
	if(aNew != a2ndPosition.GetPosition()) 
	{ 
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// save new position
		a2ndPosition.SetPosition(aNew); 
	}
}

void B2dIAOTriangle::Set3rdPosition(Point aNew) 
{ 
	if(aNew != a3rdPosition.GetPosition()) 
	{ 
		// throw away geometry
		GeometryChange(); 
		BaseRectChange();

		// save new position
		a3rdPosition.SetPosition(aNew); 
	}
}

BOOL B2dIAOTriangle::SimpleCrossTestCut(const Point& rPos, const Point& rStart, const Point& rEnd) const
{
    return (
		(((rStart.Y() <= rPos.Y()) && (rPos.Y() < rEnd.Y()))
		|| ((rEnd.Y() <= rPos.Y()) && (rPos.Y() < rStart.Y())))
		&& (rPos.X() < (rEnd.X() - rStart.X()) * (rPos.Y() - rStart.Y()) / (rEnd.Y() - rStart.Y()) + rStart.X()));
}

BOOL B2dIAOTriangle::IsHit(const Point& rPixelPos, UINT16 nTol) const
{
	if(B2dIAObject::IsHit(rPixelPos, nTol))
	{
		// i am outside
		BOOL bRetval(FALSE);

		// cut with line (GetBasePositionPixel(), Get3rdPositionPixel()) ?
		if(SimpleCrossTestCut(rPixelPos, GetBasePositionPixel(), Get3rdPositionPixel()))
			bRetval = !bRetval;

		// cut with line (Get2ndPositionPixel(), GetBasePositionPixel()) ?
		if(SimpleCrossTestCut(rPixelPos, Get2ndPositionPixel(), GetBasePositionPixel()))
			bRetval = !bRetval;

		// cut with line (Get3rdPositionPixel(), Get2ndPositionPixel()) ?
		if(SimpleCrossTestCut(rPixelPos, Get3rdPositionPixel(), Get2ndPositionPixel()))
			bRetval = !bRetval;

		return bRetval;
	}
	return FALSE;
}

//************************************************************
//   InterActionObjectBitmapTriangle
//************************************************************

TYPEINIT1(B2dIAOBitmapTriangle, B2dIAOTriangle);

B2dIAOBitmapTriangle::B2dIAOBitmapTriangle(B2dIAOManager* pMan, 
	Point aEdge1, Point aEdge2, Point aEdge3, Color aCol)
:	B2dIAOTriangle(pMan, aEdge1, aEdge2, aEdge3, aCol),
	aBmpEx(),
	aBmpWrite(NULL),
	aMaskWrite(NULL)
{
}

B2dIAOBitmapTriangle::~B2dIAOBitmapTriangle()
{
	if(aBmpWrite)
		delete aBmpWrite;
	aBmpWrite = NULL;

	if(aMaskWrite)
		delete aMaskWrite;
	aMaskWrite = NULL;

	aBmpEx = BitmapEx();
}

void B2dIAOBitmapTriangle::CreateGeometry()
{
	Region aOverRegion = GetManager()->GetClipRegion();
	aOverRegion.Intersect(Region(GetBaseRect()));

	if(!aOverRegion.IsEmpty())
	{
		// create bitmaps
		Bitmap aBmp(GetBaseRect().GetSize(), 24);
		Bitmap aMask(GetBaseRect().GetSize(), 1);

		// reset transparent mask
		Color aEraseCol(COL_WHITE);
		aMask.Erase(aEraseCol);

		// get write access
		aBmpWrite = aBmp.AcquireWriteAccess();
		DBG_ASSERT(aBmpWrite, "Got no bitmap write access to new created Bitmap!");
		aMaskWrite = aMask.AcquireWriteAccess();
		DBG_ASSERT(aMaskWrite, "Got no bitmap write access to new created Bitmap!");

		// remember TopLeft
		aTopLeft = GetBaseRect().TopLeft();

		// create object
		AddTriangle(GetBasePositionPixel(), Get2ndPositionPixel(), Get3rdPositionPixel());

		// throw away accesses
		delete aBmpWrite;
		aBmpWrite = NULL;
		delete aMaskWrite;
		aMaskWrite = NULL;

		// build real BmpEx
		aBmpEx = BitmapEx(aBmp, aMask);

		// add this bitmap
		AddBmpRef(aTopLeft, &aBmpEx);
	}
}

BOOL B2dIAOBitmapTriangle::AddTrianglePixel(const Point& rPos)
{
	INT32 nPosX = rPos.X() - aTopLeft.X();
	INT32 nPosY = rPos.Y() - aTopLeft.Y();

	aBmpWrite->SetPixel(nPosY, nPosX, GetBaseColor());
	BitmapColor aColBlack(BYTE(0));
	aMaskWrite->SetPixel(nPosY, nPosX, aColBlack);

	return TRUE;
}


