/*************************************************************************
 *
 *  $RCSfile: services.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _ADR_SERVICES_HXX
#define _ADR_SERVICES_HXX


#include <propset.hxx>
#include <stardiv/one/address/address.hxx>
#include <stardiv/one/schedule/schedule.hxx>


class OPropertySetPersistance
{
public:
	static void savePropertySet( 
		const XPropertySetRef& xProp, const XRegistryKeyRef& xKey );
	static void loadPropertySet( 
		const XPropertySetRef& xProp, const XRegistryKeyRef& xKey );
};

class OProxyFactory : 
	public OPropertySet, 
	public XSingleServiceFactory
{
public:
	SMART_UNO_DECLARATION( OProxyFactory, OPropertySet );
	OProxyFactory( 
		const XMultiServiceFactoryRef& xMgr, 
		const XSingleServiceFactoryRef& xFact );
	
	static void fillClassInfo(
		OObjectClassBase*& rpParentClass, 
		Sequence<OPropertyAccessor>& rProps );

	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );

    virtual XInterfaceRef createInstance(void) {
		return m_xFactory->createInstance(); }
    virtual XInterfaceRef createInstanceWithArguments(
		const Sequence< UsrAny >& aArguments) {
		return m_xFactory->createInstanceWithArguments( aArguments ); }
	
private:
	NAMESPACE_VOS( OMutex )       m_aMutex;
	XSingleServiceFactoryRef      m_xFactory;
};

class OServiceEnumeration : 
	public OEnumerationHelper< NAMESPACE_STD(vector)< XSingleServiceFactoryRef >::iterator >,
	public UsrObject
{
public:
	SMART_UNO_DECLARATION( OServiceEnumeration, UsrObject );
	OServiceEnumeration( const XMultiServiceFactoryRef& xSrv, const UString& rName );

	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
private:
	NAMESPACE_VOS( OMutex ) m_aMutex;
	NAMESPACE_STD(vector)< XSingleServiceFactoryRef > m_xServices;
};

class OMultiServiceFactory : 
	public XMultiServiceFactory, public XEnumerationAccess, 
	public XInitialization,	public UsrObject
{
public:
	static XInterfaceRef create( const XMultiServiceFactoryRef& xMgr ){
		return *new OMultiServiceFactory( xMgr ); }
	
	OMultiServiceFactory( const XMultiServiceFactoryRef& xMgr )
		: m_xMgr( xMgr ) {}
	SMART_UNO_DECLARATION( OMultiServiceFactory, UsrObject );
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	virtual void initialize( const Sequence<UsrAny>& rSeq ) THROWS( (IllegalArgumentException ) );

    virtual XInterfaceRef createInstance(
		const UString& aServiceSpecifier);
    virtual XInterfaceRef createInstanceWithArguments(
		const UString& ServiceSpecifier, const Sequence< UsrAny >& Arguments);
    virtual Sequence< UString > getAvailableServiceNames(void);


	virtual XEnumerationRef createEnumeration(void);

    virtual XIdlClassRef getElementType(void) const;
    virtual BOOL hasElements(void) const;
private:
	UString                 m_aServiceName;
	XMultiServiceFactoryRef m_xMgr;
};

#endif

