/*************************************************************************
 *
 *  $RCSfile: merging.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <merging.hxx>

XAddressBookJobFactorySupplierRef OAddressBookSourceMerging::getSource( 
	const UString& rName )
{
	XUniqueIDAccessRef xSources( m_xMgr->createInstance(
		L"com.sun.star.address.AddressBookSources" ), USR_QUERY );
	XAddressBookJobFactorySupplierRef xRef;
	TRY
	{
		extractInterface( xSources->getByUniqueID( rName ), xRef );
	}
	CATCH( NoSuchElementException, e )
	{
	}
	END_CATCH;
	return xRef;
}


Sequence<XAddressBookJobFactorySupplierRef> OAddressBookSourceMerging::getSources()
{
	OAddressBookSourceMergingData aData;
	{
		OGuard aGuard( m_aMutex );
		aData = *this;
	}
	XUniqueIDAccessRef xSources( m_xMgr->createInstance(
		L"com.sun.star.address.AddressBookSources" ), USR_QUERY );
	const UString* pFirst = aData.m_Sources.getConstArray();
	const UString* pLast = pFirst + aData.m_Sources.getLen();
	vector<XAddressBookJobFactorySupplierRef> aRet;
	for(; pFirst != pLast; pFirst++ )
	{
		TRY
		{
			XAddressBookJobFactorySupplierRef xRef;
			extractInterface( xSources->getByUniqueID( *pFirst ), xRef );
			if( xRef.is() ) aRet.push_back( xRef );
		}
		CATCH( NoSuchElementException, e )
		{
		}
		END_CATCH;
	}
	Sequence<XAddressBookJobFactorySupplierRef> aRetSeq;
	copyContainerToSequence( aRet, aRetSeq );
	return aRetSeq;
}

OAddressBookSourceMerging::OAddressBookSourceMerging(
	const XMultiServiceFactoryRef& xMgr ) :
	OPropertySet( 			
		m_aMutex, this,	
		OObjectClass<OAddressBookSourceMergingData>::getInstance(), false ),
	m_xMgr( xMgr )
{
	m_ServiceName = L"com.sun.star.address.AddressBookSourceMerging";
}

void OAddressBookSourceMergingData::fillClassInfo(
	OObjectClassBase*& rpParentClass, 
	Sequence<OPropertyAccessor>& rProps )
{
	static OPropertyAccessor aProps[] = 
	{
		ADR_PROPERTY( 
			OAddressBookSourceMergingData, Name, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSourceMergingData, ServiceName, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSourceMergingData, Sources, PropertyAttribute_BOUND )
	};
	rProps = Sequence<OPropertyAccessor>( 
		aProps, sizeof( aProps )/ sizeof( OPropertyAccessor ) );
	rpParentClass = &OObjectClass<OAddressBookSourceData>::getInstance();
}


XIdlClassRef OAddressBookSourceMerging::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OAddressBookSourceMerging", 
		OPropertySet::getStaticIdlClass(), 2,
		XAddressBookJobFactorySupplier_getReflection(),
		XJobFactory_getReflection()
		);
	return xClass;
}

BOOL OAddressBookSourceMerging::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XAddressBookJobFactorySupplier );
	QUERYIFACE( XJobFactory );
	return OPropertySet::queryInterface( aUik, rOut );
}

Sequence<XIdlClassRef>	OAddressBookSourceMerging::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

XJobFactoryRef OAddressBookSourceMerging::getJobFactory()
{
	if( !m_xJobFactory.is() )
	{
		UsrAny aAny;
		aAny <<= XJobFactoryRef( this );
		m_xJobFactory = XJobFactoryRef(
			m_xMgr->createInstanceWithArguments( 
				L"com.sun.star.address.SynchronAndAsynchronJobFactory",
				Sequence<UsrAny>( &aAny, 1 ) ), USR_QUERY );
	}
	return m_xJobFactory;
}

XInterfaceRef OAddressBookSourceMerging::createJob( 
	const UString& rType, const Sequence<UsrAny>& rArgs )
{
	if( rType == L"query" )
		return *new OAddressBookSourceMergingQueryJob(
			m_xMgr, this, rType, rArgs );
	else
		return *new OAddressBookSourceMergingSynchronJob(
			m_xMgr, this, rType, rArgs );
}

void OAddressBookSourceMerging::setFastPropertyValue_NoBroadcast( 
	INT32 nHandle, const UsrAny& rValue ) THROWS( (Exception) )
{
	OPropertySet::setFastPropertyValue_NoBroadcast( nHandle, rValue );
}

const XAddressBookRecordContainerRef& OAddressBookSourceMerging::getRecordContainer()
{
	if( !m_xRecordContainer.is() )
	{
		UsrAny aAny;
		aAny <<= XAddressBookJobFactorySupplierRef( this );
		m_xRecordContainer = XAddressBookRecordContainerRef(
			m_xMgr->createInstanceWithArguments( 
				L"com.sun.star.address.AddressBookSourceAccess",
				Sequence<UsrAny>( &aAny, 1 ) ), USR_QUERY );
	}
	return m_xRecordContainer;
}

void OAddressBookSourceMerging::substituteUid( 
	Sequence<AddressBookParameteredPropertyValue>& rValues, const UString& rSource, 
	BOOL bUpwards )
{
	AddressBookParameteredPropertyValue* pFirst = rValues.getArray();
	AddressBookParameteredPropertyValue* pLast = pFirst + rValues.getLen();
	UString aUid;
	UString aBasisUid;
	UString aSource;
	for( ; pFirst != pLast; pFirst++ )
		if( pFirst->Name == L"Uid" )
		{
			AddressBookParameteredValue* pFirstValue = pFirst->Values.getArray();
			AddressBookParameteredValue* pLastValue = 
				pFirstValue + pFirst->Values.getLen();
			for( ; pFirstValue != pLastValue; pFirstValue++ )
			{
				if( pFirstValue->Value >>= aUid )
				{
					if( bUpwards )
						pFirstValue->Value <<= 
							OAddressBookSources::schemaAndBasisUidToUid(
								rSource, aUid );
					else
					{
						OAddressBookSources::uidToSchemaAndBasisUid(
							aUid, aSource, aBasisUid );
						pFirstValue->Value <<= aBasisUid;
					}
				}
			}
		}
}



//////////////////////////////////////////////////////////

OAddressBookSourceMergingSynchronJob::OAddressBookSourceMergingSynchronJob( 
	const XMultiServiceFactoryRef& xMgr, 
	const OAddressBookSourceMergingRef& xSource, 
	const UString& rType, const Sequence<UsrAny>& rArgs )
	: m_xMgr( xMgr ), m_xSource( xSource ), m_aArgs( rArgs ), m_aType( rType )
{
}

XIdlClassRef OAddressBookSourceMergingSynchronJob::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OAddressBookSourceMergingSynchronJob", 
		UsrObject::getUsrObjectIdlClass(), 2,
		XCancellable_getReflection(),
		XSynchronJob_getReflection() );
	return xClass;
}

Sequence<XIdlClassRef>	OAddressBookSourceMergingSynchronJob::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookSourceMergingSynchronJob::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XJob );
	QUERYIFACE( XSynchronJob );
	QUERYIFACE( XCancellable );
	return UsrObject::queryInterface( aUik, rOut );
}

UsrAny OAddressBookSourceMergingSynchronJob::executeSynchron( )
{
	const UsrAny* pArr = m_aArgs.getConstArray();
	if( m_aType == L"getSchemata" )
	{
		Sequence<XAddressBookJobFactorySupplierRef> aSources = 
			m_xSource->getSources();
		const XAddressBookJobFactorySupplierRef* pFirst = aSources.getConstArray();
		const XAddressBookJobFactorySupplierRef* pEnd = pFirst + aSources.getLen();
		Sequence<Sequence<PropertyValue> > aResult;
		for(; pFirst != pEnd; pFirst++ )
		{
			XJobFactoryRef xFact = (*pFirst)->getJobFactory();
			XPropertySetRef xProp( (*pFirst), USR_QUERY );
			UString aSource;
			xProp->getPropertyValue( L"Uid" ) >>= aSource;
			
			XSynchronJobRef xJob( xFact->createJob( 
				m_aType, Sequence<UsrAny>() ), USR_QUERY );
			Sequence<Sequence<PropertyValue> > aSchemata;
			if( !(xJob->executeSynchron() >>= aSchemata ) )
				THROW( RuntimeException() );

			// prefix schema names
			Sequence<PropertyValue >* pSchemata = aSchemata.getArray();
			Sequence<PropertyValue >* pEnd = pSchemata + aSchemata.getLen();
			for(; pSchemata != pEnd; pSchemata++ )
			{
				PropertyValue* pFirstValue = pSchemata->getArray();
				PropertyValue* pLastValue = pFirstValue + pSchemata->getLen();
				for(; pFirstValue != pLastValue; pFirstValue++ )
					if( pFirstValue->Name == L"Name" )
					{
						UString aName;
						pFirstValue->Value >>= aName;
						pFirstValue->Value <<= 
							OAddressBookSources::schemaAndBasisUidToUid(
								aSource, aName );
					}
			}
			
			INT32 nLen = aResult.getLen();
			aResult.realloc( nLen + aSchemata.getLen() );
			copy( aSchemata.getConstArray(), 
				  aSchemata.getConstArray() + aSchemata.getLen(),
				  aResult.getArray() + nLen );
		}
		UsrAny aResultAny;
		aResultAny <<= aResult;
		return aResultAny;
	}
	else if( m_aType == L"removeRecord" )
	{
		UString aUid;
		if( m_aArgs.getLen() != 1 || !( pArr[ 0 ] >>= aUid ))
			THROW( IllegalArgumentException() );
		UString aSource, aBasisUid;
		if( !OAddressBookSources::uidToSchemaAndBasisUid(
			aUid, aSource, aBasisUid ) ) THROW( IllegalArgumentException() );
		Sequence<UsrAny> aSeq( m_aArgs );
		aSeq.getArray()[ 0 ] <<= aBasisUid;
		XAddressBookJobFactorySupplierRef xSup = m_xSource->getSource(
			aSource );
		if( !xSup.is() ) THROW( IllegalArgumentException() );
		XSynchronJobRef xJob(
			xSup->getJobFactory()->createJob( m_aType, aSeq ), USR_QUERY );
		return xJob->executeSynchron();
	}
	else if( m_aType == L"insertRecord" )
	{
		UString aSchema;
		Sequence<AddressBookParameteredPropertyValue> aValues;
		if( m_aArgs.getLen() != 2 || !( pArr[ 0 ] >>= aSchema ) ||
			!(pArr[ 1 ] >>= aValues ))
			THROW( IllegalArgumentException() );
		UString aBasisSchema;
		UString aSource;
		if( !OAddressBookSources::uidToSchemaAndBasisUid(
			aSchema, aSource, aBasisSchema ) )
			THROW( IllegalArgumentException() );
		OAddressBookSourceMerging::substituteUid(
			aValues, aSource, FALSE );
		XAddressBookJobFactorySupplierRef xSup = m_xSource->getSource( aSource );
		if( !xSup.is() ) THROW( IllegalArgumentException() );
		Sequence<UsrAny> aSeq( m_aArgs );
		UsrAny* pNewArgs = aSeq.getArray();
		pNewArgs[ 0 ] <<= aBasisSchema;
		pNewArgs[ 1 ] <<= aValues;
		
		XSynchronJobRef xJob(
			xSup->getJobFactory()->createJob( m_aType, aSeq ), USR_QUERY );
		return xJob->executeSynchron();
	}
	else if( m_aType == L"updateRecord" )
	{
		UString aUid;
		Sequence<AddressBookParameteredPropertyValue> aValues;
		if( m_aArgs.getLen() != 2 || !( pArr[ 0 ] >>= aUid ) ||
			!(pArr[ 1 ] >>= aValues ))
			THROW( IllegalArgumentException() );
		UString aSource;
		UString aBasisUid;
		if( !OAddressBookSources::uidToSchemaAndBasisUid(
			aUid, aSource, aBasisUid ) )
			THROW( IllegalArgumentException() );
		OAddressBookSourceMerging::substituteUid(
			aValues, aSource, FALSE );
		XAddressBookJobFactorySupplierRef xSup = m_xSource->getSource( aSource );
		if( !xSup.is() ) THROW( IllegalArgumentException() );
		Sequence<UsrAny> aSeq( m_aArgs );
		UsrAny* pNewArgs = aSeq.getArray();
		pNewArgs[ 0 ] <<= aBasisUid;
		pNewArgs[ 1 ] <<= aValues;
		
		XSynchronJobRef xJob(
			xSup->getJobFactory()->createJob( m_aType, aSeq ), USR_QUERY );
		return xJob->executeSynchron();
	}
	else if( m_aType == L"createUids" )
	{
		UString aSchema;
		INT16 nCount;
		if( m_aArgs.getLen() != 2 || !( pArr[ 0 ] >>= aSchema ))
			THROW( IllegalArgumentException() );
		nCount = OPropertyTypeConversion::toINT32( pArr[ 1 ] );
		UString aSource;
		UString aBasisSchema;
		if( !OAddressBookSources::uidToSchemaAndBasisUid(
			aSchema, aSource, aBasisSchema ) )
			THROW( IllegalArgumentException() );

		XAddressBookJobFactorySupplierRef xSup = m_xSource->getSource( aSource );
		if( !xSup.is() ) THROW( IllegalArgumentException() );
		Sequence<UsrAny> aSeq( m_aArgs );
		UsrAny* pNewArgs = aSeq.getArray();
		pNewArgs[ 0 ] <<= aBasisSchema;
		
		XSynchronJobRef xJob(
			xSup->getJobFactory()->createJob( m_aType, aSeq ), USR_QUERY );
		UsrAny aResult = xJob->executeSynchron();
		Sequence<UString> aUids;
		aResult >>= aUids;
		UString* pUids = aUids.getArray();
		for( INT32 nCur = aUids.getLen(); nCur--; )
			pUids[ nCur ] = OAddressBookSources::schemaAndBasisUidToUid( 
				aSource, pUids[ nCur ] );
		return makeAny( aUids );
	}
	else if( m_aType == L"getProperties" )
	{
		UsrAny aAny;
		aAny <<= Sequence<PropertyValue>();
		return aAny;
	}
	THROW( IllegalArgumentException() );
	return UsrAny();
}

//////////////////////////////////////////////////////////

OAddressBookSourceMergingQueryJob::
		OAddressBookSourceMergingQueryJob( 
	const XMultiServiceFactoryRef& xMgr, 
	const OAddressBookSourceMergingRef& xSource, 
	const UString& rType, const Sequence<UsrAny>& rArgs )
	: m_xMgr( xMgr ), m_xSource( xSource ), m_aArgs( rArgs ), m_aType( rType )
{
}

XIdlClassRef OAddressBookSourceMergingQueryJob::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"com.sun.star.address.OAddressBookSourceMergingQueryJob", 
		UsrObject::getUsrObjectIdlClass(), 2,
		XCancellable_getReflection(),
		XAsynchronJob_getReflection() );
	return xClass;
}

Sequence<XIdlClassRef>	OAddressBookSourceMergingQueryJob::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookSourceMergingQueryJob::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XJob );
	QUERYIFACE( XAsynchronJob );
	QUERYIFACE( XCancellable );
	return UsrObject::queryInterface( aUik, rOut );
}

void OAddressBookSourceMergingQueryJob::cutParentUidPart( 
	AddressBookQueryTerm& rTerm )
{
	switch( rTerm.Function )
	{
		case AddressBookQueryFunction_OR:
		case AddressBookQueryFunction_AND:
		case AddressBookQueryFunction_NOT:
		{
			UsrAny* pFirst = rTerm.Arguments.getArray();
			UsrAny* pLast =  pFirst + rTerm.Arguments.getLen();
			for( ; pFirst != pLast; pFirst++ )
			{
				if( pFirst->getReflection() != AddressBookQueryTerm_getReflection() )
					THROW( IllegalArgumentException() );
				cutParentUidPart( *(AddressBookQueryTerm*) pFirst->get() );
			}
			break;
		}
		case AddressBookQueryFunction_EQUALITYMATCH:
		{
			if( rTerm.Arguments.getLen() != 2) THROW( IllegalArgumentException() );
			UString aField;
			UString aValue;
			const UsrAny* pAny = rTerm.Arguments.getConstArray();
			pAny[ 0 ] >>= aField;
			if( aField != L"Uid" ) return;
			rTerm.Arguments.getConstArray()[ 1 ] >>= aValue;
			UString aSource, aBasisUid;
			OAddressBookSources::uidToSchemaAndBasisUid( aValue, aSource, aBasisUid );
			rTerm.Arguments.getArray()[ 1 ] <<= aBasisUid;
			break;
		}
	}
}


void OAddressBookSourceMergingQueryJob::executeQueries( 
	const UString& rSource, const vector<UString>& rBasisSchemata, 
	const UString& rQuery, const Sequence<AddressBookSortInfo>& rSorting, 
	const Sequence<UString>& rProperties )
{
	Sequence<UString> aSchemaSeq;
	copyContainerToSequence( rBasisSchemata, aSchemaSeq );
	UString aQuery = rQuery;
	if( rQuery.len() )
	{
		XAddressBookQueryParserRef xParser(
			m_xMgr->createInstance( L"com.sun.star.address.AddressBookQueryParser" ),
			USR_QUERY );
		AddressBookQueryTerm aTerm = xParser->parseTerm( rQuery );
		cutParentUidPart( aTerm );
		XAddressBookQueryWriterRef xWriter( xParser, USR_QUERY );
		aQuery= xWriter->writeTerm( aTerm );
	}
	XAddressBookJobFactorySupplierRef xSource = m_xSource->getSource(
		rSource );
	if( xSource.is() )
	{
		Sequence<UsrAny> aArgs( 4 );
		UsrAny* pArgs = aArgs.getArray();
		pArgs[ 0 ] <<= rProperties;
		pArgs[ 1 ] <<= aQuery;
		pArgs[ 2 ] <<= rSorting;
		pArgs[ 3 ] <<= aSchemaSeq;
		XAsynchronJobRef xJob( xSource->getJobFactory()->createJob(
			L"query", aArgs ), USR_QUERY );
		OAddressBookMergingSubJobData* pData = new OAddressBookMergingSubJobData(
			rSource, m_aSorting );
		m_aResultSets[ xJob ] = pData;
	}
}
				
void OAddressBookSourceMergingQueryJob::cancel()
{
	OXInterfaceResultSetHashMap aCancelMap;
	{
		OGuard aGuard( m_aMutex );
		aCancelMap = m_aResultSets;
	}
	for( OXInterfaceResultSetHashMap::iterator aCur = aCancelMap.begin();
		 aCur != aCancelMap.end(); aCur++ )
	{
		XCancellableRef xCancel( (*aCur).first, USR_QUERY );
		if( xCancel.is() ) xCancel->cancel();
	}
}

void OAddressBookSourceMergingQueryJob::feedListener(  )
{
	OClearableGuard aGuard( m_aMutex );
	if( !m_aSorting.getLen() ) return;
	list<ORecord> aRecs;
	// we can surely notify the smallest if all other queues are either done
	// or have a greater front. So find the smallest one returning on every
	// waiting queue
	while( TRUE )
	{
		list<ORecord>* pSmallest = 0;
		for( OXInterfaceResultSetHashMap::iterator aCur = m_aResultSets.begin();
			 aCur != m_aResultSets.end(); aCur++ )
		{
			list<ORecord>::iterator aCurFront = 
				(*aCur).second->m_aResultSet.getRecords().begin();
			
			// this queue is empty and pending, so break
			BOOL bEmpty = aCurFront == (*aCur).second->m_aResultSet.getRecords().end();
			if( bEmpty && !(*aCur).second->m_bDone ) 
			{
				pSmallest = 0;
				break;
			}
			
			if( !bEmpty && (!pSmallest || (*aCurFront).operator<(
				pSmallest->front() )))
				pSmallest = &(*aCur).second->m_aResultSet.getRecords();
		}
		if( !pSmallest ) break;
		else 
		{
			aRecs.push_back( pSmallest->front() );
			pSmallest->pop_front();
		}
	}
	
	if( !aRecs.size() ) return;
	
	XJobListenerRef xListener = m_xCallback;
	aGuard.clear();
	
	JobEvent aEvent;
	aEvent.Source = *this;
	aEvent.Type = JobEventType_DATA;
	for( list<ORecord>::iterator aIter = aRecs.begin();
		 aIter != aRecs.end(); aIter++ )
	{
		aEvent.Data <<= OObjectClass<ORecord>::getInstance().getPropertyValues(
			&*aIter );
		xListener->updateJobState( aEvent );
	}
}


void OAddressBookSourceMergingQueryJob::updateJobState( const JobEvent& rEvent )
{
	switch( rEvent.Type )
	{
		case JobEventType_ERROR:
		{
			JobEvent aEvent( rEvent );
			aEvent.Source = *this;
			m_xCallback->updateJobState( aEvent );
			break;
		}
		case JobEventType_DONE:
		{
			OClearableGuard aGuard( m_aMutex );
			XAsynchronJobRef xJob( rEvent.Source, USR_QUERY );
			m_aResultSets[ xJob ]->m_bDone = TRUE;
			for( OXInterfaceResultSetHashMap::iterator aIter = 
					 m_aResultSets.begin();
				 aIter != m_aResultSets.end(); aIter++ )
				if( !(*aIter).second->m_bDone ) break;
			if( aIter == m_aResultSets.end() )
			{
				aGuard.clear();
				
				feedListener();
				JobEvent aEvent( rEvent );
				aEvent.Source = *this;
				m_xCallback->updateJobState( aEvent );

				for( OXInterfaceResultSetHashMap::iterator aIter = 
						 m_aResultSets.begin();
					 aIter != m_aResultSets.end(); aIter++ )
					delete (*aIter).second;
				m_aResultSets = OXInterfaceResultSetHashMap();
			}
			break;
		}
		case JobEventType_DATA:
		{
			OClearableGuard aGuard( m_aMutex );
			Sequence<PropertyValue> aValues;
			if( rEvent.Data >>= aValues )
			{
				ORecord aRecord;
				OObjectClass<ORecord>::getInstance().setPropertyValues(
					&aRecord, aValues );

				XAsynchronJobRef xJob( rEvent.Source, USR_QUERY );
				OAddressBookMergingSubJobData* pData = m_aResultSets[ xJob ];

				aRecord.m_SchemaName = OAddressBookSources::schemaAndBasisUidToUid(
					pData->m_aSchema, aRecord.m_SchemaName );
				aRecord.m_Uid = OAddressBookSources::schemaAndBasisUidToUid(
					pData->m_aSchema, aRecord.m_Uid );
				OAddressBookSourceMerging::substituteUid(
					aRecord.m_Values, pData->m_aSchema, TRUE );
				
				if( !m_aSorting.getLen() )
				{
					JobEvent aEvent( rEvent );
					aEvent.Source = *this;
					aEvent.Data <<= OObjectClass<ORecord>::getInstance().
						getPropertyValues( &aRecord );
					aGuard.clear();
					m_xCallback->updateJobState( aEvent );
				}
				else
				{
					pData->m_aResultSet.appendRecord( aRecord );
					aGuard.clear();
					feedListener();
				}
			}
			break;
		}
	}
}

void OAddressBookSourceMergingQueryJob::executeAsynchron( 
	const XJobListenerRef& xCallback )
{
	OClearableGuard aGuard( m_aMutex );
	m_xCallback = xCallback;
	if( m_aType == L"query" )
	{
		Sequence<UString> aProperties;
		UString aQuery;
		Sequence<UString> aSchemata;
		const UsrAny* pArgs = m_aArgs.getConstArray();
		if( !(pArgs[ 0 ] >>= aProperties ) ||
			!(pArgs[ 1 ] >>= aQuery ) ||
			!(pArgs[ 2 ] >>= m_aSorting ) ||
			!(pArgs[ 3 ] >>= aSchemata ) )
			THROW( IllegalArgumentException() );
		
		if( !aSchemata.getLen() ) 
		{
			XAddressBookSchemataSupplierRef xSup(
				m_xSource->getRecordContainer(), USR_QUERY );
			aSchemata = xSup->getSchemata()->getElementNames();
		}

		sort( aSchemata.getArray(), 
			  aSchemata.getArray() + aSchemata.getLen(), UStringEqual() );

		UString aLastSource;
		const UString* pSchema = aSchemata.getConstArray();
		const UString* pLastSchema = pSchema + aSchemata.getLen();
		vector<UString> aBasisSchemata;
		UString aSource;
		for( ; pSchema != pLastSchema; pSchema++ )
		{
			UString aBasisSchema;
			OAddressBookSources::uidToSchemaAndBasisUid( 
				*pSchema, aSource, aBasisSchema );
			if( aLastSource.len() && aSource != aLastSource )
			{
				executeQueries( 
					aLastSource, aBasisSchemata, aQuery, m_aSorting, aProperties );
				aBasisSchemata = vector<UString>();
			}
			aBasisSchemata.push_back( aBasisSchema );
			aLastSource = aSource;
		}
		executeQueries( 
			aLastSource, aBasisSchemata, aQuery, m_aSorting, aProperties );
		
		OXInterfaceResultSetHashMap aMap = m_aResultSets;
		aGuard.clear();
		for( OXInterfaceResultSetHashMap::const_iterator aIter = aMap.begin();
			 aIter != aMap.end(); aIter++ )
			(*aIter).first->executeAsynchron( this );
		return;
	}
}

