/*************************************************************************
 *
 *  $RCSfile: wrapper.cxx,v $
 *
 *  $Revision: 1.6.72.4 $
 *
 *  last change: $Author: vg $ $Date: 2005/06/09 13:23:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "wrapper.hxx"

#include <offmgr/app.hxx>
#include <sw/swdll.hxx>
#include <sc/scdll.hxx>
#include <sd/sddll.hxx>
#include <sch/schdll.hxx>
#include <starmath/smdll.hxx>
#include <svx/svdetc.hxx>
#include <osl/mutex.hxx>
#include <cppuhelper/factory.hxx>
#include <sfx2/docfac.hxx>
#include <sfx2/docfilt.hxx>
#include <sfx2/fcontnr.hxx>
#include <sfx2/app.hxx>
#include <sfx2/imagemgr.hxx>
#include <sfx2/accelinfo.hxx>
#include <sfx2/event.hxx>
#include <sfx2/sfx.hrc>
#include <framework/imageproducer.hxx>
#include <framework/acceleratorinfo.hxx>
#include <unotools/configmgr.hxx>
#include <unotools/processfactory.hxx>
#ifndef INCLUDED_SVTOOLS_MODULEOPTIONS_HXX
#include <svtools/moduleoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_HELPOPT_HXX
#include <svtools/helpopt.hxx>
#endif

#include <rtl/logfile.hxx>

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::registry;

#define DEFINE_CONST_UNICODE(CONSTASCII)        UniString(RTL_CONSTASCII_USTRINGPARAM(CONSTASCII##))

static SwDLL*			pSwDLL=0;
static SdDLL*			pSdDLL=0;
static ScDLL*			pScDLL=0;
static SchDLL*			pSchDLL=0;
static SimDLL*			pSimDLL=0;
static SmDLL*			pSmDLL=0;
static OfficeWrapper*	pOfficeWrapper=0;

SFX_IMPL_XSERVICEINFO( OfficeWrapper, "com.sun.star.office.OfficeWrapper", "com.sun.star.comp.desktop.OfficeWrapper" )

Reference< XInterface >  SAL_CALL OfficeWrapper_CreateInstance( const Reference< XMultiServiceFactory >  & rSMgr )
{
	static osl::Mutex	aMutex;

	if ( pOfficeWrapper == 0 )
	{
		osl::MutexGuard guard( aMutex );
		if ( pOfficeWrapper == 0 )
		{
			pOfficeWrapper = new OfficeWrapper( rSMgr );
			return (XComponent*) pOfficeWrapper;
		}
	}

	return (XComponent*)0;
}

OfficeWrapper::OfficeWrapper( const Reference < XMultiServiceFactory >& xFactory )
    : aListeners( aMutex )
    , pApp( 0 )
	, pSfxHelp( 0 )
	, bDisposed( FALSE )
    , bInitialized( FALSE )
{
}

void SAL_CALL OfficeWrapper::initialize( const Sequence< Any >& aArguments ) throw( Exception )
{
    // arguments
    // 1: description (no longer used)
    // 2: splashscreen
    if (bInitialized)
        return;
    bInitialized = TRUE;

	// Help instance it must be destroyed before Deinit (sends AppEvent in DTOR)
	pSfxHelp = new SfxHelp;

    if (pApp == 0)
    {
    	rtl::OUString aDescription;
	    if ( aArguments.getLength() > 0 )
		    aArguments[0] >>= aDescription;
        if ( aArguments.getLength() > 1 )
            aArguments[1] >>= m_rSplashScreen;

        pApp = new OfficeApplication();
	    RTL_LOGFILE_CONTEXT(aLog, "desktop (lo119109) OfficeWrapper::OfficeWrapper");
        if(m_rSplashScreen.is()) m_rSplashScreen->setValue(55);

	    SvtModuleOptions aMOpt;
        //    if ( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SWRITER ) )
        {
            pSwDLL  = new SwDLL;
		    SwDLL::LibInit();
        }
        if (   aMOpt.IsModuleInstalled( SvtModuleOptions::E_SDRAW ) 
            || aMOpt.IsModuleInstalled( SvtModuleOptions::E_SIMPRESS ) )
        {
            pSdDLL  = new SdDLL;
		    SdDLL::LibInit();
        }
        if ( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SCALC ) )
        {
            pScDLL  = new ScDLL;
		    ScDLL::LibInit();
        }
        if ( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SCHART ) )
	    {
            pSchDLL = new SchDLL;
		    SchDLL::LibInit();
	    }
        if ( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SMATH ) )
	    {
            pSmDLL = new SmDLL;
		    SmDLL::LibInit();
	    }
        if(m_rSplashScreen.is()) m_rSplashScreen->setValue(60);


        // initialize framework
	    ::framework::SetImageProducer( GetImage );
	    ::framework::SetCommandURLFromKeyCode( GetCommandURLFromKeyCode );

        // initialize help
        pSfxHelp = new SfxHelp;
        // Help instance it must be destroyed before 
        // Deinit (sends AppEvent in DTOR)    
	    Application::SetHelp( pSfxHelp );
	    if ( SvtHelpOptions().IsExtendedHelp() ) Help::EnableBalloonHelp();
    	else Help::DisableBalloonHelp();

	    if ( SvtHelpOptions().IsHelpTips() ) Help::EnableQuickHelp();
    	else Help::DisableQuickHelp();

        // notify sfx
    	pApp->NotifyEvent(SfxEventHint(SFX_EVENT_STARTAPP), sal_False);
    }
}

OfficeWrapper::~OfficeWrapper()
{
}

void SAL_CALL OfficeWrapper::dispose() throw ( RuntimeException )
{
	if ( bDisposed )
		return;

	bDisposed = TRUE;
	RTL_LOGFILE_CONTEXT( aLog, "desktop (lo) ::OfficeWrapper::dispose" );
    EventObject aObject;
    aObject.Source = (XComponent*)this;
    aListeners.disposeAndClear( aObject );

    
    // make sure that we don't try to destroy the modules if creation of pApp
    // was interrupted by exception (Module-Ptrs will be NULL still and at least ScDLL::PreExit() crashes) 
    if ( bInitialized && pApp )
    {
        // all ConfigItems must be destroyed before destroying the SfxApp
        delete pSfxHelp;
        pSfxHelp = NULL;
        
        SvtModuleOptions aMOpt;
        
        if ( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SCHART ) && pSchDLL )
        {
            SchDLL::LibExit();
            DELETEZ( pSchDLL );
        }
        if ( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SMATH ) && pSmDLL )
        {
            SmDLL::LibExit();
            DELETEZ( pSmDLL );
        }
        if ( pSwDLL )
        {
            SwDLL::LibExit();
            DELETEZ( pSwDLL );
        }
        if (( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SDRAW ) || aMOpt.IsModuleInstalled( SvtModuleOptions::E_SIMPRESS ) ) &&
                  pSdDLL )
        {
            SdDLL::LibExit();
            DELETEZ( pSdDLL );
        }
        if ( aMOpt.IsModuleInstalled( SvtModuleOptions::E_SCALC ) && pScDLL )
        {
            ScDLL::PreExit();           // der Teil vom Exit der noch Svx etc. braucht
            ScDLL::LibExit();
            DELETEZ( pScDLL );
        }
    }
    
    delete pApp;
    delete &GetSdrGlobalData(); // ??????????
}

void SAL_CALL OfficeWrapper::addEventListener( const Reference< XEventListener > & aListener) throw ( RuntimeException )
{
    aListeners.addInterface( aListener );
}

void SAL_CALL OfficeWrapper::removeEventListener( const Reference< XEventListener > & aListener ) throw ( RuntimeException )
{
    aListeners.removeInterface( aListener );
}

extern "C"
{

void SAL_CALL component_getImplementationEnvironment(	const	sal_Char**			ppEnvironmentTypeName	,
																uno_Environment**	ppEnvironment			)
{
	*ppEnvironmentTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME ;
}

sal_Bool SAL_CALL component_writeInfo(  void*   pServiceManager , void*   pRegistryKey    )
{
    Reference< XMultiServiceFactory >  xMan( reinterpret_cast< XMultiServiceFactory* >( pServiceManager ) ) ;
//    ::utl::setProcessServiceFactory( xMan );
    Reference< XRegistryKey > xKey( reinterpret_cast< XRegistryKey* >( pRegistryKey ) ) ;

    // Eigentliche Implementierung und ihre Services registrieren
    ::rtl::OUString aTempStr;

    ::rtl::OUString aImpl( RTL_CONSTASCII_USTRINGPARAM("/") );
    aImpl += OfficeWrapper::impl_getStaticImplementationName();
    aImpl += ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("/UNO/SERVICES"));
    Reference< XRegistryKey > xNewKey = xKey->createKey( aImpl );
    xNewKey->createKey( ::rtl::OUString::createFromAscii("com.sun.star.office.OfficeWrapper") );

	return sal_True;
}

void* SAL_CALL component_getFactory(	const	sal_Char*	pImplementationName	,
												void*		pServiceManager		,
												void*		pRegistryKey		)
{
	// Set default return value for this operation - if it failed.
	void* pReturn = NULL ;
    if  ( pImplementationName && pServiceManager )
	{
		// Define variables which are used in following macros.
        Reference< XSingleServiceFactory >   xFactory                                             ;
        Reference< XMultiServiceFactory >    xServiceManager( reinterpret_cast< XMultiServiceFactory* >( pServiceManager ) ) ;

        if ( OfficeWrapper::impl_getStaticImplementationName().compareToAscii( pImplementationName ) == COMPARE_EQUAL )
        {
			xFactory = Reference< XSingleServiceFactory >( cppu::createOneInstanceFactory( xServiceManager, OfficeWrapper::impl_getStaticImplementationName(),
																OfficeWrapper_CreateInstance, OfficeWrapper::impl_getStaticSupportedServiceNames() ) );
        }

		// Factory is valid - service was found.
		if ( xFactory.is() )
		{
			xFactory->acquire();
			pReturn = xFactory.get();
		}
	}

	// Return with result of this operation.
	return pReturn ;
}

} // extern "C"
