/*************************************************************************
 *
 *  $RCSfile: javainteractionhandler.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: cd $ $Date: 2002/09/20 08:01:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DESKTOP_JAVAINTERACTION_HXX_
#include "javainteractionhandler.hxx"
#endif

#ifndef _DESKTOP_RESID_HXX_
#include "desktopresid.hxx"
#endif

#ifndef _DESKTOP_HRC_
#include "desktop.hrc"
#endif

#ifndef _DESK_APP_HXX
#include "app.hxx"
#endif

#include <com/sun/star/task/XInteractionContinuation.hpp>
#include <com/sun/star/task/XInteractionAbort.hpp>
#include <com/sun/star/task/XInteractionRetry.hpp>
#include <com/sun/star/java/JavaNotConfiguredException.hpp>
#include <com/sun/star/java/MissingJavaRuntimeException.hpp>
#include <com/sun/star/java/JavaDisabledException.hpp>
#include <com/sun/star/java/JavaVMCreationFailureException.hpp>

#include <cppuhelper/implbase1.hxx>
#include <uno/current_context.hxx>

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _VOS_PROCESS_HXX_
#include <vos/process.hxx>
#endif

#ifndef _SVTOOLS_JAVAPTIONS_HXX
#include <svtools/javaoptions.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#include <tools/string.hxx>

using namespace rtl;
using namespace com::sun::star::uno;
using namespace com::sun::star::task;

namespace desktop
{

JavaInteractionHandler::JavaInteractionHandler()
{
}

JavaInteractionHandler::~JavaInteractionHandler()
{
}

sal_Bool JavaInteractionHandler::StartJavaLDX( const OUString& aParameter )
{
#ifdef UNIX
	// JavaLDX must be located in the same directory
	// as the Office executable.
    OUString aProgName;
	OUString aSysPathFileName;
	OUString aDir;

	::vos::OStartupInfo aInfo;
    aInfo.getExecutableFile( aProgName );

	sal_uInt32 	lastIndex = aProgName.lastIndexOf('/');
	if ( lastIndex > 0 )
	{
		aProgName	= aProgName.copy( 0, lastIndex+1 );
		aDir		= aProgName;

		aProgName	+= OUString( RTL_CONSTASCII_USTRINGPARAM( "javaldx" ));
	}

	OUString			aArgListArray[1];
	vos::OSecurity		aSecurity;
	vos::OEnvironment	aEnv;

	aArgListArray[0] = aParameter;
	vos::OArgumentList aArgumentList( aArgListArray, 1 );

	vos::OProcess	aProcess( aProgName, aDir );
	vos::OProcess::TProcessError aProcessError =
		aProcess.execute( vos::OProcess::TOption_Detached,
						  aSecurity,
						  aArgumentList,
						  aEnv );

	if ( aProcessError != vos::OProcess::E_None )
	{
		WarningBox aWarningBox( NULL, DesktopResId( WARNINGBOX_JAVALDXNOTSTARTED ));
		String aTitle = String( DesktopResId( STR_WARNING_CANNOTSTARTJAVALDX ));
        aWarningBox.SetText( aTitle );
		aWarningBox.Execute();
		return sal_False;
	}

	aProcess.join();
#endif
	return sal_True;
}

sal_Bool JavaInteractionHandler::StartJavaSetup( const OUString& aParameter )
{
	// JVMSetup must be located in the same directory
	// as the Office executable.
    OUString	aProgName;
	OUString	aSysPathFileName;
	OUString	aDir;
	sal_Bool	bReturn = sal_True;

	::vos::OStartupInfo aInfo;
    aInfo.getExecutableFile( aProgName );

	sal_uInt32 	lastIndex = aProgName.lastIndexOf('/');
	if ( lastIndex > 0 )
	{
		aProgName	= aProgName.copy( 0, lastIndex+1 );
		aDir		= aProgName;

		aProgName	+= OUString( RTL_CONSTASCII_USTRINGPARAM( "jvmsetup" ));
#ifdef WNT
		aProgName	+= OUString( RTL_CONSTASCII_USTRINGPARAM( ".exe" ));
#endif
	}

	OUString			aArgListArray[1];
	vos::OSecurity		aSecurity;
	vos::OEnvironment	aEnv;

	aArgListArray[0] = aParameter;
	vos::OArgumentList aArgumentList( aArgListArray, 1 );

	vos::OProcess	aProcess( aProgName, aDir );
	vos::OProcess::TProcessError aProcessError =
		aProcess.execute( vos::OProcess::TOption_Detached,
						  aSecurity,
						  aArgumentList,
						  aEnv );

	if ( aProcessError != vos::OProcess::E_None )
	{
		WarningBox aWarningBox( NULL, DesktopResId( WARNINGBOX_JVMSETUPNOTSTARTED ));
		String aTitle = String( DesktopResId( STR_WARNING_CANNOTSTARTJVMSETUP ));
        aWarningBox.SetText( aTitle );
		aWarningBox.Execute();
		return sal_False;
	}

	// Wait for process. This can lead to a non-responding Office if this is called from
	// the main thread as there would be no message loop to process messages!!
	aProcess.join();

	// Start JavaLDX application to set the links under Unix to solve problem with LD_LIBRARY_PATH
#ifdef UNIX
	OUString aLDXParam( RTL_CONSTASCII_USTRINGPARAM( "--use-links" ));
	bReturn = StartJavaLDX( aLDXParam );
#endif
	return bReturn;
}

void SAL_CALL JavaInteractionHandler::handle( const Reference< XInteractionRequest >& Request )
throw (RuntimeException)
{
    Any anyExc = Request->getRequest();
    Sequence< Reference< XInteractionContinuation > > aSeqCont = Request->getContinuations();

    Reference< XInteractionAbort > abort;
    Reference< XInteractionRetry > retry;

    for ( sal_Int32 i= 0; i < aSeqCont.getLength(); i++ )
    {
        abort = Reference< XInteractionAbort>::query( aSeqCont[i]);
        if ( abort.is() )
            break;
    }
    
	for ( i= 0; i < aSeqCont.getLength(); i++)
    {
        retry= Reference<XInteractionRetry>::query( aSeqCont[i]);
        if ( retry.is() )
            break;
    }
    	
	com::sun::star::java::JavaNotConfiguredException		e1;
	com::sun::star::java::JavaDisabledException				e2;
	com::sun::star::java::MissingJavaRuntimeException		e3;
	com::sun::star::java::JavaVMCreationFailureException	e4;

	// Try to recover the Exception type in the any and
	// react accordingly.
	USHORT		nResult = RET_CANCEL;
	OUString	aParameter;
	
	if ( anyExc >>= e1 )
	{
		// Java not configured. Give user the chance to repair his installation
		vos::OGuard aSolarGuard( Application::GetSolarMutex() );

		WarningBox aWarningBox( NULL, DesktopResId( WARNINGBOX_JAVANOTCONFIGURED ));
		String aTitle = String( DesktopResId( STR_WARNING_FAULTYJAVACFG ));
		
        aWarningBox.SetText( aTitle );
		nResult = aWarningBox.Execute();
		if ( nResult == RET_OK )
			nResult = ( StartJavaSetup( aParameter ) ) ? RET_OK : RET_CANCEL;
	}
	else if ( anyExc >>= e2 )
	{
		// Java disabled. Give user a chance to enable Java inside Office.
		vos::OGuard aSolarGuard( Application::GetSolarMutex() );

		WarningBox aWarningBox( NULL, DesktopResId( WARNINGBOX_JAVADISABLED ));
		String aTitle = String( DesktopResId( STR_WARNING_JAVADISABLED ));
		
        aWarningBox.SetText( aTitle );
		nResult = aWarningBox.Execute();
		if ( nResult == RET_OK )
		{
			// Try to enable Java in SvtJavaOptions!
			SvtJavaOptions aJavaOptions;
			aJavaOptions.SetEnabled( sal_True );
			aJavaOptions.Commit();
		}
	}
	else if ( anyExc >>= e3 )
	{
		// Java not installed. Give user a chance to install Java.
		vos::OGuard aSolarGuard( Application::GetSolarMutex() );

		WarningBox aWarningBox( NULL, DesktopResId( WARNINGBOX_MISSINGJAVARUNTIME ));
		String aTitle = String( DesktopResId( STR_WARNING_MISSINGJAVARUNTIME ));
		OUString aLocation;

		// Replace placeholder %s with the real Java installation path
		String aMsgText( aWarningBox.GetMessText() );
		
		osl::FileBase::getSystemPathFromFileURL( e3.URLRuntimeLib, aLocation );
		aMsgText.SearchAndReplaceAscii( "%s", aLocation );
		aWarningBox.SetMessText( aMsgText );
		
        aWarningBox.SetText( aTitle );
		nResult = aWarningBox.Execute();
		if ( nResult == RET_OK )
			nResult = ( StartJavaSetup( aParameter ) ) ? RET_OK : RET_CANCEL;
	}
	else if ( anyExc >>= e4 )
	{
		// Java not correctly installed. Give user a chance to install Java again.
		vos::OGuard aSolarGuard( Application::GetSolarMutex() );
		
		WarningBox aWarningBox( NULL, DesktopResId( WARNINGBOX_JVMCREATIONFAILED ));
		String aTitle = String( DesktopResId( STR_WARNING_FAULTYJAVAINSTALL ));
		
        aWarningBox.SetText( aTitle );
		nResult = aWarningBox.Execute();
		if ( nResult == RET_OK )
			nResult = ( StartJavaSetup( aParameter ) ) ? RET_OK : RET_CANCEL;
	}

	if ( nResult == RET_CANCEL )
	{
		// Unknown exception type or user wants to cancel
		if ( abort.is() )
			abort->select();
	}
	else // nResult == RET_OK
	{
		// User selected OK => retry Java usage
		if ( retry.is() )
			retry->select();
		else if ( abort.is() ) // no retry possible => call abort
		{
		    {	
				vos::OGuard aSolarGuard( Application::GetSolarMutex() );
		
				// Give user information that restart is required to complete current function
				InfoBox aInfoBox( NULL, DesktopResId( INFOBOX_PLEASERESTARTOFFICE ));
				aInfoBox.Execute();
			}

			abort->select();
		}
	}
}

// ----------------------------------------------------------------------------

JavaContext::JavaContext( const Reference< XCurrentContext > & ctx )
    : m_xNextContext( ctx )
{
}

Any SAL_CALL JavaContext::getValueByName( const OUString& Name) throw (RuntimeException)
{
    Any retVal;

    if ( 0 == Name.compareToAscii( JAVA_INTERACTION_HANDLER_NAME ))
    {
        retVal = makeAny( Reference< XInteractionHandler >( new JavaInteractionHandler()) );
    }
	else if( m_xNextContext.is() )
	{
        // Call next context in chain if found
        retVal = m_xNextContext->getValueByName( Name );
	}
    return retVal;
}

}
