/*************************************************************************
 *
 *  $RCSfile: configurationflushable.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: oj $ $Date: 2001/07/18 08:45:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBA_CORE_CONFIGURATIONFLUSHABLE_HXX_
#include "configurationflushable.hxx"
#endif
#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif
#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif
//........................................................................
namespace dbaccess
{
//........................................................................

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::lang;
using namespace ::utl;
using namespace ::cppu;

//--------------------------------------------------------------------------
void SAL_CALL OConfigurationFlushable::flush(  ) throw(RuntimeException)
{
	::osl::ClearableMutexGuard aGuard(m_rMutex);
	if (!m_aConfigurationNode.isValid())
		throw DisposedException();

	flush_NoBroadcast_NoCommit();
	m_aConfigurationNode.commit();

	aGuard.clear();

	EventObject aEvt(static_cast<XFlushable * >(this));
	OInterfaceIteratorHelper aIter(m_aFlushListeners);
	while (aIter.hasMoreElements())
		((XFlushListener*)aIter.next())->flushed(aEvt);
}

//--------------------------------------------------------------------------
//Sequence< Type > SAL_CALL OConfigurationFlushable::getTypes() throw (RuntimeException)
//{
//	Sequence< Type > aReturn(1);
//	aReturn[0] = ::getCppuType(static_cast< Reference< XFlushable >* >(NULL));
//	return aReturn;
//}

//--------------------------------------------------------------------------
//Any SAL_CALL OConfigurationFlushable::queryInterface( const Type& rType ) throw(RuntimeException)
//{
//	Any aReturn;
//	if (rType.equals( ::getCppuType(static_cast< Reference< XFlushable >* >(NULL)) ))
//		aReturn = makeAny(Reference< XFlushable >(static_cast<XFlushable*>(this)));
//
//	return aReturn;
//}

//--------------------------------------------------------------------------
void SAL_CALL OConfigurationFlushable::addFlushListener( const Reference< XFlushListener >& _rxListener ) throw (RuntimeException)
{
	m_aFlushListeners.addInterface(_rxListener);
}

//--------------------------------------------------------------------------
void SAL_CALL OConfigurationFlushable::removeFlushListener( const Reference< XFlushListener >& _rxListener ) throw (RuntimeException)
{
	m_aFlushListeners.removeInterface(_rxListener);
}

//--------------------------------------------------------------------------
void OConfigurationFlushable::disposing()
{
	EventObject aEvt(static_cast<XFlushable * >(this));
	m_aFlushListeners.disposeAndClear(aEvt);
}
// -----------------------------------------------------------------------------
void OConfigurationFlushable::setConfigurationNode(const OConfigurationTreeRoot& _rConfigurationNode)
{
	OSL_ENSURE(!m_aConfigurationNode.isValid(),"OConfigurationFlushable::setConfigurationNode: should not be called when configuration is already valid!");
	m_aConfigurationNode = _rConfigurationNode;
}
// -----------------------------------------------------------------------------
sal_Int64 SAL_CALL OConfigurationFlushable::getSomething( const Sequence< sal_Int8 >& rId ) throw(RuntimeException)
{
	sal_Int64 nRet(0);
	if (rId.getLength() == 16 && 0 == rtl_compareMemory(getUnoTunnelImplementationId().getConstArray(),  rId.getConstArray(), 16 ) )
		return (sal_Int64)this;

	return nRet;
}
// -----------------------------------------------------------------------------
Sequence< sal_Int8 > OConfigurationFlushable::getUnoTunnelImplementationId()
{
	static ::cppu::OImplementationId * pId = 0;
	if (! pId)
	{
		::osl::MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
		if (! pId)
		{
			static ::cppu::OImplementationId aId;
			pId = &aId;
		}
	}
	return pId->getImplementationId();
}
// -----------------------------------------------------------------------------

//........................................................................
}	// namespace dbaccess
//........................................................................


