/*************************************************************************
 *
 *  $RCSfile: configimport.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/06/30 14:07:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

#include "unomain.hxx"

#include <osl/thread.h>

//=============================================================================
static inline rtl::OString narrow(rtl::OUString const & aString)
{
    return rtl::OUStringToOString( aString, osl_getThreadTextEncoding() );
}
//=============================================================================
static void usage()
{
    rtl::OString sApp = narrow( unoapp::getAppCommandPath() );

	fprintf(stderr, "%s - import files into the configuration database\n", sApp.getStr());
	fprintf(stderr, "\nusage : %s [-a | -e <entity>] <files>\n", sApp.getStr());
	fprintf(stderr, "\n  Options:"
			        "\n      -a     Import into the 'admin' entity of the default backend"
			        "\n      -e     Import into the given entity\n");
	fprintf(stderr, "\n  <entity> - An entity known to the backend"
                    "\n             into which the import should take place\n");
	fprintf(stderr, "\n  <files>  - A list of pathes or file-URLs of XCU files. "
                    "\n             The configuration data of these file will be imported\n");
	fprintf(stderr, "\n\n  Optionally you can also use UNO bootstrap arguments "
                      "\n  to select the configuration backend. \n");
	fflush(stdout);
}

//---------------------------------------------------------------------------

#include <com/sun/star/configuration/backend/XLayerImporter.hpp>
#include <com/sun/star/configuration/backend/XLayer.hpp>
#include <com/sun/star/configuration/backend/XBackendEntities.hpp>
namespace uno = ::com::sun::star::uno;
namespace backend = ::com::sun::star::configuration::backend;
using rtl::OUString;
//---------------------------------------------------------------------------

static uno::Reference< backend::XLayerImporter >  createImporter(uno::Reference< uno::XComponentContext > const & xContext);
static uno::Reference< backend::XLayer > createFileLayer(uno::Reference< uno::XComponentContext > const & xContext, OUString const & aURL);
static bool argToUrl(OUString const & aArgument, OUString & rURL);
// --------------------------------------------------------------------------

int SAL_CALL unoapp::uno_main(uno::Reference< uno::XComponentContext > const & xContext)
        SAL_THROW( (uno::Exception) )
{
    // get args
    uno::Sequence< OUString > const aArgs( getAppCommandArgs() );

    sal_Int32 const nArgC = aArgs.getLength();

    if (nArgC < 1)
    {
        usage();
        return 1;
    }

    sal_Int32 ix = 0;

    // get entity if applicable
    OUString sEntity;
    bool bUseEntity = false;
    bool bUseAdminEntity = false;

    if (aArgs[ix].equalsAscii("-a"))
    {
        ix += 1;

        if (nArgC <= ix)
        {
            usage();
            return 2;
        }

        bUseEntity = true;
        bUseAdminEntity = true;
    }
	else if (aArgs[ix].equalsAscii("-e"))
    {
        ix += 2;

        if (nArgC <= ix)
        {
            usage();
            return 3;
        }

        sEntity = aArgs[ix-1];
        bUseEntity = true;
    }


    uno::Reference< backend::XLayerImporter > xImporter = createImporter(xContext);
    OSL_ASSERT( xImporter.is());

	if (bUseAdminEntity)
	{
		uno::Reference< backend::XBackendEntities > xBackend(xImporter->getTargetBackend(), uno::UNO_QUERY);
		if (!xBackend.is())
		{

            fprintf(stderr," ERROR: Cannot determine admin entity - no backend\n" );
            return 11;
		}
		sEntity = xBackend->getAdminEntity();
		if (sEntity.getLength() == 0)
		{
            fprintf(stderr," ERROR: Cannot determine admin entity - backend does not support admin access\n" );
			return 12;
		}	
	}
	
	if (bUseEntity)
    	fprintf(stderr,"\nStarting configuration import into entity %s ..\n", narrow(sEntity).getStr() );
	else
    	fprintf(stderr,"\nStarting configuration import into user data ..\n" );

    for ( ; ix < nArgC; ++ix)
    {
        rtl::OUString aURL;
        if ( argToUrl( aArgs[ix], aURL ) )
        {
            uno::Reference< backend::XLayer > xLayer = createFileLayer(xContext,aURL);
            if (xLayer.is())
            {
                fprintf(stderr,".. importing layer %s", narrow(aURL).getStr() );
                fflush(stderr);

                if (!bUseEntity)
                    xImporter->importLayer(xLayer);

                else
                    xImporter->importLayerForEntity(xLayer,sEntity);

                fprintf(stderr," - succeeded\n" );
            }
            else
            {
                fprintf(stderr," ERROR: layer '%s' not found\n", narrow(aURL).getStr() );
                return 21;
            }
        }
        else
        {
            fprintf(stderr," ERROR: invalid argument '%s'\n", narrow(aArgs[ix]).getStr() );
            return 22;
        }
        fflush(stderr);
    }

    return 0;
}
// --------------------------------------------------------------------------

#include <osl/file.hxx>
#include <osl/process.h>

static OUString getCWD()
{
    OUString aCWD;
    OSL_VERIFY(! osl_getProcessWorkingDir(&aCWD.pData) );
    return aCWD;
}

static bool argToUrl(OUString const & aArgument, OUString & rURL)
{
    using osl::File;

    OUString aOther;

    if (File::getFileURLFromSystemPath(aArgument,aOther) == File::E_None)
    {
        rURL = aOther;
    }
    else if (File::getSystemPathFromFileURL(aArgument,aOther) == File::E_None)
    {
        rURL = aArgument;
    }
    else
        return false;

    static const OUString aCWD = getCWD();

    if (File::getAbsoluteFileURL(aCWD,rURL,aOther) == File::E_None)
    {
        rURL = aOther;
    }
    else
    {
        fprintf(stderr," WARNING: Cannot get absolute path for %s\n",narrow(rURL).getStr());
    }
    
    return true;
}
// --------------------------------------------------------------------------

#include <com/sun/star/lang/ServiceNotRegisteredException.hpp>
#include <rtl/ustrbuf.hxx>
namespace lang = com::sun::star::lang;
using uno::UNO_QUERY;

// --------------------------------------------------------------------------
static uno::Reference< uno::XInterface > createService(uno::Reference< uno::XComponentContext > const & xContext, OUString aService)
{

    uno::Reference< lang::XMultiComponentFactory > xFactory = xContext->getServiceManager();
    if (!xFactory.is())
    {
        rtl::OUStringBuffer sMsg;
        sMsg.appendAscii("Missing object ! ");
        sMsg.appendAscii("UNO context has no service manager.");

        throw uno::RuntimeException(sMsg.makeStringAndClear(),NULL);
    }

    uno::Reference< uno::XInterface > xInstance = xFactory->createInstanceWithContext(aService,xContext);
    if (!xInstance.is())
    {
        rtl::OUStringBuffer sMsg;
        sMsg.appendAscii("Missing service ! ");
        sMsg.appendAscii("Service manager can't instantiate service ");
        sMsg.append(aService).appendAscii(". ");

        throw lang::ServiceNotRegisteredException(sMsg.makeStringAndClear(),NULL);
    }
  
    return xInstance;
}

// --------------------------------------------------------------------------
static uno::Reference< backend::XLayerImporter >  createImporter(uno::Reference< uno::XComponentContext > const & xContext)
{
    static const rtl::OUString kImporter(
        RTL_CONSTASCII_USTRINGPARAM("com.sun.star.configuration.backend.MergeImporter")) ;

    uno::Reference< backend::XLayerImporter > xRet( createService(xContext,kImporter), UNO_QUERY );
    if (!xRet.is())
    {
        rtl::OUStringBuffer sMsg;
        sMsg.appendAscii("Missing interface ! Service ");
        sMsg.append(kImporter);
        sMsg.appendAscii(" does not support the required interface ");
        sMsg.appendAscii("com::sun::star::configuration::backend::XLayerImporter").appendAscii(".");

        throw uno::RuntimeException(sMsg.makeStringAndClear(),NULL);
    }

    return xRet;
}
// --------------------------------------------------------------------------

#include <com/sun/star/io/XInputStream.hpp>
#include <com/sun/star/io/XActiveDataSink.hpp>
namespace io = com::sun::star::io;

static uno::Reference< io::XInputStream >  createFileStream(uno::Reference< uno::XComponentContext > const & xContext, OUString const & aURL);
// --------------------------------------------------------------------------

static uno::Reference< backend::XLayer > createFileLayer(uno::Reference< uno::XComponentContext > const & xContext, OUString const & aURL)
{    
    static const OUString kXMLLayerParser( 
        RTL_CONSTASCII_USTRINGPARAM("com.sun.star.configuration.backend.xml.LayerParser")) ;
    
    uno::Reference< backend::XLayer > xLayerReader;

    uno::Reference< io::XInputStream > xFile = createFileStream(xContext,aURL);
    if (xFile.is())
    {
        xLayerReader.set( createService(xContext,kXMLLayerParser), UNO_QUERY );

        uno::Reference< io::XActiveDataSink > xAS(xLayerReader, UNO_QUERY);
        if (!xAS.is())
        {
            rtl::OUStringBuffer sMsg;
            sMsg.appendAscii("Missing interface ! Service ");
            sMsg.append(kXMLLayerParser);
            sMsg.appendAscii(" does not support one of the needed interfaces ");
            sMsg.appendAscii("com::sun::star::configuration::backend::XLayer").appendAscii(" or ");
            sMsg.appendAscii("com::sun::star::io::XActiveDataSink").appendAscii(".");

            throw uno::RuntimeException(sMsg.makeStringAndClear(),NULL);
        }

        xAS->setInputStream(xFile);
    }

    return xLayerReader;
}
// --------------------------------------------------------------------------

#include "oslstream.hxx"
namespace io = com::sun::star::io;
// --------------------------------------------------------------------------

static uno::Reference< io::XInputStream >  createFileStream(uno::Reference< uno::XComponentContext > const & xContext, OUString const & aURL)
{
    using osl::File;

    File * blobFile = new File(aURL);
    
    File::RC errorCode = blobFile->open(OpenFlag_Read);

    uno::Reference<io::XInputStream> xResult;
    switch (errorCode)
    { 
    case osl::File::E_None: // got it
        xResult.set( new configmgr::OSLInputStreamWrapper(blobFile,true) );
        break;

    case osl::File::E_NOENT: // no file => no stream
        delete blobFile;
        break;

    default:
        delete blobFile;
        {
            rtl::OUStringBuffer sMsg;
            sMsg.appendAscii("Cannot open output file \"");
            sMsg.append(aURL);
            sMsg.appendAscii("\" : ");
            sMsg.append(configmgr::FileHelper::createOSLErrorString(errorCode));

            throw io::IOException(sMsg.makeStringAndClear(),NULL);
        }   
    }
    return xResult;
}
// --------------------------------------------------------------------------

