/*************************************************************************
 *
 *  $RCSfile: cntvwitm.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2003/04/17 17:04:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "cntvwitm.hxx"

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _ADRPARSE_HXX
#include <svtools/adrparse.hxx>
#endif

#ifndef _CASTMACS_HXX
#include <castmacs.hxx>
#endif

using namespace chaos;

// -------------------------------------------------------------------------

TYPEINIT1_AUTOFACTORY(CntNameItem, CntUnencodedStringItem);
TYPEINIT1_AUTOFACTORY(CntPriorityItem, CntEnumItem);

// -------------------------------------------------------------------------

SfxPoolItem* CntNameItem::Clone( SfxItemPool* pPool ) const
{
	return new CntNameItem( *this );
}

int CntNameItem::operator==( const SfxPoolItem& rItm ) const
{
	return CntUnencodedStringItem::operator==( rItm );
}

int CntNameItem::Compare( const SfxPoolItem& rItm ) const
{
	DBG_ASSERT( SfxPoolItem::operator==( rItm ), "unequal type" );

	switch ( GetRealName().CompareIgnoreCaseToAscii( ((const CntNameItem&)rItm).GetRealName() ) )
	{
		case COMPARE_EQUAL   : return  0;
		case COMPARE_LESS    : return -1;
		case COMPARE_GREATER : return  1;
	}
	return 0;
}

const String& CntNameItem::GetRealName() const
{
	if ( !aRealName.Len() )
	{
		const String& rValue = CntUnencodedStringItem::GetValue();
		if ( rValue.Len() )
		{
			SvAddressParser aParser( rValue );
			CntNameItem* pVarThis = CONST_CAST( CntNameItem*, this );
			if( aParser.Count() )
				pVarThis->aRealName = aParser.GetRealName( 0 );
			else
				pVarThis->aRealName = rValue;
		}
	}
	return aRealName;
}

SfxItemPresentation CntNameItem::GetPresentation( SfxItemPresentation ePresentation,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresentationMetric,
									XubString &rText,
                                    const IntlWrapper * ) const
{
	rText = GetRealName();
	return SFX_ITEM_PRESENTATION_COMPLETE;
}

// virtual
USHORT CntNameItem::GetVersion(USHORT) const
{
	return 1; // because it uses SfxPoolItem::read/writeUnicodeString()
}

// virtual
SfxPoolItem * CntNameItem::Create(SvStream & rStream, USHORT nVersion) const
{
	String aName;
	readUnicodeString(rStream, aName, nVersion >= 1);
	return new CntNameItem(Which(), aName);
}

// virtual
SvStream& CntNameItem::Store(SvStream & rStream, USHORT) const
{
	writeUnicodeString(rStream, GetValue());
	return rStream;
}

// -------------------------------------------------------------------------

CntPriorityItem::CntPriorityItem( USHORT nWhich, CntPriority eMode )
	: CntEnumItem( nWhich, eMode )
{
}

CntPriorityItem::CntPriorityItem( USHORT nWhich, const String& rValue )
	: CntEnumItem( nWhich, CNT_PRIO_NORMAL )
{
	// Parse Value to get Enum
	USHORT nValue = rValue.ToInt32();
	if ( ( nValue > 0 ) && ( nValue <= CNT_PRIO_LOWEST ) )
		SetEnumValue( nValue );
}

SfxPoolItem* CntPriorityItem::Clone( SfxItemPool* ) const
{
	return new CntPriorityItem( *this );
}

SfxPoolItem* CntPriorityItem::Create( SvStream& rStream, USHORT ) const
{
	USHORT eStyle;
	rStream >> eStyle;

	return new CntPriorityItem( Which(), (CntPriority)eStyle );
}

SvStream& CntPriorityItem::Store( SvStream& rStream, USHORT ) const
{
	rStream << (USHORT)GetValue();
	return rStream;
}

String CntPriorityItem::GetValueText() const
{
	String aValue;

	GetPresentation( SFX_ITEM_PRESENTATION_COMPLETE,
					 SFX_MAPUNIT_APPFONT, SFX_MAPUNIT_APPFONT,
					 aValue );
	return aValue;
}

SfxItemPresentation CntPriorityItem::GetPresentation( SfxItemPresentation,
							SfxMapUnit,
							SfxMapUnit,
							XubString &rText,
                            const IntlWrapper * ) const
{
	rText = GetValueTextByPos( GetValue() );
	return SFX_ITEM_PRESENTATION_NAMELESS;
}

String CntPriorityItem::GetValueTextByPos( USHORT nPos ) const
{
	DBG_ASSERT( nPos > 0, "enum underflow!" );
	DBG_ASSERT( nPos <= CNT_PRIO_LOWEST, "enum overflow!" );

	if ( ( nPos == 0 ) || ( nPos > CNT_PRIO_LOWEST ) )
		nPos = CNT_PRIO_NORMAL;

	return String::CreateFromAscii( "Normal" );
}

USHORT CntPriorityItem::GetValueCount() const
{
	return CNT_PRIO_LOWEST - 1;
}

int CntPriorityItem::Compare( const SfxPoolItem& rWith ) const
{
	DBG_ASSERT( SfxPoolItem::operator==( rWith ), "unequal type" );

	// da X.Compare( Y ) am String einem Compare( Y, X ) entspricht,
	// vergleichen wir hier Y mit X
	if( ((const CntPriorityItem&)rWith).GetValue() == GetValue() )
		return 0;
	if( ((const CntPriorityItem&)rWith).GetValue() < GetValue() )
		return -1;
	return 1;
}

// virtual
BOOL CntPriorityItem::PutValue( const com::sun::star::uno::Any& rVal,
						   		BYTE nMemberId )
{
	sal_Int16 nValue;
	if ( rVal >>= nValue )
	{
		CntEnumItem::SetValue( nValue );
		return TRUE;
	}

	DBG_ERROR( "CntPriorityItem::PutValue - Wrong type!" );
	return FALSE;
}

// virtual
BOOL CntPriorityItem::QueryValue( com::sun::star::uno::Any& rVal,
							 	  BYTE nMemberId ) const
{
	sal_Int16 nValue = CntEnumItem::GetValue();
	rVal <<= nValue;
	return TRUE;
}

// --------------------------------------------------------------------------
