/*************************************************************************
 *
 *  $RCSfile: c_bridge.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 16:23:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _OSL_PROCESS_H_
#include <osl/process.h>
#endif
#ifndef _RTL_PROCESS_H_
#include <rtl/process.h>
#endif
#ifndef _RTL_UNLOAD_H_
#include <rtl/unload.h>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#ifndef _UNO_LBNAMES_H_
#include <uno/lbnames.h>
#endif
#ifndef _UNO_ANY2_H_
#include <uno/any2.h>
#endif

#include "c_bridge.hxx"


using namespace ::rtl;
using namespace ::osl;

namespace c_uno
{

//==================================================================================================
static rtl_StandardModuleCount g_moduleCount = MODULE_COUNT_INIT;

//--------------------------------------------------------------------------------------------------
void SAL_CALL cInterfaceProxy_free( uno_ExtEnvironment * pEnv, void * pProxy ) SAL_THROW_EXTERN_C()
{
	cInterfaceProxy * pThis = reinterpret_cast< cInterfaceProxy * >( pProxy );
	OSL_ASSERT( pEnv == pThis->pBridge->pCEnv );

	(*pThis->pBridge->pUnoEnv->revokeInterface)( pThis->pBridge->pUnoEnv, pThis->pUnoI );
	(*pThis->pUnoI->release)( pThis->pUnoI );
	::typelib_typedescription_release( (typelib_TypeDescription *)pThis->pTypeDescr );
	pThis->pBridge->release();

#if OSL_DEBUG_LEVEL > 1
	*(int *)pProxy = 0xdeadbabe;
#endif
	delete pThis;
}
//__________________________________________________________________________________________________
void cInterfaceProxy::acquireProxy() SAL_THROW( () )
{
	if (1 == ::osl_incrementInterlockedCount( &nRef ))
	{
		// rebirth of proxy zombie
		// register at c env
		void * pThis = &ftab;
		(*pBridge->pCEnv->registerProxyInterface)(
			pBridge->pCEnv, &pThis, cInterfaceProxy_free, oid.pData, pTypeDescr );
		OSL_ASSERT( pThis == &ftab );
	}
}
//__________________________________________________________________________________________________
void cInterfaceProxy::releaseProxy() SAL_THROW( () )
{
	if (! ::osl_decrementInterlockedCount( &nRef )) // last release
	{
		// revoke from c env
		(*pBridge->pCEnv->revokeInterface)(
			pBridge->pCEnv, &ftab );
	}
}
//__________________________________________________________________________________________________
cInterfaceProxy::cInterfaceProxy(
	Bridge * pBridge_, uno_Interface * pUnoI_,
	typelib_InterfaceTypeDescription * pTypeDescr_,
	OUString const & rOId_ ) SAL_THROW( () )
	: nRef( 1 )
	, pBridge( pBridge_ )
	, pUnoI( pUnoI_ )
	, pTypeDescr( pTypeDescr_ )
	, oid( rOId_ )
{
	static Ftables * s_pFtables = 0;
	if (! s_pFtables)
	{
		MutexGuard aGuard( Mutex::getGlobalMutex() );
		if (! s_pFtables)
		{
#ifdef LEAK_STATIC_DATA
			s_pFtables = new Ftables();
#else
			static Ftables s_aFtables;
			s_pFtables = &s_aFtables;
#endif
		}
	}
	ftab = s_pFtables->getFtable( pTypeDescr->nMapFunctionIndexToMemberIndex );

	pBridge->acquire();
	::typelib_typedescription_acquire( (typelib_TypeDescription *)pTypeDescr );
	if (! ((typelib_TypeDescription *)pTypeDescr)->bComplete)
	{
		::typelib_typedescription_complete( (typelib_TypeDescription **)&pTypeDescr );
	}
	OSL_ENSURE( ((typelib_TypeDescription *)pTypeDescr)->bComplete, "### type is incomplete!" );
	(*pBridge->pUnoEnv->registerInterface)(
		pBridge->pUnoEnv, reinterpret_cast< void ** >( &pUnoI ), oid.pData, pTypeDescr );
	(*pUnoI->acquire)( pUnoI );
}
//--------------------------------------------------------------------------------------------------
void SAL_CALL Mapping_uno2c(
	uno_Mapping * pMapping, void ** ppCI,
	void * pUnoI, typelib_InterfaceTypeDescription * pTypeDescr ) SAL_THROW_EXTERN_C()
{
	OSL_ASSERT( ppCI && pTypeDescr );
	if (*ppCI)
	{
		CUNO_CALL(reinterpret_cast< com_sun_star_uno_XInterface * >( *ppCI ))->release(
			reinterpret_cast< com_sun_star_uno_XInterface * >( *ppCI ) );
		*ppCI = 0;
	}
	if (pUnoI)
	{
		Bridge * pBridge = static_cast< Mapping * >( pMapping )->pBridge;

		// get object id of uno interface to be wrapped
		rtl_uString * pOId = 0;
		(*pBridge->pUnoEnv->getObjectIdentifier)( pBridge->pUnoEnv, &pOId, pUnoI );
		OSL_ASSERT( pOId );

		// try to get any known interface from target environment
		(*pBridge->pCEnv->getRegisteredInterface)(
			pBridge->pCEnv, ppCI, pOId, pTypeDescr );

		if (! *ppCI) // no existing interface, register new proxy interface
		{
			// try to publish a new proxy (ref count initially 1)
			cInterfaceProxy * pProxy = new cInterfaceProxy(
				pBridge, reinterpret_cast< uno_Interface * >( pUnoI ), pTypeDescr, pOId );
			com_sun_star_uno_XInterface * pSurrogate = &pProxy->ftab;

			// proxy may be exchanged during registration
			(*pBridge->pCEnv->registerProxyInterface)(
				pBridge->pCEnv, reinterpret_cast< void ** >( &pSurrogate ),
				cInterfaceProxy_free, pOId, pTypeDescr );

			*ppCI = pSurrogate;
		}
		::rtl_uString_release( pOId );
	}
}

//##################################################################################################

//--------------------------------------------------------------------------------------------------
void SAL_CALL unoInterfaceProxy_free( uno_ExtEnvironment * pEnv, void * pProxy ) SAL_THROW_EXTERN_C()
{
	unoInterfaceProxy * pThis =
		static_cast< unoInterfaceProxy * >( reinterpret_cast< uno_Interface * >( pProxy ) );
	OSL_ASSERT( pEnv == pThis->pBridge->pUnoEnv );

	(*pThis->pBridge->pCEnv->revokeInterface)( pThis->pBridge->pCEnv, pThis->pCI );
	CUNO_CALL(pThis->pCI)->release( pThis->pCI );
	::typelib_typedescription_release( (typelib_TypeDescription *)pThis->pTypeDescr );
	pThis->pBridge->release();

#if OSL_DEBUG_LEVEL > 1
	*(int *)pProxy = 0xdeadbabe;
#endif
	delete pThis;
}
//--------------------------------------------------------------------------------------------------
void SAL_CALL unoInterfaceProxy_acquire( uno_Interface * pUnoI ) SAL_THROW_EXTERN_C()
{
	unoInterfaceProxy * pThis =
		static_cast< unoInterfaceProxy * >( reinterpret_cast< uno_Interface * >( pUnoI ) );
	if (1 == ::osl_incrementInterlockedCount( &pThis->nRef ))
	{
		// rebirth of proxy zombie
		// register at uno env
		(*pThis->pBridge->pUnoEnv->registerProxyInterface)(
			pThis->pBridge->pUnoEnv, reinterpret_cast< void ** >( &pUnoI ), unoInterfaceProxy_free,
			pThis->oid.pData, pThis->pTypeDescr );
#if OSL_DEBUG_LEVEL > 1
		OSL_ASSERT( pThis == pUnoI );
#endif
	}
}
//--------------------------------------------------------------------------------------------------
void SAL_CALL unoInterfaceProxy_release( uno_Interface * pUnoI ) SAL_THROW_EXTERN_C()
{
	unoInterfaceProxy * pThis =
		static_cast< unoInterfaceProxy * >( reinterpret_cast< uno_Interface * >( pUnoI ) );
	if (! ::osl_decrementInterlockedCount( &pThis->nRef ))
	{
		// revoke from uno env on last release
		(*pThis->pBridge->pUnoEnv->revokeInterface)( pThis->pBridge->pUnoEnv, pUnoI );
	}
}
//__________________________________________________________________________________________________
unoInterfaceProxy::unoInterfaceProxy(
	Bridge * pBridge_,
	com_sun_star_uno_XInterface * pCI_,
	typelib_InterfaceTypeDescription * pTypeDescr_,
	OUString const & rOId_ ) SAL_THROW( () )
	: nRef( 1 )
	, pBridge( pBridge_ )
	, pCI( pCI_ )
	, pTypeDescr( pTypeDescr_ )
	, oid( rOId_ )
{
	pBridge->acquire();
	::typelib_typedescription_acquire( (typelib_TypeDescription *)pTypeDescr );
	if (! ((typelib_TypeDescription *)pTypeDescr)->bComplete)
	{
		::typelib_typedescription_complete( (typelib_TypeDescription **)&pTypeDescr );
	}
	OSL_ENSURE( ((typelib_TypeDescription *)pTypeDescr)->bComplete, "### type is incomplete!" );
	(*pBridge->pCEnv->registerInterface)(
		pBridge->pCEnv, reinterpret_cast< void ** >( &pCI ), oid.pData, pTypeDescr );
	CUNO_CALL(pCI)->acquire( pCI );

	// uno_Interface
	uno_Interface::acquire = unoInterfaceProxy_acquire;
	uno_Interface::release = unoInterfaceProxy_release;
	uno_Interface::pDispatcher = unoInterfaceProxy_dispatch;
}
//--------------------------------------------------------------------------------------------------
void SAL_CALL Mapping_c2uno(
	uno_Mapping * pMapping, void ** ppUnoI,
	void * pCI, typelib_InterfaceTypeDescription * pTypeDescr ) SAL_THROW_EXTERN_C()
{
	OSL_ENSURE( ppUnoI && pTypeDescr, "### null ptr!" );
	if (*ppUnoI)
	{
		(*reinterpret_cast< uno_Interface * >( *ppUnoI )->release)(
			reinterpret_cast< uno_Interface * >( *ppUnoI ) );
		*ppUnoI = 0;
	}
	if (pCI)
	{
		Bridge * pBridge = static_cast< Mapping * >( pMapping )->pBridge;

		// get object id of interface to be wrapped
		rtl_uString * pOId = 0;
		(*pBridge->pCEnv->getObjectIdentifier)( pBridge->pCEnv, &pOId, pCI );
		OSL_ASSERT( pOId );

		// try to get any known interface from target environment
		(*pBridge->pUnoEnv->getRegisteredInterface)(
			pBridge->pUnoEnv, ppUnoI, pOId, pTypeDescr );

		if (! *ppUnoI) // no existing interface, register new proxy interface
		{
			// try to publish a new proxy (refcount initially 1)
			uno_Interface * pSurrogate = new unoInterfaceProxy(
				pBridge, reinterpret_cast< com_sun_star_uno_XInterface * >( pCI ),
				pTypeDescr, pOId );

			// proxy may be exchanged during registration
			(*pBridge->pUnoEnv->registerProxyInterface)(
				pBridge->pUnoEnv, reinterpret_cast< void ** >( &pSurrogate ),
				unoInterfaceProxy_free, pOId, pTypeDescr );

			*ppUnoI = pSurrogate;
		}
		::rtl_uString_release( pOId );
	}
}

//##################################################################################################

//--------------------------------------------------------------------------------------------------
void SAL_CALL Mapping_acquire( uno_Mapping * pMapping ) SAL_THROW_EXTERN_C()
{
	static_cast< Mapping * >( pMapping )->pBridge->acquire();
}
//--------------------------------------------------------------------------------------------------
void SAL_CALL Mapping_release( uno_Mapping * pMapping ) SAL_THROW_EXTERN_C()
{
	static_cast< Mapping * >( pMapping )->pBridge->release();
}
//__________________________________________________________________________________________________
Mapping::Mapping( Bridge * pBridge_, uno_MapInterfaceFunc fpMap ) SAL_THROW( () )
	: pBridge( pBridge_ )
{
	uno_Mapping::acquire = Mapping_acquire;
	uno_Mapping::release = Mapping_release;
	uno_Mapping::mapInterface = fpMap;
}
//__________________________________________________________________________________________________
Bridge::Bridge(
	uno_ExtEnvironment * pCEnv_, uno_ExtEnvironment * pUnoEnv_,
	bool bExportC2Uno_ ) SAL_THROW( () )
	: nRef( 1 )
	, pCEnv( pCEnv_ )
	, pUnoEnv( pUnoEnv_ )
	, aC2Uno( this, Mapping_c2uno )
	, aUno2C( this, Mapping_uno2c )
	, bExportC2Uno( bExportC2Uno_ )
{
    g_moduleCount.modCnt.acquire( &g_moduleCount.modCnt );
	(*((uno_Environment *)pCEnv)->acquire)( (uno_Environment *)pCEnv );
	(*((uno_Environment *)pUnoEnv)->acquire)( (uno_Environment *)pUnoEnv );
}
//__________________________________________________________________________________________________
Bridge::~Bridge() SAL_THROW( () )
{
	(*((uno_Environment *)pUnoEnv)->release)( (uno_Environment *)pUnoEnv );
	(*((uno_Environment *)pCEnv)->release)( (uno_Environment *)pCEnv );
	g_moduleCount.modCnt.release( &g_moduleCount.modCnt );
}
//__________________________________________________________________________________________________
void SAL_CALL Bridge_free( uno_Mapping * pMapping ) SAL_THROW_EXTERN_C()
{
	delete static_cast< Mapping * >( pMapping )->pBridge;
}
//__________________________________________________________________________________________________
void Bridge::acquire() SAL_THROW( () )
{
	if (1 == ::osl_incrementInterlockedCount( &nRef ))
	{
		if (bExportC2Uno)
		{
			uno_Mapping * pMapping = &aC2Uno;
			::uno_registerMapping(
				&pMapping, Bridge_free,
				(uno_Environment *)pCEnv, (uno_Environment *)pUnoEnv, 0 );
		}
		else
		{
			uno_Mapping * pMapping = &aUno2C;
			::uno_registerMapping(
				&pMapping, Bridge_free,
				(uno_Environment *)pUnoEnv, (uno_Environment *)pCEnv, 0 );
		}
	}
}
//__________________________________________________________________________________________________
void Bridge::release() SAL_THROW( () )
{
	if (! ::osl_decrementInterlockedCount( &nRef ))
	{
		::uno_revokeMapping( bExportC2Uno ? &aC2Uno : &aUno2C );
	}
}

//##################################################################################################

//--------------------------------------------------------------------------------------------------
void SAL_CALL cenv_acquireInterface( uno_ExtEnvironment *, void * pCI ) SAL_THROW_EXTERN_C()
{
	CUNO_CALL(reinterpret_cast< com_sun_star_uno_XInterface * >( pCI ))->acquire(
		reinterpret_cast< com_sun_star_uno_XInterface * >( pCI ) );
}
//--------------------------------------------------------------------------------------------------
void SAL_CALL cenv_releaseInterface( uno_ExtEnvironment *, void * pCI ) SAL_THROW_EXTERN_C()
{
	CUNO_CALL(reinterpret_cast< com_sun_star_uno_XInterface * >( pCI ))->release(
		reinterpret_cast< com_sun_star_uno_XInterface * >( pCI ) );
}
//--------------------------------------------------------------------------------------------------
void SAL_CALL c_release( void * pCI ) SAL_THROW_EXTERN_C()
{
	CUNO_CALL(reinterpret_cast< com_sun_star_uno_XInterface * >( pCI ))->release(
		reinterpret_cast< com_sun_star_uno_XInterface * >( pCI ) );
}

//==================================================================================================
static void SAL_CALL cenv_computeObjectIdentifier(
	uno_ExtEnvironment * pEnv, rtl_uString ** ppOId, void * pInterface )
	SAL_THROW_EXTERN_C()
{
	OSL_ENSURE( pEnv && ppOId && pInterface, "### null ptr!" );
	if (pEnv && ppOId && pInterface)
	{
		if (*ppOId)
		{
			::rtl_uString_release( *ppOId );
			*ppOId = 0;
		}

		uno_Any exc;
		com_sun_star_uno_XInterface * pHome = 0;
		if (CUNO_EXCEPTION_OCCURED( CUNO_CALL(
			reinterpret_cast< com_sun_star_uno_XInterface * >( pInterface ) )->queryInterface(
				reinterpret_cast< com_sun_star_uno_XInterface * >( pInterface ),
				&exc,
				&pHome,
				* ::typelib_static_type_getByTypeClass( typelib_TypeClass_INTERFACE ) ) ))
		{
#if OSL_DEBUG_LEVEL > 0
			OUString aStr( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.uno.RuntimeException") );
			OSL_ASSERT(
				exc.pType->eTypeClass == typelib_TypeClass_EXCEPTION &&
				aStr == exc.pType->pTypeName );
			OSL_TRACE( "c_uno bridge: exception occured during queryInterface() call!" );
#endif
			::uno_any_destruct( &exc, c_release );
		}
		else // no exception occured
		{
			if (pHome)
			{
				// interface
				OUStringBuffer oid( 64 );
				oid.append( (sal_Int64)pHome, 16 );
				oid.append( (sal_Unicode)';' );
				// environment[context]
				oid.append( ((uno_Environment *)pEnv)->pTypeName );
				oid.append( (sal_Unicode)'[' );
				oid.append( (sal_Int64)((uno_Environment *)pEnv)->pContext, 16 );
				// process;good guid

				static OUString * s_pStaticOidPart = 0;
				if (! s_pStaticOidPart)
				{
					MutexGuard aGuard( Mutex::getGlobalMutex() );
					if (! s_pStaticOidPart)
					{
						OUStringBuffer aRet( 64 );
						aRet.appendAscii( RTL_CONSTASCII_STRINGPARAM("];") );
						// pid
						oslProcessInfo info;
						info.Size = sizeof(oslProcessInfo);
						if (::osl_getProcessInfo( 0, osl_Process_IDENTIFIER, &info ) == osl_Process_E_None)
						{
							aRet.append( (sal_Int64)info.Ident, 16 );
						}
						else
						{
							aRet.appendAscii( RTL_CONSTASCII_STRINGPARAM("unknown process id") );
						}
						// good guid
						sal_uInt8 ar[16];
						::rtl_getGlobalProcessId( ar );
						aRet.append( (sal_Unicode)';' );
						for ( sal_Int32 i = 0; i < 16; ++i )
						{
							aRet.append( (sal_Int32)ar[i], 16 );
						}
						static OUString s_aStaticOidPart( aRet.makeStringAndClear() );
						s_pStaticOidPart = &s_aStaticOidPart;
					}
				}
				oid.append( *s_pStaticOidPart );
				OUString aRet( oid.makeStringAndClear() );
				::rtl_uString_acquire( *ppOId = aRet.pData );

				CUNO_CALL(pHome)->release( pHome );
			}
		}
	}
}
//==================================================================================================
static void SAL_CALL cenv_environmentDisposing( uno_Environment * )
	SAL_THROW_EXTERN_C()
{
	g_moduleCount.modCnt.release( &g_moduleCount.modCnt );
}
} // namespace c_uno

extern "C"
{
//##################################################################################################
sal_Bool SAL_CALL component_canUnload( TimeValue * pTime ) throw ()
{
	return ::c_uno::g_moduleCount.canUnload( &::c_uno::g_moduleCount, pTime );
}
//##################################################################################################
void SAL_CALL uno_initEnvironment( uno_Environment * pCEnv )
	SAL_THROW_EXTERN_C()
{
	OSL_ENSURE( pCEnv->pExtEnv, "### expected extended environment!" );
	OSL_ENSURE( ::rtl_ustr_ascii_compare( pCEnv->pTypeName->buffer, UNO_LB_C ) == 0, "### wrong environment type!" );
    ::c_uno::g_moduleCount.modCnt.acquire( &::c_uno::g_moduleCount.modCnt );
	pCEnv->pExtEnv->computeObjectIdentifier = ::c_uno::cenv_computeObjectIdentifier;
	pCEnv->pExtEnv->acquireInterface = ::c_uno::cenv_acquireInterface;
	pCEnv->pExtEnv->releaseInterface = ::c_uno::cenv_releaseInterface;
	pCEnv->environmentDisposing = ::c_uno::cenv_environmentDisposing;
}
//##################################################################################################
void SAL_CALL uno_ext_getMapping(
	uno_Mapping ** ppMapping, uno_Environment * pFrom, uno_Environment * pTo )
	SAL_THROW_EXTERN_C()
{
	OSL_ASSERT( ppMapping && pFrom && pTo );
	if (ppMapping && pFrom && pTo && pFrom->pExtEnv && pTo->pExtEnv)
	{
		uno_Mapping * pMapping = 0;

		if (0 == ::rtl_ustr_ascii_compare( pFrom->pTypeName->buffer, UNO_LB_C ) &&
			0 == ::rtl_ustr_ascii_compare( pTo->pTypeName->buffer, UNO_LB_UNO ))
		{
			// ref count initially 1
			pMapping = &(new ::c_uno::Bridge( pFrom->pExtEnv, pTo->pExtEnv, true ))->aC2Uno;
			::uno_registerMapping(
				&pMapping, ::c_uno::Bridge_free,
				(uno_Environment *)pFrom->pExtEnv,
				(uno_Environment *)pTo->pExtEnv, 0 );
		}
		if (0 == ::rtl_ustr_ascii_compare( pTo->pTypeName->buffer, UNO_LB_C ) &&
			0 == ::rtl_ustr_ascii_compare( pFrom->pTypeName->buffer, UNO_LB_UNO ))
		{
			// ref count initially 1
			pMapping = &(new ::c_uno::Bridge( pTo->pExtEnv, pFrom->pExtEnv, false ))->aUno2C;
			::uno_registerMapping(
				&pMapping, ::c_uno::Bridge_free,
				(uno_Environment *)pFrom->pExtEnv,
				(uno_Environment *)pTo->pExtEnv, 0 );
		}

		if (*ppMapping)
		{
			(*(*ppMapping)->release)( *ppMapping );
		}
		*ppMapping = pMapping;
	}
}
} // extern "C"
