/*************************************************************************
 *
 *  $RCSfile: sto_grps.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <precomp.h>
#include <sto_grps.hxx>

#include <ary/cpp/cg_proj.hxx>
#include <ary/cpp/cg_file.hxx>
#include "t_storg.hxx"




namespace ary
{
namespace store
{

//************************          IndependentGroups_Impl         *******************//


struct IndependentGroups::IndependentGroups_Impl
{
                        IndependentGroups_Impl();
                        ~IndependentGroups_Impl();

    Dyn<ary::TopProject>
                        pTop;
    StdReStorage< ary::cpp::ProjectGroup >
                        aProjects_Cpp;
    StdReStorage< ary::cpp::FileGroup >
                        aFiles_Cpp;
};

IndependentGroups::
IndependentGroups_Impl::IndependentGroups_Impl()
    :   pTop( 0 ) 
{
}

IndependentGroups::
IndependentGroups_Impl::~IndependentGroups_Impl()
{
}




//************************          IndependentGroups         *******************//

IndependentGroups::IndependentGroups()
    :   pi( new IndependentGroups_Impl )
{
}

IndependentGroups::~IndependentGroups()
{
}

ReStorage< ary::cpp::ProjectGroup > &
IndependentGroups::Projects_Cpp()
{
    return pi->aProjects_Cpp;
}

ReStorage< ary::cpp::FileGroup > &
IndependentGroups::Files_Cpp()
{
    return pi->aFiles_Cpp;
}

void
IndependentGroups::SetTopProject( ary::TopProject & let_drProject )
{
 	pi->pTop = &let_drProject;
}



}   // namespace store
}   // namespace ary


