/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIPrefBranchInternal.idl
 */

#ifndef __gen_nsIPrefBranchInternal_h__
#define __gen_nsIPrefBranchInternal_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIObserver; /* forward declaration */


/* starting interface:    nsIPrefBranchInternal */
#define NS_IPREFBRANCHINTERNAL_IID_STR "24ef9578-1dd2-11b2-b439-fcc3d2b4fa20"

#define NS_IPREFBRANCHINTERNAL_IID \
  {0x24ef9578, 0x1dd2, 0x11b2, \
    { 0xb4, 0x39, 0xfc, 0xc3, 0xd2, 0xb4, 0xfa, 0x20 }}

/**
 * The nsIPrefBranchInternal interface allows additional access to the
 * preference branch object. This interface allows functionality to be added to
 * the preference branch object which might be transitory in nature or
 * otherwise deemed unnecessary to, or unwanted in, the main (nsIPrefBranch)
 * interface.
 *
 * @see nsIPrefBranch
 */
class NS_NO_VTABLE nsIPrefBranchInternal : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IPREFBRANCHINTERNAL_IID)

  /**
   * Called by a preferences consumer to add itself as a preference change
   * listener. This consumer must inherit from the nsIObserver interface and
   * will receive the notification via their |Observe| method. The following
   * arguments will be passed to the |Observe| method:
   *   aSubject - The nsIPrefBranch object (this)
   *   aTopic   - The string defined by NS_PREFBRANCH_PREFCHANGE_OBSERVER_ID
   *   aData    - The preference which has changed
   *
   * @param aDomain   The preference on which to listen for changes.
   * @param aObserver The object to be notified if the preference changes.
   * @param aHoldWeak true  Hold a weak reference to |aObserver|. The object
   *                        must implement the nsISupportsWeakReference
   *                        interface or this will fail.
   *                  false Hold a strong reference to |aObserver|.
   *
   * @note
   * Registering as a preference observer can open an object to potential
   * cyclical references which will cause memory leaks. These cycles generally
   * occur because an object both registers itself as an observer (causing the
   * branch to hold a reference to the observer) and holds a reference to the
   * branch object for the purpose of getting/setting preference values. There
   * are 3 approaches which have been implemented in an attempt to avoid these
   * situations.
   * 1) The nsPrefBranch object supports nsISupportsWeakReference. Any consumer
   *    may hold a weak reference to it instead of a strong one.
   * 2) The nsPrefBranch object listens for xpcom-shutdown and frees all of the
   *    objects currently in its observer list. This insures that long lived
   *    objects (services for example) will be freed correctly.
   * 3) The observer can request to be held as a weak reference when it is
   *    registered. This insures that shorter lived objects (say one tied to an
   *    open window) will not fall into the cyclical reference trap.
   *
   * @return NS_OK The observer was successfully set.
   * @return Other The observer could not be created.
   *
   * @see nsIObserver
   * @see removeObserver
   */
  /* void addObserver (in string aDomain, in nsIObserver aObserver, in boolean aHoldWeak); */
  NS_IMETHOD AddObserver(const char *aDomain, nsIObserver *aObserver, PRBool aHoldWeak) = 0;

  /**
   * Called by a preferences consumer to remove itself from the preference
   * change observer list.
   *
   * @param aDomain   The preference which is being observed for changes.
   * @param aObserver The object which is observing.
   *
   * @return NS_OK The observer was successfully removed.
   * @return Other The observer was not successfully removed.
   *
   * @see nsIObserver
   * @see addObserver
   */
  /* void removeObserver (in string aDomain, in nsIObserver aObserver); */
  NS_IMETHOD RemoveObserver(const char *aDomain, nsIObserver *aObserver) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIPREFBRANCHINTERNAL \
  NS_IMETHOD AddObserver(const char *aDomain, nsIObserver *aObserver, PRBool aHoldWeak); \
  NS_IMETHOD RemoveObserver(const char *aDomain, nsIObserver *aObserver); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIPREFBRANCHINTERNAL(_to) \
  NS_IMETHOD AddObserver(const char *aDomain, nsIObserver *aObserver, PRBool aHoldWeak) { return _to AddObserver(aDomain, aObserver, aHoldWeak); } \
  NS_IMETHOD RemoveObserver(const char *aDomain, nsIObserver *aObserver) { return _to RemoveObserver(aDomain, aObserver); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIPREFBRANCHINTERNAL(_to) \
  NS_IMETHOD AddObserver(const char *aDomain, nsIObserver *aObserver, PRBool aHoldWeak) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddObserver(aDomain, aObserver, aHoldWeak); } \
  NS_IMETHOD RemoveObserver(const char *aDomain, nsIObserver *aObserver) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveObserver(aDomain, aObserver); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsPrefBranchInternal : public nsIPrefBranchInternal
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIPREFBRANCHINTERNAL

  nsPrefBranchInternal();
  virtual ~nsPrefBranchInternal();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsPrefBranchInternal, nsIPrefBranchInternal)

nsPrefBranchInternal::nsPrefBranchInternal()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsPrefBranchInternal::~nsPrefBranchInternal()
{
  /* destructor code */
}

/* void addObserver (in string aDomain, in nsIObserver aObserver, in boolean aHoldWeak); */
NS_IMETHODIMP nsPrefBranchInternal::AddObserver(const char *aDomain, nsIObserver *aObserver, PRBool aHoldWeak)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeObserver (in string aDomain, in nsIObserver aObserver); */
NS_IMETHODIMP nsPrefBranchInternal::RemoveObserver(const char *aDomain, nsIObserver *aObserver)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

/**
 * Notification sent when a preference changes.
 */
#define NS_PREFBRANCH_PREFCHANGE_TOPIC_ID "nsPref:changed"

#endif /* __gen_nsIPrefBranchInternal_h__ */
