/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.Day;
import com.jrefinery.data.TimePeriod;
import com.jrefinery.data.TimePeriodFormatException;
import com.jrefinery.data.Year;
import com.jrefinery.date.SerialDate;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Quarter
extends TimePeriod {
    public static final int FIRST_QUARTER = 1;
    public static final int LAST_QUARTER = 4;
    public static final int[] FIRST_MONTH_IN_QUARTER = new int[]{0, 1, 4, 7, 10};
    public static final int[] LAST_MONTH_IN_QUARTER = new int[]{0, 3, 6, 9, 12};
    private Year year;
    private int quarter;

    public Quarter() {
        this(new Date());
    }

    public Quarter(int n, int n2) {
        this(n, new Year(n2));
    }

    public Quarter(int n, Year year) {
        if (n < 1 && n > 4) {
            throw new IllegalArgumentException("Quarter(int, Year): quarter outside valid range.");
        }
        this.year = year;
        this.quarter = n;
    }

    public Quarter(Date date) {
        this(date, TimePeriod.DEFAULT_TIME_ZONE);
    }

    public Quarter(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        int n = calendar.get(2) + 1;
        this.quarter = SerialDate.monthCodeToQuarter((int)n);
        this.year = new Year(calendar.get(1));
    }

    public int getQuarter() {
        return this.quarter;
    }

    public Year getYear() {
        return this.year;
    }

    public TimePeriod previous() {
        Year year;
        Quarter quarter = this.quarter > 1 ? new Quarter(this.quarter - 1, this.year) : ((year = (Year)this.year.previous()) != null ? new Quarter(4, year) : null);
        return quarter;
    }

    public TimePeriod next() {
        Year year;
        Quarter quarter = this.quarter < 4 ? new Quarter(this.quarter + 1, this.year) : ((year = (Year)this.year.next()) != null ? new Quarter(1, year) : null);
        return quarter;
    }

    public long getSerialIndex() {
        return (long)this.year.getYear() * 4L + (long)this.quarter;
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object instanceof Quarter) {
                Quarter quarter = (Quarter)object;
                return this.quarter == quarter.getQuarter() && this.year.equals(quarter.getYear());
            }
            return false;
        }
        return false;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Quarter) {
            Quarter quarter = (Quarter)object;
            n = this.year.getYear() - quarter.getYear().getYear();
            if (n == 0) {
                n = this.quarter - quarter.getQuarter();
            }
        } else {
            n = object instanceof TimePeriod ? 0 : 1;
        }
        return n;
    }

    public String toString() {
        return "Q" + this.quarter + "/" + this.year;
    }

    public long getStart(Calendar calendar) {
        int n = FIRST_MONTH_IN_QUARTER[this.quarter];
        Day day = new Day(1, n, this.year.getYear());
        return day.getStart(calendar);
    }

    public long getEnd(Calendar calendar) {
        int n = LAST_MONTH_IN_QUARTER[this.quarter];
        int n2 = SerialDate.lastDayOfMonth((int)n, (int)this.year.getYear());
        Day day = new Day(n2, n, this.year.getYear());
        return day.getEnd(calendar);
    }

    public static Quarter parseQuarter(String string) throws TimePeriodFormatException {
        int n = string.indexOf("Q");
        if (n == -1) {
            throw new TimePeriodFormatException("Quarter.parseQuarter(string): missing Q.");
        }
        if (n == string.length() - 1) {
            throw new TimePeriodFormatException("Quarter.parseQuarter(string): Q found at end of string.");
        }
        String string2 = string.substring(n + 1, n + 2);
        int n2 = Integer.parseInt(string2);
        String string3 = string.substring(0, n) + string.substring(n + 2, string.length());
        string3 = string3.replace('/', ' ');
        string3 = string3.replace(',', ' ');
        string3 = string3.replace('-', ' ');
        Year year = Year.parseYear(string3.trim());
        Quarter quarter = new Quarter(n2, year);
        return quarter;
    }
}

