/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.HorizontalCategoryAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalBarRenderer;
import com.jrefinery.data.DefaultCategoryDataset;
import com.jrefinery.ui.ApplicationFrame;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;

public class VerticalBarChartDemo2
extends ApplicationFrame {
    public VerticalBarChartDemo2(String string) {
        super(string);
        double[][] dArrayArray = new double[][]{{4.0, 3.0, 2.0, 3.0, 6.0, 3.0, 4.0, 3.0}};
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset(dArrayArray);
        Object[] objectArray = new String[]{"Category 1", "Category 2", "Category 3", "Category 4", "Category 5", "Category 6", "Category 7", "Category 8"};
        defaultCategoryDataset.setCategories(objectArray);
        JFreeChart jFreeChart = ChartFactory.createVerticalBarChart("Vertical Bar Chart", "Category", "Value", defaultCategoryDataset, false);
        jFreeChart.setBackgroundPaint(Color.lightGray);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setLabelsVisible(true);
        VerticalBarRenderer verticalBarRenderer = (VerticalBarRenderer)categoryPlot.getRenderer();
        verticalBarRenderer.setCategoriesPaint(new Paint[]{Color.red, Color.blue, Color.green, Color.yellow, Color.orange, Color.cyan, Color.magenta, Color.blue});
        HorizontalCategoryAxis horizontalCategoryAxis = (HorizontalCategoryAxis)categoryPlot.getDomainAxis();
        horizontalCategoryAxis.setSkipCategoryLabelsToFit(true);
        ValueAxis valueAxis = categoryPlot.getRangeAxis();
        valueAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        valueAxis.setUpperMargin(0.1);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] stringArray) {
        VerticalBarChartDemo2 verticalBarChartDemo2 = new VerticalBarChartDemo2("Vertical Bar Chart Demo 2");
        verticalBarChartDemo2.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)verticalBarChartDemo2));
        verticalBarChartDemo2.setVisible(true);
    }
}

