/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.ChartFrame;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.MeterLegend;
import com.jrefinery.chart.MeterPlot;
import com.jrefinery.data.DefaultMeterDataset;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.Window;

public class MeterPlotDemo {
    void displayMeterChart(double d, int n) {
        JFreeChart jFreeChart = null;
        String string = "Meter Chart";
        DefaultMeterDataset defaultMeterDataset = new DefaultMeterDataset(new Double(20.0), new Double(140.0), new Double(d), "Units");
        defaultMeterDataset.setNormalRange(new Double(70.0), new Double(100.0));
        defaultMeterDataset.setWarningRange(new Double(100.0), new Double(120.0));
        defaultMeterDataset.setCriticalRange(new Double(120.0), new Double(140.0));
        MeterPlot meterPlot = new MeterPlot(defaultMeterDataset);
        meterPlot.setDialType(n);
        meterPlot.setNeedlePaint(Color.white);
        meterPlot.setTickLabelFont(new Font("SansSerif", 1, 9));
        meterPlot.setInsets(new Insets(5, 5, 5, 5));
        jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, meterPlot, false);
        MeterLegend meterLegend = new MeterLegend(jFreeChart, "Sample Meter");
        jFreeChart.setLegend(meterLegend);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame chartFrame = new ChartFrame("Meter Chart", jFreeChart);
        chartFrame.setDefaultCloseOperation(3);
        chartFrame.pack();
        RefineryUtilities.positionFrameRandomly((Window)chartFrame);
        chartFrame.setSize(250, 250);
        chartFrame.show();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java TestMeter <type> <value>");
            System.err.println("Type:  0 = DIALTYPE_PIE");
            System.err.println("Type:  1 = DIALTYPE_CIRCLE");
            System.err.println("Type:  2 = DIALTYPE_CHORD");
        }
        MeterPlotDemo meterPlotDemo = new MeterPlotDemo();
        double d = 85.0;
        int n = 1;
        if (stringArray.length > 0) {
            n = Integer.parseInt(stringArray[0]);
        }
        if (stringArray.length > 1) {
            d = new Double(stringArray[1]);
        }
        meterPlotDemo.displayMeterChart(d, n);
    }
}

