/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.BarRenderer;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.urls.CategoryURLGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.IntervalCategoryDataset;
import com.jrefinery.data.Range;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;

public class VerticalIntervalBarRenderer
extends BarRenderer
implements CategoryItemRenderer {
    private static final int LOW_LABEL = 0;
    private static final int HIGH_LABEL = 1;

    public VerticalIntervalBarRenderer() {
        this(null, null);
    }

    public VerticalIntervalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator) {
        this(categoryToolTipGenerator, null);
    }

    public VerticalIntervalBarRenderer(CategoryURLGenerator categoryURLGenerator) {
        this(null, categoryURLGenerator);
    }

    public VerticalIntervalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, categoryPlot, valueAxis, categoryDataset, chartRenderingInfo);
        this.calculateCategoryAndItemSpans(graphics2D, rectangle2D, categoryPlot, categoryDataset, rectangle2D.getWidth());
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D, Shape shape) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        graphics2D.setPaint(marker.getOutlinePaint());
        graphics2D.draw(double_);
    }

    public void drawCategoryItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, Object object, int n2, Object object2) {
        Object object3;
        Object object4;
        Object object5;
        double d;
        IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
        double d2 = rectangle2D.getX() + rectangle2D.getWidth() * categoryPlot.getIntroGapPercent();
        int n3 = categoryDataset.getCategoryCount();
        int n4 = categoryDataset.getSeriesCount();
        if (n3 > 1) {
            d2 = d2 + (double)n2 * (this.categorySpan / (double)n3) + ((double)n2 * (this.categoryGapSpan / (double)(n3 - 1)) + (double)n * this.itemSpan / (double)(n3 * n4));
            if (n4 > 1) {
                d2 += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
            }
        } else {
            d2 += (double)n * this.itemSpan / (double)(n3 * n4);
            if (n4 > 1) {
                d2 += (double)n * this.itemGapSpan / (double)(n3 * (n4 - 1));
            }
        }
        Number number = intervalCategoryDataset.getEndValue(n, object);
        double d3 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
        Number number2 = intervalCategoryDataset.getStartValue(n, object);
        double d4 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        if (d4 < d3) {
            d = d4;
            d4 = d3;
            d3 = d;
            Number number3 = number2;
            number2 = number;
            number = number3;
        }
        d = d3;
        double d5 = this.itemWidth;
        double d6 = Math.abs(d4 - d3);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d, d5, d6);
        Paint paint = categoryPlot.getSeriesPaint(n);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.itemWidth > 3.0) {
            graphics2D.setStroke(categoryPlot.getSeriesStroke(n));
            graphics2D.setPaint(categoryPlot.getSeriesOutlinePaint(n));
            graphics2D.draw(double_);
        }
        if (categoryPlot.getLabelsVisible()) {
            object5 = categoryPlot.getLabelFormatter();
            object4 = categoryPlot.getLabelFont();
            graphics2D.setFont((Font)object4);
            object3 = categoryPlot.getLabelPaint();
            graphics2D.setPaint((Paint)object3);
            boolean bl = categoryPlot.getVerticalLabels();
            String string = ((Format)object5).format(number2);
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d2, d4, d5, rectangle2D.getMaxY() - d4);
            this.drawLabel(graphics2D, string, double_2, (Font)object4, 0, bl);
            String string2 = ((Format)object5).format(number);
            Rectangle2D.Double double_3 = new Rectangle2D.Double(d2, rectangle2D.getY(), d5, d3 - rectangle2D.getY());
            this.drawLabel(graphics2D, string2, double_3, (Font)object4, 1, bl);
        }
        if (this.getInfo() != null && (object5 = this.getInfo().getEntityCollection()) != null) {
            object4 = null;
            if (this.getToolTipGenerator() != null) {
                object4 = this.getToolTipGenerator().generateToolTip(categoryDataset, n, object);
            }
            object3 = null;
            if (this.getURLGenerator() != null) {
                object3 = this.getURLGenerator().generateURL(categoryDataset, n, object);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, (String)object4, (String)object3, n, object, n2);
            object5.addEntity(categoryItemEntity);
        }
    }

    private void drawLabel(Graphics2D graphics2D, String string, Rectangle2D rectangle2D, Font font, int n, boolean bl) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D2 = font.getStringBounds(string, fontRenderContext);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        float f = (float)rectangle2D.getCenterX();
        if (bl) {
            float f2 = n == 1 ? (float)(rectangle2D.getMaxY() - (double)lineMetrics.getLeading()) : (float)(rectangle2D.getY() + rectangle2D2.getWidth() + (double)lineMetrics.getLeading());
            RefineryUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)(f += (float)(rectangle2D2.getHeight() / 2.0 - (double)lineMetrics.getDescent())), (float)f2, (double)-1.5707963267948966);
        } else {
            float f3 = n == 1 ? (float)(rectangle2D.getMaxY() - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading()) : (float)(rectangle2D.getY() + (double)lineMetrics.getAscent() + (double)lineMetrics.getLeading());
            graphics2D.drawString(string, f -= (float)(rectangle2D2.getWidth() / 2.0), f3);
        }
    }

    public boolean hasItemGaps() {
        return true;
    }

    public int barWidthsPerCategory(CategoryDataset categoryDataset) {
        return categoryDataset.getSeriesCount();
    }
}

