/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.CategoryAxis;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.VerticalCategoryPlot;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;

public class HorizontalCategoryAxis
extends CategoryAxis
implements HorizontalAxis {
    private boolean verticalCategoryLabels;
    private boolean skipCategoryLabelsToFit;
    private int tickHeight;

    public HorizontalCategoryAxis() {
        this(null, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, false, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, false, AxisConstants.DEFAULT_TICK_STROKE, AxisConstants.DEFAULT_TICK_PAINT);
    }

    public HorizontalCategoryAxis(String string) {
        this(string, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, false, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, false, AxisConstants.DEFAULT_TICK_STROKE, AxisConstants.DEFAULT_TICK_PAINT);
    }

    public HorizontalCategoryAxis(String string, Font font, Paint paint, Insets insets, boolean bl, boolean bl2, Font font2, Paint paint2, Insets insets2, boolean bl3, Stroke stroke, Paint paint3) {
        super(string, font, paint, insets, bl, font2, paint2, insets2, bl3, stroke, paint3);
        this.verticalCategoryLabels = bl2;
    }

    public boolean getVerticalCategoryLabels() {
        return this.verticalCategoryLabels;
    }

    public void setVerticalCategoryLabels(boolean bl) {
        if (this.verticalCategoryLabels != bl) {
            this.verticalCategoryLabels = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void setVerticalTickLabels(boolean bl) {
        this.setVerticalCategoryLabels(bl);
    }

    public boolean getSkipCategoryLabelsToFit() {
        return this.skipCategoryLabelsToFit;
    }

    public void setSkipCategoryLabelsToFit(boolean bl) {
        if (this.skipCategoryLabelsToFit != bl) {
            this.skipCategoryLabelsToFit = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Tick[] tickArray;
        Rectangle2D rectangle2D3;
        Object object;
        if (!this.visible) {
            return;
        }
        if (this.label != null) {
            graphics2D.setFont(this.labelFont);
            graphics2D.setPaint(this.labelPaint);
            object = graphics2D.getFontRenderContext();
            rectangle2D3 = this.labelFont.getStringBounds(this.label, (FontRenderContext)object);
            tickArray = this.labelFont.getLineMetrics(this.label, (FontRenderContext)object);
            float f = (float)(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0 - rectangle2D3.getWidth() / 2.0);
            float f2 = (float)(rectangle2D.getMaxY() - (double)this.labelInsets.bottom - (double)tickArray.getDescent() - (double)tickArray.getLeading());
            graphics2D.drawString(this.label, f, f2);
        }
        if (this.tickLabelsVisible) {
            graphics2D.setFont(this.tickLabelFont);
            graphics2D.setPaint(this.tickLabelPaint);
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D2);
            object = this.ticks.iterator();
            while (object.hasNext()) {
                rectangle2D3 = object.next();
                if (rectangle2D3 instanceof Tick) {
                    tickArray = (Tick)((Object)rectangle2D3);
                    if (this.verticalCategoryLabels) {
                        RefineryUtilities.drawRotatedString((String)tickArray.getText(), (Graphics2D)graphics2D, (float)tickArray.getX(), (float)tickArray.getY(), (double)-1.5707963267948966);
                        continue;
                    }
                    graphics2D.drawString(tickArray.getText(), tickArray.getX(), tickArray.getY());
                    continue;
                }
                tickArray = (Tick[])rectangle2D3;
                int n = 0;
                while (n < tickArray.length) {
                    graphics2D.drawString(tickArray[n].getText(), tickArray[n].getX(), tickArray[n].getY());
                    ++n;
                }
            }
        }
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this.tickHeight = 1;
        this.ticks.clear();
        CategoryPlot categoryPlot = (CategoryPlot)this.plot;
        CategoryDataset categoryDataset = categoryPlot.getCategoryDataset();
        if (categoryDataset != null) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Font font = this.getTickLabelFont();
            graphics2D.setFont(font);
            int n = 0;
            int n2 = 0;
            float f = (float)((rectangle2D2.getWidth() + rectangle2D2.getX()) / (double)categoryDataset.getCategoryCount()) * 0.9f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            Iterator iterator = categoryDataset.getCategories().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (n != 0) {
                    ++n2;
                    --n;
                    continue;
                }
                String string = e.toString();
                Rectangle2D rectangle2D3 = font.getStringBounds(string, fontRenderContext);
                LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
                float f4 = (float)categoryPlot.getCategoryCoordinate(n2, rectangle2D2);
                if (this.verticalCategoryLabels) {
                    f2 = (float)((double)f4 + rectangle2D3.getHeight() / 2.0 - (double)lineMetrics.getDescent());
                    f3 = (float)(rectangle2D2.getMaxY() + (double)this.tickLabelInsets.top + rectangle2D3.getWidth());
                    this.ticks.add(new Tick(e, string, f2, f3));
                    if (this.skipCategoryLabelsToFit) {
                        n = (int)((rectangle2D3.getHeight() - (double)(f / 2.0f)) / (double)f) + 1;
                    }
                } else if (rectangle2D3.getWidth() > (double)f) {
                    if (this.skipCategoryLabelsToFit) {
                        f2 = f4 - f / 2.0f;
                        f3 = (float)(rectangle2D2.getMaxY() + (double)this.tickLabelInsets.top + (double)lineMetrics.getHeight() - (double)lineMetrics.getDescent());
                        this.ticks.add(new Tick(e, string, f2, f3));
                        n = (int)((rectangle2D3.getWidth() - (double)(f / 2.0f)) / (double)f) + 1;
                    } else {
                        String[] stringArray = this.breakLine(string, (int)f, fontRenderContext);
                        Tick[] tickArray = new Tick[stringArray.length];
                        int n3 = 0;
                        while (n3 < stringArray.length) {
                            rectangle2D3 = font.getStringBounds(stringArray[n3], fontRenderContext);
                            f2 = (float)((double)f4 - rectangle2D3.getWidth() / 2.0);
                            f3 = (float)(rectangle2D2.getMaxY() + (double)this.tickLabelInsets.top + (double)((float)(n3 + 1) * (lineMetrics.getHeight() - lineMetrics.getDescent())));
                            tickArray[n3] = new Tick(e, stringArray[n3], f2, f3);
                            ++n3;
                        }
                        if (stringArray.length > this.tickHeight) {
                            this.tickHeight = stringArray.length;
                        }
                        this.ticks.add(tickArray);
                    }
                } else {
                    f2 = (float)((double)f4 - rectangle2D3.getWidth() / 2.0);
                    f3 = (float)(rectangle2D2.getMaxY() + (double)this.tickLabelInsets.top + (double)lineMetrics.getHeight() - (double)lineMetrics.getDescent());
                    this.ticks.add(new Tick(e, string, f2, f3));
                }
                ++n2;
            }
        }
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D) {
        if (!this.visible) {
            return 0.0;
        }
        double d = 0.0;
        if (this.label != null) {
            Rectangle2D rectangle2D2 = this.labelFont.getStringBounds(this.label, graphics2D.getFontRenderContext());
            d = (double)(this.labelInsets.top + this.labelInsets.bottom) + rectangle2D2.getHeight();
        }
        double d2 = 0.0;
        if (this.tickLabelsVisible) {
            graphics2D.setFont(this.tickLabelFont);
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D);
            d2 = (double)(this.tickLabelInsets.top + this.tickLabelInsets.bottom) + this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.verticalCategoryLabels);
        }
        return d + d2;
    }

    public Rectangle2D reserveAxisArea(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, double d) {
        if (!this.visible) {
            return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getMaxY(), rectangle2D.getWidth() - d, 0.0);
        }
        double d2 = 0.0;
        if (this.label != null) {
            Rectangle2D rectangle2D2 = this.labelFont.getStringBounds(this.label, graphics2D.getFontRenderContext());
            d2 = (double)(this.labelInsets.top + this.labelInsets.bottom) + rectangle2D2.getHeight();
        }
        double d3 = 0.0;
        if (this.tickLabelsVisible) {
            graphics2D.setFont(this.tickLabelFont);
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D);
            d3 = (double)(this.tickLabelInsets.top + this.tickLabelInsets.bottom) + this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.verticalCategoryLabels);
        }
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getMaxY() - d2 - d3, rectangle2D.getWidth() - d, d2 + d3);
    }

    private double getMaxTickLabelHeight(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = 0.0;
        if (bl) {
            Iterator iterator = this.ticks.iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D rectangle2D2 = font.getStringBounds(tick.getText(), fontRenderContext);
                if (!(rectangle2D2.getWidth() > d)) continue;
                d = rectangle2D2.getWidth();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("Sample", fontRenderContext);
            d = lineMetrics.getHeight() * (float)this.tickHeight - lineMetrics.getDescent() * (float)(this.tickHeight - 1);
        }
        return d;
    }

    protected double getMaxTickLabelWidth(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d = 0.0;
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Iterator iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            Tick[] tickArray;
            Object e = iterator.next();
            if (e instanceof Tick) {
                tickArray = (Tick[])e;
                Rectangle2D rectangle2D2 = font.getStringBounds(tickArray.getText(), fontRenderContext);
                if (!(rectangle2D2.getWidth() > d)) continue;
                d = rectangle2D2.getWidth();
                continue;
            }
            tickArray = (Tick[])e;
            int n = 0;
            while (n < tickArray.length) {
                Rectangle2D rectangle2D3 = font.getStringBounds(tickArray[n].getText(), fontRenderContext);
                if (rectangle2D3.getWidth() > d) {
                    d = rectangle2D3.getWidth();
                }
                ++n;
            }
        }
        return d;
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof VerticalCategoryPlot;
    }

    public void configure() {
    }

    private String[] breakLine(String string, int n, FontRenderContext fontRenderContext) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>(5);
        int n2 = n;
        AttributedString attributedString = new AttributedString(string, this.getTickLabelFont().getAttributes());
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        AffineTransform affineTransform = new AffineTransform();
        while (true) {
            stringArray = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
            int n3 = 0;
            int n4 = 0;
            TextLayout textLayout = stringArray.nextLayout(n2);
            while (textLayout != null) {
                arrayList.add(string.substring(n4, n4 + textLayout.getCharacterCount()));
                int n5 = textLayout.getOutline((AffineTransform)affineTransform).getBounds().width;
                if (n3 < n5) {
                    n3 = n5;
                }
                n4 += textLayout.getCharacterCount();
                textLayout = stringArray.nextLayout(n2);
            }
            if (n3 <= n || (n2 -= n3 - n2) <= 0) break;
            arrayList.clear();
        }
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }
}

