/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.tree.DomEx;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.NamespaceScoped;
import com.sun.xml.tree.ParentNode;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlWriteContext;
import com.sun.xml.util.XmlNames;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

final class AttributeNode
extends ParentNode
implements Attr,
NamespaceScoped {
    private String name;
    private String value;
    private boolean specified;
    private String defaultValue;
    private ElementNode nameScope;

    public AttributeNode(AttributeNode attributeNode) throws DOMException {
        this(attributeNode.name, attributeNode.value, attributeNode.specified, attributeNode.defaultValue);
        this.nameScope = attributeNode.nameScope;
        this.setOwnerDocument((XmlDocument)attributeNode.getOwnerDocument());
    }

    public AttributeNode(String string, String string2, boolean bl, String string3) throws DOMException {
        if (!XmlNames.isName(string)) {
            throw new DomEx(5);
        }
        this.name = string;
        this.value = string2;
        this.specified = bl;
        this.defaultValue = string3;
    }

    void checkChildType(int n) throws DOMException {
        switch (n) {
            case 3: 
            case 5: {
                return;
            }
        }
        throw new DomEx(3);
    }

    public Node cloneNode(boolean bl) {
        try {
            AttributeNode attributeNode = new AttributeNode(this.name, this.value, this.specified, this.defaultValue);
            attributeNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
            if (bl) {
                Node node;
                int n = 0;
                while ((node = this.item(n)) != null) {
                    node = node.cloneNode(true);
                    attributeNode.appendChild(node);
                    ++n;
                }
            }
            return attributeNode;
        }
        catch (DOMException dOMException) {
            throw new RuntimeException(this.getMessage("A-002"));
        }
    }

    String getDefaultValue() {
        return this.defaultValue;
    }

    public String getLocalName() {
        int n = this.name.indexOf(58);
        if (n < 0) {
            return this.name;
        }
        return this.name.substring(n + 1);
    }

    public String getName() {
        return this.name;
    }

    ElementNode getNameScope() {
        return this.nameScope;
    }

    public String getNamespace() {
        if (this.nameScope == null) {
            throw new IllegalStateException(this.getMessage("A-001"));
        }
        String string = this.getPrefix();
        if (string == null) {
            return this.nameScope.getNamespace();
        }
        if ("xml".equals(string) || "xmlns".equals(string)) {
            return null;
        }
        String string2 = this.nameScope.getInheritedAttribute("xmlns:" + string);
        if (string2 == null) {
            throw new IllegalStateException();
        }
        return string2;
    }

    public Node getNextSibling() {
        return null;
    }

    public String getNodeName() {
        return this.name;
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeValue() {
        return this.value;
    }

    public Node getParentNode() {
        return null;
    }

    public String getPrefix() {
        int n = this.name.indexOf(58);
        return n < 0 ? null : this.name.substring(0, n);
    }

    public Node getPreviousSibling() {
        return null;
    }

    public boolean getSpecified() {
        return this.specified;
    }

    public String getValue() {
        return this.value;
    }

    void setNameScope(ElementNode elementNode) {
        if (elementNode != null && this.nameScope != null) {
            throw new IllegalStateException(this.getMessage("A-000", new Object[]{elementNode.getTagName()}));
        }
        this.nameScope = elementNode;
    }

    public void setNodeValue(String string) {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        this.value = string;
        this.specified = true;
    }

    public void setPrefix(String string) {
        int n = this.name.indexOf(58);
        if (string == null) {
            if (n < 0) {
                return;
            }
            this.name = this.name.substring(n + 1);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(':');
        if (n < 0) {
            stringBuffer.append(this.name);
        } else {
            stringBuffer.append(this.name.substring(n + 1));
        }
        this.name = stringBuffer.toString();
    }

    void setSpecified(boolean bl) {
        this.specified = bl;
    }

    public void setValue(String string) {
        this.setNodeValue(string);
    }

    public void writeChildrenXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        int n = 0;
        while (n < this.value.length()) {
            char c = this.value.charAt(n);
            switch (c) {
                case '<': {
                    writer.write("&lt;");
                    break;
                }
                case '>': {
                    writer.write("&gt;");
                    break;
                }
                case '&': {
                    writer.write("&amp;");
                    break;
                }
                case '\'': {
                    writer.write("&apos;");
                    break;
                }
                case '\"': {
                    writer.write("&quot;");
                    break;
                }
                default: {
                    writer.write(c);
                    break;
                }
            }
            ++n;
        }
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        writer.write(this.name);
        writer.write("=\"");
        this.writeChildrenXml(xmlWriteContext);
        writer.write(34);
    }
}

