/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger.diff;

import java.util.List;
import java.util.Vector;
import org.openoffice.xmerge.ConverterCapabilities;
import org.openoffice.xmerge.merger.Iterator;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.Resources;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class NodeIterator
implements Iterator {
    private List nodeList = null;
    private int currentPosition = 0;
    private Node root;
    private ConverterCapabilities cc_ = null;

    public NodeIterator(ConverterCapabilities converterCapabilities, Node node) {
        this.cc_ = converterCapabilities;
        this.nodeList = new Vector();
        this.root = node;
        this.markTree(node);
    }

    protected boolean attributesEqual(Node node, Node node2) {
        boolean bl;
        block9: {
            bl = false;
            String string = node.getNodeName();
            NamedNodeMap[] namedNodeMapArray = new NamedNodeMap[]{node.getAttributes(), node2.getAttributes()};
            if (namedNodeMapArray[0] == null || namedNodeMapArray[1] == null) {
                if (namedNodeMapArray[0] == null && namedNodeMapArray[1] == null) {
                    bl = true;
                }
                return bl;
            }
            int[] nArray = new int[2];
            int n = 0;
            while (n < 2) {
                int n2;
                int n3;
                if (n == 0) {
                    n3 = 0;
                    n2 = 1;
                } else {
                    n3 = 1;
                    n2 = 0;
                }
                nArray[n3] = namedNodeMapArray[n3].getLength();
                int n4 = 0;
                while (n4 < nArray[n3]) {
                    Node node3 = namedNodeMapArray[n3].item(n4);
                    String string2 = node3.getNodeName();
                    if (this.cc_ == null || this.cc_.canConvertAttribute(string, string2)) {
                        Node node4 = namedNodeMapArray[n2].getNamedItem(string2);
                        if (node4 == null) {
                            Debug.log(1, "[NodeIterator] Attr not exist in dst - " + string2);
                            break block9;
                        }
                        if (!node3.getNodeValue().equals(node4.getNodeValue())) {
                            Debug.log(1, "[NodeIterator] Attr diff src: " + node3.getNodeValue() + " dst: " + node4.getNodeValue());
                            break block9;
                        }
                    }
                    ++n4;
                }
                ++n;
            }
            bl = true;
        }
        return bl;
    }

    protected boolean childrenEqual(Node node, Node node2) {
        boolean bl = false;
        NodeList nodeList = node.getChildNodes();
        NodeList nodeList2 = node2.getChildNodes();
        if (nodeList != null && nodeList2 != null && nodeList.getLength() == nodeList2.getLength()) {
            bl = true;
            int n = 0;
            while (n < nodeList.getLength()) {
                if (!this.compareNode(nodeList.item(n), nodeList2.item(n))) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    protected boolean compareNode(Node node, Node node2) {
        boolean bl = false;
        if (node != null && node2 != null && node.getNodeType() == node2.getNodeType() && node.getNodeName().equals(node2.getNodeName()) && (node.getNodeValue() == null && node2.getNodeValue() == null || node.getNodeValue() != null && node2.getNodeValue() != null && node.getNodeValue().equals(node2.getNodeValue())) && this.attributesEqual(node, node2)) {
            if (!node.hasChildNodes() && !node2.hasChildNodes()) {
                bl = true;
            } else if (!node.hasChildNodes() || !node2.hasChildNodes()) {
                bl = false;
            } else if (this.childrenEqual(node, node2)) {
                bl = true;
            }
        }
        return bl;
    }

    public Object currentElement() {
        if (this.currentPosition < 0 || this.currentPosition >= this.nodeList.size()) {
            return null;
        }
        return this.nodeList.get(this.currentPosition);
    }

    public int elementCount() {
        return this.nodeList.size();
    }

    public Object end() {
        int n = this.nodeList.size();
        if (n > 0) {
            this.currentPosition = n - 1;
            return this.currentElement();
        }
        return null;
    }

    public boolean equivalent(Object object, Object object2) {
        boolean bl = false;
        String string = null;
        if (!(object instanceof Node) || !(object2 instanceof Node)) {
            string = Resources.getInstance().getString("NOT_NODE_ERROR");
            Debug.log(2, string);
        } else {
            Node node = (Node)object;
            Node node2 = (Node)object2;
            bl = this.compareNode(node, node2);
        }
        return bl;
    }

    private void markTree(Node node) {
        if (this.nodeSupported(node)) {
            this.nodeList.add(node);
        } else {
            String string = node.getNodeName();
            if (this.cc_ == null || this.cc_.canConvertTag(string)) {
                NodeList nodeList = node.getChildNodes();
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    this.markTree(nodeList.item(n2));
                    ++n2;
                }
            } else {
                Debug.log(1, " [NodeIterator::markTree] Skipping node " + string);
            }
        }
    }

    public Object next() {
        if (this.currentPosition < this.nodeList.size() - 1) {
            ++this.currentPosition;
            return this.currentElement();
        }
        return null;
    }

    protected abstract boolean nodeSupported(Node var1);

    public Object previous() {
        if (this.currentPosition > 0) {
            --this.currentPosition;
            return this.currentElement();
        }
        return null;
    }

    public void refresh() {
        this.nodeList = new Vector();
        this.markTree(this.root);
        this.currentPosition = 0;
    }

    public Object start() {
        this.currentPosition = 0;
        return this.currentElement();
    }
}

