/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger.diff;

import java.util.List;
import java.util.Vector;
import org.openoffice.xmerge.merger.diff.TextNodeEntry;
import org.openoffice.xmerge.merger.diff.TextNodeIterator;
import org.w3c.dom.Node;

public class CharacterParser {
    private TextNodeIterator textNodes;
    private int currentPosition = 0;
    private List nodeList_ = null;
    private char[] charArray;

    public CharacterParser(Node node) {
        this.textNodes = new TextNodeIterator(node);
        this.nodeList_ = new Vector();
        this.parseNodes();
    }

    private void addNewNodeEntry(int n, Node node) {
        TextNodeEntry textNodeEntry = new TextNodeEntry(this.currentPosition, this.currentPosition + n - 1, node);
        this.currentPosition += n;
        this.nodeList_.add(textNodeEntry);
    }

    public char[] getCharArray() {
        return this.charArray;
    }

    public List getNodeList() {
        return this.nodeList_;
    }

    private void parseNodes() {
        StringBuffer stringBuffer = new StringBuffer();
        Node node = (Node)this.textNodes.start();
        while (node != null) {
            String string = null;
            String string2 = node.getNodeName();
            if (node.getNodeType() == 3) {
                string = node.getNodeValue();
            } else if (string2.equals("text:s")) {
                string = " ";
            } else if (string2.equals("text:tab-stop")) {
                string = "\t";
            }
            if (string != null) {
                stringBuffer.append(string);
                this.addNewNodeEntry(string.length(), node);
            }
            node = (Node)this.textNodes.next();
        }
        this.charArray = stringBuffer.toString().toCharArray();
    }
}

