/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.io;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.util.WeakSet;
import org.openide.util.io.SafeException;

public class NbObjectOutputStream
extends ObjectOutputStream {
    private static final String SVUID = "serialVersionUID";
    private static final Set alreadyReported = new WeakSet();
    private final List serializing = new ArrayList(50);
    private static Map examinedClasses;
    static /* synthetic */ Class class$java$io$IOException;

    public NbObjectOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        try {
            this.enableReplaceObject(true);
        }
        catch (SecurityException securityException) {
            IOException iOException = new IOException(securityException.toString());
            ErrorManager.getDefault().annotate((Throwable)iOException, securityException);
            throw iOException;
        }
    }

    public Object replaceObject(Object object) throws IOException {
        if (object instanceof Image) {
            return null;
        }
        return super.replaceObject(object);
    }

    public static void writeSafely(ObjectOutput objectOutput, Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(200);
        try {
            NbObjectOutputStream nbObjectOutputStream = new NbObjectOutputStream(byteArrayOutputStream);
            nbObjectOutputStream.writeObject(object);
            nbObjectOutputStream.flush();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            objectOutput.writeInt(0);
            throw new SafeException(exception);
        }
        objectOutput.writeInt(byteArrayOutputStream.size());
        objectOutput.write(byteArrayOutputStream.toByteArray());
    }

    protected void annotateClass(Class clazz) throws IOException {
        super.annotateClass(clazz);
        if (clazz.isArray()) {
            return;
        }
        this.serializing.add(clazz);
        if (NbObjectOutputStream.isSerialVersionUIDDeclared(clazz)) {
            return;
        }
        if ((class$java$io$IOException == null ? (class$java$io$IOException = NbObjectOutputStream.class$("java.io.IOException")) : class$java$io$IOException).isAssignableFrom(clazz)) {
            return;
        }
        String string = clazz.getName();
        if (alreadyReported.add(string)) {
            Object object;
            HashSet<Object> hashSet = new HashSet<Object>();
            StringBuffer stringBuffer = new StringBuffer("Serializable class ");
            stringBuffer.append(string);
            stringBuffer.append(" does not declare serialVersionUID field. Encountered while storing: [");
            Iterator iterator = this.serializing.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                object = (Class)iterator.next();
                if (object == clazz || !hashSet.add(object)) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((Class)object).getName());
            }
            stringBuffer.append("] See also http://www.netbeans.org/issues/show_bug.cgi?id=19915");
            object = System.getProperty("InstanceDataObject.current.file");
            if (object != null && ((String)object).length() > 0) {
                stringBuffer.append(" [may have been writing ");
                stringBuffer.append((String)object);
                stringBuffer.append("]");
            }
            ErrorManager.getDefault().log(16, stringBuffer.toString());
        }
    }

    private static boolean isSerialVersionUIDDeclared(Class clazz) {
        String string = clazz.getName();
        Boolean bl = (Boolean)examinedClasses.get(string);
        if (bl == null) {
            if (string.equals("java.util.HashSet")) {
                bl = Boolean.TRUE;
            } else {
                bl = Boolean.FALSE;
                Field[] fieldArray = clazz.getDeclaredFields();
                int n = 0;
                while (n < fieldArray.length) {
                    if (fieldArray[n].getName().equals(SVUID)) {
                        bl = Boolean.TRUE;
                        break;
                    }
                    ++n;
                }
            }
            examinedClasses.put(clazz.getName(), bl);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        alreadyReported.add("java.lang.Exception");
        alreadyReported.add("java.io.IOException");
        examinedClasses = new WeakHashMap(250);
    }
}

