/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.src.ConstructorElement;
import org.openide.src.ElementFormat;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.MemberElementNode;
import org.openide.src.nodes.MethodCustomizer;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.HelpCtx;

public class ConstructorElementNode
extends MemberElementNode {
    static /* synthetic */ Class array$Lorg$openide$src$MethodParameter;
    static /* synthetic */ Class array$Lorg$openide$src$Identifier;

    public ConstructorElementNode(ConstructorElement constructorElement, boolean bl) {
        super(constructorElement, Children.LEAF, bl);
        this.setElementFormat0(ElementNode.sourceOptions.getConstructorElementFormat());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.openide.src.ConstructorNode");
    }

    protected String resolveIconBase() {
        int n = ((ConstructorElement)this.element).getModifiers();
        if (Modifier.isPrivate(n)) {
            return "org/openide/resources/src/constructorPrivate";
        }
        if (Modifier.isProtected(n)) {
            return "org/openide/resources/src/constructorProtected";
        }
        if (Modifier.isPublic(n)) {
            return "org/openide/resources/src/constructorPublic";
        }
        return "org/openide/resources/src/constructorPackage";
    }

    protected ElementFormat getHintElementFormat() {
        return ElementNode.sourceOptions.getConstructorElementLongFormat();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(this.createModifiersProperty(this.isWriteable()));
        set.put(this.createNameProperty(false));
        set.put(this.createParametersProperty(this.isWriteable()));
        set.put(this.createExceptionsProperty(this.isWriteable()));
        return sheet;
    }

    public void destroy() throws IOException {
        if (!(this.element instanceof MethodElement)) {
            SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

                public void run() throws SourceException {
                    ConstructorElement constructorElement = (ConstructorElement)ConstructorElementNode.this.element;
                    constructorElement.getDeclaringClass().removeConstructor(constructorElement);
                }
            });
        }
        super.destroy();
    }

    public boolean canRename() {
        return false;
    }

    public Component getCustomizer() {
        return new MethodCustomizer((ConstructorElement)this.element);
    }

    public boolean hasCustomizer() {
        return this.isWriteable();
    }

    protected Node.Property createParametersProperty(boolean bl) {
        ElementNode.ElementProp elementProp = new ElementNode.ElementProp("parameters", array$Lorg$openide$src$MethodParameter == null ? (array$Lorg$openide$src$MethodParameter = ConstructorElementNode.class$("[Lorg.openide.src.MethodParameter;")) : array$Lorg$openide$src$MethodParameter, bl){

            public Object getValue() {
                return ((ConstructorElement)ConstructorElementNode.this.element).getParameters();
            }

            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(object);
                if (!(object instanceof MethodParameter[])) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(ConstructorElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, object){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$val = object;
                    }

                    public void run() throws SourceException {
                        ((ConstructorElement)2.access$000(this.this$1).element).setParameters((MethodParameter[])this.val$val);
                    }
                });
            }

            static /* synthetic */ ConstructorElementNode access$000(2 var0) {
                return var0.ConstructorElementNode.this;
            }
        };
        elementProp.setValue("changeImmediate", Boolean.FALSE);
        return elementProp;
    }

    protected Node.Property createExceptionsProperty(boolean bl) {
        ElementNode.ElementProp elementProp = new ElementNode.ElementProp("exceptions", array$Lorg$openide$src$Identifier == null ? (array$Lorg$openide$src$Identifier = ConstructorElementNode.class$("[Lorg.openide.src.Identifier;")) : array$Lorg$openide$src$Identifier, bl){

            public Object getValue() {
                return ((ConstructorElement)ConstructorElementNode.this.element).getExceptions();
            }

            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(object);
                if (!(object instanceof Identifier[])) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(ConstructorElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, object){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$val = object;
                    }

                    public void run() throws SourceException {
                        ((ConstructorElement)4.access$100(this.this$1).element).setExceptions((Identifier[])this.val$val);
                    }
                });
            }

            static /* synthetic */ ConstructorElementNode access$100(4 var0) {
                return var0.ConstructorElementNode.this;
            }
        };
        elementProp.setValue("changeImmediate", Boolean.FALSE);
        return elementProp;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

